//////////////////////////////////////////////////////////////////
//
// thread.cxx
//
// Copyright (c) Citron Network Inc. 2001-2003
//
// This work is published under the GNU Public License (GPL)
// see file COPYING for details.
// We also explicitely grant the right to link this code
// with the OpenH323 library.
//
// initial author: Chih-Wei Huang <cwhuang@linux.org.tw>
// initial version: 3/18/2003
//
//////////////////////////////////////////////////////////////////

#include "gk.h"
#include "thread.h"

// class MyPThread
MyPThread::MyPThread(bool del)
      : PThread(5000, del ? AutoDeleteThread : NoAutoDeleteThread), isOpen(true)
{
}

void MyPThread::Main()
{
	PTRACE(2, GetClass() << ' ' << getpid() << " started");
	while (isOpen)
		Exec();

	PTRACE(2, GetClass() << ' ' << getpid() << " closed");
}

void MyPThread::Close()
{
	isOpen = false;
	sync.Signal();
}

bool MyPThread::Wait()
{
	sync.Wait();
	return isOpen;
}

void MyPThread::Go()
{
	if (sync.WillBlock())
		sync.Signal();
}

bool MyPThread::Destroy()
{
	Close();
	WaitForTermination();
	delete this;
	return true; // useless, workaround for VC
}

