/*
**  BounceWindowToolbar.m
**
**  Copyright (c) 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "BounceWindowToolbar.h"

#include "Constants.h"

@implementation BounceWindowController (BounceWindowToolbar)

//
// NSToolbar delegate methods
//
- (void) toolbarDidRemoveItem: (NSNotification *) theNotification
{
  NSDebugLog(@"Removing %@", [[[theNotification userInfo] objectForKey: @"item"] label]);
  
  if ( [[theNotification userInfo] objectForKey: @"item"] == sendButton )
    {
      DESTROY(sendButton);
    }
  else if ( [[theNotification userInfo] objectForKey: @"item"] == addressesButton )
    {
      DESTROY(addressesButton);
    }
}


//
//
//
- (void) toolbarWillAddItem: (NSNotification *) theNotification
{
  id item;
  
  item = [[theNotification userInfo] objectForKey: @"item"];
  NSDebugLog(@"Adding %@", [item label]);
 
   if ( [[item itemIdentifier] isEqualToString: @"send"] )
    {
      sendButton = (id)item;
      RETAIN(sendButton);
    }
  else if ([[item itemIdentifier] isEqualToString: @"addresses"])
    {
      addressesButton = (id)item;
      RETAIN(addressesButton);
    }
}


//
//
//
- (NSToolbarItem *) toolbar: (NSToolbar *) toolbar
      itemForItemIdentifier: (NSString *) itemIdentifier
  willBeInsertedIntoToolbar: (BOOL) flag
{
  NSToolbarItem *item = [[NSToolbarItem alloc] initWithItemIdentifier: itemIdentifier];
  
  if ([itemIdentifier isEqualToString: @"send"])
    {
      [item setLabel: _(@"Send")];
      [item setPaletteLabel: _(@"Send Message")];
      [item setImage: [NSImage imageNamed: @"send_32.tiff"]];
      [item setTarget: self];
      [item setAction: @selector(send:)];
    }
  else if ([itemIdentifier isEqualToString: @"addresses"])
    {
      [item setLabel: _(@"Addresses")];
      [item setPaletteLabel: _(@"Show Address Book")];
      [item setImage: [NSImage imageNamed: @"addresses_32.tiff"]];
      [item setTarget: [NSApp delegate]];
      [item setAction: @selector(showAddressBook:)];
    }

  return [item autorelease];
}


//
//
//
- (NSArray *) toolbarAllowedItemIdentifiers: (NSToolbar*) toolbar
{
  return [NSArray arrayWithObjects: NSToolbarSeparatorItemIdentifier,
		                    NSToolbarSpaceItemIdentifier,
		                    NSToolbarFlexibleSpaceItemIdentifier,
		                    NSToolbarCustomizeToolbarItemIdentifier, 
		  @"send",
		  @"addresses",
		  nil];
}


//
//
//
- (NSArray *) toolbarDefaultItemIdentifiers: (NSToolbar*) toolbar
{
  return [NSArray arrayWithObjects: @"send",
		  @"addresses",
		  nil];
}


//
// NSToolbarItemValidation protocol
//
- (BOOL) validateToolbarItem:(NSToolbarItem *)theItem
{
  return YES;
}

@end
