/*
**  FilterManager.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_FilterManager
#define _GNUMail_H_FilterManager

#import <AppKit/AppKit.h>

@class Filter;
@class FilterCriteria;
@class Message;
@class NSColor;
@class URLName;

NSString *PathToFilters();

@interface FilterManager: NSObject <NSCoding>
{
  NSMutableArray *filters;
}

- (id) init;
- (void) dealloc;

- (BOOL) synchronize;


//
// NSCoding protocol
//
- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;


//
// access/mutation methods
//
- (Filter *) filterAtIndex: (int) theIndex;
- (void) addFilter: (Filter *) theFilter;
- (void) addFilter: (Filter *) theFilter
           atIndex: (int) theIndex;
- (void) removeFilter: (Filter *) theFilter;

- (NSArray *) filters;
- (void) setFilters: (NSArray *) theFilters;

- (BOOL) matchExistsForFilter: (Filter *) theFilter
                      message: (Message *) theMessage;

- (Filter *) matchedFilterForMessage: (Message *) theMessage
                                type: (int) theType;

- (Filter *) matchedFilterForMessageAsRawSource: (NSData *) theRawSource
                                           type: (int) theType;

- (NSColor *) colorForMessage: (Message *) theMessage;

- (URLName *) matchedURLNameFromMessage: (Message *) theMessage
				   type: (int) theType
				    key: (NSString *) theKey
                                 filter: (Filter *) theFilter;

- (URLName *) matchedURLNameFromMessageAsRawSource: (NSData *) theRawSource
                                              type: (int) theType
                                               key: (NSString *) theKey
                                            filter: (Filter *) theFilter;
//
// class methods
//
+ (id) singleInstance;

@end

//
// private methods
//
@interface FilterManager (Private)

- (Message *) _messageFromExternalProgramUsingFilter: (Filter *) theFilter
                                             message: (Message *) theMessage;

- (BOOL) _matchCriteriasFromMessage: (Message *) theMessage
                             filter: (Filter *) theFilter;

- (BOOL) _matchStrings: (NSArray *) theStrings
             operation: (int) theOperation
              criteria: (NSString *) theCriteria;

- (NSArray *) _stringsFromMessage: (Message *) theMessage
                         criteria: (FilterCriteria *) theFilterCriteria;

@end


#endif // _GNUMail_H_FilterManager
