/*
     This file is part of GNUnet
     (C) 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/include/gnunetgtk_common.h
 * @author Igor Wronsky
 * @author Christian Grothoff
 */

#ifndef GTKUI_HELPER_H
#define GTKUI_HELPER_H

void initGNUnetGTKCommon(void * callback);

void shutdownPlugins(void);

void doneGNUnetGTKCommon(void);

/**
 * Get the name of the main glade file for gnunet-gtk.
 */
const char * getGladeFileName(void);

/**
 * Get the GladeXML for the main window of gnunet-gtk.
 */
GladeXML * getMainXML(void);

/**
 * Appends a message to the info window
 * @param doPopup if YES, the info window will
 *   be opened
 */
void infoMessage(int doPopup,
		 const char * format,
		 ...);

/**
 * Appends a log entry to the info window
 * and update the statusbar to show this
 * message (until the next call).
 *
 * @param txt the log entry
 */
void addLogEntry(const char * txt, ...);
	
/**
 * Simple callback function.
 */
typedef void (*SimpleCallback)(void *);

/**
 * Call a callback function from the mainloop/main thread ("SaveCall").
 * Since GTK doesn't work with multi-threaded applications under Windows,
 * all GTK operations have to be done in the main thread
 */
void gtkSaveCall(SimpleCallback func,
		 void * arg);

/**
 * Use this method when blocking the
 * GTK event thread and save calls should
 * still continue.
 */
int gtkRunSomeSaveCalls();

/**
 * Run the given "cb" function and save calls
 * in parallel (used within the event loop to
 * keep save calls going while something else
 * happens).
 */
void run_with_save_calls(PThreadMain cb,
			 void * arg);

/**
 * Bind handlers defined by the various
 * plugins to the signals defined by the
 * Glade XML.
 */
void connectGladeWithPlugins(GladeXML * xml);

#endif
