
#include "VrScopeSink.h"
#include "VrGUI.h"
#include "moc_VrGUI.cc"
#include <qwt_counter.h>
#include <qlabel.h>
#include <qpushbutton.h>

/*
 * Constructs a new ScopeGUI.
 * Records the location of the time per x-axis division (won't be necessary
 *  once we implement call-backs.)
 */

ScopeGUI::ScopeGUI(double *tpd, QScopeApp *parent = 0, const char *name = 0,
 		   WFlags flags = 0,
			char *xaxis_name, char *yaxis_name, char *slider_name) : QWidget(parent, name, flags) {
  this->tpd = tpd;
  if (*tpd < 1.0) *tpd = 1.0;
  if (*tpd > maxTPD) *tpd = maxTPD;
  xValues = new double[nPoints];
  for (int i = 0; i < nPoints; i++) xValues[i] = i;

  QBoxLayout *scopeLayout = new QVBoxLayout(this);

  QBoxLayout *displayLayout = new QHBoxLayout();
  scopeLayout->addLayout(displayLayout);

  display = new QwtPlot(this, "display");
  display->setFixedSize(530, 280);
  display->setFrameStyle(QFrame::Box | QFrame::Raised);
  display->setLineWidth(4);
  display->setMidLineWidth(7);
  display->setAxisTitle(QwtPlot::xBottom, xaxis_name);
  display->setAxisScale(QwtPlot::xBottom, 0.0, nPoints, (double)nPoints/divisions);
  //  display->setAxisMaxMajor(QwtPlot::xBottom, divisions);
  display->enableGridX(TRUE);
  display->setAxisTitle(QwtPlot::yLeft, yaxis_name);
  //  display->enableAxis(QwtPlot::yLeft, FALSE);
  //  display->setAxisMaxMajor(QwtPlot::yLeft, divisions);
  display->enableGridY(TRUE);
  signalCurve = display->insertCurve("Plot");
  if (signalCurve > 0) display->setCurvePen(signalCurve, green);
  displayLayout->addWidget(display);

  QBoxLayout *controlLayout = new QHBoxLayout();
  scopeLayout->addLayout(controlLayout);

  QPushButton *quitButton = new QPushButton("Quit", this);
  quitButton->setFont(QFont("times", 14, QFont::Bold));
  quitButton->setFixedSize(quitButton->sizeHint());
  QObject::connect(quitButton, SIGNAL(clicked()), this, SLOT(quit()));
  controlLayout->addWidget(quitButton);

  QBoxLayout *tpdLayout = new QVBoxLayout();
  controlLayout->addLayout(tpdLayout);
  tpdSlider = new QwtSlider(this, "tpdSlider", QwtSlider::Horizontal,
			    QwtSlider::Bottom, QwtSlider::BgSlot);
  tpdSlider->setTracking(FALSE);
  tpdSlider->setScale(0, maxTPD, 0);
  tpdSlider->setValue(*tpd); 
  tpdSlider->setFixedSize(tpdSlider->sizeHint());  // Fix: more width
  tpdLayout->addWidget(tpdSlider);

  QLabel *tpdLabel = new QLabel(slider_name, this);
  tpdLabel->setAlignment(AlignCenter);
  tpdLabel->setFont(QFont("times", 14, QFont::Bold));
  tpdLabel->setFixedSize(tpdLabel->sizeHint());
  tpdLayout->addWidget(tpdLabel);
  QObject::connect(tpdSlider, SIGNAL(valueChanged(double)), 
		   this, SLOT(setTPD(double)));

  scopeLayout->activate();
  scopeLayout->freeze();
}

/*
 * Draws curve defined by
 *    <0, y[offset]>, ..., <nPoints-1, y[offset+nPoints-1]>
 * Requires y[] to be dimensioned properly, offset >= 0
 *
 * Fix: handle offset (for now, it's always 0)
 */
void
ScopeGUI::showData(double *y, int offset = 0) {
  display->setCurveRawData(signalCurve, xValues, y, nPoints);
  display->replot();
}

void
ScopeGUI::setTPD(double percent) {
  if (percent <= 0.0) percent = 1;
  *tpd = (int)(percent*maxTPD/100 + 0.5);
}

void 
ScopeGUI::setYmin(int y) {
  ymin = y;
  display->setAxisScale(QwtPlot::yLeft, ymin, ymax, (ymax - ymin) / 256); 
}

void 
ScopeGUI::setYmax(int y) {
  ymax = y;
  display->setAxisScale(QwtPlot::yLeft, ymin, ymax, (ymax - ymin) / 256); 
}

void
ScopeGUI::quit() {
  // Fix: do something less drastic
  exit(0);
}

VrGUI::VrGUI(int argc, char *argv[]) :QApplication(argc, argv)
{
  top = new QScopeApp(this);
  appLayout = new QHBoxLayout(top, 40);  // widget, border width
  setMainWidget(top);
}

QScopeApp::QScopeApp(QApplication *a)
{
  signalGenerator = new QFrame(this, "mainFrame");
  signalGenerator->setFrameStyle(QFrame::Box | QFrame::Raised);
  signalGenerator->setLineWidth(4);
  signalGenerator->setMidLineWidth(7);
}

ScopeGUI * VrGUI::get_scope(double *arg_tpd,
			char *xaxis_name, char *yaxis_name, char *slider_name)
{
  ScopeGUI *p = new ScopeGUI(arg_tpd, top, 0, 0,
			xaxis_name, yaxis_name, slider_name);

  appLayout->addWidget(p, 0);
  appLayout->addWidget(top->signalGenerator, 0);
  return p;
}

void (*freq_callback)(double);

void VrGUI::get_number(char *arg_title, char *arg_units, void (*arg_callback)(double))
{
  freq_callback = arg_callback;
  QBoxLayout *signalGeneratorLayout = new QVBoxLayout(top->signalGenerator, 20);
  QLabel *title = new QLabel(arg_title, top->signalGenerator);
  title->setAlignment(AlignCenter);
  title->setFont(QFont("times", 14, QFont::Bold));
  title->setFixedSize(title->sizeHint());
  signalGeneratorLayout->addWidget(title);

  QwtCounter *freqSetter = new QwtCounter(top->signalGenerator, "freqSetter");
  freqSetter->setRange(0, MAX_FREQUENCY, 1);
  freqSetter->setNumButtons(3);
  freqSetter->setIncSteps(QwtCounter::Button2, 100);
  freqSetter->setIncSteps(QwtCounter::Button3, 1000);
  freqSetter->setValue(FREQUENCY); 
  freqSetter->setFixedSize(freqSetter->sizeHint());
  signalGeneratorLayout->addWidget(freqSetter);

  QLabel *freqLabel = new QLabel(arg_units, top->signalGenerator);
  freqLabel->setAlignment(AlignCenter);
  freqLabel->setFont(QFont("times", 14, QFont::Bold));
  freqLabel->setFixedSize(freqLabel->sizeHint());
  signalGeneratorLayout->addWidget(freqLabel);
  QObject::connect(freqSetter, SIGNAL(buttonReleased(double)), 
		   top, SLOT(setFrequency(double)));
  signalGeneratorLayout->freeze();
}

void VrGUI::start()
{
  appLayout->activate();
  QBoxLayout *masterLayout = new QVBoxLayout(top);
  masterLayout->activate();
  top->show();
}

void QScopeApp::setFrequency(double f) {
	(*freq_callback)(f);
}
