/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRSUM_H_
#define _VRSUM_H_

#include <VrSigProc.h>
#if defined (ENABLE_MMX)
#include <VrMMX.h>
#endif

template<class iType,class oType> 
class VrSum : public VrSigProc {
protected:
#if defined (ENABLE_MMX)
  char mmxReady;
#endif  
public: 
  virtual const char *name() { return "VrSum"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);
  virtual void initialize() {
#if 0
    //work on 8-units blocks
    setHistory(8);
    setOutputSize(8);
#endif
  };
  VrSum();
};

template<class iType,class oType> int
VrSum<iType,oType>::work(VrSampleRange output, void *ao[],
				VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  oType **o = (oType **)ao;
  int size = output.size;
  int ni = getNumberInputs();
  oType temp;

  while(size-- > 0) {
#if 0
    int units = availableUnits();
    if(availableSpace() < units ) units = availableSpace();
    if (n < units) units = n;

#ifdef XENABLE_MMX
    if(mmxReady && getNumberInputs()>1) {
      units=units-units%8;
      if (PARANOID && units <= 0){
        fprintf(stderr, "Can't write any data in VrSum\n");
	abort ();
      }

      mmxAdd(inputHistoryPtrN(0), inputHistoryPtrN(1),
             units, outputWritePtr());
      incReadPtrN(0,units);
      incReadPtrN(1,units);
      int jj=2;
      while(jj < getNumberInputs()){
        mmxAdd(outputWritePtr(), inputHistoryPtrN(jj),
               units, outputWritePtr());
      incReadPtrN(jj,units);
      jj++;
      }

    } else
#endif
#endif
    {
        temp = *i[0]++;
        int j=1;
        while(j < ni)
          temp += *i[j++]++;
        *o[0]++ = temp;
    }
  }
  return output.size;
}

template<class iType,class oType> 
VrSum<iType,oType>::VrSum()
  : VrSigProc(1, sizeof(iType), sizeof(oType))
{
#ifdef ENABLE_MMX
  mmxReady=queryMMX();
#endif
}
#endif
