/*  GNU Robbo
 *  Copyright (C) notes:
 *  An Idea and Atari version: LK Avalon, Janusz Pelc, 1989
 *                 Linux Code: Arkadiusz Lipiec, 2002-2009
 *                                 <arkadiusz.lipiec@gmail.com>
 *                             Thunor 2007-2009
 *                                 <thunorsif@hotmail.com>
 *
 *  GNU Robbo is free software - you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  GNU Robbo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the impled warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU CC; see the file COPYING. If not, write to the
 *  Free Software Foundation, 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *
 */

#include <SDL/SDL.h>
#include <SDL/SDL_endian.h>
#include <SDL/SDL_ttf.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>		/* For ceil() */
#include <time.h>		/* For random data */
#include <sys/stat.h>	/* For time_t struct */
#include <unistd.h>		/* For getpid() */
#include <dirent.h>		/* For dir functions */
#include "screen.h"
#include "board.h"
#include "controls.h"
#include "levels.h"
#include "skins.h"
#include "rcfile.h"
#include "sound.h"
#include "locales.h"

/* Defines */
/*
#define DEBUG_RECORD_DEMO
#define DEBUG_COLOUR_SELECT
*/

#define TRUE 1
#define FALSE 0

#define UNDEFINED -1

#define SINGLE_SPACE " "

#define DATA_UNREAD 0
#define DATA_READING 1
#define DATA_READ 2
#define DATA_INCOMPLETE 3

#define GAME_CYCLE_LIMIT_MAX 33
#define GAME_CYCLE_LIMIT_MIN 20
#define DEFAULT_GAME_CYCLE_LIMIT 25

/* Game modes */
#define INTRO_SCREEN 0
#define GAME_ON 1
#define END_SCREEN 2
#define HELP_SCREEN 3
#define OPTIONS_SCREEN 4

#define HELP_SCREEN_PAGES 4
#define OPTIONS_SCREEN_PAGES 6

#define OPTIONS_MENUPOS_LEFT 9
#define OPTIONS_MENUPOS_SAVE 10
#define OPTIONS_MENUPOS_EXIT 11
#define OPTIONS_MENUPOS_RIGHT 12

/* demo_mode subfunctions */
#define DEMO_MODE_INITIALISE 0
#define DEMO_MODE_TIMEOUT_INITIALISE 1
#define DEMO_MODE_TIMEOUT_DECREMENT 2
#define DEMO_MODE_ACTIVATE 3
#define DEMO_MODE_IS_ACTIVE 4
#define DEMO_MODE_DEACTIVATE 5
#define DEMO_MODE_RECORD_INITIALISE 6
#define DEMO_MODE_RECORD 7
#define DEMO_MODE_PLAYBACK 8
#define DEMO_MODE_DUMP 9

/* Variables */
#ifdef DEBUG_COLOUR_SELECT
	int debug_colour_select_r;
	int debug_colour_select_g;
	int debug_colour_select_b;
	int debug_colour_select_component;
#endif

int game_mode;
int game_cycle_delay;			/* Defaults to 10ms */
int game_cycle_limit;			/* 20, 25, 33 Hz */
int temp_game_cycle_limit;		/* 20, 25, 33 Hz */
int cycle_count;				/* A running cycle count used for time stamping objects */

int introscreenmenuposition;
int helpscreenpage;			
int helpscreenmenuposition;	
int optionsscreenpage;		
int optionsscreenmenuposition[OPTIONS_SCREEN_PAGES];	

/* Function prototypes */
int my_rand();
void my_srand(unsigned int seed);
int demo_mode(int demo_mode_state, int actionid);




