#include <config.h>
#include "filter.h"

struct filter *
filter_new(struct filter *producer,
           size_t sz) {
    struct filter *f;

    assert(sz >= sizeof(struct filter));
        
    f = mem_alloc(sz);
    
    if(!f)
        return NULL;

    f->producer = producer;
    f->producer_pos = 0;
    f->consumer = NULL;

    f->read = NULL;
    f->write = NULL;
    f->seek = NULL;
    f->destroy = NULL;
    f->query = NULL;

    if(!producer)
        return f;

    f->read = producer->read;
    f->write = producer->write;
    f->seek = producer->seek;
    f->destroy = producer->destroy;
    f->query = producer->query;

    producer->consumer = f;

    return f;
}

void
filter_destroy(struct filter *f) {
    if(f->consumer)
        f->consumer->producer = NULL;

    if(f->destroy)
        f->destroy(f);

    mem_free(f);
}

int
filter_query(struct filter *f,
             int query,
             void *ptr) {
    return f->query(f, query, ptr);
}
