/* 
   interpreter.h: file contains read-eval-print loop and
   supportive functions
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef _INTERPRETER_H
#define _INTERPRETER_H

#define EX_DYNAMIC_COMMANDS "gy-commands"



typedef struct
{
	int id;
	char * room_name;
	char * host;
	YList * members;
	int joined;
} conf_room;


unsigned char get_bell_state (void);
unsigned char get_who_state (void);
unsigned char get_session_mode (void);
unsigned char get_status_mode (void);

void toggle_bell (void);
void toggle_who (void);
void toggle_session (void);
void toggle_status (void);

int get_current_status (void);
void set_current_status (int current_status_value);

char *get_current_status_custom_message (void);
void set_current_status_custom_message (char *current_status_custom_message_value);

void register_command (SCM command);
void unregister_command (SCM command);
void *get_nth_buddy(int index);
char *command_generator (const char *text, int stat);
char **complete_text (char *text, int start, int end);
void syntax_error (void);
void interpreter (char *line);

void command_show_help (char *line);
void command_status (char *line);
void command_send_message (char *line);
void command_send_file (char *line);
void command_buddy_add (char *line);
void command_buddy_remove (char *line);
void command_buddy_reject (char *line);
void command_buddy_ignore (char *line);
void command_buddy_unignore (char *line);
void command_default_handler (char *command, char *line);
void command_eval_scheme_str (char *line);
void command_load_scheme_file (char *line);
void command_toggle (char *line);
void command_bell ();
void command_dynamic_commands (char *dynamic_command, char *line);

void command_default_handler (char *command, char *line);
conf_room * find_conf_room_by_name_and_id(int id, const char * name);
void command_conf_add (char *line);
void command_conf_begin (char *line);
void command_conf_quit (char *line);
void command_conf_decline (char *line);
void command_conf_join (char *line);
void command_conf_list (char *line);
void command_conf_send (char *line);

#endif
