/* 
   messenger.h : main file and heart for the messenger
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef _MESSENGER_H
#define _MESSENGER_H

#include <sys/time.h>
#include <glib.h>
#include <yahoo_list.h>

struct yahoo_session 
{
  char *login_id;
  char *password;
  int status;
  int session_id;
  int socket_fd;
  struct timeval refresh_time;
  YList *buddy_list;
  YList *ignore_list;
};

int get_auto_insert_mode (void);
void set_auto_insert_mode (int auto_insert_mode_value);

int get_quit_flag (void);
void set_quit_flag (int quit_flag_value);

int get_yahoo_session_id ();
struct yahoo_session *get_gnuyahoo_session ();

void signal_handler (int signum);
void main_loop ();
void messenger_main (int argc, char **argv);
extern void register_callbacks ();
#endif
