indexing

	description:

		"Routines that ought to be in class INTEGER"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 1999, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/10/30 07:45:41 $"
	revision: "$Revision: 1.4 $"

class KL_INTEGER_ROUTINES

inherit

	KL_SHARED_PLATFORM
	KL_IMPORTED_STRING_ROUTINES

feature -- Conversion

	to_character (an_int: INTEGER): CHARACTER is
			-- Character whose ASCII code is `an_int'
		require
			an_int_large_enough: an_int >= Platform.Minimum_character_code
			an_int_small_enough: an_int <= Platform.Maximum_character_code
		do




			Result := an_int.to_character




		ensure
			valid_character_code: Result.code = an_int
		end

	to_hexadecimal (an_int: INTEGER; uppercase: BOOLEAN): STRING is
			-- Hexadecimal representation of `an_int';
			-- Return a new string at each call.
			-- Regexp:
			--    uppercase: 0|[1-9A-F][0-9A-F]*
			--    not uppercase: 0|[1-9a-f][0-9a-f]*
		require
			an_int_positive: an_int >= 0
		do
			Result := STRING_.make (8) -- Max 8 hexadecimal digits for 32-bits
			append_hexadecimal_integer (Result, an_int, uppercase)
		ensure
			hexadecimal_not_void: Result /= Void
			is_string: Result.same_type ("")
		end

feature -- Output

	append_hexadecimal_integer (a_string: STRING; an_int: INTEGER; uppercase: BOOLEAN) is
			-- Append a hexadecimal representation of `an_int' to `a_string'.
			-- Regexp:
			--    uppercase: 0|[1-9A-F][0-9A-F]*
			--    not uppercase: 0|[1-9a-f][0-9a-f]*
			-- Note: works even when `a_string' is a UC_STRING.
		require
			a_string_not_void: a_string /= Void
			an_int_positive: an_int >= 0
		local
			k: INTEGER
		do
			if an_int = 0 then
				a_string.append_character ('0')
			else
				k := an_int // 16
				if k /= 0 then
					append_hexadecimal_integer (a_string, k, uppercase)
				end
				inspect an_int \\ 16
				when 0 then
					a_string.append_character ('0')
				when 1 then
					a_string.append_character ('1')
				when 2 then
					a_string.append_character ('2')
				when 3 then
					a_string.append_character ('3')
				when 4 then
					a_string.append_character ('4')
				when 5 then
					a_string.append_character ('5')
				when 6 then
					a_string.append_character ('6')
				when 7 then
					a_string.append_character ('7')
				when 8 then
					a_string.append_character ('8')
				when 9 then
					a_string.append_character ('9')
				when 10 then
					if uppercase then
						a_string.append_character ('A')
					else
						a_string.append_character ('a')
					end
				when 11 then
					if uppercase then
						a_string.append_character ('B')
					else
						a_string.append_character ('b')
					end
				when 12 then
					if uppercase then
						a_string.append_character ('C')
					else
						a_string.append_character ('c')
					end
				when 13 then
					if uppercase then
						a_string.append_character ('D')
					else
						a_string.append_character ('d')
					end
				when 14 then
					if uppercase then
						a_string.append_character ('E')
					else
						a_string.append_character ('e')
					end
				when 15 then
					if uppercase then
						a_string.append_character ('F')
					else
						a_string.append_character ('f')
					end
				end
			end
		end

feature -- Status report

	is_even (an_int: INTEGER): BOOLEAN is
			-- Is `an_int' an even integer?
		do
			Result := an_int \\ 2 = 0
		ensure
			definition: Result = (an_int \\ 2 = 0)
		end

end
