// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about a job template.
func (c *Client) DescribeJobTemplate(ctx context.Context, params *DescribeJobTemplateInput, optFns ...func(*Options)) (*DescribeJobTemplateOutput, error) {
	if params == nil {
		params = &DescribeJobTemplateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeJobTemplate", params, optFns, c.addOperationDescribeJobTemplateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeJobTemplateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeJobTemplateInput struct {

	// The unique identifier of the job template.
	//
	// This member is required.
	JobTemplateId *string

	noSmithyDocumentSerde
}

type DescribeJobTemplateOutput struct {

	// The criteria that determine when and how a job abort takes place.
	AbortConfig *types.AbortConfig

	// The time, in seconds since the epoch, when the job template was created.
	CreatedAt *time.Time

	// A description of the job template.
	Description *string

	// The job document.
	Document *string

	// An S3 link to the job document.
	DocumentSource *string

	// The configuration that determines how many retries are allowed for each failure
	// type for a job.
	JobExecutionsRetryConfig *types.JobExecutionsRetryConfig

	// Allows you to create a staged rollout of a job.
	JobExecutionsRolloutConfig *types.JobExecutionsRolloutConfig

	// The ARN of the job template.
	JobTemplateArn *string

	// The unique identifier of the job template.
	JobTemplateId *string

	// Allows you to configure an optional maintenance window for the rollout of a job
	// document to all devices in the target group for a job.
	MaintenanceWindows []types.MaintenanceWindow

	// Configuration for pre-signed S3 URLs.
	PresignedUrlConfig *types.PresignedUrlConfig

	// Specifies the amount of time each device has to finish its execution of the job.
	// A timer is started when the job execution status is set to IN_PROGRESS. If the
	// job execution status is not set to another terminal state before the timer
	// expires, it will be automatically set to TIMED_OUT.
	TimeoutConfig *types.TimeoutConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeJobTemplateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeJobTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeJobTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeJobTemplateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeJobTemplate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeJobTemplate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "execute-api",
		OperationName: "DescribeJobTemplate",
	}
}
