// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes code configuration for an application.
type ApplicationCodeConfiguration struct {

	// Specifies whether the code content is in text or zip format.
	//
	// This member is required.
	CodeContentType CodeContentType

	// The location and type of the application code.
	CodeContent *CodeContent

	noSmithyDocumentSerde
}

// Describes code configuration for an application.
type ApplicationCodeConfigurationDescription struct {

	// Specifies whether the code content is in text or zip format.
	//
	// This member is required.
	CodeContentType CodeContentType

	// Describes details about the location and format of the application code.
	CodeContentDescription *CodeContentDescription

	noSmithyDocumentSerde
}

// Describes code configuration updates for an application. This is supported for a
// Flink-based Kinesis Data Analytics application or a SQL-based Kinesis Data
// Analytics application.
type ApplicationCodeConfigurationUpdate struct {

	// Describes updates to the code content type.
	CodeContentTypeUpdate CodeContentType

	// Describes updates to the code content of an application.
	CodeContentUpdate *CodeContentUpdate

	noSmithyDocumentSerde
}

// Specifies the creation parameters for a Kinesis Data Analytics application.
type ApplicationConfiguration struct {

	// The code location and type parameters for a Flink-based Kinesis Data Analytics
	// application.
	ApplicationCodeConfiguration *ApplicationCodeConfiguration

	// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
	// application.
	ApplicationSnapshotConfiguration *ApplicationSnapshotConfiguration

	// Describes execution properties for a Flink-based Kinesis Data Analytics
	// application.
	EnvironmentProperties *EnvironmentProperties

	// The creation and update parameters for a Flink-based Kinesis Data Analytics
	// application.
	FlinkApplicationConfiguration *FlinkApplicationConfiguration

	// The creation and update parameters for a SQL-based Kinesis Data Analytics
	// application.
	SqlApplicationConfiguration *SqlApplicationConfiguration

	// The array of descriptions of VPC configurations available to the application.
	VpcConfigurations []VpcConfiguration

	// The configuration parameters for a Kinesis Data Analytics Studio notebook.
	ZeppelinApplicationConfiguration *ZeppelinApplicationConfiguration

	noSmithyDocumentSerde
}

// Describes details about the application code and starting parameters for a
// Kinesis Data Analytics application.
type ApplicationConfigurationDescription struct {

	// The details about the application code for a Flink-based Kinesis Data Analytics
	// application.
	ApplicationCodeConfigurationDescription *ApplicationCodeConfigurationDescription

	// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
	// application.
	ApplicationSnapshotConfigurationDescription *ApplicationSnapshotConfigurationDescription

	// Describes execution properties for a Flink-based Kinesis Data Analytics
	// application.
	EnvironmentPropertyDescriptions *EnvironmentPropertyDescriptions

	// The details about a Flink-based Kinesis Data Analytics application.
	FlinkApplicationConfigurationDescription *FlinkApplicationConfigurationDescription

	// The details about the starting properties for a Kinesis Data Analytics
	// application.
	RunConfigurationDescription *RunConfigurationDescription

	// The details about inputs, outputs, and reference data sources for a SQL-based
	// Kinesis Data Analytics application.
	SqlApplicationConfigurationDescription *SqlApplicationConfigurationDescription

	// The array of descriptions of VPC configurations available to the application.
	VpcConfigurationDescriptions []VpcConfigurationDescription

	// The configuration parameters for a Kinesis Data Analytics Studio notebook.
	ZeppelinApplicationConfigurationDescription *ZeppelinApplicationConfigurationDescription

	noSmithyDocumentSerde
}

// Describes updates to an application's configuration.
type ApplicationConfigurationUpdate struct {

	// Describes updates to an application's code configuration.
	ApplicationCodeConfigurationUpdate *ApplicationCodeConfigurationUpdate

	// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
	// application.
	ApplicationSnapshotConfigurationUpdate *ApplicationSnapshotConfigurationUpdate

	// Describes updates to the environment properties for a Flink-based Kinesis Data
	// Analytics application.
	EnvironmentPropertyUpdates *EnvironmentPropertyUpdates

	// Describes updates to a Flink-based Kinesis Data Analytics application's
	// configuration.
	FlinkApplicationConfigurationUpdate *FlinkApplicationConfigurationUpdate

	// Describes updates to a SQL-based Kinesis Data Analytics application's
	// configuration.
	SqlApplicationConfigurationUpdate *SqlApplicationConfigurationUpdate

	// Updates to the array of descriptions of VPC configurations available to the
	// application.
	VpcConfigurationUpdates []VpcConfigurationUpdate

	// Updates to the configuration of a Kinesis Data Analytics Studio notebook.
	ZeppelinApplicationConfigurationUpdate *ZeppelinApplicationConfigurationUpdate

	noSmithyDocumentSerde
}

// Describes the application, including the application Amazon Resource Name (ARN),
// status, latest version, and input and output configurations.
type ApplicationDetail struct {

	// The ARN of the application.
	//
	// This member is required.
	ApplicationARN *string

	// The name of the application.
	//
	// This member is required.
	ApplicationName *string

	// The status of the application.
	//
	// This member is required.
	ApplicationStatus ApplicationStatus

	// Provides the current application version. Kinesis Data Analytics updates the
	// ApplicationVersionId each time you update the application.
	//
	// This member is required.
	ApplicationVersionId *int64

	// The runtime environment for the application.
	//
	// This member is required.
	RuntimeEnvironment RuntimeEnvironment

	// Describes details about the application code and starting parameters for a
	// Kinesis Data Analytics application.
	ApplicationConfigurationDescription *ApplicationConfigurationDescription

	// The description of the application.
	ApplicationDescription *string

	// The details of the maintenance configuration for the application.
	ApplicationMaintenanceConfigurationDescription *ApplicationMaintenanceConfigurationDescription

	// To create a Kinesis Data Analytics Studio notebook, you must set the mode to
	// INTERACTIVE. However, for a Kinesis Data Analytics for Apache Flink application,
	// the mode is optional.
	ApplicationMode ApplicationMode

	// If you reverted the application using RollbackApplication, the application
	// version when RollbackApplication was called.
	ApplicationVersionRolledBackFrom *int64

	// The version to which you want to roll back the application.
	ApplicationVersionRolledBackTo *int64

	// The previous application version before the latest application update.
	// RollbackApplication reverts the application to this version.
	ApplicationVersionUpdatedFrom *int64

	// Describes the application Amazon CloudWatch logging options.
	CloudWatchLoggingOptionDescriptions []CloudWatchLoggingOptionDescription

	// A value you use to implement strong concurrency for application updates.
	ConditionalToken *string

	// The current timestamp when the application was created.
	CreateTimestamp *time.Time

	// The current timestamp when the application was last updated.
	LastUpdateTimestamp *time.Time

	// Specifies the IAM role that the application uses to access external resources.
	ServiceExecutionRole *string

	noSmithyDocumentSerde
}

// The details of the maintenance configuration for the application.
type ApplicationMaintenanceConfigurationDescription struct {

	// The end time for the maintenance window.
	//
	// This member is required.
	ApplicationMaintenanceWindowEndTime *string

	// The start time for the maintenance window.
	//
	// This member is required.
	ApplicationMaintenanceWindowStartTime *string

	noSmithyDocumentSerde
}

// Describes the updated maintenance configuration for the application.
type ApplicationMaintenanceConfigurationUpdate struct {

	// The updated start time for the maintenance window.
	//
	// This member is required.
	ApplicationMaintenanceWindowStartTimeUpdate *string

	noSmithyDocumentSerde
}

// Specifies the method and snapshot to use when restarting an application using
// previously saved application state.
type ApplicationRestoreConfiguration struct {

	// Specifies how the application should be restored.
	//
	// This member is required.
	ApplicationRestoreType ApplicationRestoreType

	// The identifier of an existing snapshot of application state to use to restart an
	// application. The application uses this value if RESTORE_FROM_CUSTOM_SNAPSHOT is
	// specified for the ApplicationRestoreType.
	SnapshotName *string

	noSmithyDocumentSerde
}

// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
// application.
type ApplicationSnapshotConfiguration struct {

	// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
	// application.
	//
	// This member is required.
	SnapshotsEnabled *bool

	noSmithyDocumentSerde
}

// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
// application.
type ApplicationSnapshotConfigurationDescription struct {

	// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
	// application.
	//
	// This member is required.
	SnapshotsEnabled *bool

	noSmithyDocumentSerde
}

// Describes updates to whether snapshots are enabled for a Flink-based Kinesis
// Data Analytics application.
type ApplicationSnapshotConfigurationUpdate struct {

	// Describes updates to whether snapshots are enabled for an application.
	//
	// This member is required.
	SnapshotsEnabledUpdate *bool

	noSmithyDocumentSerde
}

// Provides application summary information, including the application Amazon
// Resource Name (ARN), name, and status.
type ApplicationSummary struct {

	// The ARN of the application.
	//
	// This member is required.
	ApplicationARN *string

	// The name of the application.
	//
	// This member is required.
	ApplicationName *string

	// The status of the application.
	//
	// This member is required.
	ApplicationStatus ApplicationStatus

	// Provides the current application version.
	//
	// This member is required.
	ApplicationVersionId *int64

	// The runtime environment for the application.
	//
	// This member is required.
	RuntimeEnvironment RuntimeEnvironment

	// For a Kinesis Data Analytics for Apache Flink application, the mode is
	// STREAMING. For a Kinesis Data Analytics Studio notebook, it is INTERACTIVE.
	ApplicationMode ApplicationMode

	noSmithyDocumentSerde
}

// The summary of the application version.
type ApplicationVersionSummary struct {

	// The status of the application.
	//
	// This member is required.
	ApplicationStatus ApplicationStatus

	// The ID of the application version. Kinesis Data Analytics updates the
	// ApplicationVersionId each time you update the application.
	//
	// This member is required.
	ApplicationVersionId *int64

	noSmithyDocumentSerde
}

// The configuration parameters for the default Amazon Glue database. You use this
// database for SQL queries that you write in a Kinesis Data Analytics Studio
// notebook.
type CatalogConfiguration struct {

	// The configuration parameters for the default Amazon Glue database. You use this
	// database for Apache Flink SQL queries and table API transforms that you write in
	// a Kinesis Data Analytics Studio notebook.
	//
	// This member is required.
	GlueDataCatalogConfiguration *GlueDataCatalogConfiguration

	noSmithyDocumentSerde
}

// The configuration parameters for the default Amazon Glue database. You use this
// database for Apache Flink SQL queries and table API transforms that you write in
// a Kinesis Data Analytics Studio notebook.
type CatalogConfigurationDescription struct {

	// The configuration parameters for the default Amazon Glue database. You use this
	// database for SQL queries that you write in a Kinesis Data Analytics Studio
	// notebook.
	//
	// This member is required.
	GlueDataCatalogConfigurationDescription *GlueDataCatalogConfigurationDescription

	noSmithyDocumentSerde
}

// Updates to the configuration parameters for the default Amazon Glue database.
// You use this database for SQL queries that you write in a Kinesis Data Analytics
// Studio notebook.
type CatalogConfigurationUpdate struct {

	// Updates to the configuration parameters for the default Amazon Glue database.
	// You use this database for SQL queries that you write in a Kinesis Data Analytics
	// Studio notebook.
	//
	// This member is required.
	GlueDataCatalogConfigurationUpdate *GlueDataCatalogConfigurationUpdate

	noSmithyDocumentSerde
}

// Describes an application's checkpointing configuration. Checkpointing is the
// process of persisting application state for fault tolerance. For more
// information, see  Checkpoints for Fault Tolerance
// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance)
// in the Apache Flink Documentation
// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
type CheckpointConfiguration struct {

	// Describes whether the application uses Kinesis Data Analytics' default
	// checkpointing behavior. You must set this property to CUSTOM in order to set the
	// CheckpointingEnabled, CheckpointInterval, or MinPauseBetweenCheckpoints
	// parameters. If this value is set to DEFAULT, the application will use the
	// following values, even if they are set to other values using APIs or application
	// code:
	//
	// * CheckpointingEnabled: true
	//
	// * CheckpointInterval: 60000
	//
	// *
	// MinPauseBetweenCheckpoints: 5000
	//
	// This member is required.
	ConfigurationType ConfigurationType

	// Describes the interval in milliseconds between checkpoint operations. If
	// CheckpointConfiguration.ConfigurationType is DEFAULT, the application will use a
	// CheckpointInterval value of 60000, even if this value is set to another value
	// using this API or in application code.
	CheckpointInterval *int64

	// Describes whether checkpointing is enabled for a Flink-based Kinesis Data
	// Analytics application. If CheckpointConfiguration.ConfigurationType is DEFAULT,
	// the application will use a CheckpointingEnabled value of true, even if this
	// value is set to another value using this API or in application code.
	CheckpointingEnabled *bool

	// Describes the minimum time in milliseconds after a checkpoint operation
	// completes that a new checkpoint operation can start. If a checkpoint operation
	// takes longer than the CheckpointInterval, the application otherwise performs
	// continual checkpoint operations. For more information, see  Tuning Checkpointing
	// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/large_state_tuning.html#tuning-checkpointing)
	// in the Apache Flink Documentation
	// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/). If
	// CheckpointConfiguration.ConfigurationType is DEFAULT, the application will use a
	// MinPauseBetweenCheckpoints value of 5000, even if this value is set using this
	// API or in application code.
	MinPauseBetweenCheckpoints *int64

	noSmithyDocumentSerde
}

// Describes checkpointing parameters for a Flink-based Kinesis Data Analytics
// application.
type CheckpointConfigurationDescription struct {

	// Describes the interval in milliseconds between checkpoint operations. If
	// CheckpointConfiguration.ConfigurationType is DEFAULT, the application will use a
	// CheckpointInterval value of 60000, even if this value is set to another value
	// using this API or in application code.
	CheckpointInterval *int64

	// Describes whether checkpointing is enabled for a Flink-based Kinesis Data
	// Analytics application. If CheckpointConfiguration.ConfigurationType is DEFAULT,
	// the application will use a CheckpointingEnabled value of true, even if this
	// value is set to another value using this API or in application code.
	CheckpointingEnabled *bool

	// Describes whether the application uses the default checkpointing behavior in
	// Kinesis Data Analytics. If this value is set to DEFAULT, the application will
	// use the following values, even if they are set to other values using APIs or
	// application code:
	//
	// * CheckpointingEnabled: true
	//
	// * CheckpointInterval: 60000
	//
	// *
	// MinPauseBetweenCheckpoints: 5000
	ConfigurationType ConfigurationType

	// Describes the minimum time in milliseconds after a checkpoint operation
	// completes that a new checkpoint operation can start. If
	// CheckpointConfiguration.ConfigurationType is DEFAULT, the application will use a
	// MinPauseBetweenCheckpoints value of 5000, even if this value is set using this
	// API or in application code.
	MinPauseBetweenCheckpoints *int64

	noSmithyDocumentSerde
}

// Describes updates to the checkpointing parameters for a Flink-based Kinesis Data
// Analytics application.
type CheckpointConfigurationUpdate struct {

	// Describes updates to the interval in milliseconds between checkpoint operations.
	// If CheckpointConfiguration.ConfigurationType is DEFAULT, the application will
	// use a CheckpointInterval value of 60000, even if this value is set to another
	// value using this API or in application code.
	CheckpointIntervalUpdate *int64

	// Describes updates to whether checkpointing is enabled for an application. If
	// CheckpointConfiguration.ConfigurationType is DEFAULT, the application will use a
	// CheckpointingEnabled value of true, even if this value is set to another value
	// using this API or in application code.
	CheckpointingEnabledUpdate *bool

	// Describes updates to whether the application uses the default checkpointing
	// behavior of Kinesis Data Analytics. You must set this property to CUSTOM in
	// order to set the CheckpointingEnabled, CheckpointInterval, or
	// MinPauseBetweenCheckpoints parameters. If this value is set to DEFAULT, the
	// application will use the following values, even if they are set to other values
	// using APIs or application code:
	//
	// * CheckpointingEnabled: true
	//
	// *
	// CheckpointInterval: 60000
	//
	// * MinPauseBetweenCheckpoints: 5000
	ConfigurationTypeUpdate ConfigurationType

	// Describes updates to the minimum time in milliseconds after a checkpoint
	// operation completes that a new checkpoint operation can start. If
	// CheckpointConfiguration.ConfigurationType is DEFAULT, the application will use a
	// MinPauseBetweenCheckpoints value of 5000, even if this value is set using this
	// API or in application code.
	MinPauseBetweenCheckpointsUpdate *int64

	noSmithyDocumentSerde
}

// Provides a description of Amazon CloudWatch logging options, including the log
// stream Amazon Resource Name (ARN).
type CloudWatchLoggingOption struct {

	// The ARN of the CloudWatch log to receive application messages.
	//
	// This member is required.
	LogStreamARN *string

	noSmithyDocumentSerde
}

// Describes the Amazon CloudWatch logging option.
type CloudWatchLoggingOptionDescription struct {

	// The Amazon Resource Name (ARN) of the CloudWatch log to receive application
	// messages.
	//
	// This member is required.
	LogStreamARN *string

	// The ID of the CloudWatch logging option description.
	CloudWatchLoggingOptionId *string

	// The IAM ARN of the role to use to send application messages. Provided for
	// backward compatibility. Applications created with the current API version have
	// an application-level service execution role rather than a resource-level role.
	RoleARN *string

	noSmithyDocumentSerde
}

// Describes the Amazon CloudWatch logging option updates.
type CloudWatchLoggingOptionUpdate struct {

	// The ID of the CloudWatch logging option to update
	//
	// This member is required.
	CloudWatchLoggingOptionId *string

	// The Amazon Resource Name (ARN) of the CloudWatch log to receive application
	// messages.
	LogStreamARNUpdate *string

	noSmithyDocumentSerde
}

// Specifies either the application code, or the location of the application code,
// for a Flink-based Kinesis Data Analytics application.
type CodeContent struct {

	// Information about the Amazon S3 bucket that contains the application code.
	S3ContentLocation *S3ContentLocation

	// The text-format code for a Flink-based Kinesis Data Analytics application.
	TextContent *string

	// The zip-format code for a Flink-based Kinesis Data Analytics application.
	ZipFileContent []byte

	noSmithyDocumentSerde
}

// Describes details about the code of a Kinesis Data Analytics application.
type CodeContentDescription struct {

	// The checksum that can be used to validate zip-format code.
	CodeMD5 *string

	// The size in bytes of the application code. Can be used to validate zip-format
	// code.
	CodeSize *int64

	// The S3 bucket Amazon Resource Name (ARN), file key, and object version of the
	// application code stored in Amazon S3.
	S3ApplicationCodeLocationDescription *S3ApplicationCodeLocationDescription

	// The text-format code
	TextContent *string

	noSmithyDocumentSerde
}

// Describes an update to the code of an application. Not supported for Apache
// Zeppelin.
type CodeContentUpdate struct {

	// Describes an update to the location of code for an application.
	S3ContentLocationUpdate *S3ContentLocationUpdate

	// Describes an update to the text code for an application.
	TextContentUpdate *string

	// Describes an update to the zipped code for an application.
	ZipFileContentUpdate []byte

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, provides additional mapping
// information when the record format uses delimiters, such as CSV. For example,
// the following sample records use CSV format, where the records use the '\n' as
// the row delimiter and a comma (",") as the column delimiter: "name1",
// "address1"
//
//	"name2", "address2"
type CSVMappingParameters struct {

	// The column delimiter. For example, in a CSV format, a comma (",") is the typical
	// column delimiter.
	//
	// This member is required.
	RecordColumnDelimiter *string

	// The row delimiter. For example, in a CSV format, '\n' is the typical row
	// delimiter.
	//
	// This member is required.
	RecordRowDelimiter *string

	noSmithyDocumentSerde
}

// Specifies dependency JARs, as well as JAR files that contain user-defined
// functions (UDF).
type CustomArtifactConfiguration struct {

	// UDF stands for user-defined functions. This type of artifact must be in an S3
	// bucket. A DEPENDENCY_JAR can be in either Maven or an S3 bucket.
	//
	// This member is required.
	ArtifactType ArtifactType

	// The parameters required to fully specify a Maven reference.
	MavenReference *MavenReference

	// For a Kinesis Data Analytics application provides a description of an Amazon S3
	// object, including the Amazon Resource Name (ARN) of the S3 bucket, the name of
	// the Amazon S3 object that contains the data, and the version number of the
	// Amazon S3 object that contains the data.
	S3ContentLocation *S3ContentLocation

	noSmithyDocumentSerde
}

// Specifies a dependency JAR or a JAR of user-defined functions.
type CustomArtifactConfigurationDescription struct {

	// UDF stands for user-defined functions. This type of artifact must be in an S3
	// bucket. A DEPENDENCY_JAR can be in either Maven or an S3 bucket.
	ArtifactType ArtifactType

	// The parameters that are required to specify a Maven dependency.
	MavenReferenceDescription *MavenReference

	// For a Kinesis Data Analytics application provides a description of an Amazon S3
	// object, including the Amazon Resource Name (ARN) of the S3 bucket, the name of
	// the Amazon S3 object that contains the data, and the version number of the
	// Amazon S3 object that contains the data.
	S3ContentLocationDescription *S3ContentLocation

	noSmithyDocumentSerde
}

// The information required to deploy a Kinesis Data Analytics Studio notebook as
// an application with durable state.
type DeployAsApplicationConfiguration struct {

	// The description of an Amazon S3 object that contains the Amazon Data Analytics
	// application, including the Amazon Resource Name (ARN) of the S3 bucket, the name
	// of the Amazon S3 object that contains the data, and the version number of the
	// Amazon S3 object that contains the data.
	//
	// This member is required.
	S3ContentLocation *S3ContentBaseLocation

	noSmithyDocumentSerde
}

// The configuration information required to deploy an Amazon Data Analytics Studio
// notebook as an application with durable state.
type DeployAsApplicationConfigurationDescription struct {

	// The location that holds the data required to specify an Amazon Data Analytics
	// application.
	//
	// This member is required.
	S3ContentLocationDescription *S3ContentBaseLocationDescription

	noSmithyDocumentSerde
}

// Updates to the configuration information required to deploy an Amazon Data
// Analytics Studio notebook as an application with durable state.
type DeployAsApplicationConfigurationUpdate struct {

	// Updates to the location that holds the data required to specify an Amazon Data
	// Analytics application.
	S3ContentLocationUpdate *S3ContentBaseLocationUpdate

	noSmithyDocumentSerde
}

// Describes the data format when records are written to the destination in a
// SQL-based Kinesis Data Analytics application.
type DestinationSchema struct {

	// Specifies the format of the records on the output stream.
	//
	// This member is required.
	RecordFormatType RecordFormatType

	noSmithyDocumentSerde
}

// Describes execution properties for a Flink-based Kinesis Data Analytics
// application.
type EnvironmentProperties struct {

	// Describes the execution property groups.
	//
	// This member is required.
	PropertyGroups []PropertyGroup

	noSmithyDocumentSerde
}

// Describes the execution properties for an Apache Flink runtime.
type EnvironmentPropertyDescriptions struct {

	// Describes the execution property groups.
	PropertyGroupDescriptions []PropertyGroup

	noSmithyDocumentSerde
}

// Describes updates to the execution property groups for a Flink-based Kinesis
// Data Analytics application or a Studio notebook.
type EnvironmentPropertyUpdates struct {

	// Describes updates to the execution property groups.
	//
	// This member is required.
	PropertyGroups []PropertyGroup

	noSmithyDocumentSerde
}

// Describes configuration parameters for a Flink-based Kinesis Data Analytics
// application or a Studio notebook.
type FlinkApplicationConfiguration struct {

	// Describes an application's checkpointing configuration. Checkpointing is the
	// process of persisting application state for fault tolerance. For more
	// information, see  Checkpoints for Fault Tolerance
	// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance)
	// in the Apache Flink Documentation
	// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
	CheckpointConfiguration *CheckpointConfiguration

	// Describes configuration parameters for Amazon CloudWatch logging for an
	// application.
	MonitoringConfiguration *MonitoringConfiguration

	// Describes parameters for how an application executes multiple tasks
	// simultaneously.
	ParallelismConfiguration *ParallelismConfiguration

	noSmithyDocumentSerde
}

// Describes configuration parameters for a Flink-based Kinesis Data Analytics
// application.
type FlinkApplicationConfigurationDescription struct {

	// Describes an application's checkpointing configuration. Checkpointing is the
	// process of persisting application state for fault tolerance.
	CheckpointConfigurationDescription *CheckpointConfigurationDescription

	// The job plan for an application. For more information about the job plan, see
	// Jobs and Scheduling
	// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/internals/job_scheduling.html)
	// in the Apache Flink Documentation
	// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/). To retrieve the
	// job plan for the application, use the
	// DescribeApplicationRequest$IncludeAdditionalDetails parameter of the
	// DescribeApplication operation.
	JobPlanDescription *string

	// Describes configuration parameters for Amazon CloudWatch logging for an
	// application.
	MonitoringConfigurationDescription *MonitoringConfigurationDescription

	// Describes parameters for how an application executes multiple tasks
	// simultaneously.
	ParallelismConfigurationDescription *ParallelismConfigurationDescription

	noSmithyDocumentSerde
}

// Describes updates to the configuration parameters for a Flink-based Kinesis Data
// Analytics application.
type FlinkApplicationConfigurationUpdate struct {

	// Describes updates to an application's checkpointing configuration. Checkpointing
	// is the process of persisting application state for fault tolerance.
	CheckpointConfigurationUpdate *CheckpointConfigurationUpdate

	// Describes updates to the configuration parameters for Amazon CloudWatch logging
	// for an application.
	MonitoringConfigurationUpdate *MonitoringConfigurationUpdate

	// Describes updates to the parameters for how an application executes multiple
	// tasks simultaneously.
	ParallelismConfigurationUpdate *ParallelismConfigurationUpdate

	noSmithyDocumentSerde
}

// Describes the starting parameters for a Flink-based Kinesis Data Analytics
// application.
type FlinkRunConfiguration struct {

	// When restoring from a snapshot, specifies whether the runtime is allowed to skip
	// a state that cannot be mapped to the new program. This will happen if the
	// program is updated between snapshots to remove stateful parameters, and state
	// data in the snapshot no longer corresponds to valid application data. For more
	// information, see  Allowing Non-Restored State
	// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/savepoints.html#allowing-non-restored-state)
	// in the Apache Flink documentation
	// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/). This value
	// defaults to false. If you update your application without specifying this
	// parameter, AllowNonRestoredState will be set to false, even if it was previously
	// set to true.
	AllowNonRestoredState *bool

	noSmithyDocumentSerde
}

// The configuration of the Glue Data Catalog that you use for Apache Flink SQL
// queries and table API transforms that you write in an application.
type GlueDataCatalogConfiguration struct {

	// The Amazon Resource Name (ARN) of the database.
	//
	// This member is required.
	DatabaseARN *string

	noSmithyDocumentSerde
}

// The configuration of the Glue Data Catalog that you use for Apache Flink SQL
// queries and table API transforms that you write in an application.
type GlueDataCatalogConfigurationDescription struct {

	// The Amazon Resource Name (ARN) of the database.
	//
	// This member is required.
	DatabaseARN *string

	noSmithyDocumentSerde
}

// Updates to the configuration of the Glue Data Catalog that you use for SQL
// queries that you write in a Kinesis Data Analytics Studio notebook.
type GlueDataCatalogConfigurationUpdate struct {

	// The updated Amazon Resource Name (ARN) of the database.
	//
	// This member is required.
	DatabaseARNUpdate *string

	noSmithyDocumentSerde
}

// When you configure the application input for a SQL-based Kinesis Data Analytics
// application, you specify the streaming source, the in-application stream name
// that is created, and the mapping between the two.
type Input struct {

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns in the in-application stream that is being
	// created. Also used to describe the format of the reference data source.
	//
	// This member is required.
	InputSchema *SourceSchema

	// The name prefix to use when creating an in-application stream. Suppose that you
	// specify a prefix "MyInApplicationStream." Kinesis Data Analytics then creates
	// one or more (as per the InputParallelism count you specified) in-application
	// streams with the names "MyInApplicationStream_001," "MyInApplicationStream_002,"
	// and so on.
	//
	// This member is required.
	NamePrefix *string

	// Describes the number of in-application streams to create.
	InputParallelism *InputParallelism

	// The InputProcessingConfiguration for the input. An input processor transforms
	// records as they are received from the stream, before the application's SQL code
	// executes. Currently, the only input processing configuration available is
	// InputLambdaProcessor.
	InputProcessingConfiguration *InputProcessingConfiguration

	// If the streaming source is an Amazon Kinesis Data Firehose delivery stream,
	// identifies the delivery stream's ARN.
	KinesisFirehoseInput *KinesisFirehoseInput

	// If the streaming source is an Amazon Kinesis data stream, identifies the
	// stream's Amazon Resource Name (ARN).
	KinesisStreamsInput *KinesisStreamsInput

	noSmithyDocumentSerde
}

// Describes the application input configuration for a SQL-based Kinesis Data
// Analytics application.
type InputDescription struct {

	// Returns the in-application stream names that are mapped to the stream source.
	InAppStreamNames []string

	// The input ID that is associated with the application input. This is the ID that
	// Kinesis Data Analytics assigns to each input configuration that you add to your
	// application.
	InputId *string

	// Describes the configured parallelism (number of in-application streams mapped to
	// the streaming source).
	InputParallelism *InputParallelism

	// The description of the preprocessor that executes on records in this input
	// before the application's code is run.
	InputProcessingConfigurationDescription *InputProcessingConfigurationDescription

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns in the in-application stream that is being
	// created.
	InputSchema *SourceSchema

	// The point at which the application is configured to read from the input stream.
	InputStartingPositionConfiguration *InputStartingPositionConfiguration

	// If a Kinesis Data Firehose delivery stream is configured as a streaming source,
	// provides the delivery stream's ARN.
	KinesisFirehoseInputDescription *KinesisFirehoseInputDescription

	// If a Kinesis data stream is configured as a streaming source, provides the
	// Kinesis data stream's Amazon Resource Name (ARN).
	KinesisStreamsInputDescription *KinesisStreamsInputDescription

	// The in-application name prefix.
	NamePrefix *string

	noSmithyDocumentSerde
}

// An object that contains the Amazon Resource Name (ARN) of the Amazon Lambda
// function that is used to preprocess records in the stream in a SQL-based Kinesis
// Data Analytics application.
type InputLambdaProcessor struct {

	// The ARN of the Amazon Lambda function that operates on records in the stream. To
	// specify an earlier version of the Lambda function than the latest, include the
	// Lambda function version in the Lambda function ARN. For more information about
	// Lambda ARNs, see Example ARNs: Amazon Lambda
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// This member is required.
	ResourceARN *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, an object that contains the
// Amazon Resource Name (ARN) of the Amazon Lambda function that is used to
// preprocess records in the stream.
type InputLambdaProcessorDescription struct {

	// The ARN of the Amazon Lambda function that is used to preprocess the records in
	// the stream. To specify an earlier version of the Lambda function than the
	// latest, include the Lambda function version in the Lambda function ARN. For more
	// information about Lambda ARNs, see Example ARNs: Amazon Lambda
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// This member is required.
	ResourceARN *string

	// The ARN of the IAM role that is used to access the Amazon Lambda function.
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather than
	// a resource-level role.
	RoleARN *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, represents an update to the
// InputLambdaProcessor that is used to preprocess the records in the stream.
type InputLambdaProcessorUpdate struct {

	// The Amazon Resource Name (ARN) of the new Amazon Lambda function that is used to
	// preprocess the records in the stream. To specify an earlier version of the
	// Lambda function than the latest, include the Lambda function version in the
	// Lambda function ARN. For more information about Lambda ARNs, see Example ARNs:
	// Amazon Lambda
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// This member is required.
	ResourceARNUpdate *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes the number of
// in-application streams to create for a given streaming source.
type InputParallelism struct {

	// The number of in-application streams to create.
	Count *int32

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, provides updates to the
// parallelism count.
type InputParallelismUpdate struct {

	// The number of in-application streams to create for the specified streaming
	// source.
	//
	// This member is required.
	CountUpdate *int32

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes a processor that
// is used to preprocess the records in the stream before being processed by your
// application code. Currently, the only input processor available is Amazon Lambda
// (https://docs.aws.amazon.com/lambda/).
type InputProcessingConfiguration struct {

	// The InputLambdaProcessor that is used to preprocess the records in the stream
	// before being processed by your application code.
	//
	// This member is required.
	InputLambdaProcessor *InputLambdaProcessor

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, provides the configuration
// information about an input processor. Currently, the only input processor
// available is Amazon Lambda (https://docs.aws.amazon.com/lambda/).
type InputProcessingConfigurationDescription struct {

	// Provides configuration information about the associated
	// InputLambdaProcessorDescription
	InputLambdaProcessorDescription *InputLambdaProcessorDescription

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes updates to an
// InputProcessingConfiguration.
type InputProcessingConfigurationUpdate struct {

	// Provides update information for an InputLambdaProcessor.
	//
	// This member is required.
	InputLambdaProcessorUpdate *InputLambdaProcessorUpdate

	noSmithyDocumentSerde
}

// Describes updates for an SQL-based Kinesis Data Analytics application's input
// schema.
type InputSchemaUpdate struct {

	// A list of RecordColumn objects. Each object describes the mapping of the
	// streaming source element to the corresponding column in the in-application
	// stream.
	RecordColumnUpdates []RecordColumn

	// Specifies the encoding of the records in the streaming source; for example,
	// UTF-8.
	RecordEncodingUpdate *string

	// Specifies the format of the records on the streaming source.
	RecordFormatUpdate *RecordFormat

	noSmithyDocumentSerde
}

// Describes the point at which the application reads from the streaming source.
type InputStartingPositionConfiguration struct {

	// The starting position on the stream.
	//
	// * NOW - Start reading just after the most
	// recent record in the stream, and start at the request timestamp that the
	// customer issued.
	//
	// * TRIM_HORIZON - Start reading at the last untrimmed record in
	// the stream, which is the oldest record available in the stream. This option is
	// not available for an Amazon Kinesis Data Firehose delivery stream.
	//
	// *
	// LAST_STOPPED_POINT - Resume reading from where the application last stopped
	// reading.
	InputStartingPosition InputStartingPosition

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes updates to a
// specific input configuration (identified by the InputId of an application).
type InputUpdate struct {

	// The input ID of the application input to be updated.
	//
	// This member is required.
	InputId *string

	// Describes the parallelism updates (the number of in-application streams Kinesis
	// Data Analytics creates for the specific streaming source).
	InputParallelismUpdate *InputParallelismUpdate

	// Describes updates to an InputProcessingConfiguration.
	InputProcessingConfigurationUpdate *InputProcessingConfigurationUpdate

	// Describes the data format on the streaming source, and how record elements on
	// the streaming source map to columns of the in-application stream that is
	// created.
	InputSchemaUpdate *InputSchemaUpdate

	// If a Kinesis Data Firehose delivery stream is the streaming source to be
	// updated, provides an updated stream ARN.
	KinesisFirehoseInputUpdate *KinesisFirehoseInputUpdate

	// If a Kinesis data stream is the streaming source to be updated, provides an
	// updated stream Amazon Resource Name (ARN).
	KinesisStreamsInputUpdate *KinesisStreamsInputUpdate

	// The name prefix for in-application streams that Kinesis Data Analytics creates
	// for the specific streaming source.
	NamePrefixUpdate *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, provides additional mapping
// information when JSON is the record format on the streaming source.
type JSONMappingParameters struct {

	// The path to the top-level parent that contains the records.
	//
	// This member is required.
	RecordRowPath *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, identifies a Kinesis Data
// Firehose delivery stream as the streaming source. You provide the delivery
// stream's Amazon Resource Name (ARN).
type KinesisFirehoseInput struct {

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// This member is required.
	ResourceARN *string

	noSmithyDocumentSerde
}

// Describes the Amazon Kinesis Data Firehose delivery stream that is configured as
// the streaming source in the application input configuration.
type KinesisFirehoseInputDescription struct {

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// This member is required.
	ResourceARN *string

	// The ARN of the IAM role that Kinesis Data Analytics assumes to access the
	// stream. Provided for backward compatibility. Applications that are created with
	// the current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, when updating application
// input configuration, provides information about a Kinesis Data Firehose delivery
// stream as the streaming source.
type KinesisFirehoseInputUpdate struct {

	// The Amazon Resource Name (ARN) of the input delivery stream to read.
	//
	// This member is required.
	ResourceARNUpdate *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, when configuring application
// output, identifies a Kinesis Data Firehose delivery stream as the destination.
// You provide the stream Amazon Resource Name (ARN) of the delivery stream.
type KinesisFirehoseOutput struct {

	// The ARN of the destination delivery stream to write to.
	//
	// This member is required.
	ResourceARN *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application's output, describes the
// Kinesis Data Firehose delivery stream that is configured as its destination.
type KinesisFirehoseOutputDescription struct {

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// This member is required.
	ResourceARN *string

	// The ARN of the IAM role that Kinesis Data Analytics can assume to access the
	// stream. Provided for backward compatibility. Applications that are created with
	// the current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, when updating an output
// configuration using the UpdateApplication operation, provides information about
// a Kinesis Data Firehose delivery stream that is configured as the destination.
type KinesisFirehoseOutputUpdate struct {

	// The Amazon Resource Name (ARN) of the delivery stream to write to.
	//
	// This member is required.
	ResourceARNUpdate *string

	noSmithyDocumentSerde
}

// Identifies a Kinesis data stream as the streaming source. You provide the
// stream's Amazon Resource Name (ARN).
type KinesisStreamsInput struct {

	// The ARN of the input Kinesis data stream to read.
	//
	// This member is required.
	ResourceARN *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes the Kinesis data
// stream that is configured as the streaming source in the application input
// configuration.
type KinesisStreamsInputDescription struct {

	// The Amazon Resource Name (ARN) of the Kinesis data stream.
	//
	// This member is required.
	ResourceARN *string

	// The ARN of the IAM role that Kinesis Data Analytics can assume to access the
	// stream. Provided for backward compatibility. Applications that are created with
	// the current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string

	noSmithyDocumentSerde
}

// When you update the input configuration for a SQL-based Kinesis Data Analytics
// application, provides information about a Kinesis stream as the streaming
// source.
type KinesisStreamsInputUpdate struct {

	// The Amazon Resource Name (ARN) of the input Kinesis data stream to read.
	//
	// This member is required.
	ResourceARNUpdate *string

	noSmithyDocumentSerde
}

// When you configure a SQL-based Kinesis Data Analytics application's output,
// identifies a Kinesis data stream as the destination. You provide the stream
// Amazon Resource Name (ARN).
type KinesisStreamsOutput struct {

	// The ARN of the destination Kinesis data stream to write to.
	//
	// This member is required.
	ResourceARN *string

	noSmithyDocumentSerde
}

// For an SQL-based Kinesis Data Analytics application's output, describes the
// Kinesis data stream that is configured as its destination.
type KinesisStreamsOutputDescription struct {

	// The Amazon Resource Name (ARN) of the Kinesis data stream.
	//
	// This member is required.
	ResourceARN *string

	// The ARN of the IAM role that Kinesis Data Analytics can assume to access the
	// stream. Provided for backward compatibility. Applications that are created with
	// the current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string

	noSmithyDocumentSerde
}

// When you update a SQL-based Kinesis Data Analytics application's output
// configuration using the UpdateApplication operation, provides information about
// a Kinesis data stream that is configured as the destination.
type KinesisStreamsOutputUpdate struct {

	// The Amazon Resource Name (ARN) of the Kinesis data stream where you want to
	// write the output.
	//
	// This member is required.
	ResourceARNUpdate *string

	noSmithyDocumentSerde
}

// When you configure a SQL-based Kinesis Data Analytics application's output,
// identifies an Amazon Lambda function as the destination. You provide the
// function Amazon Resource Name (ARN) of the Lambda function.
type LambdaOutput struct {

	// The Amazon Resource Name (ARN) of the destination Lambda function to write to.
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: Amazon Lambda
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// This member is required.
	ResourceARN *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application's output, describes the
// Amazon Lambda function that is configured as its destination.
type LambdaOutputDescription struct {

	// The Amazon Resource Name (ARN) of the destination Lambda function.
	//
	// This member is required.
	ResourceARN *string

	// The ARN of the IAM role that Kinesis Data Analytics can assume to write to the
	// destination function. Provided for backward compatibility. Applications that are
	// created with the current API version have an application-level service execution
	// role rather than a resource-level role.
	RoleARN *string

	noSmithyDocumentSerde
}

// When you update an SQL-based Kinesis Data Analytics application's output
// configuration using the UpdateApplication operation, provides information about
// an Amazon Lambda function that is configured as the destination.
type LambdaOutputUpdate struct {

	// The Amazon Resource Name (ARN) of the destination Amazon Lambda function. To
	// specify an earlier version of the Lambda function than the latest, include the
	// Lambda function version in the Lambda function ARN. For more information about
	// Lambda ARNs, see Example ARNs: Amazon Lambda
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// This member is required.
	ResourceARNUpdate *string

	noSmithyDocumentSerde
}

// When you configure a SQL-based Kinesis Data Analytics application's input at the
// time of creating or updating an application, provides additional mapping
// information specific to the record format (such as JSON, CSV, or record fields
// delimited by some delimiter) on the streaming source.
type MappingParameters struct {

	// Provides additional mapping information when the record format uses delimiters
	// (for example, CSV).
	CSVMappingParameters *CSVMappingParameters

	// Provides additional mapping information when JSON is the record format on the
	// streaming source.
	JSONMappingParameters *JSONMappingParameters

	noSmithyDocumentSerde
}

// The information required to specify a Maven reference. You can use Maven
// references to specify dependency JAR files.
type MavenReference struct {

	// The artifact ID of the Maven reference.
	//
	// This member is required.
	ArtifactId *string

	// The group ID of the Maven reference.
	//
	// This member is required.
	GroupId *string

	// The version of the Maven reference.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// Describes configuration parameters for Amazon CloudWatch logging for an
// application. For more information about CloudWatch logging, see Monitoring
// (https://docs.aws.amazon.com/kinesisanalytics/latest/java/monitoring-overview.html).
type MonitoringConfiguration struct {

	// Describes whether to use the default CloudWatch logging configuration for an
	// application. You must set this property to CUSTOM in order to set the LogLevel
	// or MetricsLevel parameters.
	//
	// This member is required.
	ConfigurationType ConfigurationType

	// Describes the verbosity of the CloudWatch Logs for an application.
	LogLevel LogLevel

	// Describes the granularity of the CloudWatch Logs for an application. The
	// Parallelism level is not recommended for applications with a Parallelism over 64
	// due to excessive costs.
	MetricsLevel MetricsLevel

	noSmithyDocumentSerde
}

// Describes configuration parameters for CloudWatch logging for an application.
type MonitoringConfigurationDescription struct {

	// Describes whether to use the default CloudWatch logging configuration for an
	// application.
	ConfigurationType ConfigurationType

	// Describes the verbosity of the CloudWatch Logs for an application.
	LogLevel LogLevel

	// Describes the granularity of the CloudWatch Logs for an application.
	MetricsLevel MetricsLevel

	noSmithyDocumentSerde
}

// Describes updates to configuration parameters for Amazon CloudWatch logging for
// an application.
type MonitoringConfigurationUpdate struct {

	// Describes updates to whether to use the default CloudWatch logging configuration
	// for an application. You must set this property to CUSTOM in order to set the
	// LogLevel or MetricsLevel parameters.
	ConfigurationTypeUpdate ConfigurationType

	// Describes updates to the verbosity of the CloudWatch Logs for an application.
	LogLevelUpdate LogLevel

	// Describes updates to the granularity of the CloudWatch Logs for an application.
	// The Parallelism level is not recommended for applications with a Parallelism
	// over 64 due to excessive costs.
	MetricsLevelUpdate MetricsLevel

	noSmithyDocumentSerde
}

// Describes a SQL-based Kinesis Data Analytics application's output configuration,
// in which you identify an in-application stream and a destination where you want
// the in-application stream data to be written. The destination can be a Kinesis
// data stream or a Kinesis Data Firehose delivery stream.
type Output struct {

	// Describes the data format when records are written to the destination.
	//
	// This member is required.
	DestinationSchema *DestinationSchema

	// The name of the in-application stream.
	//
	// This member is required.
	Name *string

	// Identifies a Kinesis Data Firehose delivery stream as the destination.
	KinesisFirehoseOutput *KinesisFirehoseOutput

	// Identifies a Kinesis data stream as the destination.
	KinesisStreamsOutput *KinesisStreamsOutput

	// Identifies an Amazon Lambda function as the destination.
	LambdaOutput *LambdaOutput

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes the application
// output configuration, which includes the in-application stream name and the
// destination where the stream data is written. The destination can be a Kinesis
// data stream or a Kinesis Data Firehose delivery stream.
type OutputDescription struct {

	// The data format used for writing data to the destination.
	DestinationSchema *DestinationSchema

	// Describes the Kinesis Data Firehose delivery stream that is configured as the
	// destination where output is written.
	KinesisFirehoseOutputDescription *KinesisFirehoseOutputDescription

	// Describes the Kinesis data stream that is configured as the destination where
	// output is written.
	KinesisStreamsOutputDescription *KinesisStreamsOutputDescription

	// Describes the Lambda function that is configured as the destination where output
	// is written.
	LambdaOutputDescription *LambdaOutputDescription

	// The name of the in-application stream that is configured as output.
	Name *string

	// A unique identifier for the output configuration.
	OutputId *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes updates to the
// output configuration identified by the OutputId.
type OutputUpdate struct {

	// Identifies the specific output configuration that you want to update.
	//
	// This member is required.
	OutputId *string

	// Describes the data format when records are written to the destination.
	DestinationSchemaUpdate *DestinationSchema

	// Describes a Kinesis Data Firehose delivery stream as the destination for the
	// output.
	KinesisFirehoseOutputUpdate *KinesisFirehoseOutputUpdate

	// Describes a Kinesis data stream as the destination for the output.
	KinesisStreamsOutputUpdate *KinesisStreamsOutputUpdate

	// Describes an Amazon Lambda function as the destination for the output.
	LambdaOutputUpdate *LambdaOutputUpdate

	// If you want to specify a different in-application stream for this output
	// configuration, use this field to specify the new in-application stream name.
	NameUpdate *string

	noSmithyDocumentSerde
}

// Describes parameters for how a Flink-based Kinesis Data Analytics application
// executes multiple tasks simultaneously. For more information about parallelism,
// see Parallel Execution
// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/dev/parallel.html)
// in the Apache Flink Documentation
// (https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
type ParallelismConfiguration struct {

	// Describes whether the application uses the default parallelism for the Kinesis
	// Data Analytics service. You must set this property to CUSTOM in order to change
	// your application's AutoScalingEnabled, Parallelism, or ParallelismPerKPU
	// properties.
	//
	// This member is required.
	ConfigurationType ConfigurationType

	// Describes whether the Kinesis Data Analytics service can increase the
	// parallelism of the application in response to increased throughput.
	AutoScalingEnabled *bool

	// Describes the initial number of parallel tasks that a Flink-based Kinesis Data
	// Analytics application can perform. If AutoScalingEnabled is set to True, Kinesis
	// Data Analytics increases the CurrentParallelism value in response to application
	// load. The service can increase the CurrentParallelism value up to the maximum
	// parallelism, which is ParalellismPerKPU times the maximum KPUs for the
	// application. The maximum KPUs for an application is 32 by default, and can be
	// increased by requesting a limit increase. If application load is reduced, the
	// service can reduce the CurrentParallelism value down to the Parallelism setting.
	Parallelism *int32

	// Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics
	// application can perform per Kinesis Processing Unit (KPU) used by the
	// application. For more information about KPUs, see Amazon Kinesis Data Analytics
	// Pricing (http://aws.amazon.com/kinesis/data-analytics/pricing/).
	ParallelismPerKPU *int32

	noSmithyDocumentSerde
}

// Describes parameters for how a Flink-based Kinesis Data Analytics application
// executes multiple tasks simultaneously.
type ParallelismConfigurationDescription struct {

	// Describes whether the Kinesis Data Analytics service can increase the
	// parallelism of the application in response to increased throughput.
	AutoScalingEnabled *bool

	// Describes whether the application uses the default parallelism for the Kinesis
	// Data Analytics service.
	ConfigurationType ConfigurationType

	// Describes the current number of parallel tasks that a Flink-based Kinesis Data
	// Analytics application can perform. If AutoScalingEnabled is set to True, Kinesis
	// Data Analytics can increase this value in response to application load. The
	// service can increase this value up to the maximum parallelism, which is
	// ParalellismPerKPU times the maximum KPUs for the application. The maximum KPUs
	// for an application is 32 by default, and can be increased by requesting a limit
	// increase. If application load is reduced, the service can reduce the
	// CurrentParallelism value down to the Parallelism setting.
	CurrentParallelism *int32

	// Describes the initial number of parallel tasks that a Flink-based Kinesis Data
	// Analytics application can perform. If AutoScalingEnabled is set to True, then
	// Kinesis Data Analytics can increase the CurrentParallelism value in response to
	// application load. The service can increase CurrentParallelism up to the maximum
	// parallelism, which is ParalellismPerKPU times the maximum KPUs for the
	// application. The maximum KPUs for an application is 32 by default, and can be
	// increased by requesting a limit increase. If application load is reduced, the
	// service can reduce the CurrentParallelism value down to the Parallelism setting.
	Parallelism *int32

	// Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics
	// application can perform per Kinesis Processing Unit (KPU) used by the
	// application.
	ParallelismPerKPU *int32

	noSmithyDocumentSerde
}

// Describes updates to parameters for how an application executes multiple tasks
// simultaneously.
type ParallelismConfigurationUpdate struct {

	// Describes updates to whether the Kinesis Data Analytics service can increase the
	// parallelism of a Flink-based Kinesis Data Analytics application in response to
	// increased throughput.
	AutoScalingEnabledUpdate *bool

	// Describes updates to whether the application uses the default parallelism for
	// the Kinesis Data Analytics service, or if a custom parallelism is used. You must
	// set this property to CUSTOM in order to change your application's
	// AutoScalingEnabled, Parallelism, or ParallelismPerKPU properties.
	ConfigurationTypeUpdate ConfigurationType

	// Describes updates to the number of parallel tasks an application can perform per
	// Kinesis Processing Unit (KPU) used by the application.
	ParallelismPerKPUUpdate *int32

	// Describes updates to the initial number of parallel tasks an application can
	// perform. If AutoScalingEnabled is set to True, then Kinesis Data Analytics can
	// increase the CurrentParallelism value in response to application load. The
	// service can increase CurrentParallelism up to the maximum parallelism, which is
	// ParalellismPerKPU times the maximum KPUs for the application. The maximum KPUs
	// for an application is 32 by default, and can be increased by requesting a limit
	// increase. If application load is reduced, the service will reduce
	// CurrentParallelism down to the Parallelism setting.
	ParallelismUpdate *int32

	noSmithyDocumentSerde
}

// Property key-value pairs passed into an application.
type PropertyGroup struct {

	// Describes the key of an application execution property key-value pair.
	//
	// This member is required.
	PropertyGroupId *string

	// Describes the value of an application execution property key-value pair.
	//
	// This member is required.
	PropertyMap map[string]string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes the mapping of
// each data element in the streaming source to the corresponding column in the
// in-application stream. Also used to describe the format of the reference data
// source.
type RecordColumn struct {

	// The name of the column that is created in the in-application input stream or
	// reference table.
	//
	// This member is required.
	Name *string

	// The type of column created in the in-application input stream or reference
	// table.
	//
	// This member is required.
	SqlType *string

	// A reference to the data element in the streaming input or the reference data
	// source.
	Mapping *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes the record format
// and relevant mapping information that should be applied to schematize the
// records on the stream.
type RecordFormat struct {

	// The type of record format.
	//
	// This member is required.
	RecordFormatType RecordFormatType

	// When you configure application input at the time of creating or updating an
	// application, provides additional mapping information specific to the record
	// format (such as JSON, CSV, or record fields delimited by some delimiter) on the
	// streaming source.
	MappingParameters *MappingParameters

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes the reference data
// source by providing the source information (Amazon S3 bucket name and object key
// name), the resulting in-application table name that is created, and the
// necessary schema to map the data elements in the Amazon S3 object to the
// in-application table.
type ReferenceDataSource struct {

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	//
	// This member is required.
	ReferenceSchema *SourceSchema

	// The name of the in-application table to create.
	//
	// This member is required.
	TableName *string

	// Identifies the S3 bucket and object that contains the reference data. A Kinesis
	// Data Analytics application loads reference data only once. If the data changes,
	// you call the UpdateApplication operation to trigger reloading of data into your
	// application.
	S3ReferenceDataSource *S3ReferenceDataSource

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes the reference data
// source configured for an application.
type ReferenceDataSourceDescription struct {

	// The ID of the reference data source. This is the ID that Kinesis Data Analytics
	// assigns when you add the reference data source to your application using the
	// CreateApplication or UpdateApplication operation.
	//
	// This member is required.
	ReferenceId *string

	// Provides the Amazon S3 bucket name, the object key name that contains the
	// reference data.
	//
	// This member is required.
	S3ReferenceDataSourceDescription *S3ReferenceDataSourceDescription

	// The in-application table name created by the specific reference data source
	// configuration.
	//
	// This member is required.
	TableName *string

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	ReferenceSchema *SourceSchema

	noSmithyDocumentSerde
}

// When you update a reference data source configuration for a SQL-based Kinesis
// Data Analytics application, this object provides all the updated values (such as
// the source bucket name and object key name), the in-application table name that
// is created, and updated mapping information that maps the data in the Amazon S3
// object to the in-application reference table that is created.
type ReferenceDataSourceUpdate struct {

	// The ID of the reference data source that is being updated. You can use the
	// DescribeApplication operation to get this value.
	//
	// This member is required.
	ReferenceId *string

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	ReferenceSchemaUpdate *SourceSchema

	// Describes the S3 bucket name, object key name, and IAM role that Kinesis Data
	// Analytics can assume to read the Amazon S3 object on your behalf and populate
	// the in-application reference table.
	S3ReferenceDataSourceUpdate *S3ReferenceDataSourceUpdate

	// The in-application table name that is created by this update.
	TableNameUpdate *string

	noSmithyDocumentSerde
}

// Describes the starting parameters for an Kinesis Data Analytics application.
type RunConfiguration struct {

	// Describes the restore behavior of a restarting application.
	ApplicationRestoreConfiguration *ApplicationRestoreConfiguration

	// Describes the starting parameters for a Flink-based Kinesis Data Analytics
	// application.
	FlinkRunConfiguration *FlinkRunConfiguration

	// Describes the starting parameters for a SQL-based Kinesis Data Analytics
	// application application.
	SqlRunConfigurations []SqlRunConfiguration

	noSmithyDocumentSerde
}

// Describes the starting properties for a Kinesis Data Analytics application.
type RunConfigurationDescription struct {

	// Describes the restore behavior of a restarting application.
	ApplicationRestoreConfigurationDescription *ApplicationRestoreConfiguration

	// Describes the starting parameters for a Flink-based Kinesis Data Analytics
	// application.
	FlinkRunConfigurationDescription *FlinkRunConfiguration

	noSmithyDocumentSerde
}

// Describes the updates to the starting parameters for a Kinesis Data Analytics
// application.
type RunConfigurationUpdate struct {

	// Describes updates to the restore behavior of a restarting application.
	ApplicationRestoreConfiguration *ApplicationRestoreConfiguration

	// Describes the starting parameters for a Flink-based Kinesis Data Analytics
	// application.
	FlinkRunConfiguration *FlinkRunConfiguration

	noSmithyDocumentSerde
}

// Describes the location of an application's code stored in an S3 bucket.
type S3ApplicationCodeLocationDescription struct {

	// The Amazon Resource Name (ARN) for the S3 bucket containing the application
	// code.
	//
	// This member is required.
	BucketARN *string

	// The file key for the object containing the application code.
	//
	// This member is required.
	FileKey *string

	// The version of the object containing the application code.
	ObjectVersion *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, provides a description of an
// Amazon S3 data source, including the Amazon Resource Name (ARN) of the S3 bucket
// and the name of the Amazon S3 object that contains the data.
type S3Configuration struct {

	// The ARN of the S3 bucket that contains the data.
	//
	// This member is required.
	BucketARN *string

	// The name of the object that contains the data.
	//
	// This member is required.
	FileKey *string

	noSmithyDocumentSerde
}

// The S3 bucket that holds the application information.
type S3ContentBaseLocation struct {

	// The Amazon Resource Name (ARN) of the S3 bucket.
	//
	// This member is required.
	BucketARN *string

	// The base path for the S3 bucket.
	BasePath *string

	noSmithyDocumentSerde
}

// The description of the S3 base location that holds the application.
type S3ContentBaseLocationDescription struct {

	// The Amazon Resource Name (ARN) of the S3 bucket.
	//
	// This member is required.
	BucketARN *string

	// The base path for the S3 bucket.
	BasePath *string

	noSmithyDocumentSerde
}

// The information required to update the S3 base location that holds the
// application.
type S3ContentBaseLocationUpdate struct {

	// The updated S3 bucket path.
	BasePathUpdate *string

	// The updated Amazon Resource Name (ARN) of the S3 bucket.
	BucketARNUpdate *string

	noSmithyDocumentSerde
}

// For a Kinesis Data Analytics application provides a description of an Amazon S3
// object, including the Amazon Resource Name (ARN) of the S3 bucket, the name of
// the Amazon S3 object that contains the data, and the version number of the
// Amazon S3 object that contains the data.
type S3ContentLocation struct {

	// The Amazon Resource Name (ARN) for the S3 bucket containing the application
	// code.
	//
	// This member is required.
	BucketARN *string

	// The file key for the object containing the application code.
	//
	// This member is required.
	FileKey *string

	// The version of the object containing the application code.
	ObjectVersion *string

	noSmithyDocumentSerde
}

// Describes an update for the Amazon S3 code content location for an application.
type S3ContentLocationUpdate struct {

	// The new Amazon Resource Name (ARN) for the S3 bucket containing the application
	// code.
	BucketARNUpdate *string

	// The new file key for the object containing the application code.
	FileKeyUpdate *string

	// The new version of the object containing the application code.
	ObjectVersionUpdate *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, identifies the Amazon S3
// bucket and object that contains the reference data. A Kinesis Data Analytics
// application loads reference data only once. If the data changes, you call the
// UpdateApplication operation to trigger reloading of data into your application.
type S3ReferenceDataSource struct {

	// The Amazon Resource Name (ARN) of the S3 bucket.
	BucketARN *string

	// The object key name containing the reference data.
	FileKey *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, provides the bucket name and
// object key name that stores the reference data.
type S3ReferenceDataSourceDescription struct {

	// The Amazon Resource Name (ARN) of the S3 bucket.
	//
	// This member is required.
	BucketARN *string

	// Amazon S3 object key name.
	//
	// This member is required.
	FileKey *string

	// The ARN of the IAM role that Kinesis Data Analytics can assume to read the
	// Amazon S3 object on your behalf to populate the in-application reference table.
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather than
	// a resource-level role.
	ReferenceRoleARN *string

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes the Amazon S3
// bucket name and object key name for an in-application reference table.
type S3ReferenceDataSourceUpdate struct {

	// The Amazon Resource Name (ARN) of the S3 bucket.
	BucketARNUpdate *string

	// The object key name.
	FileKeyUpdate *string

	noSmithyDocumentSerde
}

// Provides details about a snapshot of application state.
type SnapshotDetails struct {

	// The current application version ID when the snapshot was created.
	//
	// This member is required.
	ApplicationVersionId *int64

	// The identifier for the application snapshot.
	//
	// This member is required.
	SnapshotName *string

	// The status of the application snapshot.
	//
	// This member is required.
	SnapshotStatus SnapshotStatus

	// The timestamp of the application snapshot.
	SnapshotCreationTimestamp *time.Time

	noSmithyDocumentSerde
}

// For a SQL-based Kinesis Data Analytics application, describes the format of the
// data in the streaming source, and how each data element maps to corresponding
// columns created in the in-application stream.
type SourceSchema struct {

	// A list of RecordColumn objects.
	//
	// This member is required.
	RecordColumns []RecordColumn

	// Specifies the format of the records on the streaming source.
	//
	// This member is required.
	RecordFormat *RecordFormat

	// Specifies the encoding of the records in the streaming source. For example,
	// UTF-8.
	RecordEncoding *string

	noSmithyDocumentSerde
}

// Describes the inputs, outputs, and reference data sources for a SQL-based
// Kinesis Data Analytics application.
type SqlApplicationConfiguration struct {

	// The array of Input objects describing the input streams used by the application.
	Inputs []Input

	// The array of Output objects describing the destination streams used by the
	// application.
	Outputs []Output

	// The array of ReferenceDataSource objects describing the reference data sources
	// used by the application.
	ReferenceDataSources []ReferenceDataSource

	noSmithyDocumentSerde
}

// Describes the inputs, outputs, and reference data sources for a SQL-based
// Kinesis Data Analytics application.
type SqlApplicationConfigurationDescription struct {

	// The array of InputDescription objects describing the input streams used by the
	// application.
	InputDescriptions []InputDescription

	// The array of OutputDescription objects describing the destination streams used
	// by the application.
	OutputDescriptions []OutputDescription

	// The array of ReferenceDataSourceDescription objects describing the reference
	// data sources used by the application.
	ReferenceDataSourceDescriptions []ReferenceDataSourceDescription

	noSmithyDocumentSerde
}

// Describes updates to the input streams, destination streams, and reference data
// sources for a SQL-based Kinesis Data Analytics application.
type SqlApplicationConfigurationUpdate struct {

	// The array of InputUpdate objects describing the new input streams used by the
	// application.
	InputUpdates []InputUpdate

	// The array of OutputUpdate objects describing the new destination streams used by
	// the application.
	OutputUpdates []OutputUpdate

	// The array of ReferenceDataSourceUpdate objects describing the new reference data
	// sources used by the application.
	ReferenceDataSourceUpdates []ReferenceDataSourceUpdate

	noSmithyDocumentSerde
}

// Describes the starting parameters for a SQL-based Kinesis Data Analytics
// application.
type SqlRunConfiguration struct {

	// The input source ID. You can get this ID by calling the DescribeApplication
	// operation.
	//
	// This member is required.
	InputId *string

	// The point at which you want the application to start processing records from the
	// streaming source.
	//
	// This member is required.
	InputStartingPositionConfiguration *InputStartingPositionConfiguration

	noSmithyDocumentSerde
}

// A key-value pair (the value is optional) that you can define and assign to
// Amazon resources. If you specify a tag that already exists, the tag value is
// replaced with the value that you specify in the request. Note that the maximum
// number of application tags includes system tags. The maximum number of
// user-defined application tags is 50. For more information, see Using Tagging
// (https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
type Tag struct {

	// The key of the key-value tag.
	//
	// This member is required.
	Key *string

	// The value of the key-value tag. The value is optional.
	Value *string

	noSmithyDocumentSerde
}

// Describes the parameters of a VPC used by the application.
type VpcConfiguration struct {

	// The array of SecurityGroup
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html)
	// IDs used by the VPC configuration.
	//
	// This member is required.
	SecurityGroupIds []string

	// The array of Subnet
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html) IDs
	// used by the VPC configuration.
	//
	// This member is required.
	SubnetIds []string

	noSmithyDocumentSerde
}

// Describes the parameters of a VPC used by the application.
type VpcConfigurationDescription struct {

	// The array of SecurityGroup
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html)
	// IDs used by the VPC configuration.
	//
	// This member is required.
	SecurityGroupIds []string

	// The array of Subnet
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html) IDs
	// used by the VPC configuration.
	//
	// This member is required.
	SubnetIds []string

	// The ID of the VPC configuration.
	//
	// This member is required.
	VpcConfigurationId *string

	// The ID of the associated VPC.
	//
	// This member is required.
	VpcId *string

	noSmithyDocumentSerde
}

// Describes updates to the VPC configuration used by the application.
type VpcConfigurationUpdate struct {

	// Describes an update to the ID of the VPC configuration.
	//
	// This member is required.
	VpcConfigurationId *string

	// Describes updates to the array of SecurityGroup
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html)
	// IDs used by the VPC configuration.
	SecurityGroupIdUpdates []string

	// Describes updates to the array of Subnet
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html) IDs
	// used by the VPC configuration.
	SubnetIdUpdates []string

	noSmithyDocumentSerde
}

// The configuration of a Kinesis Data Analytics Studio notebook.
type ZeppelinApplicationConfiguration struct {

	// The Amazon Glue Data Catalog that you use in queries in a Kinesis Data Analytics
	// Studio notebook.
	CatalogConfiguration *CatalogConfiguration

	// Custom artifacts are dependency JARs and user-defined functions (UDF).
	CustomArtifactsConfiguration []CustomArtifactConfiguration

	// The information required to deploy a Kinesis Data Analytics Studio notebook as
	// an application with durable state.
	DeployAsApplicationConfiguration *DeployAsApplicationConfiguration

	// The monitoring configuration of a Kinesis Data Analytics Studio notebook.
	MonitoringConfiguration *ZeppelinMonitoringConfiguration

	noSmithyDocumentSerde
}

// The configuration of a Kinesis Data Analytics Studio notebook.
type ZeppelinApplicationConfigurationDescription struct {

	// The monitoring configuration of a Kinesis Data Analytics Studio notebook.
	//
	// This member is required.
	MonitoringConfigurationDescription *ZeppelinMonitoringConfigurationDescription

	// The Amazon Glue Data Catalog that is associated with the Kinesis Data Analytics
	// Studio notebook.
	CatalogConfigurationDescription *CatalogConfigurationDescription

	// Custom artifacts are dependency JARs and user-defined functions (UDF).
	CustomArtifactsConfigurationDescription []CustomArtifactConfigurationDescription

	// The parameters required to deploy a Kinesis Data Analytics Studio notebook as an
	// application with durable state.
	DeployAsApplicationConfigurationDescription *DeployAsApplicationConfigurationDescription

	noSmithyDocumentSerde
}

// Updates to the configuration of Kinesis Data Analytics Studio notebook.
type ZeppelinApplicationConfigurationUpdate struct {

	// Updates to the configuration of the Amazon Glue Data Catalog that is associated
	// with the Kinesis Data Analytics Studio notebook.
	CatalogConfigurationUpdate *CatalogConfigurationUpdate

	// Updates to the customer artifacts. Custom artifacts are dependency JAR files and
	// user-defined functions (UDF).
	CustomArtifactsConfigurationUpdate []CustomArtifactConfiguration

	// Updates to the configuration information required to deploy an Amazon Data
	// Analytics Studio notebook as an application with durable state.
	DeployAsApplicationConfigurationUpdate *DeployAsApplicationConfigurationUpdate

	// Updates to the monitoring configuration of a Kinesis Data Analytics Studio
	// notebook.
	MonitoringConfigurationUpdate *ZeppelinMonitoringConfigurationUpdate

	noSmithyDocumentSerde
}

// Describes configuration parameters for Amazon CloudWatch logging for a Kinesis
// Data Analytics Studio notebook. For more information about CloudWatch logging,
// see Monitoring
// (https://docs.aws.amazon.com/kinesisanalytics/latest/java/monitoring-overview.html).
type ZeppelinMonitoringConfiguration struct {

	// The verbosity of the CloudWatch Logs for an application.
	//
	// This member is required.
	LogLevel LogLevel

	noSmithyDocumentSerde
}

// The monitoring configuration for Apache Zeppelin within a Kinesis Data Analytics
// Studio notebook.
type ZeppelinMonitoringConfigurationDescription struct {

	// Describes the verbosity of the CloudWatch Logs for an application.
	LogLevel LogLevel

	noSmithyDocumentSerde
}

// Updates to the monitoring configuration for Apache Zeppelin within a Kinesis
// Data Analytics Studio notebook.
type ZeppelinMonitoringConfigurationUpdate struct {

	// Updates to the logging level for Apache Zeppelin within a Kinesis Data Analytics
	// Studio notebook.
	//
	// This member is required.
	LogLevelUpdate LogLevel

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
