# Every Programmer Should Know :thinking:
A collection of (mostly) technical things every software developer should know.  

:point_up: *These are resources I can recommend to every programmer regardless of their skill level or tech stack*

Highly opinionated :bomb:. Not backed by science.  
Comes in no particular order :recycle:

U like it? :star: it and [share](https://twitter.com/mr_mig_by/status/900735231552098306) with a friendly developer!
U don't like it? [Watch the doggo](https://twitter.com/RespectfulMemes/status/900147758845308930) :dog:

*P.S. You [don't need to know](https://xkcd.com/1050/) all of that by heart to be a programmer.  
But knowing the stuff will help you become better! :muscle:*

*P.P.S. [Contributions](CONTRIBUTING.md) are welcome!*

----

### Introduction
- :movie_camera: [Map of Computer Science](https://www.youtube.com/watch?v=SzJ46YA_RaA)
- :movie_camera: [40 Key Computer Science Concepts Explained In Layman’s Terms](http://carlcheo.com/compsci)

### Falsehoods
- [Awesome Falsehoods](https://github.com/kdeldycke/awesome-falsehood)  
  💊 Curated list of falsehoods programmers believe in.    
  Check for things you do not know about Strings, Addresses, Names, Numbers, Emails, Timezones and Dates and more.

### Algorithms
- [Big O Cheatsheet](http://bigocheatsheet.com/)
- :book: [Grokking Algorithms](https://www.goodreads.com/book/show/22847284-grokking-algorithms-an-illustrated-guide-for-programmers-and-other-curio)
- [Algorithms Visualization](http://www.cs.usfca.edu/~galles/visualization/Algorithms.html)

### Data Structures
- :movie_camera: [UC Berkeley, Data Structures Course](https://archive.org/details/ucberkeley-webcast-PL-XXv-cvA_iAlnI-BQr9hjqADPBtujFJd)
- [Foundations of Data Structures - EDX](https://www.edx.org/course/foundations-data-structures-iitbombayx-cs213-1x-0#!)
- [Data Structures - Coursera](https://www.coursera.org/learn/data-structures)
- [Mathematics for Computer Science - Eric Lehman](https://courses.csail.mit.edu/6.042/spring17/mcs.pdf)

### Numbers
- :book: [How to Count](https://www.goodreads.com/book/show/12093869-how-to-count)
- :page_facing_up: [Floating Point Guide](http://floating-point-gui.de/)
- :page_facing_up: [What Every Computer Scientist Should Know About Floating-Point Arithmetic](https://docs.oracle.com/cd/E19957-01/806-3568/ncg_goldberg.html#680)
- :page_facing_up: [Basic Number Theory Every Programmer Should Know...](https://www.codechef.com/wiki/tutorial-number-theory/)

### Strings
- :page_facing_up: [Unicode and Character Sets](http://www.joelonsoftware.com/articles/Unicode.html)
- [Homoglyphs](https://github.com/codebox/homoglyph/)
- [Unicode Common Locale Data Repository](http://cldr.unicode.org/)
- :movie_camera: [ASCII](https://www.youtube.com/watch?v=B1Sf1IhA0j4)
- :movie_camera: [UTF-8](https://www.youtube.com/watch?v=vLBtrd9Ar28)

### Latency
- [Interactive Latency Infographics](https://people.eecs.berkeley.edu/~rcs/research/interactive_latency.html)
- :page_facing_up: [Latency Numbers Every Programmer Should Know](https://gist.github.com/jboner/2841832)

### Time
- :page_facing_up: [Some notes about time](https://unix4lyfe.org/time/)

### Memory
- :page_facing_up: [What every Programmer should know about memory](http://lwn.net/Articles/250967/)

### Distributed Systems
- :book: [Designing Data-Intensive Applications](https://www.goodreads.com/book/show/23463279-designing-data-intensive-applications)
- :scroll: [Designs, Lessons and Advice from Building Large Distributed Systems](http://www.cs.cornell.edu/projects/ladis2009/talks/dean-keynote-ladis2009.pdf)
- :scroll: [Time, Clocks and the Ordering of Events in a Distributed System](https://www.microsoft.com/en-us/research/publication/time-clocks-ordering-events-distributed-system/?from=http%3A%2F%2Fresearch.microsoft.com%2Fen-us%2Fum%2Fpeople%2Flamport%2Fpubs%2Ftime-clocks.pdf)
- :page_facing_up: [There is No Now](http://queue.acm.org/detail.cfm?id=2745385)
- :page_facing_up: [Jepsen: how different databases behave under partition](https://aphyr.com/tags/jepsen)
- :scroll: [Fallacies of Distributed Computing Explained](http://www.rgoarchitects.com/Files/fallacies.pdf)

### RegExp
- [RegexHQ](https://github.com/regexhq)
- [Learn regex the easy way](https://github.com/zeeshanu/learn-regex)

### Security
- :book: [Security Programming](https://www.dwheeler.com/secure-programs/)
- :page_facing_up: [Rolling Your Own Crypto](http://loup-vaillant.fr/articles/rolling-your-own-crypto)
- :page_facing_up: [Cryptographic Right Answers](https://gist.github.com/tqbf/be58d2d39690c3b366ad)
- :page_facing_up: [An Open Letter to Developers Everywhere (About Cryptography)](https://gist.github.com/paragonie-scott/e9319254c8ecbad4f227)
- :book: [Foundations of Security: What Every Programmer Needs to Know ](https://www.goodreads.com/book/show/128003.Foundations_of_Security)
- [OWASP Top 10](https://www.owasp.org/index.php/Category:OWASP_Top_Ten_Project)
- [Web Application Exploits and Defenses](https://google-gruyere.appspot.com/part1)

### SEO
- :page_facing_up: [What Every Programmer Should Know About SEO](http://katemats.com/what-every-programmer-should-know-about-seo/)

### Architecture
- :scroll: [A Field Guide to Boxology](http://web.cs.wpi.edu/~cs562/s98/pdf/Boxology.pdf)
- :scroll: [Out of the Tar Pit](https://github.com/papers-we-love/papers-we-love/blob/master/design/out-of-the-tar-pit.pdf?raw=true)
- :scroll: [No Silver Bullet — Essence and Accidents of Software Engineering](http://faculty.salisbury.edu/~xswang/Research/Papers/SERelated/no-silver-bullet.pdf)
- :movie_camera: [Growing a Language](https://www.youtube.com/watch?v=_ahvzDzKdB0)
- :movie_camera: [CQRS and Event Sourcing](https://www.youtube.com/watch?v=JHGkaShoyNs)
- :book: [Practical Object Oriented Design in Ruby](http://www.poodr.com/)
- :movie_camera: [Evolutionary Software Architectures](https://www.youtube.com/watch?v=CglSFhwbI3s)
- [System Design: A Primer](https://github.com/donnemartin/system-design-primer)
- :page_facing_up: [How JavaScript works: part-1](https://blog.sessionstack.com/how-does-javascript-actually-work-part-1-b0bacc073cf), [2](https://blog.sessionstack.com/how-javascript-works-inside-the-v8-engine-5-tips-on-how-to-write-optimized-code-ac089e62b12e), [3](https://blog.sessionstack.com/how-javascript-works-memory-management-how-to-handle-4-common-memory-leaks-3f28b94cfbec), [4](https://blog.sessionstack.com/how-javascript-works-event-loop-and-the-rise-of-async-programming-5-ways-to-better-coding-with-2f077c4438b5)

### Practices
- :book: [Working Effectively with Legacy Code](https://www.goodreads.com/book/show/44919.Working_Effectively_with_Legacy_Code)
- :book: [Clean Code: A Handbook of Agile Software Craftsmanship](https://www.goodreads.com/book/show/3735293-clean-code)
- :book: [Test Driven Development: By Example](https://www.goodreads.com/book/show/387190.Test_Driven_Development)
- :white_check_mark: [Going To Production Checklist](https://github.com/mr-mig/going-to-production)
- :book: [Release It!](https://www.goodreads.com/book/show/1069827.Release_It_)
- :book: [Professor Frisby's Mostly Adequate Guide to Functional Programming](https://drboolean.gitbooks.io/mostly-adequate-guide/content/)
- :book: [SICP: Structure and Interpretation of Computer Programs](https://www.goodreads.com/book/show/43713.Structure_and_Interpretation_of_Computer_Programs)
- :page_facing_up: [Thirteen Ways of Looking at a Turtle](https://fsharpforfunandprofit.com/posts/13-ways-of-looking-at-a-turtle-3/)
- :scroll: [Programming Paradigms for Dummies: What Every Programmer Should Know](https://www.info.ucl.ac.be/~pvr/VanRoyChapter.pdf)
- [Learn X in Y Minutes](https://learnxinyminutes.com/)  
  Learn the basics of a language in a highly condensed way.
- [Hyperpolyglot](http://hyperpolyglot.org/)  
  Compare commonly used features of more or less similar languages side-by-side. Helps you to jump Python<->Ruby, Ocaml<->Haskell, etc.
- :page_facing_up: [Pomodoro for Programmers](http://www.metadevelopment.io/pomodoro-for-programmers/)

### Career
- :page_facing_up: [10 Things Every Programmer Should Know For Their First Job](http://www.applematters.com/article/10-things-every-programmer-should-know-for-their-first-job/)
- :page_facing_up: [How Much Do Software Engineers Really Make in Each City?](https://www.codementor.io/blog/best-cities-software-engineer-earnings-271vpf599k)
- :page_facing_up: [Software Engineers Tenure in San Francisco](https://hackerlife.co/blog/san-francisco-large-corporation-employee-tenure)
- [Software Engineering 101](https://slides.com/mr-mig/se101)
- :book: [The Passionate Programmer](https://www.goodreads.com/book/show/6399113-the-passionate-programmer)
- :book: [Soft Skills: The software developer's life manual](https://www.goodreads.com/book/show/23232941-soft-skills)
- :book: [The Complete Software Developer's Career Guide](https://www.goodreads.com/book/show/35674293-the-complete-software-developer-s-career-guide)
- :book: [Programming Beyond Practices: Be More Than Just a Code Monkey](https://www.goodreads.com/book/show/29895093-programming-beyond-practices)
- [A list of European Investors](https://docs.google.com/spreadsheets/d/1hfl67rI0Pk_hSm0GIX0QByW4NgfAH-cEmMa4N6UoO1w/edit#gid=1203141194)
- :page_facing_up: [Ten Rules for Negotiating a Job Offer](https://medium.freecodecamp.com/ten-rules-for-negotiating-a-job-offer-ee17cccbdab6)
- :page_facing_up: [How To Interview As a Developer Candidate](https://medium.freecodecamp.com/how-to-interview-as-a-developer-candidate-b666734f12dd)
- :book: [How To Be A STAR Engineer](http://vlsicad.ucsd.edu/Research/Advice/star_engineer.pdf)
- :page_facing_up: [TL;DR; Stock Options](https://tldroptions.io/)
- :page_facing_up: [Equity 101 for Startup Employees](https://blog.carta.com/equity-101-stock-option-basics/)
- :book: [Cracking the Coding Interview: 189 Programming Questions and Solutions](https://www.goodreads.com/book/show/25707092-cracking-the-coding-interview)
- :fire: [Everything you need to know to get the job](https://github.com/kdn251/interviews)
- :book: [Tech Interview Handbook](https://github.com/yangshun/tech-interview-handbook)
- :page_facing_up: [Teach Yourself Programming in Ten Years](http://norvig.com/21-days.html)
- :page_facing_up: [What you should know as a founder of a software company](https://qotoqot.com/blog/founder-skills/)


### UX/Usability
- :book: [Don't Make Me Think: A Common Sense Approach to Web Usability](https://www.goodreads.com/book/show/18197267-don-t-make-me-think-revisited)
- :movie_camera: [Inventing on Principle](https://vimeo.com/36579366)

### Open Source
- :globe_with_meridians: [An Intro to Git and GitHub for Beginners](http://product.hubspot.com/blog/git-and-github-tutorial-for-beginners)

### Remote Work
- :globe_with_meridians: [Remote Work List for Developers](https://github.com/georgemandis/remote-working-list)
- :zap: [NomadList](https://nomadlist.com/)
- :book: [The Ultimate Guide to Remote Work](https://zapier.com/learn/remote-work/)
- :house: [Awesome Remote Job](https://github.com/lukasz-madon/awesome-remote-job)

### Engineering Philosophy
- :movie_camera: [Simple Made Easy](https://www.infoq.com/presentations/Simple-Made-Easy)
- :page_facing_up: [Speed In Software Development](https://www.targetprocess.com/articles/speed-in-software-development/)
- :movie_camera: [The Myth of the Genius Programmer](https://www.youtube.com/watch?v=0SARbwvhupQ&feature=youtu.be)
- :movie_camera: [Making Badass Developers](https://www.youtube.com/watch?v=FKTxC9pl-WM&t=2s)
- :page_facing_up: [The Ten Rules of a Zen Programmer](https://www.zenprogrammer.org/en/10-rules-of-a-zen-programmer.html)
- :page_facing_up: [The mythical 10x programmer](http://antirez.com/news/112)
- :page_facing_up: [The Debugging Mindset](http://queue.acm.org/detail.cfm?id=3068754)
- :movie_camera: [The Future of Programming](http://worrydream.com/dbx/)

### Problem Solving
- :book: [The Art and Craft of Problem Solving](https://www.goodreads.com/book/show/593458.The_Art_and_Craft_of_Problem_Solving)
- :book: [How to Solve It: A New Aspect of Mathematical Method](https://www.goodreads.com/book/show/192221.How_to_Solve_It)

### Soft Skills
- :book: [Difficult Conversations](https://www.goodreads.com/book/show/774088.Difficult_Conversations)
- :book: [Crucial Conversations](https://www.goodreads.com/book/show/15014.Crucial_Conversations)
- :book: [How to Win Friends and Influence People](https://www.goodreads.com/book/show/4865.How_to_Win_Friends_and_Influence_People)

### Papers on Programming
- :heart: [Papers We Love](https://github.com/papers-we-love/papers-we-love)
- :newspaper: [The Morning Paper](https://blog.acolyer.org/)
- 📜 [What Every Programmer Should Know About Memory](http://futuretech.blinkenlights.nl/misc/cpumemory.pdf)
- 📜 [Go To Statement Considered Harmful](https://homepages.cwi.nl/~storm/teaching/reader/Dijkstra68.pdf)

### Free Books on Programming
- :books: [Free Programming Books](https://github.com/EbookFoundation/free-programming-books)

### Services :zap:
- [Free For Dev](https://github.com/ripienaar/free-for-dev/blob/master/README.md)
- [Public APIs](https://github.com/abhishekbanthia/Public-APIs)
- [The Noun Project](https://thenounproject.com/)
- [Without Coding](https://www.producthunt.com/@jurica87/collections/without-coding)
- [Simpleicons](https://simpleicons.org/)
- [Learn Anything](https://learn-anything.xyz/)
- [repl.it](https://repl.it/)

### Licenses
- [Choose An Open Source License](https://choosealicense.com/)
- [Well-explained Software licenses in TLDR version](https://tldrlegal.com/)

### Where To Look For Further Info
- [freeCodeCamp Guide](https://guide.freecodecamp.org/)
- [GeeksForGeeks](http://www.geeksforgeeks.org/)
- [Dev.To](https://dev.to/)
- [Stack Overflow](https://stackoverflow.com/)
- [Dzone](https://dzone.com/)

### Coding Practice Sites :zap:
- :link: [CodeForces](http://codeforces.com/)
- :link: [CodeChef](https://www.codechef.com)
- :link: [Coderbyte](https://coderbyte.com/)
- :link: [CodinGame](https://www.codingame.com/)
- :link: [Cs Academy](https://csacademy.com/)
- :link: [HackerRank](https://hackerrank.com/)
- :link: [Spoj](https://spoj.com/)
- :link: [HackerEarth](https://hackerearth.com/)
- :link: [TopCoder](https://www.topcoder.com/)
- :link: [Codewars](http://codewars.com/)
- :link: [Exercism](http://www.exercism.io/)
- :link: [CodeFights](https://codefights.com/)
- :link: [Project Euler](https://projecteuler.net/)
- :link: [LeetCode](https://leetcode.com/)
- :link: [InterviewBit](https://www.interviewbit.com/)
- :link: [LintCode](https://www.lintcode.com/)
- :link: [CodeCombat](https://codecombat.com/)

