// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/servicecontrol/v1/log_entry.proto
// DO NOT EDIT!

package google_api_servicecontrol_v1 // import "google.golang.org/genproto/googleapis/api/servicecontrol/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_logging_type "google.golang.org/genproto/googleapis/logging/type"
import google_protobuf1 "github.com/golang/protobuf/ptypes/any"
import google_protobuf2 "github.com/golang/protobuf/ptypes/struct"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// An individual log entry.
type LogEntry struct {
	// Required. The log to which this log entry belongs. Examples: `"syslog"`,
	// `"book_log"`.
	Name string `protobuf:"bytes,10,opt,name=name" json:"name,omitempty"`
	// The time the event described by the log entry occurred. If
	// omitted, defaults to operation start time.
	Timestamp *google_protobuf3.Timestamp `protobuf:"bytes,11,opt,name=timestamp" json:"timestamp,omitempty"`
	// The severity of the log entry. The default value is
	// `LogSeverity.DEFAULT`.
	Severity google_logging_type.LogSeverity `protobuf:"varint,12,opt,name=severity,enum=google.logging.type.LogSeverity" json:"severity,omitempty"`
	// A unique ID for the log entry used for deduplication. If omitted,
	// the implementation will generate one based on operation_id.
	InsertId string `protobuf:"bytes,4,opt,name=insert_id,json=insertId" json:"insert_id,omitempty"`
	// A set of user-defined (key, value) data that provides additional
	// information about the log entry.
	Labels map[string]string `protobuf:"bytes,13,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The log entry payload, which can be one of multiple types.
	//
	// Types that are valid to be assigned to Payload:
	//	*LogEntry_ProtoPayload
	//	*LogEntry_TextPayload
	//	*LogEntry_StructPayload
	Payload isLogEntry_Payload `protobuf_oneof:"payload"`
}

func (m *LogEntry) Reset()                    { *m = LogEntry{} }
func (m *LogEntry) String() string            { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()               {}
func (*LogEntry) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

type isLogEntry_Payload interface {
	isLogEntry_Payload()
}

type LogEntry_ProtoPayload struct {
	ProtoPayload *google_protobuf1.Any `protobuf:"bytes,2,opt,name=proto_payload,json=protoPayload,oneof"`
}
type LogEntry_TextPayload struct {
	TextPayload string `protobuf:"bytes,3,opt,name=text_payload,json=textPayload,oneof"`
}
type LogEntry_StructPayload struct {
	StructPayload *google_protobuf2.Struct `protobuf:"bytes,6,opt,name=struct_payload,json=structPayload,oneof"`
}

func (*LogEntry_ProtoPayload) isLogEntry_Payload()  {}
func (*LogEntry_TextPayload) isLogEntry_Payload()   {}
func (*LogEntry_StructPayload) isLogEntry_Payload() {}

func (m *LogEntry) GetPayload() isLogEntry_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *LogEntry) GetTimestamp() *google_protobuf3.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogEntry) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *LogEntry) GetProtoPayload() *google_protobuf1.Any {
	if x, ok := m.GetPayload().(*LogEntry_ProtoPayload); ok {
		return x.ProtoPayload
	}
	return nil
}

func (m *LogEntry) GetTextPayload() string {
	if x, ok := m.GetPayload().(*LogEntry_TextPayload); ok {
		return x.TextPayload
	}
	return ""
}

func (m *LogEntry) GetStructPayload() *google_protobuf2.Struct {
	if x, ok := m.GetPayload().(*LogEntry_StructPayload); ok {
		return x.StructPayload
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*LogEntry) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _LogEntry_OneofMarshaler, _LogEntry_OneofUnmarshaler, _LogEntry_OneofSizer, []interface{}{
		(*LogEntry_ProtoPayload)(nil),
		(*LogEntry_TextPayload)(nil),
		(*LogEntry_StructPayload)(nil),
	}
}

func _LogEntry_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*LogEntry)
	// payload
	switch x := m.Payload.(type) {
	case *LogEntry_ProtoPayload:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProtoPayload); err != nil {
			return err
		}
	case *LogEntry_TextPayload:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.TextPayload)
	case *LogEntry_StructPayload:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StructPayload); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("LogEntry.Payload has unexpected type %T", x)
	}
	return nil
}

func _LogEntry_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*LogEntry)
	switch tag {
	case 2: // payload.proto_payload
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Any)
		err := b.DecodeMessage(msg)
		m.Payload = &LogEntry_ProtoPayload{msg}
		return true, err
	case 3: // payload.text_payload
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Payload = &LogEntry_TextPayload{x}
		return true, err
	case 6: // payload.struct_payload
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf2.Struct)
		err := b.DecodeMessage(msg)
		m.Payload = &LogEntry_StructPayload{msg}
		return true, err
	default:
		return false, nil
	}
}

func _LogEntry_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*LogEntry)
	// payload
	switch x := m.Payload.(type) {
	case *LogEntry_ProtoPayload:
		s := proto.Size(x.ProtoPayload)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LogEntry_TextPayload:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.TextPayload)))
		n += len(x.TextPayload)
	case *LogEntry_StructPayload:
		s := proto.Size(x.StructPayload)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*LogEntry)(nil), "google.api.servicecontrol.v1.LogEntry")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/servicecontrol/v1/log_entry.proto", fileDescriptor2)
}

var fileDescriptor2 = []byte{
	// 467 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x92, 0xc1, 0x6f, 0xd3, 0x30,
	0x14, 0xc6, 0x9b, 0x75, 0x94, 0xd6, 0x69, 0x27, 0x64, 0x4d, 0x22, 0x0a, 0x1c, 0x22, 0xb8, 0xf4,
	0x64, 0x6b, 0x9d, 0x90, 0x06, 0xe3, 0x00, 0x95, 0x26, 0x75, 0xd0, 0xc3, 0x94, 0x71, 0xaf, 0xdc,
	0xd4, 0x33, 0x16, 0x8e, 0x5f, 0x14, 0xbb, 0x11, 0xf9, 0x93, 0xf9, 0x2f, 0x50, 0x6c, 0xa7, 0x03,
	0x4d, 0xda, 0x10, 0x87, 0xaa, 0xcf, 0xf6, 0xf7, 0x7b, 0xef, 0x7b, 0x5f, 0x8b, 0xbe, 0x0a, 0x00,
	0xa1, 0x38, 0x11, 0xa0, 0x98, 0x16, 0x04, 0x6a, 0x41, 0x05, 0xd7, 0x55, 0x0d, 0x16, 0xa8, 0x7f,
	0x62, 0x95, 0x34, 0x94, 0x55, 0x92, 0x1a, 0x5e, 0x37, 0xb2, 0xe0, 0x05, 0x68, 0x5b, 0x83, 0xa2,
	0xcd, 0x19, 0x55, 0x20, 0x36, 0x5c, 0xdb, 0xba, 0x25, 0x0e, 0xc0, 0xaf, 0x43, 0x33, 0x56, 0x49,
	0xf2, 0xb7, 0x9a, 0x34, 0x67, 0xe9, 0xf5, 0xff, 0x8c, 0xba, 0x93, 0x82, 0x32, 0xad, 0xc1, 0x32,
	0x2b, 0x41, 0x1b, 0x3f, 0x28, 0xbd, 0xfa, 0xb7, 0x56, 0x0a, 0x84, 0x90, 0x5a, 0x50, 0xdb, 0x56,
	0xdc, 0x99, 0x35, 0xbc, 0xe1, 0xb5, 0xb4, 0xc1, 0x6f, 0x4a, 0x85, 0xb4, 0xdf, 0xf7, 0x5b, 0x52,
	0x40, 0x49, 0x7d, 0x2b, 0xea, 0x1e, 0xb6, 0xfb, 0x3b, 0x5a, 0x75, 0x90, 0xa1, 0x4c, 0xb7, 0xdd,
	0x27, 0x00, 0xef, 0x9e, 0x06, 0x8c, 0xad, 0xf7, 0x85, 0x0d, 0x5f, 0x01, 0xbb, 0x7c, 0x1a, 0xb3,
	0xb2, 0xe4, 0xc6, 0xb2, 0xb2, 0xba, 0xaf, 0x3c, 0xfc, 0xe6, 0xd7, 0x10, 0x8d, 0xd7, 0x20, 0xae,
	0xba, 0x9c, 0x31, 0x46, 0xc7, 0x9a, 0x95, 0x3c, 0x41, 0x59, 0x34, 0x9f, 0xe4, 0xae, 0xc6, 0x17,
	0x68, 0x72, 0x60, 0x92, 0x38, 0x8b, 0xe6, 0xf1, 0x22, 0x25, 0x21, 0xa0, 0x7e, 0x0c, 0xf9, 0xd6,
	0x2b, 0xf2, 0x7b, 0x31, 0xfe, 0x88, 0xc6, 0x7d, 0x22, 0xc9, 0x34, 0x8b, 0xe6, 0x27, 0x8b, 0xac,
	0x07, 0x43, 0x74, 0xa4, 0x73, 0x47, 0xd6, 0x20, 0x6e, 0x83, 0x2e, 0x3f, 0x10, 0xf8, 0x15, 0x9a,
	0x48, 0x6d, 0x78, 0x6d, 0x37, 0x72, 0x97, 0x1c, 0x3b, 0x43, 0x63, 0x7f, 0x71, 0xbd, 0xc3, 0x5f,
	0xd0, 0x48, 0xb1, 0x2d, 0x57, 0x26, 0x99, 0x65, 0xc3, 0x79, 0xbc, 0x58, 0x90, 0xc7, 0xfe, 0x1b,
	0xa4, 0x5f, 0x90, 0xac, 0x1d, 0xe4, 0xea, 0x3c, 0x74, 0xc0, 0x97, 0x68, 0xe6, 0xf6, 0xd8, 0x54,
	0xac, 0x55, 0xc0, 0x76, 0xc9, 0x91, 0x5b, 0xf2, 0xf4, 0xc1, 0x92, 0x9f, 0x75, 0xbb, 0x1a, 0xe4,
	0x53, 0x77, 0xbe, 0xf1, 0x5a, 0xfc, 0x16, 0x4d, 0x2d, 0xff, 0x69, 0x0f, 0xec, 0xb0, 0x33, 0xba,
	0x1a, 0xe4, 0x71, 0x77, 0xdb, 0x8b, 0x3e, 0xa1, 0x13, 0xff, 0x83, 0x1d, 0x64, 0x23, 0x37, 0xe2,
	0xe5, 0x83, 0x11, 0xb7, 0x4e, 0xb6, 0x1a, 0xe4, 0x33, 0x0f, 0x84, 0x0e, 0xe9, 0x7b, 0x14, 0xff,
	0x61, 0x1d, 0xbf, 0x40, 0xc3, 0x1f, 0xbc, 0x4d, 0x22, 0x97, 0x4a, 0x57, 0xe2, 0x53, 0xf4, 0xac,
	0x61, 0x6a, 0xcf, 0x9d, 0xf9, 0x49, 0xee, 0x0f, 0x1f, 0x8e, 0x2e, 0xa2, 0xe5, 0x04, 0x3d, 0x0f,
	0x53, 0x97, 0xe7, 0x28, 0x2b, 0xa0, 0x7c, 0x34, 0xaa, 0xe5, 0xac, 0xcf, 0xea, 0xc6, 0xad, 0x19,
	0x6d, 0x47, 0xce, 0xdc, 0xf9, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0xca, 0x34, 0xe0, 0xb6, 0xcb,
	0x03, 0x00, 0x00,
}
