// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/bigtable/v1/bigtable_service.proto
// DO NOT EDIT!

package google_bigtable_v1 // import "google.golang.org/genproto/googleapis/bigtable/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for BigtableService service

type BigtableServiceClient interface {
	// Streams back the contents of all requested rows, optionally applying
	// the same Reader filter to each. Depending on their size, rows may be
	// broken up across multiple responses, but atomicity of each row will still
	// be preserved.
	ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigtableService_ReadRowsClient, error)
	// Returns a sample of row keys in the table. The returned row keys will
	// delimit contiguous sections of the table of approximately equal size,
	// which can be used to break up the data for distributed tasks like
	// mapreduces.
	SampleRowKeys(ctx context.Context, in *SampleRowKeysRequest, opts ...grpc.CallOption) (BigtableService_SampleRowKeysClient, error)
	// Mutates a row atomically. Cells already present in the row are left
	// unchanged unless explicitly changed by 'mutation'.
	MutateRow(ctx context.Context, in *MutateRowRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Mutates multiple rows in a batch. Each individual row is mutated
	// atomically as in MutateRow, but the entire batch is not executed
	// atomically.
	MutateRows(ctx context.Context, in *MutateRowsRequest, opts ...grpc.CallOption) (*MutateRowsResponse, error)
	// Mutates a row atomically based on the output of a predicate Reader filter.
	CheckAndMutateRow(ctx context.Context, in *CheckAndMutateRowRequest, opts ...grpc.CallOption) (*CheckAndMutateRowResponse, error)
	// Modifies a row atomically, reading the latest existing timestamp/value from
	// the specified columns and writing a new value at
	// max(existing timestamp, current server time) based on pre-defined
	// read/modify/write rules. Returns the new contents of all modified cells.
	ReadModifyWriteRow(ctx context.Context, in *ReadModifyWriteRowRequest, opts ...grpc.CallOption) (*Row, error)
}

type bigtableServiceClient struct {
	cc *grpc.ClientConn
}

func NewBigtableServiceClient(cc *grpc.ClientConn) BigtableServiceClient {
	return &bigtableServiceClient{cc}
}

func (c *bigtableServiceClient) ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigtableService_ReadRowsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_BigtableService_serviceDesc.Streams[0], c.cc, "/google.bigtable.v1.BigtableService/ReadRows", opts...)
	if err != nil {
		return nil, err
	}
	x := &bigtableServiceReadRowsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BigtableService_ReadRowsClient interface {
	Recv() (*ReadRowsResponse, error)
	grpc.ClientStream
}

type bigtableServiceReadRowsClient struct {
	grpc.ClientStream
}

func (x *bigtableServiceReadRowsClient) Recv() (*ReadRowsResponse, error) {
	m := new(ReadRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigtableServiceClient) SampleRowKeys(ctx context.Context, in *SampleRowKeysRequest, opts ...grpc.CallOption) (BigtableService_SampleRowKeysClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_BigtableService_serviceDesc.Streams[1], c.cc, "/google.bigtable.v1.BigtableService/SampleRowKeys", opts...)
	if err != nil {
		return nil, err
	}
	x := &bigtableServiceSampleRowKeysClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BigtableService_SampleRowKeysClient interface {
	Recv() (*SampleRowKeysResponse, error)
	grpc.ClientStream
}

type bigtableServiceSampleRowKeysClient struct {
	grpc.ClientStream
}

func (x *bigtableServiceSampleRowKeysClient) Recv() (*SampleRowKeysResponse, error) {
	m := new(SampleRowKeysResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigtableServiceClient) MutateRow(ctx context.Context, in *MutateRowRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.bigtable.v1.BigtableService/MutateRow", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableServiceClient) MutateRows(ctx context.Context, in *MutateRowsRequest, opts ...grpc.CallOption) (*MutateRowsResponse, error) {
	out := new(MutateRowsResponse)
	err := grpc.Invoke(ctx, "/google.bigtable.v1.BigtableService/MutateRows", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableServiceClient) CheckAndMutateRow(ctx context.Context, in *CheckAndMutateRowRequest, opts ...grpc.CallOption) (*CheckAndMutateRowResponse, error) {
	out := new(CheckAndMutateRowResponse)
	err := grpc.Invoke(ctx, "/google.bigtable.v1.BigtableService/CheckAndMutateRow", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableServiceClient) ReadModifyWriteRow(ctx context.Context, in *ReadModifyWriteRowRequest, opts ...grpc.CallOption) (*Row, error) {
	out := new(Row)
	err := grpc.Invoke(ctx, "/google.bigtable.v1.BigtableService/ReadModifyWriteRow", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for BigtableService service

type BigtableServiceServer interface {
	// Streams back the contents of all requested rows, optionally applying
	// the same Reader filter to each. Depending on their size, rows may be
	// broken up across multiple responses, but atomicity of each row will still
	// be preserved.
	ReadRows(*ReadRowsRequest, BigtableService_ReadRowsServer) error
	// Returns a sample of row keys in the table. The returned row keys will
	// delimit contiguous sections of the table of approximately equal size,
	// which can be used to break up the data for distributed tasks like
	// mapreduces.
	SampleRowKeys(*SampleRowKeysRequest, BigtableService_SampleRowKeysServer) error
	// Mutates a row atomically. Cells already present in the row are left
	// unchanged unless explicitly changed by 'mutation'.
	MutateRow(context.Context, *MutateRowRequest) (*google_protobuf2.Empty, error)
	// Mutates multiple rows in a batch. Each individual row is mutated
	// atomically as in MutateRow, but the entire batch is not executed
	// atomically.
	MutateRows(context.Context, *MutateRowsRequest) (*MutateRowsResponse, error)
	// Mutates a row atomically based on the output of a predicate Reader filter.
	CheckAndMutateRow(context.Context, *CheckAndMutateRowRequest) (*CheckAndMutateRowResponse, error)
	// Modifies a row atomically, reading the latest existing timestamp/value from
	// the specified columns and writing a new value at
	// max(existing timestamp, current server time) based on pre-defined
	// read/modify/write rules. Returns the new contents of all modified cells.
	ReadModifyWriteRow(context.Context, *ReadModifyWriteRowRequest) (*Row, error)
}

func RegisterBigtableServiceServer(s *grpc.Server, srv BigtableServiceServer) {
	s.RegisterService(&_BigtableService_serviceDesc, srv)
}

func _BigtableService_ReadRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRowsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigtableServiceServer).ReadRows(m, &bigtableServiceReadRowsServer{stream})
}

type BigtableService_ReadRowsServer interface {
	Send(*ReadRowsResponse) error
	grpc.ServerStream
}

type bigtableServiceReadRowsServer struct {
	grpc.ServerStream
}

func (x *bigtableServiceReadRowsServer) Send(m *ReadRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BigtableService_SampleRowKeys_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SampleRowKeysRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigtableServiceServer).SampleRowKeys(m, &bigtableServiceSampleRowKeysServer{stream})
}

type BigtableService_SampleRowKeysServer interface {
	Send(*SampleRowKeysResponse) error
	grpc.ServerStream
}

type bigtableServiceSampleRowKeysServer struct {
	grpc.ServerStream
}

func (x *bigtableServiceSampleRowKeysServer) Send(m *SampleRowKeysResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BigtableService_MutateRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServiceServer).MutateRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.v1.BigtableService/MutateRow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServiceServer).MutateRow(ctx, req.(*MutateRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableService_MutateRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServiceServer).MutateRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.v1.BigtableService/MutateRows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServiceServer).MutateRows(ctx, req.(*MutateRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableService_CheckAndMutateRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckAndMutateRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServiceServer).CheckAndMutateRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.v1.BigtableService/CheckAndMutateRow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServiceServer).CheckAndMutateRow(ctx, req.(*CheckAndMutateRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableService_ReadModifyWriteRow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadModifyWriteRowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableServiceServer).ReadModifyWriteRow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.v1.BigtableService/ReadModifyWriteRow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableServiceServer).ReadModifyWriteRow(ctx, req.(*ReadModifyWriteRowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigtableService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.v1.BigtableService",
	HandlerType: (*BigtableServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "MutateRow",
			Handler:    _BigtableService_MutateRow_Handler,
		},
		{
			MethodName: "MutateRows",
			Handler:    _BigtableService_MutateRows_Handler,
		},
		{
			MethodName: "CheckAndMutateRow",
			Handler:    _BigtableService_CheckAndMutateRow_Handler,
		},
		{
			MethodName: "ReadModifyWriteRow",
			Handler:    _BigtableService_ReadModifyWriteRow_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadRows",
			Handler:       _BigtableService_ReadRows_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SampleRowKeys",
			Handler:       _BigtableService_SampleRowKeys_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google.golang.org/genproto/googleapis/bigtable/v1/bigtable_service.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/bigtable/v1/bigtable_service.proto", fileDescriptor2)
}

var fileDescriptor2 = []byte{
	// 536 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x94, 0x4f, 0x6f, 0xd3, 0x30,
	0x18, 0xc6, 0x65, 0x0e, 0x68, 0x58, 0x42, 0x08, 0x4b, 0x0c, 0xa9, 0xc7, 0xf0, 0x47, 0x50, 0xb1,
	0x78, 0x63, 0x9c, 0x2a, 0x71, 0x58, 0xd1, 0x18, 0x13, 0x54, 0x8c, 0x4e, 0xfc, 0x11, 0x1c, 0x8a,
	0x9b, 0xbe, 0xf5, 0xc2, 0x1a, 0xbf, 0xc1, 0x76, 0x1b, 0x85, 0x69, 0x17, 0x4e, 0xdc, 0xf9, 0x08,
	0x88, 0x0b, 0x5f, 0x80, 0x23, 0xdf, 0x01, 0xce, 0xdc, 0xf8, 0x20, 0xc8, 0x4e, 0x52, 0x54, 0x16,
	0x46, 0xb5, 0xee, 0x92, 0x58, 0x7a, 0x9f, 0x3c, 0xef, 0xef, 0x79, 0x6d, 0x87, 0x3e, 0x90, 0x88,
	0x72, 0x04, 0xa1, 0xc4, 0x91, 0x50, 0x32, 0x44, 0x2d, 0xb9, 0x04, 0x95, 0x6a, 0xb4, 0xc8, 0x8b,
	0x92, 0x48, 0x63, 0xc3, 0xfb, 0xb1, 0xb4, 0xa2, 0x3f, 0x02, 0x3e, 0x59, 0x9b, 0xae, 0x7b, 0x06,
	0xf4, 0x24, 0x8e, 0x20, 0xf4, 0x6a, 0xc6, 0x4a, 0xa7, 0xaa, 0x1c, 0x4e, 0xd6, 0x1a, 0xdb, 0xf3,
	0xb9, 0x8b, 0x34, 0xe6, 0xa5, 0x59, 0x84, 0x6a, 0x18, 0x4b, 0x2e, 0x94, 0x42, 0x2b, 0x6c, 0x8c,
	0xca, 0x14, 0xf6, 0x8d, 0xcd, 0x05, 0x40, 0x07, 0xc2, 0x8a, 0xd2, 0xe6, 0xc9, 0xe2, 0x79, 0x7b,
	0x09, 0x18, 0x23, 0x24, 0x54, 0x64, 0xeb, 0x32, 0xb6, 0x7b, 0xe3, 0x7e, 0x18, 0x61, 0xc2, 0x0b,
	0x5b, 0xee, 0x0b, 0xfd, 0xf1, 0x90, 0xa7, 0x36, 0x4f, 0xc1, 0x70, 0x48, 0x52, 0x9b, 0x17, 0xcf,
	0xe2, 0xa3, 0xdb, 0x3f, 0x97, 0xe8, 0x85, 0x76, 0x69, 0xbc, 0x5b, 0xf8, 0xb2, 0xcf, 0x84, 0x2e,
	0x75, 0x41, 0x0c, 0xba, 0x98, 0x19, 0x76, 0x25, 0x3c, 0x3a, 0xcf, 0xb0, 0xaa, 0x76, 0xe1, 0xed,
	0x18, 0x8c, 0x6d, 0x5c, 0x3d, 0x5e, 0x64, 0x52, 0x54, 0x06, 0x82, 0x47, 0xef, 0x7f, 0xfc, 0xfa,
	0x78, 0xe6, 0x7e, 0xb0, 0xe1, 0xd2, 0x1c, 0x14, 0x59, 0x94, 0x48, 0xe0, 0x6e, 0xaa, 0xf1, 0x0d,
	0x44, 0xd6, 0xf0, 0x26, 0x7f, 0x87, 0x0a, 0xdc, 0x3b, 0x1a, 0x8d, 0x8d, 0x05, 0xed, 0x96, 0x5e,
	0x68, 0x78, 0xf3, 0x90, 0x6b, 0xcc, 0x4c, 0x4b, 0x83, 0x18, 0xb4, 0x48, 0x73, 0x95, 0xb0, 0xaf,
	0x84, 0x9e, 0xdf, 0x15, 0x49, 0x3a, 0x82, 0x2e, 0x66, 0x0f, 0x21, 0x37, 0xec, 0x46, 0x1d, 0xc7,
	0x8c, 0xa4, 0x22, 0xbe, 0x39, 0x87, 0xb2, 0xc4, 0x7e, 0xec, 0xb1, 0xb7, 0xd9, 0xd6, 0x42, 0xd8,
	0xc6, 0x7b, 0x3b, 0xe3, 0x55, 0xc2, 0x3e, 0x11, 0x7a, 0xae, 0x33, 0xb6, 0xc2, 0xba, 0x66, 0xac,
	0x76, 0x7a, 0xd3, 0x72, 0x45, 0xbc, 0x5c, 0xa9, 0xaa, 0x4d, 0x0d, 0x37, 0xdd, 0x3e, 0x06, 0x2f,
	0x3c, 0x5e, 0x37, 0xe8, 0x2c, 0x82, 0xc7, 0x0f, 0x34, 0x66, 0xbd, 0x7d, 0xc8, 0x0f, 0x5b, 0x89,
	0x6f, 0xdc, 0x22, 0x4d, 0xf6, 0x85, 0x50, 0x3a, 0xc5, 0x30, 0xec, 0xda, 0xb1, 0x98, 0xd3, 0xc9,
	0x5e, 0xff, 0x9f, 0xac, 0x1c, 0x6b, 0xc7, 0x73, 0x6f, 0x05, 0xed, 0x13, 0x72, 0x97, 0xa0, 0xce,
	0xd3, 0xc1, 0x7e, 0x27, 0xf4, 0xe2, 0xbd, 0x3d, 0x88, 0xf6, 0x37, 0xd4, 0xe0, 0xcf, 0x68, 0x6f,
	0xd5, 0xc1, 0x1c, 0x91, 0x55, 0xe8, 0x2b, 0x73, 0xaa, 0xcb, 0x04, 0xaf, 0x7d, 0x82, 0x97, 0xc1,
	0xd3, 0x53, 0x9a, 0x7c, 0x34, 0xd3, 0xc9, 0x85, 0xfa, 0x46, 0x28, 0x73, 0xd7, 0xa8, 0x83, 0x83,
	0x78, 0x98, 0x3f, 0xd7, 0x71, 0x91, 0x6a, 0xe5, 0x5f, 0xd7, 0x6d, 0x56, 0x57, 0xc5, 0xba, 0x5c,
	0x2b, 0xc7, 0x2c, 0x10, 0x3e, 0xc0, 0xab, 0xe0, 0xd9, 0x29, 0x05, 0xd0, 0xb3, 0x08, 0x2d, 0xd2,
	0x6c, 0xdf, 0xa1, 0xcb, 0x11, 0x26, 0x35, 0x00, 0xed, 0x4b, 0x7f, 0xfd, 0x76, 0xcc, 0x8e, 0x3b,
	0xd7, 0x3b, 0xe4, 0x03, 0x21, 0xfd, 0xb3, 0xfe, 0x8c, 0xaf, 0xff, 0x0e, 0x00, 0x00, 0xff, 0xff,
	0x7a, 0xad, 0xef, 0xcd, 0x16, 0x06, 0x00, 0x00,
}
