// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/functions/v1beta2/functions.proto
// DO NOT EDIT!

/*
Package google_cloud_functions_v1beta2 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/cloud/functions/v1beta2/functions.proto
	google.golang.org/genproto/googleapis/cloud/functions/v1beta2/operations.proto

It has these top-level messages:
	CloudFunction
	HTTPSTrigger
	EventTrigger
	SourceRepository
	CreateFunctionRequest
	UpdateFunctionRequest
	GetFunctionRequest
	ListFunctionsRequest
	ListFunctionsResponse
	DeleteFunctionRequest
	CallFunctionRequest
	CallFunctionResponse
	OperationMetadataV1Beta2
*/
package google_cloud_functions_v1beta2 // import "google.golang.org/genproto/googleapis/cloud/functions/v1beta2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Describes the current stage of a deployment.
type CloudFunctionStatus int32

const (
	// Status not specified.
	CloudFunctionStatus_STATUS_UNSPECIFIED CloudFunctionStatus = 0
	// Successfully deployed.
	CloudFunctionStatus_READY CloudFunctionStatus = 1
	// Not deployed correctly - behavior is undefined. The item should be updated
	// or deleted to move it out of this state.
	CloudFunctionStatus_FAILED CloudFunctionStatus = 2
	// Creation or update in progress.
	CloudFunctionStatus_DEPLOYING CloudFunctionStatus = 3
	// Deletion in progress.
	CloudFunctionStatus_DELETING CloudFunctionStatus = 4
)

var CloudFunctionStatus_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "READY",
	2: "FAILED",
	3: "DEPLOYING",
	4: "DELETING",
}
var CloudFunctionStatus_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"READY":              1,
	"FAILED":             2,
	"DEPLOYING":          3,
	"DELETING":           4,
}

func (x CloudFunctionStatus) String() string {
	return proto.EnumName(CloudFunctionStatus_name, int32(x))
}
func (CloudFunctionStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Describes a cloud function that contains user computation executed in
// response to an event. It encapsulate function and triggers configurations.
type CloudFunction struct {
	// A user-defined name of the function. Function names must be unique
	// globally and match pattern: projects/*/locations/*/functions/*
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The location of the function source code.
	//
	// Types that are valid to be assigned to SourceCode:
	//	*CloudFunction_GcsUrl
	//	*CloudFunction_SourceRepository
	SourceCode isCloudFunction_SourceCode `protobuf_oneof:"source_code"`
	// Types that are valid to be assigned to Trigger:
	//	*CloudFunction_PubsubTrigger
	//	*CloudFunction_GcsTrigger
	//	*CloudFunction_HttpsTrigger
	//	*CloudFunction_EventTrigger
	Trigger isCloudFunction_Trigger `protobuf_oneof:"trigger"`
	// [Output only] Status of the function deployment.
	Status CloudFunctionStatus `protobuf:"varint,7,opt,name=status,enum=google.cloud.functions.v1beta2.CloudFunctionStatus" json:"status,omitempty"`
	// [Output only] Name of the most recent operation modifying the function. If
	// the function status is DEPLOYING or DELETING, then it points to the active
	// operation.
	LatestOperation string `protobuf:"bytes,8,opt,name=latest_operation,json=latestOperation" json:"latest_operation,omitempty"`
	// The name of the function (as defined in source code) that will be
	// executed. Defaults to the resource name suffix, if not specified. For
	// backward compatibility, if function with given name is not found, then the
	// system will try to use function named 'function'.
	// For Node.js this is name of a function exported by the module specified
	// in source_location.
	EntryPoint string `protobuf:"bytes,9,opt,name=entry_point,json=entryPoint" json:"entry_point,omitempty"`
	// The cloud function execution timeout. Execution is considered failed and
	// can be terminated if the function is not completed at the end of the
	// timeout period. Defaults to 60 seconds.
	Timeout *google_protobuf3.Duration `protobuf:"bytes,10,opt,name=timeout" json:"timeout,omitempty"`
	// The amount of memory in MB available for a function.
	// Defaults to 128MB.
	AvailableMemoryMb int32 `protobuf:"varint,11,opt,name=available_memory_mb,json=availableMemoryMb" json:"available_memory_mb,omitempty"`
	// [Output only] The service account of the function.
	ServiceAccount string `protobuf:"bytes,13,opt,name=service_account,json=serviceAccount" json:"service_account,omitempty"`
}

func (m *CloudFunction) Reset()                    { *m = CloudFunction{} }
func (m *CloudFunction) String() string            { return proto.CompactTextString(m) }
func (*CloudFunction) ProtoMessage()               {}
func (*CloudFunction) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type isCloudFunction_SourceCode interface {
	isCloudFunction_SourceCode()
}
type isCloudFunction_Trigger interface {
	isCloudFunction_Trigger()
}

type CloudFunction_GcsUrl struct {
	GcsUrl string `protobuf:"bytes,2,opt,name=gcs_url,json=gcsUrl,oneof"`
}
type CloudFunction_SourceRepository struct {
	SourceRepository *SourceRepository `protobuf:"bytes,3,opt,name=source_repository,json=sourceRepository,oneof"`
}
type CloudFunction_PubsubTrigger struct {
	PubsubTrigger string `protobuf:"bytes,4,opt,name=pubsub_trigger,json=pubsubTrigger,oneof"`
}
type CloudFunction_GcsTrigger struct {
	GcsTrigger string `protobuf:"bytes,5,opt,name=gcs_trigger,json=gcsTrigger,oneof"`
}
type CloudFunction_HttpsTrigger struct {
	HttpsTrigger *HTTPSTrigger `protobuf:"bytes,6,opt,name=https_trigger,json=httpsTrigger,oneof"`
}
type CloudFunction_EventTrigger struct {
	EventTrigger *EventTrigger `protobuf:"bytes,12,opt,name=event_trigger,json=eventTrigger,oneof"`
}

func (*CloudFunction_GcsUrl) isCloudFunction_SourceCode()           {}
func (*CloudFunction_SourceRepository) isCloudFunction_SourceCode() {}
func (*CloudFunction_PubsubTrigger) isCloudFunction_Trigger()       {}
func (*CloudFunction_GcsTrigger) isCloudFunction_Trigger()          {}
func (*CloudFunction_HttpsTrigger) isCloudFunction_Trigger()        {}
func (*CloudFunction_EventTrigger) isCloudFunction_Trigger()        {}

func (m *CloudFunction) GetSourceCode() isCloudFunction_SourceCode {
	if m != nil {
		return m.SourceCode
	}
	return nil
}
func (m *CloudFunction) GetTrigger() isCloudFunction_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (m *CloudFunction) GetGcsUrl() string {
	if x, ok := m.GetSourceCode().(*CloudFunction_GcsUrl); ok {
		return x.GcsUrl
	}
	return ""
}

func (m *CloudFunction) GetSourceRepository() *SourceRepository {
	if x, ok := m.GetSourceCode().(*CloudFunction_SourceRepository); ok {
		return x.SourceRepository
	}
	return nil
}

func (m *CloudFunction) GetPubsubTrigger() string {
	if x, ok := m.GetTrigger().(*CloudFunction_PubsubTrigger); ok {
		return x.PubsubTrigger
	}
	return ""
}

func (m *CloudFunction) GetGcsTrigger() string {
	if x, ok := m.GetTrigger().(*CloudFunction_GcsTrigger); ok {
		return x.GcsTrigger
	}
	return ""
}

func (m *CloudFunction) GetHttpsTrigger() *HTTPSTrigger {
	if x, ok := m.GetTrigger().(*CloudFunction_HttpsTrigger); ok {
		return x.HttpsTrigger
	}
	return nil
}

func (m *CloudFunction) GetEventTrigger() *EventTrigger {
	if x, ok := m.GetTrigger().(*CloudFunction_EventTrigger); ok {
		return x.EventTrigger
	}
	return nil
}

func (m *CloudFunction) GetTimeout() *google_protobuf3.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CloudFunction) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CloudFunction_OneofMarshaler, _CloudFunction_OneofUnmarshaler, _CloudFunction_OneofSizer, []interface{}{
		(*CloudFunction_GcsUrl)(nil),
		(*CloudFunction_SourceRepository)(nil),
		(*CloudFunction_PubsubTrigger)(nil),
		(*CloudFunction_GcsTrigger)(nil),
		(*CloudFunction_HttpsTrigger)(nil),
		(*CloudFunction_EventTrigger)(nil),
	}
}

func _CloudFunction_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CloudFunction)
	// source_code
	switch x := m.SourceCode.(type) {
	case *CloudFunction_GcsUrl:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.GcsUrl)
	case *CloudFunction_SourceRepository:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SourceRepository); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CloudFunction.SourceCode has unexpected type %T", x)
	}
	// trigger
	switch x := m.Trigger.(type) {
	case *CloudFunction_PubsubTrigger:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.PubsubTrigger)
	case *CloudFunction_GcsTrigger:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.GcsTrigger)
	case *CloudFunction_HttpsTrigger:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpsTrigger); err != nil {
			return err
		}
	case *CloudFunction_EventTrigger:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EventTrigger); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CloudFunction.Trigger has unexpected type %T", x)
	}
	return nil
}

func _CloudFunction_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CloudFunction)
	switch tag {
	case 2: // source_code.gcs_url
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.SourceCode = &CloudFunction_GcsUrl{x}
		return true, err
	case 3: // source_code.source_repository
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SourceRepository)
		err := b.DecodeMessage(msg)
		m.SourceCode = &CloudFunction_SourceRepository{msg}
		return true, err
	case 4: // trigger.pubsub_trigger
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Trigger = &CloudFunction_PubsubTrigger{x}
		return true, err
	case 5: // trigger.gcs_trigger
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Trigger = &CloudFunction_GcsTrigger{x}
		return true, err
	case 6: // trigger.https_trigger
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HTTPSTrigger)
		err := b.DecodeMessage(msg)
		m.Trigger = &CloudFunction_HttpsTrigger{msg}
		return true, err
	case 12: // trigger.event_trigger
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EventTrigger)
		err := b.DecodeMessage(msg)
		m.Trigger = &CloudFunction_EventTrigger{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CloudFunction_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CloudFunction)
	// source_code
	switch x := m.SourceCode.(type) {
	case *CloudFunction_GcsUrl:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.GcsUrl)))
		n += len(x.GcsUrl)
	case *CloudFunction_SourceRepository:
		s := proto.Size(x.SourceRepository)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// trigger
	switch x := m.Trigger.(type) {
	case *CloudFunction_PubsubTrigger:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.PubsubTrigger)))
		n += len(x.PubsubTrigger)
	case *CloudFunction_GcsTrigger:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.GcsTrigger)))
		n += len(x.GcsTrigger)
	case *CloudFunction_HttpsTrigger:
		s := proto.Size(x.HttpsTrigger)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CloudFunction_EventTrigger:
		s := proto.Size(x.EventTrigger)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Describes HTTPSTrigger, could be used to connect web hooks to function.
type HTTPSTrigger struct {
	// [Output only] The deployed url for the function.
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
}

func (m *HTTPSTrigger) Reset()                    { *m = HTTPSTrigger{} }
func (m *HTTPSTrigger) String() string            { return proto.CompactTextString(m) }
func (*HTTPSTrigger) ProtoMessage()               {}
func (*HTTPSTrigger) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Describes EventTrigger, used to request events be sent from another
// service.
type EventTrigger struct {
	// event_type names contain the service that is sending an event and the kind
	// of event that was fired. Must be of the form providers/*/eventTypes/*
	// e.g. Directly handle a Message published to Google Cloud PubSub
	//      providers/cloud.pubsub/eventTypes/topic.publish
	//
	//      Handle an object changing in Google Cloud Storage
	//      providers/cloud.storage/eventTypes/object.change
	//
	//      Handle a write to the Firebase Realtime Database
	//      providers/firebase.database/eventTypes/data.write
	EventType string `protobuf:"bytes,1,opt,name=event_type,json=eventType" json:"event_type,omitempty"`
	// Which instance of the source's service should send events. E.g. for PubSub
	// this would be a PubSub topic at projects/*/topics/*. For Google Cloud
	// Storage this would be a bucket at projects/*/buckets/*. For any source
	// that only supports one instance per-project, this should be the name of the
	// project (projects/*)
	Resource string `protobuf:"bytes,2,opt,name=resource" json:"resource,omitempty"`
	// Optional path within the resource that should be used to filter events.
	// Named wildcards may be written in curly brackets (e.g. {variable}). The
	// value that matched this parameter will be included  in the event
	// parameters. e.g. users/{userId}/profilePic
	// Path is not supported for all actions.
	Path string `protobuf:"bytes,3,opt,name=path" json:"path,omitempty"`
}

func (m *EventTrigger) Reset()                    { *m = EventTrigger{} }
func (m *EventTrigger) String() string            { return proto.CompactTextString(m) }
func (*EventTrigger) ProtoMessage()               {}
func (*EventTrigger) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Describes the location of the function source in a remote repository.
type SourceRepository struct {
	// URL to the hosted repository where the function is defined. Only paths in
	// https://source.developers.google.com domain are supported. The path should
	// contain the name of the repository.
	RepositoryUrl string `protobuf:"bytes,1,opt,name=repository_url,json=repositoryUrl" json:"repository_url,omitempty"`
	// The path within the repository where the function is defined. The path
	// should point to the directory where cloud functions files are located. Use
	// '/' if the function is defined directly in the root directory of a
	// repository.
	SourcePath string `protobuf:"bytes,2,opt,name=source_path,json=sourcePath" json:"source_path,omitempty"`
	// The version of a function. Defaults to the latest version of the master
	// branch.
	//
	// Types that are valid to be assigned to Version:
	//	*SourceRepository_Branch
	//	*SourceRepository_Tag
	//	*SourceRepository_Revision
	Version isSourceRepository_Version `protobuf_oneof:"version"`
	// [Output only] The id of the revision that was resolved at the moment of
	// function creation or update. For example when a user deployed from a
	// branch, it will be the revision id of the latest change on this branch at
	// that time. If user deployed from revision then this value will be always
	// equal to the revision specified by the user.
	DeployedRevision string `protobuf:"bytes,6,opt,name=deployed_revision,json=deployedRevision" json:"deployed_revision,omitempty"`
}

func (m *SourceRepository) Reset()                    { *m = SourceRepository{} }
func (m *SourceRepository) String() string            { return proto.CompactTextString(m) }
func (*SourceRepository) ProtoMessage()               {}
func (*SourceRepository) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type isSourceRepository_Version interface {
	isSourceRepository_Version()
}

type SourceRepository_Branch struct {
	Branch string `protobuf:"bytes,3,opt,name=branch,oneof"`
}
type SourceRepository_Tag struct {
	Tag string `protobuf:"bytes,4,opt,name=tag,oneof"`
}
type SourceRepository_Revision struct {
	Revision string `protobuf:"bytes,5,opt,name=revision,oneof"`
}

func (*SourceRepository_Branch) isSourceRepository_Version()   {}
func (*SourceRepository_Tag) isSourceRepository_Version()      {}
func (*SourceRepository_Revision) isSourceRepository_Version() {}

func (m *SourceRepository) GetVersion() isSourceRepository_Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *SourceRepository) GetBranch() string {
	if x, ok := m.GetVersion().(*SourceRepository_Branch); ok {
		return x.Branch
	}
	return ""
}

func (m *SourceRepository) GetTag() string {
	if x, ok := m.GetVersion().(*SourceRepository_Tag); ok {
		return x.Tag
	}
	return ""
}

func (m *SourceRepository) GetRevision() string {
	if x, ok := m.GetVersion().(*SourceRepository_Revision); ok {
		return x.Revision
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SourceRepository) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SourceRepository_OneofMarshaler, _SourceRepository_OneofUnmarshaler, _SourceRepository_OneofSizer, []interface{}{
		(*SourceRepository_Branch)(nil),
		(*SourceRepository_Tag)(nil),
		(*SourceRepository_Revision)(nil),
	}
}

func _SourceRepository_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SourceRepository)
	// version
	switch x := m.Version.(type) {
	case *SourceRepository_Branch:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Branch)
	case *SourceRepository_Tag:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Tag)
	case *SourceRepository_Revision:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Revision)
	case nil:
	default:
		return fmt.Errorf("SourceRepository.Version has unexpected type %T", x)
	}
	return nil
}

func _SourceRepository_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SourceRepository)
	switch tag {
	case 3: // version.branch
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Version = &SourceRepository_Branch{x}
		return true, err
	case 4: // version.tag
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Version = &SourceRepository_Tag{x}
		return true, err
	case 5: // version.revision
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Version = &SourceRepository_Revision{x}
		return true, err
	default:
		return false, nil
	}
}

func _SourceRepository_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SourceRepository)
	// version
	switch x := m.Version.(type) {
	case *SourceRepository_Branch:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Branch)))
		n += len(x.Branch)
	case *SourceRepository_Tag:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Tag)))
		n += len(x.Tag)
	case *SourceRepository_Revision:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Revision)))
		n += len(x.Revision)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request for the CreateFunction method.
type CreateFunctionRequest struct {
	// The project and location in which the function should be created, specified
	// in the format: projects/*/locations/*
	Location string `protobuf:"bytes,1,opt,name=location" json:"location,omitempty"`
	// Function to be created.
	Function *CloudFunction `protobuf:"bytes,2,opt,name=function" json:"function,omitempty"`
}

func (m *CreateFunctionRequest) Reset()                    { *m = CreateFunctionRequest{} }
func (m *CreateFunctionRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateFunctionRequest) ProtoMessage()               {}
func (*CreateFunctionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *CreateFunctionRequest) GetFunction() *CloudFunction {
	if m != nil {
		return m.Function
	}
	return nil
}

// Request for the UpdateFunction method.
type UpdateFunctionRequest struct {
	// The name of the function to be updated.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// New version of the function.
	Function *CloudFunction `protobuf:"bytes,2,opt,name=function" json:"function,omitempty"`
}

func (m *UpdateFunctionRequest) Reset()                    { *m = UpdateFunctionRequest{} }
func (m *UpdateFunctionRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateFunctionRequest) ProtoMessage()               {}
func (*UpdateFunctionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *UpdateFunctionRequest) GetFunction() *CloudFunction {
	if m != nil {
		return m.Function
	}
	return nil
}

// Request for the GetFunction method.
type GetFunctionRequest struct {
	// The name of the function which details should be obtained.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetFunctionRequest) Reset()                    { *m = GetFunctionRequest{} }
func (m *GetFunctionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetFunctionRequest) ProtoMessage()               {}
func (*GetFunctionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// Request for the ListFunctions method.
type ListFunctionsRequest struct {
	// The project and location from which the function should be listed,
	// specified in the format: projects/*/locations/*
	// If you want to list functions in all locations, use '-' in place of a
	// location.
	Location string `protobuf:"bytes,1,opt,name=location" json:"location,omitempty"`
	// Maximum number of functions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last ListFunctionsResponse; indicates that
	// this is a continuation of a prior ListFunctions call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListFunctionsRequest) Reset()                    { *m = ListFunctionsRequest{} }
func (m *ListFunctionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListFunctionsRequest) ProtoMessage()               {}
func (*ListFunctionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// Response for the ListFunctions method.
type ListFunctionsResponse struct {
	// The functions that match the request.
	Functions []*CloudFunction `protobuf:"bytes,1,rep,name=functions" json:"functions,omitempty"`
	// If not empty, indicates that there may be more functions that match
	// the request; this value should be passed in a new ListFunctionsRequest
	// to get more functions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListFunctionsResponse) Reset()                    { *m = ListFunctionsResponse{} }
func (m *ListFunctionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListFunctionsResponse) ProtoMessage()               {}
func (*ListFunctionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ListFunctionsResponse) GetFunctions() []*CloudFunction {
	if m != nil {
		return m.Functions
	}
	return nil
}

// Request for the DeleteFunction method.
type DeleteFunctionRequest struct {
	// The name of the function which should be deleted.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteFunctionRequest) Reset()                    { *m = DeleteFunctionRequest{} }
func (m *DeleteFunctionRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteFunctionRequest) ProtoMessage()               {}
func (*DeleteFunctionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// Request for the CallFunction method.
type CallFunctionRequest struct {
	// The name of the function to be called.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Input to be passed to the function.
	Data string `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
}

func (m *CallFunctionRequest) Reset()                    { *m = CallFunctionRequest{} }
func (m *CallFunctionRequest) String() string            { return proto.CompactTextString(m) }
func (*CallFunctionRequest) ProtoMessage()               {}
func (*CallFunctionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

// Response of CallFunction method.
type CallFunctionResponse struct {
	// Execution id of function invocation.
	ExecutionId string `protobuf:"bytes,1,opt,name=execution_id,json=executionId" json:"execution_id,omitempty"`
	// Result populated for successful execution of synchronous function. Will
	// not be populated if function does not return a result through context.
	Result string `protobuf:"bytes,2,opt,name=result" json:"result,omitempty"`
	// Either system or user-function generated error. Set if execution
	// was not successful.
	Error string `protobuf:"bytes,3,opt,name=error" json:"error,omitempty"`
}

func (m *CallFunctionResponse) Reset()                    { *m = CallFunctionResponse{} }
func (m *CallFunctionResponse) String() string            { return proto.CompactTextString(m) }
func (*CallFunctionResponse) ProtoMessage()               {}
func (*CallFunctionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func init() {
	proto.RegisterType((*CloudFunction)(nil), "google.cloud.functions.v1beta2.CloudFunction")
	proto.RegisterType((*HTTPSTrigger)(nil), "google.cloud.functions.v1beta2.HTTPSTrigger")
	proto.RegisterType((*EventTrigger)(nil), "google.cloud.functions.v1beta2.EventTrigger")
	proto.RegisterType((*SourceRepository)(nil), "google.cloud.functions.v1beta2.SourceRepository")
	proto.RegisterType((*CreateFunctionRequest)(nil), "google.cloud.functions.v1beta2.CreateFunctionRequest")
	proto.RegisterType((*UpdateFunctionRequest)(nil), "google.cloud.functions.v1beta2.UpdateFunctionRequest")
	proto.RegisterType((*GetFunctionRequest)(nil), "google.cloud.functions.v1beta2.GetFunctionRequest")
	proto.RegisterType((*ListFunctionsRequest)(nil), "google.cloud.functions.v1beta2.ListFunctionsRequest")
	proto.RegisterType((*ListFunctionsResponse)(nil), "google.cloud.functions.v1beta2.ListFunctionsResponse")
	proto.RegisterType((*DeleteFunctionRequest)(nil), "google.cloud.functions.v1beta2.DeleteFunctionRequest")
	proto.RegisterType((*CallFunctionRequest)(nil), "google.cloud.functions.v1beta2.CallFunctionRequest")
	proto.RegisterType((*CallFunctionResponse)(nil), "google.cloud.functions.v1beta2.CallFunctionResponse")
	proto.RegisterEnum("google.cloud.functions.v1beta2.CloudFunctionStatus", CloudFunctionStatus_name, CloudFunctionStatus_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for CloudFunctionsService service

type CloudFunctionsServiceClient interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, it will return ALREADY_EXISTS error.
	CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Updates existing function.
	UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Invokes synchronously deployed function. To be used for testing, very
	// limited traffic allowed.
	CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error)
}

type cloudFunctionsServiceClient struct {
	cc *grpc.ClientConn
}

func NewCloudFunctionsServiceClient(cc *grpc.ClientConn) CloudFunctionsServiceClient {
	return &cloudFunctionsServiceClient{cc}
}

func (c *cloudFunctionsServiceClient) ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error) {
	out := new(ListFunctionsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/ListFunctions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error) {
	out := new(CloudFunction)
	err := grpc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/GetFunction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/CreateFunction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/UpdateFunction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/DeleteFunction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error) {
	out := new(CallFunctionResponse)
	err := grpc.Invoke(ctx, "/google.cloud.functions.v1beta2.CloudFunctionsService/CallFunction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for CloudFunctionsService service

type CloudFunctionsServiceServer interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(context.Context, *GetFunctionRequest) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, it will return ALREADY_EXISTS error.
	CreateFunction(context.Context, *CreateFunctionRequest) (*google_longrunning.Operation, error)
	// Updates existing function.
	UpdateFunction(context.Context, *UpdateFunctionRequest) (*google_longrunning.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(context.Context, *DeleteFunctionRequest) (*google_longrunning.Operation, error)
	// Invokes synchronously deployed function. To be used for testing, very
	// limited traffic allowed.
	CallFunction(context.Context, *CallFunctionRequest) (*CallFunctionResponse, error)
}

func RegisterCloudFunctionsServiceServer(s *grpc.Server, srv CloudFunctionsServiceServer) {
	s.RegisterService(&_CloudFunctionsService_serviceDesc, srv)
}

func _CloudFunctionsService_ListFunctions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/ListFunctions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, req.(*ListFunctionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GetFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/GetFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, req.(*GetFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CreateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/CreateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, req.(*CreateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_UpdateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/UpdateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, req.(*UpdateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_DeleteFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/DeleteFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, req.(*DeleteFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CallFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CallFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1beta2.CloudFunctionsService/CallFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, req.(*CallFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudFunctionsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.functions.v1beta2.CloudFunctionsService",
	HandlerType: (*CloudFunctionsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFunctions",
			Handler:    _CloudFunctionsService_ListFunctions_Handler,
		},
		{
			MethodName: "GetFunction",
			Handler:    _CloudFunctionsService_GetFunction_Handler,
		},
		{
			MethodName: "CreateFunction",
			Handler:    _CloudFunctionsService_CreateFunction_Handler,
		},
		{
			MethodName: "UpdateFunction",
			Handler:    _CloudFunctionsService_UpdateFunction_Handler,
		},
		{
			MethodName: "DeleteFunction",
			Handler:    _CloudFunctionsService_DeleteFunction_Handler,
		},
		{
			MethodName: "CallFunction",
			Handler:    _CloudFunctionsService_CallFunction_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/cloud/functions/v1beta2/functions.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/functions/v1beta2/functions.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1220 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xcf, 0x26, 0xb1, 0x13, 0x3f, 0xff, 0xa9, 0x3b, 0x6d, 0x2a, 0xd7, 0x50, 0x9a, 0xae, 0x04,
	0x0d, 0x29, 0x78, 0xc1, 0x0d, 0x20, 0xaa, 0x16, 0x11, 0xc7, 0x4e, 0x63, 0x35, 0x6d, 0xad, 0xb5,
	0x73, 0xe8, 0x01, 0xad, 0xc6, 0xeb, 0xe9, 0x66, 0x61, 0xbd, 0xb3, 0xec, 0xcc, 0x5a, 0x75, 0x51,
	0x39, 0x70, 0xe6, 0xc6, 0x37, 0xe8, 0x19, 0xf1, 0x01, 0x90, 0xb8, 0x73, 0x47, 0xe2, 0xc8, 0x89,
	0x0f, 0x82, 0x66, 0x76, 0x76, 0x6d, 0xa7, 0x06, 0x3b, 0x11, 0xb7, 0x9d, 0xdf, 0xcc, 0x7b, 0xef,
	0x37, 0xef, 0xfd, 0xde, 0xdb, 0x81, 0xc7, 0x0e, 0xa5, 0x8e, 0x47, 0x6a, 0x0e, 0xf5, 0xb0, 0xef,
	0xd4, 0x68, 0xe8, 0x18, 0x0e, 0xf1, 0x83, 0x90, 0x72, 0x6a, 0xc4, 0x5b, 0x38, 0x70, 0x99, 0x61,
	0x7b, 0x34, 0x1a, 0x18, 0xcf, 0x23, 0xdf, 0xe6, 0x2e, 0xf5, 0x99, 0x31, 0xfa, 0xb8, 0x4f, 0x38,
	0xae, 0x4f, 0x90, 0x9a, 0x34, 0x41, 0xef, 0x28, 0x77, 0xf2, 0x7c, 0x6d, 0xb2, 0xab, 0xce, 0x57,
	0xdb, 0xcb, 0x85, 0xc3, 0x81, 0x6b, 0x30, 0x12, 0x8e, 0x5c, 0x9b, 0xd8, 0xd4, 0x7f, 0xee, 0x3a,
	0x06, 0xf6, 0x7d, 0xca, 0xf1, 0x54, 0xa8, 0x6a, 0x63, 0x39, 0x57, 0x1e, 0xf5, 0x9d, 0x30, 0xf2,
	0x7d, 0xd7, 0x77, 0x0c, 0x1a, 0x90, 0x70, 0xc6, 0xc7, 0xe7, 0x8e, 0xcb, 0x4f, 0xa3, 0x7e, 0xcd,
	0xa6, 0x43, 0x23, 0xf6, 0x63, 0xc8, 0x8d, 0x7e, 0xf4, 0xdc, 0x08, 0xf8, 0x38, 0x20, 0xcc, 0x18,
	0x44, 0xb1, 0x49, 0xfa, 0x11, 0x9b, 0xea, 0x7f, 0x66, 0xa0, 0x78, 0x20, 0x6e, 0x79, 0xa8, 0x2e,
	0x89, 0x10, 0xac, 0xfb, 0x78, 0x48, 0x2a, 0xda, 0xb6, 0xb6, 0x93, 0x33, 0xe5, 0x37, 0xba, 0x0e,
	0x1b, 0x8e, 0xcd, 0xac, 0x28, 0xf4, 0x2a, 0xab, 0x02, 0x3e, 0x5a, 0x31, 0xb3, 0x8e, 0xcd, 0x4e,
	0x42, 0x0f, 0x59, 0x70, 0x99, 0xd1, 0x28, 0xb4, 0x89, 0x15, 0x92, 0x80, 0x32, 0x97, 0xd3, 0x70,
	0x5c, 0x59, 0xdb, 0xd6, 0x76, 0xf2, 0xf5, 0x8f, 0x6a, 0xff, 0x9d, 0xc6, 0x5a, 0x57, 0x1a, 0x9a,
	0xa9, 0xdd, 0xd1, 0x8a, 0x59, 0x66, 0x67, 0x30, 0x74, 0x1b, 0x4a, 0x41, 0xd4, 0x67, 0x51, 0xdf,
	0xe2, 0xa1, 0xeb, 0x38, 0x24, 0xac, 0xac, 0x4b, 0x0a, 0x9a, 0x59, 0x8c, 0xf1, 0x5e, 0x0c, 0xa3,
	0x5b, 0x90, 0x17, 0x24, 0x93, 0x53, 0x19, 0x75, 0x0a, 0x1c, 0x9b, 0x25, 0x47, 0xba, 0x50, 0x3c,
	0xe5, 0x3c, 0x98, 0x1c, 0xca, 0x4a, 0xa2, 0x1f, 0x2c, 0x22, 0x7a, 0xd4, 0xeb, 0x75, 0xba, 0xca,
	0xc9, 0x91, 0x66, 0x16, 0xa4, 0x93, 0x29, 0xa7, 0x64, 0x44, 0x7c, 0x9e, 0x3a, 0x2d, 0x2c, 0xe7,
	0xb4, 0x25, 0x8c, 0xa6, 0x9c, 0x92, 0xa9, 0x35, 0x7a, 0x04, 0x59, 0xc6, 0x31, 0x8f, 0x58, 0x65,
	0x63, 0x5b, 0xdb, 0x29, 0xd5, 0xef, 0x2e, 0xf2, 0x36, 0x53, 0xc4, 0xae, 0x34, 0x35, 0x95, 0x0b,
	0xf4, 0x3e, 0x94, 0x3d, 0xcc, 0x09, 0xe3, 0x56, 0x2a, 0x9d, 0xca, 0xa6, 0x2c, 0xef, 0xa5, 0x18,
	0x7f, 0x9a, 0xc0, 0xe8, 0x26, 0xe4, 0x89, 0xcf, 0xc3, 0xb1, 0x15, 0x50, 0xd7, 0xe7, 0x95, 0x9c,
	0x3c, 0x05, 0x12, 0xea, 0x08, 0x04, 0xdd, 0x85, 0x0d, 0xee, 0x0e, 0x09, 0x8d, 0x78, 0x05, 0xe4,
	0x3d, 0xaf, 0x27, 0xcc, 0x12, 0xc9, 0xd5, 0x9a, 0x4a, 0x62, 0x66, 0x72, 0x12, 0xd5, 0xe0, 0x0a,
	0x1e, 0x61, 0xd7, 0xc3, 0x7d, 0x8f, 0x58, 0x43, 0x32, 0xa4, 0xe1, 0xd8, 0x1a, 0xf6, 0x2b, 0xf9,
	0x6d, 0x6d, 0x27, 0x63, 0x5e, 0x4e, 0xb7, 0x1e, 0xcb, 0x9d, 0xc7, 0x7d, 0x74, 0x1b, 0x2e, 0xa9,
	0xbe, 0xb1, 0xb0, 0x6d, 0xd3, 0xc8, 0xe7, 0x95, 0xa2, 0x64, 0x52, 0x52, 0xf0, 0x7e, 0x8c, 0x36,
	0x8a, 0x90, 0x57, 0xea, 0xb3, 0xe9, 0x80, 0x34, 0x72, 0xb0, 0xa1, 0x8a, 0xa0, 0x6f, 0x43, 0x61,
	0xba, 0x6a, 0xa8, 0x0c, 0x6b, 0x42, 0xbe, 0xb1, 0xaa, 0xc5, 0xa7, 0xfe, 0x15, 0x14, 0xa6, 0x4b,
	0x80, 0x6e, 0x00, 0xa8, 0x3a, 0x8e, 0x83, 0x44, 0xfe, 0xb9, 0xb8, 0x28, 0xe3, 0x80, 0xa0, 0x2a,
	0x6c, 0x86, 0x24, 0x0e, 0x16, 0x37, 0x81, 0x99, 0xae, 0x45, 0xcf, 0x04, 0x98, 0x9f, 0x4a, 0xdd,
	0xe7, 0x4c, 0xf9, 0xad, 0xff, 0xa5, 0x41, 0xf9, 0xac, 0xc0, 0xd1, 0xbb, 0x50, 0x9a, 0xb4, 0x89,
	0x35, 0x21, 0x54, 0x9c, 0xa0, 0xa2, 0xa9, 0x6e, 0xa6, 0xd7, 0x92, 0x6e, 0xe3, 0x70, 0x10, 0x43,
	0x1d, 0xcc, 0x4f, 0x51, 0x05, 0xb2, 0xfd, 0x10, 0xfb, 0xb6, 0x0a, 0x29, 0xfa, 0x31, 0x5e, 0x23,
	0x04, 0x6b, 0x1c, 0x3b, 0xaa, 0x47, 0x56, 0x4c, 0xb1, 0x40, 0x6f, 0x0b, 0xea, 0x23, 0x97, 0x89,
	0xba, 0x67, 0xd4, 0x46, 0x8a, 0xa0, 0x3b, 0x70, 0x79, 0x40, 0x02, 0x8f, 0x8e, 0xc9, 0xc0, 0x4a,
	0x8f, 0x65, 0x65, 0xc8, 0x72, 0xb2, 0x61, 0x2a, 0x5c, 0x64, 0x78, 0x44, 0x42, 0xf1, 0xa9, 0x7f,
	0x0f, 0x5b, 0x07, 0x21, 0xc1, 0x9c, 0x24, 0xaa, 0x33, 0xc9, 0xb7, 0x11, 0x61, 0x5c, 0x64, 0xca,
	0xa3, 0x76, 0x2c, 0xb3, 0xf8, 0x7a, 0xe9, 0x1a, 0xb5, 0x61, 0x33, 0xd1, 0xae, 0xbc, 0x56, 0xbe,
	0xfe, 0xe1, 0xb9, 0x94, 0x6d, 0xa6, 0xe6, 0xfa, 0x08, 0xb6, 0x4e, 0x82, 0xc1, 0x9c, 0xf8, 0xf3,
	0x26, 0xd8, 0xff, 0x18, 0x77, 0x07, 0xd0, 0x43, 0xc2, 0x97, 0x08, 0xaa, 0xfb, 0x70, 0xf5, 0xd8,
	0x65, 0xe9, 0x51, 0xb6, 0x4c, 0x82, 0xde, 0x82, 0x5c, 0x80, 0x1d, 0x62, 0x31, 0xf7, 0x65, 0xac,
	0xb3, 0x8c, 0xb9, 0x29, 0x80, 0xae, 0xfb, 0x92, 0x08, 0x89, 0xca, 0x4d, 0x4e, 0xbf, 0x21, 0xbe,
	0x52, 0x9b, 0x3c, 0xde, 0x13, 0x80, 0xfe, 0xa3, 0x06, 0x5b, 0x67, 0x02, 0xb2, 0x80, 0xfa, 0x8c,
	0xa0, 0x47, 0x90, 0x4b, 0x2f, 0x58, 0xd1, 0xb6, 0xd7, 0xce, 0x7f, 0xff, 0x89, 0x3d, 0x7a, 0x0f,
	0x2e, 0xf9, 0xe4, 0x05, 0xb7, 0xa6, 0xa8, 0xc4, 0x0a, 0x2d, 0x0a, 0xb8, 0x93, 0xd2, 0xb9, 0x03,
	0x5b, 0x4d, 0xe2, 0x91, 0xa5, 0x0a, 0xa4, 0x3f, 0x80, 0x2b, 0x07, 0xd8, 0xf3, 0x96, 0xa9, 0x25,
	0x82, 0xf5, 0x01, 0xe6, 0x58, 0x05, 0x95, 0xdf, 0xba, 0x03, 0x57, 0x67, 0xcd, 0xd5, 0xc5, 0x6f,
	0x41, 0x81, 0xbc, 0x20, 0x76, 0x24, 0x40, 0xcb, 0x1d, 0x28, 0x3f, 0xf9, 0x14, 0x6b, 0x0f, 0xd0,
	0x35, 0xc8, 0x86, 0x84, 0x45, 0x1e, 0x57, 0x0e, 0xd5, 0x0a, 0x5d, 0x85, 0x0c, 0x09, 0x43, 0x1a,
	0xaa, 0x3c, 0xc7, 0x8b, 0x5d, 0x0c, 0x57, 0xe6, 0x8c, 0x5a, 0x74, 0x0d, 0x50, 0xb7, 0xb7, 0xdf,
	0x3b, 0xe9, 0x5a, 0x27, 0x4f, 0xba, 0x9d, 0xd6, 0x41, 0xfb, 0xb0, 0xdd, 0x6a, 0x96, 0x57, 0x50,
	0x0e, 0x32, 0x66, 0x6b, 0xbf, 0xf9, 0xac, 0xac, 0x21, 0x80, 0xec, 0xe1, 0x7e, 0xfb, 0xb8, 0xd5,
	0x2c, 0xaf, 0xa2, 0x22, 0xe4, 0x9a, 0xad, 0xce, 0xf1, 0xd3, 0x67, 0xed, 0x27, 0x0f, 0xcb, 0x6b,
	0xa8, 0x00, 0x9b, 0xcd, 0xd6, 0x71, 0xab, 0x27, 0x56, 0xeb, 0xf5, 0xdf, 0x37, 0x61, 0x6b, 0x26,
	0x06, 0xeb, 0xc6, 0x53, 0x0f, 0xfd, 0xaa, 0x41, 0x71, 0xa6, 0xc0, 0x68, 0x6f, 0x51, 0x15, 0xe7,
	0x09, 0xb0, 0xfa, 0xc9, 0x39, 0xad, 0xe2, 0x64, 0xea, 0xf7, 0x7f, 0xf8, 0xe3, 0xef, 0x9f, 0x56,
	0x3f, 0x45, 0x7b, 0xe9, 0xc3, 0xe9, 0xbb, 0x44, 0xb7, 0x0f, 0x82, 0x90, 0x7e, 0x4d, 0x6c, 0xce,
	0x8c, 0x5d, 0x23, 0xc1, 0x98, 0xb1, 0xfb, 0x6a, 0xf2, 0xb4, 0x42, 0x3f, 0x6b, 0x90, 0x9f, 0x6a,
	0x1c, 0x54, 0x5f, 0x44, 0xe2, 0xcd, 0x2e, 0xab, 0x9e, 0x4f, 0xb4, 0xfa, 0x3d, 0x49, 0x78, 0x0f,
	0xd5, 0x27, 0x84, 0x85, 0x82, 0xfe, 0x85, 0xec, 0xd4, 0xc3, 0x70, 0xf7, 0x15, 0xfa, 0x45, 0x83,
	0xd2, 0xec, 0x7c, 0x43, 0x0b, 0xd3, 0x36, 0x77, 0x1e, 0x56, 0x6f, 0x24, 0x66, 0x53, 0x8f, 0xb8,
	0x5a, 0xfa, 0xcb, 0xd5, 0x0f, 0x25, 0xc9, 0x2f, 0xf5, 0x0b, 0x65, 0xf5, 0x5e, 0x3a, 0x97, 0x44,
	0x7e, 0x4b, 0xb3, 0x03, 0x71, 0x31, 0xe1, 0xb9, 0x03, 0x74, 0x11, 0xe1, 0xa6, 0x24, 0xfc, 0x45,
	0xf5, 0x02, 0x59, 0x9d, 0xa2, 0xfb, 0x5a, 0x83, 0xd2, 0xec, 0x78, 0x58, 0x4c, 0x77, 0xee, 0x38,
	0x59, 0x44, 0x57, 0x89, 0x60, 0xf7, 0x22, 0x22, 0xf8, 0x4d, 0x83, 0xc2, 0xf4, 0x5c, 0x41, 0x8b,
	0xdf, 0x61, 0x6f, 0x0e, 0xb1, 0xea, 0xde, 0xf9, 0x8c, 0x54, 0xb7, 0x35, 0x24, 0xef, 0xfb, 0xfa,
	0x67, 0x17, 0x48, 0xb3, 0x8d, 0x3d, 0xef, 0x9e, 0xb6, 0xdb, 0xb8, 0x0f, 0xba, 0x4d, 0x87, 0x0b,
	0xc2, 0x37, 0x4a, 0x69, 0xab, 0x77, 0xc4, 0x1b, 0xae, 0xa3, 0xbd, 0x5e, 0x5d, 0x7b, 0x78, 0x70,
	0xd8, 0xcf, 0xca, 0x27, 0xdd, 0xdd, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0xd7, 0xae, 0x3b, 0xec,
	0x5e, 0x0d, 0x00, 0x00,
}
