// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/ml/v1beta1/job_service.proto
// DO NOT EDIT!

/*
Package google_cloud_ml_v1beta1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/cloud/ml/v1beta1/job_service.proto
	google.golang.org/genproto/googleapis/cloud/ml/v1beta1/model_service.proto
	google.golang.org/genproto/googleapis/cloud/ml/v1beta1/operation_metadata.proto
	google.golang.org/genproto/googleapis/cloud/ml/v1beta1/prediction_service.proto
	google.golang.org/genproto/googleapis/cloud/ml/v1beta1/project_service.proto

It has these top-level messages:
	TrainingInput
	HyperparameterSpec
	ParameterSpec
	HyperparameterOutput
	TrainingOutput
	PredictionInput
	PredictionOutput
	Job
	CreateJobRequest
	ListJobsRequest
	ListJobsResponse
	GetJobRequest
	CancelJobRequest
	Model
	Version
	CreateModelRequest
	ListModelsRequest
	ListModelsResponse
	GetModelRequest
	DeleteModelRequest
	CreateVersionRequest
	ListVersionsRequest
	ListVersionsResponse
	GetVersionRequest
	DeleteVersionRequest
	SetDefaultVersionRequest
	OperationMetadata
	PredictRequest
	GetConfigRequest
	GetConfigResponse
*/
package google_cloud_ml_v1beta1 // import "google.golang.org/genproto/googleapis/cloud/ml/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A scale tier is an abstract representation of the resources Cloud ML
// will allocate to a training job. When selecting a scale tier for your
// training job, you should consider the size of your training dataset and
// the complexity of your model. As the tiers increase, virtual machines are
// added to handle your job, and the individual machines in the cluster
// generally have more memory and greater processing power than they do at
// lower tiers. The number of training units charged per hour of processing
// increases as tiers get more advanced. Refer to the
// [pricing guide](/ml/pricing) for more details.
type TrainingInput_ScaleTier int32

const (
	// A single worker instance. This tier is suitable for learning how to use
	// Cloud ML, and for experimenting with new models using small datasets.
	TrainingInput_BASIC TrainingInput_ScaleTier = 0
	// Many workers and a few parameter servers.
	TrainingInput_STANDARD_1 TrainingInput_ScaleTier = 1
	// A large number of workers with many parameter servers.
	TrainingInput_PREMIUM_1 TrainingInput_ScaleTier = 3
	// The CUSTOM tier is not a set tier, but rather enables you to use your
	// own cluster specification. When you use this tier, you must also set
	// valid values for `worker_count` and `parameter_server_count`, and you can
	// specify the type of virtual machines to use for the different types of
	// workers by setting `master_type`, `worker_type`, and
	// `parameter_server_type`.
	TrainingInput_CUSTOM TrainingInput_ScaleTier = 5
)

var TrainingInput_ScaleTier_name = map[int32]string{
	0: "BASIC",
	1: "STANDARD_1",
	3: "PREMIUM_1",
	5: "CUSTOM",
}
var TrainingInput_ScaleTier_value = map[string]int32{
	"BASIC":      0,
	"STANDARD_1": 1,
	"PREMIUM_1":  3,
	"CUSTOM":     5,
}

func (x TrainingInput_ScaleTier) String() string {
	return proto.EnumName(TrainingInput_ScaleTier_name, int32(x))
}
func (TrainingInput_ScaleTier) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

// The available types of optimization goals.
type HyperparameterSpec_GoalType int32

const (
	// Goal Type will default to maximize.
	HyperparameterSpec_GOAL_TYPE_UNSPECIFIED HyperparameterSpec_GoalType = 0
	// Maximize the goal metric.
	HyperparameterSpec_MAXIMIZE HyperparameterSpec_GoalType = 1
	// Minimize the goal metric.
	HyperparameterSpec_MINIMIZE HyperparameterSpec_GoalType = 2
)

var HyperparameterSpec_GoalType_name = map[int32]string{
	0: "GOAL_TYPE_UNSPECIFIED",
	1: "MAXIMIZE",
	2: "MINIMIZE",
}
var HyperparameterSpec_GoalType_value = map[string]int32{
	"GOAL_TYPE_UNSPECIFIED": 0,
	"MAXIMIZE":              1,
	"MINIMIZE":              2,
}

func (x HyperparameterSpec_GoalType) String() string {
	return proto.EnumName(HyperparameterSpec_GoalType_name, int32(x))
}
func (HyperparameterSpec_GoalType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{1, 0}
}

// The type of the parameter.
type ParameterSpec_ParameterType int32

const (
	// You must specify a valid type. Using this unspecified type will result in
	// an error.
	ParameterSpec_PARAMETER_TYPE_UNSPECIFIED ParameterSpec_ParameterType = 0
	// Type for real-valued parameters.
	ParameterSpec_DOUBLE ParameterSpec_ParameterType = 1
	// Type for integral parameters.
	ParameterSpec_INTEGER ParameterSpec_ParameterType = 2
	// The parameter is categorical, with a value chosen from the categories
	// field.
	ParameterSpec_CATEGORICAL ParameterSpec_ParameterType = 3
	// The parameter is real valued, with a fixed set of feasible points. If
	// `type==DISCRETE`, feasible_points must be provided, and
	// {`min_value`, `max_value`} will be ignored.
	ParameterSpec_DISCRETE ParameterSpec_ParameterType = 4
)

var ParameterSpec_ParameterType_name = map[int32]string{
	0: "PARAMETER_TYPE_UNSPECIFIED",
	1: "DOUBLE",
	2: "INTEGER",
	3: "CATEGORICAL",
	4: "DISCRETE",
}
var ParameterSpec_ParameterType_value = map[string]int32{
	"PARAMETER_TYPE_UNSPECIFIED": 0,
	"DOUBLE":                     1,
	"INTEGER":                    2,
	"CATEGORICAL":                3,
	"DISCRETE":                   4,
}

func (x ParameterSpec_ParameterType) String() string {
	return proto.EnumName(ParameterSpec_ParameterType_name, int32(x))
}
func (ParameterSpec_ParameterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{2, 0}
}

// The type of scaling that should be applied to this parameter.
type ParameterSpec_ScaleType int32

const (
	// By default, no scaling is applied.
	ParameterSpec_NONE ParameterSpec_ScaleType = 0
	// Scales the feasible space to (0, 1) linearly.
	ParameterSpec_UNIT_LINEAR_SCALE ParameterSpec_ScaleType = 1
	// Scales the feasible space logarithmically to (0, 1). The entire feasible
	// space must be strictly positive.
	ParameterSpec_UNIT_LOG_SCALE ParameterSpec_ScaleType = 2
	// Scales the feasible space "reverse" logarithmically to (0, 1). The result
	// is that values close to the top of the feasible space are spread out more
	// than points near the bottom. The entire feasible space must be strictly
	// positive.
	ParameterSpec_UNIT_REVERSE_LOG_SCALE ParameterSpec_ScaleType = 3
)

var ParameterSpec_ScaleType_name = map[int32]string{
	0: "NONE",
	1: "UNIT_LINEAR_SCALE",
	2: "UNIT_LOG_SCALE",
	3: "UNIT_REVERSE_LOG_SCALE",
}
var ParameterSpec_ScaleType_value = map[string]int32{
	"NONE":                   0,
	"UNIT_LINEAR_SCALE":      1,
	"UNIT_LOG_SCALE":         2,
	"UNIT_REVERSE_LOG_SCALE": 3,
}

func (x ParameterSpec_ScaleType) String() string {
	return proto.EnumName(ParameterSpec_ScaleType_name, int32(x))
}
func (ParameterSpec_ScaleType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 1} }

// The format used to separate data instances in the source files.
type PredictionInput_DataFormat int32

const (
	// Unspecified format.
	PredictionInput_DATA_FORMAT_UNSPECIFIED PredictionInput_DataFormat = 0
	// The source file is a text file with instances separated by the
	// new-line character.
	PredictionInput_TEXT PredictionInput_DataFormat = 1
	// The source file is a TFRecord file.
	PredictionInput_TF_RECORD PredictionInput_DataFormat = 2
	// The source file is a GZIP-compressed TFRecord file.
	PredictionInput_TF_RECORD_GZIP PredictionInput_DataFormat = 3
)

var PredictionInput_DataFormat_name = map[int32]string{
	0: "DATA_FORMAT_UNSPECIFIED",
	1: "TEXT",
	2: "TF_RECORD",
	3: "TF_RECORD_GZIP",
}
var PredictionInput_DataFormat_value = map[string]int32{
	"DATA_FORMAT_UNSPECIFIED": 0,
	"TEXT":           1,
	"TF_RECORD":      2,
	"TF_RECORD_GZIP": 3,
}

func (x PredictionInput_DataFormat) String() string {
	return proto.EnumName(PredictionInput_DataFormat_name, int32(x))
}
func (PredictionInput_DataFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{5, 0}
}

// Describes the job state.
type Job_State int32

const (
	// The job state is unspecified.
	Job_STATE_UNSPECIFIED Job_State = 0
	// The job has been just created and processing has not yet begun.
	Job_QUEUED Job_State = 1
	// The service is preparing to run the job.
	Job_PREPARING Job_State = 2
	// The job is in progress.
	Job_RUNNING Job_State = 3
	// The job completed successfully.
	Job_SUCCEEDED Job_State = 4
	// The job failed.
	// `error_message` should contain the details of the failure.
	Job_FAILED Job_State = 5
	// The job is being cancelled.
	// `error_message` should describe the reason for the cancellation.
	Job_CANCELLING Job_State = 6
	// The job has been cancelled.
	// `error_message` should describe the reason for the cancellation.
	Job_CANCELLED Job_State = 7
)

var Job_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "QUEUED",
	2: "PREPARING",
	3: "RUNNING",
	4: "SUCCEEDED",
	5: "FAILED",
	6: "CANCELLING",
	7: "CANCELLED",
}
var Job_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"QUEUED":            1,
	"PREPARING":         2,
	"RUNNING":           3,
	"SUCCEEDED":         4,
	"FAILED":            5,
	"CANCELLING":        6,
	"CANCELLED":         7,
}

func (x Job_State) String() string {
	return proto.EnumName(Job_State_name, int32(x))
}
func (Job_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

// Represents input parameters for a training job.
type TrainingInput struct {
	// Required. Specifies the machine types, the number of replicas for workers
	// and parameter servers.
	ScaleTier TrainingInput_ScaleTier `protobuf:"varint,1,opt,name=scale_tier,json=scaleTier,enum=google.cloud.ml.v1beta1.TrainingInput_ScaleTier" json:"scale_tier,omitempty"`
	// Optional. Specifies the type of virtual machine to use for your training
	// job's master worker.
	//
	// The following types are supported:
	//
	// <dl>
	//   <dt>standard</dt>
	//   <dd>
	//   A basic machine configuration suitable for training simple models with
	//   small to moderate datasets.
	//   </dd>
	//   <dt>large_model</dt>
	//   <dd>
	//   A machine with a lot of memory, specially suited for parameter servers
	//   when your model is large (having many hidden layers or layers with very
	//   large numbers of nodes).
	//   </dd>
	//   <dt>complex_model_s</dt>
	//   <dd>
	//   A machine suitable for the master and workers of the cluster when your
	//   model requires more computation than the standard machine can handle
	//   satisfactorily.
	//   </dd>
	//   <dt>complex_model_m</dt>
	//   <dd>
	//   A machine with roughly twice the number of cores and roughly double the
	//   memory of `complex_model_s`.
	//   </dd>
	//   <dt>complex_model_l</dt>
	//   <dd>
	//   A machine with roughly twice the number of cores and roughly double the
	//   memory of `complex_model_m`.
	//   </dd>
	// </dl>
	//
	// This value can only be used when `ScaleTier` is set to `CUSTOM`.
	MasterType string `protobuf:"bytes,2,opt,name=master_type,json=masterType" json:"master_type,omitempty"`
	// Optional. Specifies the type of virtual machine to use for your training
	// job's worker nodes.
	//
	// The supported values are the same as those described in the entry for
	// `master_type`.
	//
	// This value must be present when `scale_tier` is set to `CUSTOM` and
	// `worker_count` is greater than zero.
	WorkerType string `protobuf:"bytes,3,opt,name=worker_type,json=workerType" json:"worker_type,omitempty"`
	// Optional. Specifies the type of virtual machine to use for your training
	// job's parameter server.
	//
	// The supported values are the same as those described in the entry for
	// `master_type`.
	//
	// This value must be present when `scale_tier` is set to `CUSTOM` and
	// `parameter_server_count` is greater than zero.
	ParameterServerType string `protobuf:"bytes,4,opt,name=parameter_server_type,json=parameterServerType" json:"parameter_server_type,omitempty"`
	// Optional. The number of worker replicas to use for the training job. Each
	// replica in the cluster will be of the type specified in `worker_type`.
	//
	// This value can only be used when `scale_tier` is set to `CUSTOM`. If you
	// set this value, you must also set `worker_type`.
	WorkerCount int64 `protobuf:"varint,5,opt,name=worker_count,json=workerCount" json:"worker_count,omitempty"`
	// Optional. The number of parameter server replicas to use for the training
	// job. Each replica in the cluster will be of the type specified in
	// `parameter_server_type`.
	//
	// This value can only be used when `scale_tier` is set to `CUSTOM`.If you
	// set this value, you must also set `parameter_server_type`.
	ParameterServerCount int64 `protobuf:"varint,6,opt,name=parameter_server_count,json=parameterServerCount" json:"parameter_server_count,omitempty"`
	// Required. The Google Cloud Storage location of the packages with
	// the training program and any additional dependencies.
	PackageUris []string `protobuf:"bytes,7,rep,name=package_uris,json=packageUris" json:"package_uris,omitempty"`
	// Required. The Python module name to run after installing the packages.
	PythonModule string `protobuf:"bytes,8,opt,name=python_module,json=pythonModule" json:"python_module,omitempty"`
	// Optional. Command line arguments to pass to the program.
	Args []string `protobuf:"bytes,10,rep,name=args" json:"args,omitempty"`
	// Optional. The set of Hyperparameters to tune.
	Hyperparameters *HyperparameterSpec `protobuf:"bytes,12,opt,name=hyperparameters" json:"hyperparameters,omitempty"`
	// Required. The Google Compute Engine region to run the training job in.
	Region string `protobuf:"bytes,14,opt,name=region" json:"region,omitempty"`
}

func (m *TrainingInput) Reset()                    { *m = TrainingInput{} }
func (m *TrainingInput) String() string            { return proto.CompactTextString(m) }
func (*TrainingInput) ProtoMessage()               {}
func (*TrainingInput) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *TrainingInput) GetHyperparameters() *HyperparameterSpec {
	if m != nil {
		return m.Hyperparameters
	}
	return nil
}

// Represents a set of hyperparameters to optimize.
type HyperparameterSpec struct {
	// Required. The type of goal to use for tuning. Available types are
	// `MAXIMIZE` and `MINIMIZE`.
	//
	// Defaults to `MAXIMIZE`.
	Goal HyperparameterSpec_GoalType `protobuf:"varint,1,opt,name=goal,enum=google.cloud.ml.v1beta1.HyperparameterSpec_GoalType" json:"goal,omitempty"`
	// Required. The set of parameters to tune.
	Params []*ParameterSpec `protobuf:"bytes,2,rep,name=params" json:"params,omitempty"`
	// Optional. How many training trials should be attempted to optimize
	// the specified hyperparameters.
	//
	// Defaults to one.
	MaxTrials int32 `protobuf:"varint,3,opt,name=max_trials,json=maxTrials" json:"max_trials,omitempty"`
	// Optional. The number of training trials to run concurrently.
	// You can reduce the time it takes to perform hyperparameter tuning by adding
	// trials in parallel. However, each trail only benefits from the information
	// gained in completed trials. That means that a trial does not get access to
	// the results of trials running at the same time, which could reduce the
	// quality of the overall optimization.
	//
	// Each trial will use the same scale tier and machine types.
	//
	// Defaults to one.
	MaxParallelTrials int32 `protobuf:"varint,4,opt,name=max_parallel_trials,json=maxParallelTrials" json:"max_parallel_trials,omitempty"`
}

func (m *HyperparameterSpec) Reset()                    { *m = HyperparameterSpec{} }
func (m *HyperparameterSpec) String() string            { return proto.CompactTextString(m) }
func (*HyperparameterSpec) ProtoMessage()               {}
func (*HyperparameterSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *HyperparameterSpec) GetParams() []*ParameterSpec {
	if m != nil {
		return m.Params
	}
	return nil
}

// Represents a single hyperparameter to optimize.
type ParameterSpec struct {
	// Required. The parameter name must be unique amongst all ParameterConfigs in
	// a HyperparameterSpec message. E.g., "learning_rate".
	ParameterName string `protobuf:"bytes,1,opt,name=parameter_name,json=parameterName" json:"parameter_name,omitempty"`
	// Required. The type of the parameter.
	Type ParameterSpec_ParameterType `protobuf:"varint,4,opt,name=type,enum=google.cloud.ml.v1beta1.ParameterSpec_ParameterType" json:"type,omitempty"`
	// Required if type is `DOUBLE` or `INTEGER`. This field
	// should be unset if type is `CATEGORICAL`. This value should be integers if
	// type is INTEGER.
	MinValue float64 `protobuf:"fixed64,2,opt,name=min_value,json=minValue" json:"min_value,omitempty"`
	// Required if typeis `DOUBLE` or `INTEGER`. This field
	// should be unset if type is `CATEGORICAL`. This value should be integers if
	// type is `INTEGER`.
	MaxValue float64 `protobuf:"fixed64,3,opt,name=max_value,json=maxValue" json:"max_value,omitempty"`
	// Required if type is `CATEGORICAL`. The list of possible categories.
	CategoricalValues []string `protobuf:"bytes,5,rep,name=categorical_values,json=categoricalValues" json:"categorical_values,omitempty"`
	// Required if type is `DISCRETE`.
	// A list of feasible points.
	// The list should be in strictly increasing order. For instance, this
	// parameter might have possible settings of 1.5, 2.5, and 4.0. This list
	// should not contain more than 1,000 values.
	DiscreteValues []float64 `protobuf:"fixed64,6,rep,packed,name=discrete_values,json=discreteValues" json:"discrete_values,omitempty"`
	// Optional. How the parameter should be scaled to the hypercube.
	// Leave unset for categorical parameters.
	// Some kind of scaling is strongly recommended for real or integral
	// parameters (e.g., `UNIT_LINEAR_SCALE`).
	ScaleType ParameterSpec_ScaleType `protobuf:"varint,7,opt,name=scale_type,json=scaleType,enum=google.cloud.ml.v1beta1.ParameterSpec_ScaleType" json:"scale_type,omitempty"`
}

func (m *ParameterSpec) Reset()                    { *m = ParameterSpec{} }
func (m *ParameterSpec) String() string            { return proto.CompactTextString(m) }
func (*ParameterSpec) ProtoMessage()               {}
func (*ParameterSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Represents the result of a single hyperparameter tuning trial from a
// training job. The TrainingOutput object that is returned on successful
// completion of a training job with hyperparameter tuning includes a list
// of HyperparameterOutput objects, one for each successful trial.
type HyperparameterOutput struct {
	// The trial id for these results.
	TrialId string `protobuf:"bytes,1,opt,name=trial_id,json=trialId" json:"trial_id,omitempty"`
	// The hyperparameters given to this trial.
	Hyperparameters map[string]string `protobuf:"bytes,2,rep,name=hyperparameters" json:"hyperparameters,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The final objective metric seen for this trial.
	FinalMetric *HyperparameterOutput_HyperparameterMetric `protobuf:"bytes,3,opt,name=final_metric,json=finalMetric" json:"final_metric,omitempty"`
	// All recorded object metrics for this trial.
	AllMetrics []*HyperparameterOutput_HyperparameterMetric `protobuf:"bytes,4,rep,name=all_metrics,json=allMetrics" json:"all_metrics,omitempty"`
}

func (m *HyperparameterOutput) Reset()                    { *m = HyperparameterOutput{} }
func (m *HyperparameterOutput) String() string            { return proto.CompactTextString(m) }
func (*HyperparameterOutput) ProtoMessage()               {}
func (*HyperparameterOutput) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *HyperparameterOutput) GetHyperparameters() map[string]string {
	if m != nil {
		return m.Hyperparameters
	}
	return nil
}

func (m *HyperparameterOutput) GetFinalMetric() *HyperparameterOutput_HyperparameterMetric {
	if m != nil {
		return m.FinalMetric
	}
	return nil
}

func (m *HyperparameterOutput) GetAllMetrics() []*HyperparameterOutput_HyperparameterMetric {
	if m != nil {
		return m.AllMetrics
	}
	return nil
}

// An observed value of a metric.
type HyperparameterOutput_HyperparameterMetric struct {
	// The global training step for this metric.
	TrainingStep int64 `protobuf:"varint,1,opt,name=training_step,json=trainingStep" json:"training_step,omitempty"`
	// The objective value at this training step.
	ObjectiveValue float64 `protobuf:"fixed64,2,opt,name=objective_value,json=objectiveValue" json:"objective_value,omitempty"`
}

func (m *HyperparameterOutput_HyperparameterMetric) Reset() {
	*m = HyperparameterOutput_HyperparameterMetric{}
}
func (m *HyperparameterOutput_HyperparameterMetric) String() string { return proto.CompactTextString(m) }
func (*HyperparameterOutput_HyperparameterMetric) ProtoMessage()    {}
func (*HyperparameterOutput_HyperparameterMetric) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{3, 0}
}

// Represents results of a training job.
type TrainingOutput struct {
	// The number of hyperparameter tuning trials that completed successfully.
	CompletedTrialCount int64 `protobuf:"varint,1,opt,name=completed_trial_count,json=completedTrialCount" json:"completed_trial_count,omitempty"`
	// Results for individual Hyperparameter trials.
	Trials []*HyperparameterOutput `protobuf:"bytes,2,rep,name=trials" json:"trials,omitempty"`
}

func (m *TrainingOutput) Reset()                    { *m = TrainingOutput{} }
func (m *TrainingOutput) String() string            { return proto.CompactTextString(m) }
func (*TrainingOutput) ProtoMessage()               {}
func (*TrainingOutput) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *TrainingOutput) GetTrials() []*HyperparameterOutput {
	if m != nil {
		return m.Trials
	}
	return nil
}

// Represents input parameters for a prediction job.
type PredictionInput struct {
	// Required. The model or the version to use for prediction.
	//
	// Types that are valid to be assigned to ModelVersion:
	//	*PredictionInput_ModelName
	//	*PredictionInput_VersionName
	ModelVersion isPredictionInput_ModelVersion `protobuf_oneof:"model_version"`
	// Required. The format of the input data files.
	DataFormat PredictionInput_DataFormat `protobuf:"varint,3,opt,name=data_format,json=dataFormat,enum=google.cloud.ml.v1beta1.PredictionInput_DataFormat" json:"data_format,omitempty"`
	// Required. The Google Cloud Storage location of the input data files.
	// May contain wildcards.
	InputPaths []string `protobuf:"bytes,4,rep,name=input_paths,json=inputPaths" json:"input_paths,omitempty"`
	// Required. The output Google Cloud Storage location.
	OutputPath string `protobuf:"bytes,5,opt,name=output_path,json=outputPath" json:"output_path,omitempty"`
	// Optional. The maximum amount of workers to be used for parallel processing.
	// Defaults to 10.
	MaxWorkerCount int64 `protobuf:"varint,6,opt,name=max_worker_count,json=maxWorkerCount" json:"max_worker_count,omitempty"`
	// Required. The Google Compute Engine region to run the prediction job in.
	Region string `protobuf:"bytes,7,opt,name=region" json:"region,omitempty"`
}

func (m *PredictionInput) Reset()                    { *m = PredictionInput{} }
func (m *PredictionInput) String() string            { return proto.CompactTextString(m) }
func (*PredictionInput) ProtoMessage()               {}
func (*PredictionInput) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type isPredictionInput_ModelVersion interface {
	isPredictionInput_ModelVersion()
}

type PredictionInput_ModelName struct {
	ModelName string `protobuf:"bytes,1,opt,name=model_name,json=modelName,oneof"`
}
type PredictionInput_VersionName struct {
	VersionName string `protobuf:"bytes,2,opt,name=version_name,json=versionName,oneof"`
}

func (*PredictionInput_ModelName) isPredictionInput_ModelVersion()   {}
func (*PredictionInput_VersionName) isPredictionInput_ModelVersion() {}

func (m *PredictionInput) GetModelVersion() isPredictionInput_ModelVersion {
	if m != nil {
		return m.ModelVersion
	}
	return nil
}

func (m *PredictionInput) GetModelName() string {
	if x, ok := m.GetModelVersion().(*PredictionInput_ModelName); ok {
		return x.ModelName
	}
	return ""
}

func (m *PredictionInput) GetVersionName() string {
	if x, ok := m.GetModelVersion().(*PredictionInput_VersionName); ok {
		return x.VersionName
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PredictionInput) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PredictionInput_OneofMarshaler, _PredictionInput_OneofUnmarshaler, _PredictionInput_OneofSizer, []interface{}{
		(*PredictionInput_ModelName)(nil),
		(*PredictionInput_VersionName)(nil),
	}
}

func _PredictionInput_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PredictionInput)
	// model_version
	switch x := m.ModelVersion.(type) {
	case *PredictionInput_ModelName:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ModelName)
	case *PredictionInput_VersionName:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.VersionName)
	case nil:
	default:
		return fmt.Errorf("PredictionInput.ModelVersion has unexpected type %T", x)
	}
	return nil
}

func _PredictionInput_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PredictionInput)
	switch tag {
	case 1: // model_version.model_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ModelVersion = &PredictionInput_ModelName{x}
		return true, err
	case 2: // model_version.version_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ModelVersion = &PredictionInput_VersionName{x}
		return true, err
	default:
		return false, nil
	}
}

func _PredictionInput_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PredictionInput)
	// model_version
	switch x := m.ModelVersion.(type) {
	case *PredictionInput_ModelName:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ModelName)))
		n += len(x.ModelName)
	case *PredictionInput_VersionName:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.VersionName)))
		n += len(x.VersionName)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Represents results of a prediction job.
type PredictionOutput struct {
	// The output Google Cloud Storage location provided at the job creation time.
	OutputPath string `protobuf:"bytes,1,opt,name=output_path,json=outputPath" json:"output_path,omitempty"`
	// The number of generated predictions.
	PredictionCount int64 `protobuf:"varint,2,opt,name=prediction_count,json=predictionCount" json:"prediction_count,omitempty"`
	// The number of data instances which resulted in errors.
	ErrorCount int64 `protobuf:"varint,3,opt,name=error_count,json=errorCount" json:"error_count,omitempty"`
}

func (m *PredictionOutput) Reset()                    { *m = PredictionOutput{} }
func (m *PredictionOutput) String() string            { return proto.CompactTextString(m) }
func (*PredictionOutput) ProtoMessage()               {}
func (*PredictionOutput) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// Represents a training or prediction job.
type Job struct {
	// Required. The user-specified id of the job.
	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
	// Required. Parameters to create a job.
	//
	// Types that are valid to be assigned to Input:
	//	*Job_TrainingInput
	//	*Job_PredictionInput
	Input isJob_Input `protobuf_oneof:"input"`
	// Output only. When the job was created.
	CreateTime *google_protobuf2.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Output only. When the job processing was started.
	StartTime *google_protobuf2.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Output only. When the job processing was completed.
	EndTime *google_protobuf2.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Output only. The detailed state of a job.
	State Job_State `protobuf:"varint,7,opt,name=state,enum=google.cloud.ml.v1beta1.Job_State" json:"state,omitempty"`
	// Output only. The details of a failure or a cancellation.
	ErrorMessage string `protobuf:"bytes,8,opt,name=error_message,json=errorMessage" json:"error_message,omitempty"`
	// Output only. The current result of the job.
	//
	// Types that are valid to be assigned to Output:
	//	*Job_TrainingOutput
	//	*Job_PredictionOutput
	Output isJob_Output `protobuf_oneof:"output"`
}

func (m *Job) Reset()                    { *m = Job{} }
func (m *Job) String() string            { return proto.CompactTextString(m) }
func (*Job) ProtoMessage()               {}
func (*Job) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type isJob_Input interface {
	isJob_Input()
}
type isJob_Output interface {
	isJob_Output()
}

type Job_TrainingInput struct {
	TrainingInput *TrainingInput `protobuf:"bytes,2,opt,name=training_input,json=trainingInput,oneof"`
}
type Job_PredictionInput struct {
	PredictionInput *PredictionInput `protobuf:"bytes,3,opt,name=prediction_input,json=predictionInput,oneof"`
}
type Job_TrainingOutput struct {
	TrainingOutput *TrainingOutput `protobuf:"bytes,9,opt,name=training_output,json=trainingOutput,oneof"`
}
type Job_PredictionOutput struct {
	PredictionOutput *PredictionOutput `protobuf:"bytes,10,opt,name=prediction_output,json=predictionOutput,oneof"`
}

func (*Job_TrainingInput) isJob_Input()     {}
func (*Job_PredictionInput) isJob_Input()   {}
func (*Job_TrainingOutput) isJob_Output()   {}
func (*Job_PredictionOutput) isJob_Output() {}

func (m *Job) GetInput() isJob_Input {
	if m != nil {
		return m.Input
	}
	return nil
}
func (m *Job) GetOutput() isJob_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (m *Job) GetTrainingInput() *TrainingInput {
	if x, ok := m.GetInput().(*Job_TrainingInput); ok {
		return x.TrainingInput
	}
	return nil
}

func (m *Job) GetPredictionInput() *PredictionInput {
	if x, ok := m.GetInput().(*Job_PredictionInput); ok {
		return x.PredictionInput
	}
	return nil
}

func (m *Job) GetCreateTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Job) GetStartTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Job) GetEndTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *Job) GetTrainingOutput() *TrainingOutput {
	if x, ok := m.GetOutput().(*Job_TrainingOutput); ok {
		return x.TrainingOutput
	}
	return nil
}

func (m *Job) GetPredictionOutput() *PredictionOutput {
	if x, ok := m.GetOutput().(*Job_PredictionOutput); ok {
		return x.PredictionOutput
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Job) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Job_OneofMarshaler, _Job_OneofUnmarshaler, _Job_OneofSizer, []interface{}{
		(*Job_TrainingInput)(nil),
		(*Job_PredictionInput)(nil),
		(*Job_TrainingOutput)(nil),
		(*Job_PredictionOutput)(nil),
	}
}

func _Job_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Job)
	// input
	switch x := m.Input.(type) {
	case *Job_TrainingInput:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TrainingInput); err != nil {
			return err
		}
	case *Job_PredictionInput:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PredictionInput); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Job.Input has unexpected type %T", x)
	}
	// output
	switch x := m.Output.(type) {
	case *Job_TrainingOutput:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TrainingOutput); err != nil {
			return err
		}
	case *Job_PredictionOutput:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PredictionOutput); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Job.Output has unexpected type %T", x)
	}
	return nil
}

func _Job_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Job)
	switch tag {
	case 2: // input.training_input
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TrainingInput)
		err := b.DecodeMessage(msg)
		m.Input = &Job_TrainingInput{msg}
		return true, err
	case 3: // input.prediction_input
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PredictionInput)
		err := b.DecodeMessage(msg)
		m.Input = &Job_PredictionInput{msg}
		return true, err
	case 9: // output.training_output
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TrainingOutput)
		err := b.DecodeMessage(msg)
		m.Output = &Job_TrainingOutput{msg}
		return true, err
	case 10: // output.prediction_output
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PredictionOutput)
		err := b.DecodeMessage(msg)
		m.Output = &Job_PredictionOutput{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Job_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Job)
	// input
	switch x := m.Input.(type) {
	case *Job_TrainingInput:
		s := proto.Size(x.TrainingInput)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_PredictionInput:
		s := proto.Size(x.PredictionInput)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// output
	switch x := m.Output.(type) {
	case *Job_TrainingOutput:
		s := proto.Size(x.TrainingOutput)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_PredictionOutput:
		s := proto.Size(x.PredictionOutput)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request message for the CreateJob method.
type CreateJobRequest struct {
	// Required. The project name.
	//
	// Authorization: requires `Editor` role on the specified project.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The job to create.
	Job *Job `protobuf:"bytes,2,opt,name=job" json:"job,omitempty"`
}

func (m *CreateJobRequest) Reset()                    { *m = CreateJobRequest{} }
func (m *CreateJobRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateJobRequest) ProtoMessage()               {}
func (*CreateJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *CreateJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

// Request message for the ListJobs method.
type ListJobsRequest struct {
	// Required. The name of the project for which to list jobs.
	//
	// Authorization: requires `Viewer` role on the specified project.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. Specifies the subset of jobs to retrieve.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Optional. A page token to request the next page of results.
	//
	// You get the token from the `next_page_token` field of the response from
	// the previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// Optional. The number of jobs to retrieve per "page" of results. If there
	// are more remaining results than this number, the response message will
	// contain a valid value in the `next_page_token` field.
	//
	// The default value is 20, and the maximum page size is 100.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListJobsRequest) Reset()                    { *m = ListJobsRequest{} }
func (m *ListJobsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListJobsRequest) ProtoMessage()               {}
func (*ListJobsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// Response message for the ListJobs method.
type ListJobsResponse struct {
	// The list of jobs.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs" json:"jobs,omitempty"`
	// Optional. Pass this token as the `page_token` field of the request for a
	// subsequent call.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListJobsResponse) Reset()                    { *m = ListJobsResponse{} }
func (m *ListJobsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListJobsResponse) ProtoMessage()               {}
func (*ListJobsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ListJobsResponse) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

// Request message for the GetJob method.
type GetJobRequest struct {
	// Required. The name of the job to get the description of.
	//
	// Authorization: requires `Viewer` role on the parent project.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetJobRequest) Reset()                    { *m = GetJobRequest{} }
func (m *GetJobRequest) String() string            { return proto.CompactTextString(m) }
func (*GetJobRequest) ProtoMessage()               {}
func (*GetJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

// Request message for the CancelJob method.
type CancelJobRequest struct {
	// Required. The name of the job to cancel.
	//
	// Authorization: requires `Editor` role on the parent project.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *CancelJobRequest) Reset()                    { *m = CancelJobRequest{} }
func (m *CancelJobRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelJobRequest) ProtoMessage()               {}
func (*CancelJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func init() {
	proto.RegisterType((*TrainingInput)(nil), "google.cloud.ml.v1beta1.TrainingInput")
	proto.RegisterType((*HyperparameterSpec)(nil), "google.cloud.ml.v1beta1.HyperparameterSpec")
	proto.RegisterType((*ParameterSpec)(nil), "google.cloud.ml.v1beta1.ParameterSpec")
	proto.RegisterType((*HyperparameterOutput)(nil), "google.cloud.ml.v1beta1.HyperparameterOutput")
	proto.RegisterType((*HyperparameterOutput_HyperparameterMetric)(nil), "google.cloud.ml.v1beta1.HyperparameterOutput.HyperparameterMetric")
	proto.RegisterType((*TrainingOutput)(nil), "google.cloud.ml.v1beta1.TrainingOutput")
	proto.RegisterType((*PredictionInput)(nil), "google.cloud.ml.v1beta1.PredictionInput")
	proto.RegisterType((*PredictionOutput)(nil), "google.cloud.ml.v1beta1.PredictionOutput")
	proto.RegisterType((*Job)(nil), "google.cloud.ml.v1beta1.Job")
	proto.RegisterType((*CreateJobRequest)(nil), "google.cloud.ml.v1beta1.CreateJobRequest")
	proto.RegisterType((*ListJobsRequest)(nil), "google.cloud.ml.v1beta1.ListJobsRequest")
	proto.RegisterType((*ListJobsResponse)(nil), "google.cloud.ml.v1beta1.ListJobsResponse")
	proto.RegisterType((*GetJobRequest)(nil), "google.cloud.ml.v1beta1.GetJobRequest")
	proto.RegisterType((*CancelJobRequest)(nil), "google.cloud.ml.v1beta1.CancelJobRequest")
	proto.RegisterEnum("google.cloud.ml.v1beta1.TrainingInput_ScaleTier", TrainingInput_ScaleTier_name, TrainingInput_ScaleTier_value)
	proto.RegisterEnum("google.cloud.ml.v1beta1.HyperparameterSpec_GoalType", HyperparameterSpec_GoalType_name, HyperparameterSpec_GoalType_value)
	proto.RegisterEnum("google.cloud.ml.v1beta1.ParameterSpec_ParameterType", ParameterSpec_ParameterType_name, ParameterSpec_ParameterType_value)
	proto.RegisterEnum("google.cloud.ml.v1beta1.ParameterSpec_ScaleType", ParameterSpec_ScaleType_name, ParameterSpec_ScaleType_value)
	proto.RegisterEnum("google.cloud.ml.v1beta1.PredictionInput_DataFormat", PredictionInput_DataFormat_name, PredictionInput_DataFormat_value)
	proto.RegisterEnum("google.cloud.ml.v1beta1.Job_State", Job_State_name, Job_State_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for JobService service

type JobServiceClient interface {
	// Creates a training or a batch prediction job.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Lists the jobs in the project.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Describes a job.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Cancels a running job.
	CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
}

type jobServiceClient struct {
	cc *grpc.ClientConn
}

func NewJobServiceClient(cc *grpc.ClientConn) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.JobService/CreateJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.JobService/ListJobs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.JobService/GetJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.JobService/CancelJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for JobService service

type JobServiceServer interface {
	// Creates a training or a batch prediction job.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Lists the jobs in the project.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Describes a job.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Cancels a running job.
	CancelJob(context.Context, *CancelJobRequest) (*google_protobuf1.Empty, error)
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.JobService/CreateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.JobService/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.JobService/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_CancelJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CancelJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.JobService/CancelJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CancelJob(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.ml.v1beta1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJob",
			Handler:    _JobService_CreateJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobService_ListJobs_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobService_GetJob_Handler,
		},
		{
			MethodName: "CancelJob",
			Handler:    _JobService_CancelJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/cloud/ml/v1beta1/job_service.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/ml/v1beta1/job_service.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1939 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x58, 0x5b, 0x73, 0x1b, 0x49,
	0x15, 0xb6, 0xae, 0x96, 0x8e, 0x6c, 0x69, 0xd2, 0x9b, 0x78, 0xb5, 0x5a, 0x20, 0xce, 0xb8, 0xc8,
	0x2a, 0xa1, 0x22, 0x6d, 0x9c, 0x50, 0xb5, 0x64, 0x0b, 0xaa, 0xc6, 0xd2, 0xd8, 0x96, 0xcb, 0xba,
	0xd0, 0x1a, 0x85, 0x90, 0xa2, 0x6a, 0xaa, 0x35, 0x6a, 0x2b, 0xe3, 0xcc, 0x8d, 0x99, 0x91, 0xb1,
	0x96, 0x4a, 0x41, 0x01, 0x4f, 0xf0, 0x48, 0xc1, 0x03, 0x6f, 0xbc, 0xf2, 0xc4, 0x1f, 0xe0, 0x57,
	0xf0, 0x17, 0xf8, 0x21, 0x54, 0x77, 0xcf, 0x8c, 0x2e, 0x8e, 0x2f, 0x5b, 0xf0, 0xe2, 0x9a, 0x3e,
	0xe7, 0x3b, 0xf7, 0xd3, 0xa7, 0x8f, 0x0c, 0xc7, 0x53, 0xd7, 0x9d, 0x5a, 0xb4, 0x31, 0x75, 0x2d,
	0xe2, 0x4c, 0x1b, 0xae, 0x3f, 0x6d, 0x4e, 0xa9, 0xe3, 0xf9, 0x6e, 0xe8, 0x36, 0x05, 0x8b, 0x78,
	0x66, 0xd0, 0x34, 0x2c, 0x77, 0x36, 0x69, 0xda, 0x56, 0xf3, 0xe2, 0xf9, 0x98, 0x86, 0xe4, 0x79,
	0xf3, 0xdc, 0x1d, 0xeb, 0x01, 0xf5, 0x2f, 0x4c, 0x83, 0x36, 0x38, 0x1a, 0x7d, 0x1a, 0x69, 0xe2,
	0xd0, 0x86, 0x6d, 0x35, 0x22, 0x68, 0xad, 0x73, 0x37, 0x13, 0xc4, 0x33, 0x9b, 0x91, 0x46, 0xc3,
	0x75, 0xce, 0xcc, 0x69, 0x93, 0x38, 0x8e, 0x1b, 0x92, 0xd0, 0x74, 0x9d, 0x40, 0xd8, 0xa8, 0xbd,
	0x98, 0x9a, 0xe1, 0xbb, 0xd9, 0xb8, 0x61, 0xb8, 0x76, 0x53, 0xa8, 0x6b, 0x72, 0xc6, 0x78, 0x76,
	0xd6, 0xf4, 0xc2, 0xb9, 0x47, 0x83, 0x26, 0xb5, 0xbd, 0x70, 0x2e, 0xfe, 0x46, 0x42, 0x5f, 0xdf,
	0x2e, 0x14, 0x9a, 0x36, 0x0d, 0x42, 0x62, 0x7b, 0x8b, 0x2f, 0x21, 0x2c, 0xff, 0x2b, 0x0b, 0xdb,
	0x9a, 0x4f, 0x4c, 0xc7, 0x74, 0xa6, 0x1d, 0xc7, 0x9b, 0x85, 0xa8, 0x0f, 0x10, 0x18, 0xc4, 0xa2,
	0x7a, 0x68, 0x52, 0xbf, 0x9a, 0xda, 0x4d, 0xd5, 0xcb, 0xfb, 0x5f, 0x36, 0xae, 0x09, 0xbe, 0xb1,
	0x22, 0xdb, 0x18, 0x32, 0x41, 0xcd, 0xa4, 0x3e, 0x2e, 0x06, 0xf1, 0x27, 0x7a, 0x08, 0x25, 0x9b,
	0x04, 0x21, 0xf5, 0x75, 0xe6, 0x4c, 0x35, 0xbd, 0x9b, 0xaa, 0x17, 0x31, 0x08, 0x92, 0x36, 0xf7,
	0x28, 0x03, 0xfc, 0xca, 0xf5, 0xdf, 0xc7, 0x80, 0x8c, 0x00, 0x08, 0x12, 0x07, 0xec, 0xc3, 0x03,
	0x8f, 0xf8, 0xc4, 0xa6, 0x4c, 0x09, 0xcb, 0x61, 0x0c, 0xcd, 0x72, 0xe8, 0x27, 0x09, 0x73, 0xc8,
	0x79, 0x5c, 0xe6, 0x11, 0x6c, 0x45, 0x4a, 0x0d, 0x77, 0xe6, 0x84, 0xd5, 0xdc, 0x6e, 0xaa, 0x9e,
	0xc1, 0x91, 0xa1, 0x16, 0x23, 0xa1, 0x97, 0xb0, 0x73, 0x45, 0xad, 0x00, 0xe7, 0x39, 0xf8, 0xfe,
	0x9a, 0x5e, 0x21, 0xf5, 0x08, 0xb6, 0x3c, 0x62, 0xbc, 0x27, 0x53, 0xaa, 0xcf, 0x7c, 0x33, 0xa8,
	0x6e, 0xee, 0x66, 0xea, 0x45, 0x5c, 0x8a, 0x68, 0x23, 0xdf, 0x0c, 0xd0, 0x1e, 0x6c, 0x7b, 0xf3,
	0xf0, 0x9d, 0xeb, 0xe8, 0xb6, 0x3b, 0x99, 0x59, 0xb4, 0x5a, 0xe0, 0x7e, 0x6e, 0x09, 0x62, 0x97,
	0xd3, 0x10, 0x82, 0x2c, 0xf1, 0xa7, 0x41, 0x15, 0xb8, 0x3c, 0xff, 0x46, 0x23, 0xa8, 0xbc, 0x9b,
	0x7b, 0xd4, 0x4f, 0x0c, 0x07, 0xd5, 0xad, 0xdd, 0x54, 0xbd, 0xb4, 0xff, 0x83, 0x6b, 0x0b, 0x70,
	0xbc, 0x82, 0x1f, 0x7a, 0xd4, 0xc0, 0xeb, 0x3a, 0xd0, 0x0e, 0xe4, 0x7d, 0x3a, 0x35, 0x5d, 0xa7,
	0x5a, 0xe6, 0x8e, 0x44, 0x27, 0x59, 0x81, 0x62, 0x52, 0x31, 0x54, 0x84, 0xdc, 0x81, 0x32, 0xec,
	0xb4, 0xa4, 0x0d, 0x54, 0x06, 0x18, 0x6a, 0x4a, 0xaf, 0xad, 0xe0, 0xb6, 0xfe, 0x5c, 0x4a, 0xa1,
	0x6d, 0x28, 0x0e, 0xb0, 0xda, 0xed, 0x8c, 0xba, 0xfa, 0x73, 0x29, 0x83, 0x00, 0xf2, 0xad, 0xd1,
	0x50, 0xeb, 0x77, 0xa5, 0x9c, 0xfc, 0xcf, 0x34, 0xa0, 0xab, 0x2e, 0xa0, 0x63, 0xc8, 0x4e, 0x5d,
	0x62, 0x45, 0xed, 0xf3, 0xf2, 0x5b, 0x78, 0xdf, 0x38, 0x72, 0x89, 0xc5, 0x2a, 0x88, 0xb9, 0x06,
	0xf4, 0x13, 0xc8, 0x73, 0x7e, 0x50, 0x4d, 0xef, 0x66, 0xea, 0xa5, 0xfd, 0xc7, 0xd7, 0xea, 0x1a,
	0xac, 0x24, 0x21, 0x92, 0x42, 0xdf, 0x05, 0xb0, 0xc9, 0xa5, 0x1e, 0xfa, 0x26, 0xb1, 0x02, 0xde,
	0x5b, 0x39, 0x5c, 0xb4, 0xc9, 0xa5, 0xc6, 0x09, 0xa8, 0x01, 0x9f, 0x30, 0x36, 0x03, 0x5b, 0x16,
	0xb5, 0x62, 0x5c, 0x96, 0xe3, 0xee, 0xd9, 0xe4, 0x72, 0x10, 0x71, 0x04, 0x5e, 0x56, 0xa0, 0x10,
	0x3b, 0x88, 0x3e, 0x83, 0x07, 0x47, 0x7d, 0xe5, 0x54, 0xd7, 0x7e, 0x3e, 0x50, 0xf5, 0x51, 0x6f,
	0x38, 0x50, 0x5b, 0x9d, 0xc3, 0x8e, 0xda, 0x96, 0x36, 0xd0, 0x16, 0x14, 0xba, 0xca, 0x9b, 0x4e,
	0xb7, 0xf3, 0x56, 0x95, 0x52, 0xfc, 0xd4, 0xe9, 0x89, 0x53, 0x5a, 0xfe, 0x47, 0x16, 0xb6, 0x57,
	0x7c, 0x45, 0xdf, 0x87, 0xf2, 0xa2, 0x11, 0x1d, 0x62, 0x53, 0x9e, 0xb7, 0x22, 0xde, 0x4e, 0xa8,
	0x3d, 0x62, 0x53, 0x96, 0xd4, 0xa4, 0xeb, 0x6f, 0x4a, 0xea, 0x8a, 0xf2, 0xc5, 0x49, 0x24, 0x95,
	0x69, 0x40, 0x9f, 0x43, 0xd1, 0x36, 0x1d, 0xfd, 0x82, 0x58, 0x33, 0x71, 0x21, 0x53, 0xb8, 0x60,
	0x9b, 0xce, 0x6b, 0x76, 0xe6, 0x4c, 0x72, 0x19, 0x31, 0x33, 0x11, 0x93, 0x5c, 0x0a, 0xe6, 0x33,
	0x40, 0x06, 0x09, 0xe9, 0xd4, 0xf5, 0x4d, 0x83, 0x58, 0x02, 0x14, 0x54, 0x73, 0xbc, 0x87, 0xef,
	0x2d, 0x71, 0x38, 0x3a, 0x40, 0x5f, 0x40, 0x65, 0x62, 0x06, 0x86, 0x4f, 0x43, 0x1a, 0x63, 0xf3,
	0xbb, 0x99, 0x7a, 0x0a, 0x97, 0x63, 0x72, 0x04, 0x5c, 0x4c, 0x1d, 0x16, 0xe1, 0xe6, 0x2d, 0x53,
	0x67, 0x35, 0x42, 0xd1, 0xc3, 0x2c, 0xba, 0x68, 0xea, 0xcc, 0x3d, 0x2a, 0x4f, 0x97, 0x92, 0xcc,
	0xab, 0xf5, 0x3d, 0xa8, 0x0d, 0x14, 0xac, 0x74, 0x55, 0x4d, 0xc5, 0x1f, 0x2b, 0x19, 0x40, 0xbe,
	0xdd, 0x1f, 0x1d, 0x9c, 0xb2, 0x82, 0x95, 0x60, 0xb3, 0xd3, 0xd3, 0xd4, 0x23, 0x15, 0x4b, 0x69,
	0x54, 0x81, 0x52, 0x4b, 0xd1, 0xd4, 0xa3, 0x3e, 0xee, 0xb4, 0x94, 0x53, 0x29, 0xc3, 0xca, 0xd9,
	0xee, 0x0c, 0x5b, 0x58, 0xd5, 0x54, 0x29, 0x2b, 0xff, 0x22, 0xbe, 0x44, 0xcc, 0x48, 0x01, 0xb2,
	0xbd, 0x7e, 0x4f, 0x95, 0x36, 0xd0, 0x03, 0xb8, 0x37, 0xea, 0x75, 0x34, 0xfd, 0xb4, 0xd3, 0x53,
	0x15, 0xac, 0x0f, 0x5b, 0x0a, 0xd7, 0x8c, 0xa0, 0x2c, 0xc8, 0xfd, 0xa3, 0x88, 0x96, 0x46, 0x35,
	0xd8, 0xe1, 0x34, 0xac, 0xbe, 0x56, 0xf1, 0x50, 0x5d, 0xe2, 0x65, 0xe4, 0xbf, 0x64, 0xe1, 0xfe,
	0xea, 0x25, 0xe9, 0xcf, 0x42, 0x36, 0xa6, 0x3f, 0x83, 0x02, 0xef, 0x55, 0xdd, 0x9c, 0x44, 0xdd,
	0xb2, 0xc9, 0xcf, 0x9d, 0x09, 0xb2, 0xae, 0x4e, 0x11, 0x71, 0x77, 0x0e, 0xee, 0x78, 0x0f, 0x85,
	0x89, 0x35, 0x62, 0xa0, 0x3a, 0xa1, 0x3f, 0xbf, 0x3a, 0x5c, 0x28, 0x6c, 0x9d, 0x99, 0x0e, 0xb1,
	0x74, 0x9b, 0x86, 0xbe, 0x69, 0xf0, 0x8e, 0xf9, 0x1f, 0x4d, 0x75, 0xb9, 0x26, 0x5c, 0xe2, 0x7a,
	0xc5, 0x01, 0x19, 0x50, 0x22, 0x56, 0x6c, 0x84, 0x5d, 0xd0, 0xcc, 0xff, 0xc9, 0x0a, 0x10, 0x2b,
	0xb2, 0x11, 0xd4, 0x26, 0xeb, 0xc9, 0x8e, 0x8c, 0xef, 0xc1, 0x76, 0x18, 0x3d, 0x74, 0x7a, 0x10,
	0x52, 0x8f, 0x67, 0x3c, 0x83, 0xb7, 0x62, 0xe2, 0x30, 0xa4, 0x1e, 0xeb, 0x75, 0x77, 0x7c, 0x4e,
	0x8d, 0xd0, 0xbc, 0xa0, 0x2b, 0x57, 0xab, 0x9c, 0x90, 0x79, 0xb3, 0xd7, 0x0e, 0xd6, 0xad, 0x88,
	0xd4, 0x22, 0x09, 0x32, 0xef, 0xe9, 0x3c, 0xaa, 0x26, 0xfb, 0x44, 0xf7, 0x21, 0xb7, 0x50, 0x54,
	0xc4, 0xe2, 0xf0, 0x2a, 0xfd, 0x55, 0x4a, 0xfe, 0x53, 0x0a, 0xca, 0xf1, 0xdb, 0x1b, 0x75, 0xc4,
	0x3e, 0x3c, 0x30, 0x5c, 0xdb, 0xb3, 0x68, 0x48, 0x27, 0x62, 0x8e, 0x45, 0xaf, 0x99, 0x70, 0xf6,
	0x93, 0x84, 0xc9, 0x47, 0x99, 0x78, 0xcc, 0x54, 0xc8, 0x47, 0x13, 0x4f, 0x74, 0xc8, 0xb3, 0x6f,
	0x95, 0x50, 0x1c, 0x09, 0xcb, 0x7f, 0xcb, 0x40, 0x65, 0xe0, 0xd3, 0x89, 0x69, 0xb0, 0x6d, 0x46,
	0xec, 0x11, 0x0f, 0x01, 0x6c, 0x77, 0x42, 0xad, 0xa5, 0x81, 0x76, 0xbc, 0x81, 0x8b, 0x9c, 0xc6,
	0xc7, 0xd9, 0x1e, 0x6c, 0x5d, 0x50, 0x3f, 0x30, 0x5d, 0x47, 0x40, 0xd2, 0x11, 0xa4, 0x14, 0x51,
	0x39, 0x48, 0x83, 0xd2, 0x84, 0x84, 0x44, 0x3f, 0x73, 0x7d, 0x9b, 0x84, 0xbc, 0xb9, 0xca, 0xfb,
	0x2f, 0xae, 0x1f, 0x0c, 0xab, 0x4e, 0x34, 0xda, 0x24, 0x24, 0x87, 0x5c, 0x14, 0xc3, 0x24, 0xf9,
	0x66, 0x1b, 0x87, 0xc9, 0xf8, 0xba, 0x47, 0xc2, 0x77, 0xa2, 0x99, 0x8a, 0x18, 0x38, 0x69, 0xc0,
	0x28, 0x0c, 0xe0, 0xf2, 0x10, 0x39, 0x82, 0x2f, 0x0f, 0x45, 0x0c, 0x82, 0xc4, 0x10, 0xa8, 0x0e,
	0x12, 0x1b, 0x92, 0x2b, 0x2b, 0x86, 0xd8, 0x1a, 0xca, 0x36, 0xb9, 0xfc, 0xd9, 0xd2, 0x96, 0xb1,
	0x78, 0x7c, 0x37, 0x57, 0x1e, 0xdf, 0xd7, 0x00, 0x0b, 0xef, 0xd0, 0xe7, 0xf0, 0x69, 0x5b, 0xd1,
	0x14, 0xfd, 0xb0, 0x8f, 0xbb, 0x8a, 0xb6, 0x36, 0x9a, 0x0a, 0x90, 0xd5, 0xd4, 0x37, 0x9a, 0x78,
	0x89, 0xb5, 0x43, 0x1d, 0xab, 0xad, 0x3e, 0x6e, 0x4b, 0x69, 0x36, 0x4d, 0x92, 0xa3, 0x7e, 0xf4,
	0xb6, 0x33, 0x90, 0x32, 0x07, 0x15, 0xd8, 0x16, 0x79, 0x8f, 0xd2, 0x28, 0xff, 0x06, 0xa4, 0x45,
	0x5a, 0xa2, 0x5e, 0x59, 0x8b, 0x2f, 0x75, 0x25, 0xbe, 0x27, 0x20, 0x79, 0x89, 0x50, 0x14, 0x5f,
	0x9a, 0xc7, 0x57, 0x59, 0xd0, 0x45, 0x80, 0x0f, 0xa1, 0x44, 0x7d, 0xdf, 0x8d, 0xb3, 0x90, 0xe1,
	0x28, 0xe0, 0x24, 0x0e, 0x90, 0xff, 0x9a, 0x87, 0xcc, 0x89, 0x3b, 0x46, 0x0f, 0x20, 0xcf, 0xd6,
	0xea, 0x64, 0x60, 0xe5, 0xce, 0xdd, 0x71, 0x67, 0x82, 0xfa, 0x50, 0x4e, 0x2e, 0x17, 0x2f, 0x01,
	0x37, 0x74, 0xd3, 0x4b, 0xbf, 0xb2, 0x74, 0x1e, 0x6f, 0xe0, 0xe4, 0x72, 0x8a, 0xce, 0x1b, 0xad,
	0xf8, 0x2e, 0x54, 0x8a, 0xa9, 0x54, 0xbf, 0x6b, 0xe3, 0x1c, 0x6f, 0x2c, 0xc7, 0x29, 0xd4, 0x7e,
	0x0d, 0x25, 0xc3, 0xa7, 0x24, 0x64, 0x9b, 0xb1, 0x2d, 0x5e, 0xe1, 0xd2, 0x7e, 0x2d, 0xd6, 0x18,
	0xaf, 0xdc, 0x0d, 0x2d, 0xde, 0xb0, 0x31, 0x08, 0x38, 0x23, 0xa0, 0x1f, 0x01, 0x04, 0x21, 0xf1,
	0x43, 0x21, 0x9b, 0xbb, 0x55, 0xb6, 0xc8, 0xd1, 0x5c, 0xf4, 0x87, 0x50, 0xa0, 0xce, 0x44, 0x08,
	0xe6, 0x6f, 0x15, 0xdc, 0xa4, 0xce, 0x84, 0x8b, 0x7d, 0x05, 0xb9, 0x20, 0x24, 0x61, 0xfc, 0x98,
	0xca, 0xd7, 0x86, 0x7e, 0xe2, 0x8e, 0x1b, 0x43, 0x86, 0xc4, 0x42, 0x80, 0x4d, 0x3b, 0x51, 0x50,
	0x9b, 0x06, 0x01, 0x99, 0x26, 0xeb, 0x2b, 0x27, 0x76, 0x05, 0x0d, 0x61, 0xa8, 0x24, 0x55, 0x13,
	0x7d, 0x53, 0x2d, 0x72, 0xe7, 0xbe, 0xb8, 0xb5, 0x6c, 0xa2, 0x07, 0x8f, 0x53, 0x38, 0xa9, 0x7b,
	0xd4, 0x95, 0x6f, 0xe0, 0xde, 0x52, 0xe1, 0x22, 0xad, 0xc0, 0xb5, 0x3e, 0xb9, 0x43, 0xe5, 0x12,
	0xbd, 0x4b, 0xe5, 0x17, 0x34, 0xf9, 0xb7, 0x29, 0xc8, 0xf1, 0x18, 0xd9, 0xbb, 0x3c, 0xd4, 0x14,
	0xed, 0x23, 0xaf, 0xff, 0x4f, 0x47, 0xea, 0x48, 0x6d, 0x27, 0xeb, 0xee, 0x40, 0xc1, 0x9d, 0xde,
	0x91, 0x94, 0x66, 0xcb, 0x00, 0x1e, 0xf5, 0x7a, 0xec, 0x90, 0x61, 0xbc, 0xe1, 0xa8, 0xd5, 0x52,
	0xd5, 0xb6, 0xda, 0x96, 0xb2, 0x4c, 0xec, 0x50, 0xe9, 0x9c, 0xaa, 0x6d, 0x29, 0xc7, 0xb6, 0xe6,
	0x96, 0xd2, 0x6b, 0xa9, 0xa7, 0xa7, 0x0c, 0x9a, 0x67, 0xd0, 0xe8, 0xac, 0xb6, 0xa5, 0xcd, 0x83,
	0x4d, 0xc8, 0xf1, 0x56, 0x3c, 0x28, 0x40, 0x5e, 0x84, 0x26, 0xbf, 0x05, 0xa9, 0xc5, 0x5b, 0xe4,
	0xc4, 0x1d, 0x63, 0xfa, 0xcb, 0x19, 0x0d, 0xf8, 0xb8, 0xf0, 0x88, 0x4f, 0xa3, 0xb1, 0x5d, 0xc4,
	0xd1, 0x09, 0x35, 0x20, 0x73, 0xee, 0x8e, 0xa3, 0xab, 0xf1, 0x9d, 0x9b, 0x8a, 0x89, 0x19, 0x50,
	0xfe, 0x00, 0x95, 0x53, 0x33, 0x08, 0x4f, 0xdc, 0x71, 0x70, 0x9b, 0xea, 0x1d, 0xc8, 0x9f, 0x99,
	0x56, 0x48, 0xfd, 0xe8, 0x99, 0x89, 0x4e, 0x6c, 0x75, 0xf6, 0xd8, 0xcf, 0x9c, 0xd0, 0x7d, 0x4f,
	0x9d, 0xe8, 0xb7, 0x56, 0x91, 0x51, 0x34, 0x46, 0x60, 0x7b, 0x22, 0x67, 0x07, 0xe6, 0x37, 0xa2,
	0xa3, 0x73, 0xb8, 0xc0, 0x08, 0x43, 0xf3, 0x1b, 0x2a, 0x5b, 0x20, 0x2d, 0xcc, 0x07, 0x9e, 0xeb,
	0x04, 0x14, 0x7d, 0x09, 0xd9, 0x73, 0x77, 0x1c, 0x54, 0x53, 0xfc, 0xa9, 0xb9, 0x39, 0x06, 0x8e,
	0x44, 0x8f, 0xa1, 0xe2, 0xd0, 0x4b, 0x36, 0xa4, 0x12, 0x37, 0x84, 0x8b, 0xdb, 0x8c, 0x3c, 0x88,
	0x5d, 0x91, 0xf7, 0x60, 0xfb, 0x88, 0x86, 0x4b, 0x59, 0x44, 0x90, 0x5d, 0xda, 0xa3, 0xf9, 0xb7,
	0xfc, 0x18, 0xa4, 0x16, 0x71, 0x0c, 0x6a, 0xdd, 0x8c, 0xdb, 0xff, 0x7b, 0x16, 0xe0, 0xc4, 0x1d,
	0x0f, 0xc5, 0x6f, 0x75, 0xf4, 0x87, 0x14, 0x14, 0x93, 0x2a, 0xa1, 0xeb, 0xfb, 0x70, 0xbd, 0x92,
	0xb5, 0x1b, 0x03, 0x94, 0x1b, 0xbf, 0xfb, 0xf7, 0x7f, 0xfe, 0x9c, 0xae, 0xcb, 0x8f, 0x92, 0x7f,
	0x39, 0xfc, 0x5a, 0x94, 0xe3, 0xc7, 0x9e, 0xef, 0xb2, 0x75, 0x21, 0x68, 0x3e, 0xfd, 0xd0, 0x64,
	0x59, 0x78, 0xc5, 0xea, 0x89, 0xfe, 0x98, 0x82, 0x42, 0x9c, 0x51, 0x74, 0xfd, 0x1c, 0x5b, 0xab,
	0x79, 0xed, 0xc9, 0x1d, 0x90, 0xa2, 0x3c, 0xf2, 0x13, 0xee, 0xd1, 0x1e, 0xba, 0xdd, 0x23, 0x34,
	0x87, 0xbc, 0xc8, 0x37, 0xba, 0x7e, 0x48, 0xaf, 0x14, 0xe4, 0x96, 0x64, 0x7c, 0xc4, 0x34, 0x2b,
	0xc5, 0x92, 0x61, 0x6e, 0xb7, 0xf9, 0xf4, 0x03, 0xfa, 0x3d, 0x2b, 0x47, 0x5c, 0xc6, 0x9b, 0xca,
	0xb1, 0x56, 0xea, 0xda, 0xce, 0x95, 0xa1, 0xa9, 0xda, 0x5e, 0x38, 0x97, 0x5f, 0x70, 0xdb, 0xcf,
	0xe4, 0xfa, 0xad, 0xb6, 0x5f, 0x19, 0x5c, 0xe7, 0xab, 0xd4, 0xd3, 0x83, 0x97, 0xf0, 0xd0, 0x70,
	0xed, 0x2b, 0xc6, 0x89, 0x67, 0xc6, 0x0e, 0x1c, 0x54, 0x16, 0x3d, 0x34, 0x60, 0x16, 0x07, 0xa9,
	0x71, 0x9e, 0x9b, 0x7e, 0xf1, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xe8, 0x1d, 0x5c, 0x2a, 0x95,
	0x12, 0x00, 0x00,
}
