// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/genomics/v1/reads.proto
// DO NOT EDIT!

package google_genomics_v1 // import "google.golang.org/genproto/googleapis/genomics/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "google.golang.org/genproto/protobuf"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type ImportReadGroupSetsRequest_PartitionStrategy int32

const (
	ImportReadGroupSetsRequest_PARTITION_STRATEGY_UNSPECIFIED ImportReadGroupSetsRequest_PartitionStrategy = 0
	// In most cases, this strategy yields one read group set per file. This is
	// the default behavior.
	//
	// Allocate one read group set per file per sample. For BAM files, read
	// groups are considered to share a sample if they have identical sample
	// names. Furthermore, all reads for each file which do not belong to a read
	// group, if any, will be grouped into a single read group set per-file.
	ImportReadGroupSetsRequest_PER_FILE_PER_SAMPLE ImportReadGroupSetsRequest_PartitionStrategy = 1
	// Includes all read groups in all imported files into a single read group
	// set. Requires that the headers for all imported files are equivalent. All
	// reads which do not belong to a read group, if any, will be grouped into a
	// separate read group set.
	ImportReadGroupSetsRequest_MERGE_ALL ImportReadGroupSetsRequest_PartitionStrategy = 2
)

var ImportReadGroupSetsRequest_PartitionStrategy_name = map[int32]string{
	0: "PARTITION_STRATEGY_UNSPECIFIED",
	1: "PER_FILE_PER_SAMPLE",
	2: "MERGE_ALL",
}
var ImportReadGroupSetsRequest_PartitionStrategy_value = map[string]int32{
	"PARTITION_STRATEGY_UNSPECIFIED": 0,
	"PER_FILE_PER_SAMPLE":            1,
	"MERGE_ALL":                      2,
}

func (x ImportReadGroupSetsRequest_PartitionStrategy) String() string {
	return proto.EnumName(ImportReadGroupSetsRequest_PartitionStrategy_name, int32(x))
}
func (ImportReadGroupSetsRequest_PartitionStrategy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor9, []int{2, 0}
}

// The read group set search request.
type SearchReadGroupSetsRequest struct {
	// Restricts this query to read group sets within the given datasets. At least
	// one ID must be provided.
	DatasetIds []string `protobuf:"bytes,1,rep,name=dataset_ids,json=datasetIds" json:"dataset_ids,omitempty"`
	// Only return read group sets for which a substring of the name matches this
	// string.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 256. The maximum value is 1024.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *SearchReadGroupSetsRequest) Reset()                    { *m = SearchReadGroupSetsRequest{} }
func (m *SearchReadGroupSetsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchReadGroupSetsRequest) ProtoMessage()               {}
func (*SearchReadGroupSetsRequest) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{0} }

// The read group set search response.
type SearchReadGroupSetsResponse struct {
	// The list of matching read group sets.
	ReadGroupSets []*ReadGroupSet `protobuf:"bytes,1,rep,name=read_group_sets,json=readGroupSets" json:"read_group_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *SearchReadGroupSetsResponse) Reset()                    { *m = SearchReadGroupSetsResponse{} }
func (m *SearchReadGroupSetsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchReadGroupSetsResponse) ProtoMessage()               {}
func (*SearchReadGroupSetsResponse) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{1} }

func (m *SearchReadGroupSetsResponse) GetReadGroupSets() []*ReadGroupSet {
	if m != nil {
		return m.ReadGroupSets
	}
	return nil
}

// The read group set import request.
type ImportReadGroupSetsRequest struct {
	// Required. The ID of the dataset these read group sets will belong to. The
	// caller must have WRITE permissions to this dataset.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId" json:"dataset_id,omitempty"`
	// The reference set to which the imported read group sets are aligned to, if
	// any. The reference names of this reference set must be a superset of those
	// found in the imported file headers. If no reference set id is provided, a
	// best effort is made to associate with a matching reference set.
	ReferenceSetId string `protobuf:"bytes,4,opt,name=reference_set_id,json=referenceSetId" json:"reference_set_id,omitempty"`
	// A list of URIs pointing at [BAM
	// files](https://samtools.github.io/hts-specs/SAMv1.pdf)
	// in Google Cloud Storage.
	SourceUris []string `protobuf:"bytes,2,rep,name=source_uris,json=sourceUris" json:"source_uris,omitempty"`
	// The partition strategy describes how read groups are partitioned into read
	// group sets.
	PartitionStrategy ImportReadGroupSetsRequest_PartitionStrategy `protobuf:"varint,5,opt,name=partition_strategy,json=partitionStrategy,enum=google.genomics.v1.ImportReadGroupSetsRequest_PartitionStrategy" json:"partition_strategy,omitempty"`
}

func (m *ImportReadGroupSetsRequest) Reset()                    { *m = ImportReadGroupSetsRequest{} }
func (m *ImportReadGroupSetsRequest) String() string            { return proto.CompactTextString(m) }
func (*ImportReadGroupSetsRequest) ProtoMessage()               {}
func (*ImportReadGroupSetsRequest) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{2} }

// The read group set import response.
type ImportReadGroupSetsResponse struct {
	// IDs of the read group sets that were created.
	ReadGroupSetIds []string `protobuf:"bytes,1,rep,name=read_group_set_ids,json=readGroupSetIds" json:"read_group_set_ids,omitempty"`
}

func (m *ImportReadGroupSetsResponse) Reset()                    { *m = ImportReadGroupSetsResponse{} }
func (m *ImportReadGroupSetsResponse) String() string            { return proto.CompactTextString(m) }
func (*ImportReadGroupSetsResponse) ProtoMessage()               {}
func (*ImportReadGroupSetsResponse) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{3} }

// The read group set export request.
type ExportReadGroupSetRequest struct {
	// Required. The Google Developers Console project ID that owns this
	// export. The caller must have WRITE access to this project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. A Google Cloud Storage URI for the exported BAM file.
	// The currently authenticated user must have write access to the new file.
	// An error will be returned if the URI already contains data.
	ExportUri string `protobuf:"bytes,2,opt,name=export_uri,json=exportUri" json:"export_uri,omitempty"`
	// Required. The ID of the read group set to export. The caller must have
	// READ access to this read group set.
	ReadGroupSetId string `protobuf:"bytes,3,opt,name=read_group_set_id,json=readGroupSetId" json:"read_group_set_id,omitempty"`
	// The reference names to export. If this is not specified, all reference
	// sequences, including unmapped reads, are exported.
	// Use `*` to export only unmapped reads.
	ReferenceNames []string `protobuf:"bytes,4,rep,name=reference_names,json=referenceNames" json:"reference_names,omitempty"`
}

func (m *ExportReadGroupSetRequest) Reset()                    { *m = ExportReadGroupSetRequest{} }
func (m *ExportReadGroupSetRequest) String() string            { return proto.CompactTextString(m) }
func (*ExportReadGroupSetRequest) ProtoMessage()               {}
func (*ExportReadGroupSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{4} }

type UpdateReadGroupSetRequest struct {
	// The ID of the read group set to be updated. The caller must have WRITE
	// permissions to the dataset associated with this read group set.
	ReadGroupSetId string `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId" json:"read_group_set_id,omitempty"`
	// The new read group set data. See `updateMask` for details on mutability of
	// fields.
	ReadGroupSet *ReadGroupSet `protobuf:"bytes,2,opt,name=read_group_set,json=readGroupSet" json:"read_group_set,omitempty"`
	// An optional mask specifying which fields to update. Supported fields:
	//
	// * [name][google.genomics.v1.ReadGroupSet.name].
	// * [referenceSetId][google.genomics.v1.ReadGroupSet.reference_set_id].
	//
	// Leaving `updateMask` unset is equivalent to specifying all mutable
	// fields.
	UpdateMask *google_protobuf2.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateReadGroupSetRequest) Reset()                    { *m = UpdateReadGroupSetRequest{} }
func (m *UpdateReadGroupSetRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateReadGroupSetRequest) ProtoMessage()               {}
func (*UpdateReadGroupSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{5} }

func (m *UpdateReadGroupSetRequest) GetReadGroupSet() *ReadGroupSet {
	if m != nil {
		return m.ReadGroupSet
	}
	return nil
}

func (m *UpdateReadGroupSetRequest) GetUpdateMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteReadGroupSetRequest struct {
	// The ID of the read group set to be deleted. The caller must have WRITE
	// permissions to the dataset associated with this read group set.
	ReadGroupSetId string `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId" json:"read_group_set_id,omitempty"`
}

func (m *DeleteReadGroupSetRequest) Reset()                    { *m = DeleteReadGroupSetRequest{} }
func (m *DeleteReadGroupSetRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteReadGroupSetRequest) ProtoMessage()               {}
func (*DeleteReadGroupSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{6} }

type GetReadGroupSetRequest struct {
	// The ID of the read group set.
	ReadGroupSetId string `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId" json:"read_group_set_id,omitempty"`
}

func (m *GetReadGroupSetRequest) Reset()                    { *m = GetReadGroupSetRequest{} }
func (m *GetReadGroupSetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetReadGroupSetRequest) ProtoMessage()               {}
func (*GetReadGroupSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{7} }

type ListCoverageBucketsRequest struct {
	// Required. The ID of the read group set over which coverage is requested.
	ReadGroupSetId string `protobuf:"bytes,1,opt,name=read_group_set_id,json=readGroupSetId" json:"read_group_set_id,omitempty"`
	// The name of the reference to query, within the reference set associated
	// with this query. Optional.
	ReferenceName string `protobuf:"bytes,3,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified, `referenceName` must also be specified. Defaults to 0.
	Start int64 `protobuf:"varint,4,opt,name=start" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// specified, `referenceName` must also be specified. If unset or 0, defaults
	// to the length of the reference.
	End int64 `protobuf:"varint,5,opt,name=end" json:"end,omitempty"`
	// The desired width of each reported coverage bucket in base pairs. This
	// will be rounded down to the nearest precomputed bucket width; the value
	// of which is returned as `bucketWidth` in the response. Defaults
	// to infinity (each bucket spans an entire reference sequence) or the length
	// of the target range, if specified. The smallest precomputed
	// `bucketWidth` is currently 2048 base pairs; this is subject to
	// change.
	TargetBucketWidth int64 `protobuf:"varint,6,opt,name=target_bucket_width,json=targetBucketWidth" json:"target_bucket_width,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 1024. The maximum value is 2048.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *ListCoverageBucketsRequest) Reset()                    { *m = ListCoverageBucketsRequest{} }
func (m *ListCoverageBucketsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListCoverageBucketsRequest) ProtoMessage()               {}
func (*ListCoverageBucketsRequest) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{8} }

// A bucket over which read coverage has been precomputed. A bucket corresponds
// to a specific range of the reference sequence.
type CoverageBucket struct {
	// The genomic coordinate range spanned by this bucket.
	Range *Range `protobuf:"bytes,1,opt,name=range" json:"range,omitempty"`
	// The average number of reads which are aligned to each individual
	// reference base in this bucket.
	MeanCoverage float32 `protobuf:"fixed32,2,opt,name=mean_coverage,json=meanCoverage" json:"mean_coverage,omitempty"`
}

func (m *CoverageBucket) Reset()                    { *m = CoverageBucket{} }
func (m *CoverageBucket) String() string            { return proto.CompactTextString(m) }
func (*CoverageBucket) ProtoMessage()               {}
func (*CoverageBucket) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{9} }

func (m *CoverageBucket) GetRange() *Range {
	if m != nil {
		return m.Range
	}
	return nil
}

type ListCoverageBucketsResponse struct {
	// The length of each coverage bucket in base pairs. Note that buckets at the
	// end of a reference sequence may be shorter. This value is omitted if the
	// bucket width is infinity (the default behaviour, with no range or
	// `targetBucketWidth`).
	BucketWidth int64 `protobuf:"varint,1,opt,name=bucket_width,json=bucketWidth" json:"bucket_width,omitempty"`
	// The coverage buckets. The list of buckets is sparse; a bucket with 0
	// overlapping reads is not returned. A bucket never crosses more than one
	// reference sequence. Each bucket has width `bucketWidth`, unless
	// its end is the end of the reference sequence.
	CoverageBuckets []*CoverageBucket `protobuf:"bytes,2,rep,name=coverage_buckets,json=coverageBuckets" json:"coverage_buckets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListCoverageBucketsResponse) Reset()                    { *m = ListCoverageBucketsResponse{} }
func (m *ListCoverageBucketsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListCoverageBucketsResponse) ProtoMessage()               {}
func (*ListCoverageBucketsResponse) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{10} }

func (m *ListCoverageBucketsResponse) GetCoverageBuckets() []*CoverageBucket {
	if m != nil {
		return m.CoverageBuckets
	}
	return nil
}

// The read search request.
type SearchReadsRequest struct {
	// The IDs of the read groups sets within which to search for reads. All
	// specified read group sets must be aligned against a common set of reference
	// sequences; this defines the genomic coordinates for the query. Must specify
	// one of `readGroupSetIds` or `readGroupIds`.
	ReadGroupSetIds []string `protobuf:"bytes,1,rep,name=read_group_set_ids,json=readGroupSetIds" json:"read_group_set_ids,omitempty"`
	// The IDs of the read groups within which to search for reads. All specified
	// read groups must belong to the same read group sets. Must specify one of
	// `readGroupSetIds` or `readGroupIds`.
	ReadGroupIds []string `protobuf:"bytes,5,rep,name=read_group_ids,json=readGroupIds" json:"read_group_ids,omitempty"`
	// The reference sequence name, for example `chr1`, `1`, or `chrX`. If set to
	// `*`, only unmapped reads are returned. If unspecified, all reads (mapped
	// and unmapped) are returned.
	ReferenceName string `protobuf:"bytes,7,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified, `referenceName` must also be specified.
	Start int64 `protobuf:"varint,8,opt,name=start" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// specified, `referenceName` must also be specified.
	End int64 `protobuf:"varint,9,opt,name=end" json:"end,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 256. The maximum value is 2048.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *SearchReadsRequest) Reset()                    { *m = SearchReadsRequest{} }
func (m *SearchReadsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchReadsRequest) ProtoMessage()               {}
func (*SearchReadsRequest) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{11} }

// The read search response.
type SearchReadsResponse struct {
	// The list of matching alignments sorted by mapped genomic coordinate,
	// if any, ascending in position within the same reference. Unmapped reads,
	// which have no position, are returned contiguously and are sorted in
	// ascending lexicographic order by fragment name.
	Alignments []*Read `protobuf:"bytes,1,rep,name=alignments" json:"alignments,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *SearchReadsResponse) Reset()                    { *m = SearchReadsResponse{} }
func (m *SearchReadsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchReadsResponse) ProtoMessage()               {}
func (*SearchReadsResponse) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{12} }

func (m *SearchReadsResponse) GetAlignments() []*Read {
	if m != nil {
		return m.Alignments
	}
	return nil
}

// The stream reads request.
type StreamReadsRequest struct {
	// The Google Developers Console project ID or number which will be billed
	// for this access. The caller must have WRITE access to this project.
	// Required.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The ID of the read group set from which to stream reads.
	ReadGroupSetId string `protobuf:"bytes,2,opt,name=read_group_set_id,json=readGroupSetId" json:"read_group_set_id,omitempty"`
	// The reference sequence name, for example `chr1`,
	// `1`, or `chrX`. If set to *, only unmapped reads are
	// returned.
	ReferenceName string `protobuf:"bytes,3,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified, `referenceName` must also be specified.
	Start int64 `protobuf:"varint,4,opt,name=start" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// specified, `referenceName` must also be specified.
	End int64 `protobuf:"varint,5,opt,name=end" json:"end,omitempty"`
	// Restricts results to a shard containing approximately `1/totalShards`
	// of the normal response payload for this query. Results from a sharded
	// request are disjoint from those returned by all queries which differ only
	// in their shard parameter. A shard may yield 0 results; this is especially
	// likely for large values of `totalShards`.
	//
	// Valid values are `[0, totalShards)`.
	Shard int32 `protobuf:"varint,6,opt,name=shard" json:"shard,omitempty"`
	// Specifying `totalShards` causes a disjoint subset of the normal response
	// payload to be returned for each query with a unique `shard` parameter
	// specified. A best effort is made to yield equally sized shards. Sharding
	// can be used to distribute processing amongst workers, where each worker is
	// assigned a unique `shard` number and all workers specify the same
	// `totalShards` number. The union of reads returned for all sharded queries
	// `[0, totalShards)` is equal to those returned by a single unsharded query.
	//
	// Queries for different values of `totalShards` with common divisors will
	// share shard boundaries. For example, streaming `shard` 2 of 5
	// `totalShards` yields the same results as streaming `shard`s 4 and 5 of 10
	// `totalShards`. This property can be leveraged for adaptive retries.
	TotalShards int32 `protobuf:"varint,7,opt,name=total_shards,json=totalShards" json:"total_shards,omitempty"`
}

func (m *StreamReadsRequest) Reset()                    { *m = StreamReadsRequest{} }
func (m *StreamReadsRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamReadsRequest) ProtoMessage()               {}
func (*StreamReadsRequest) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{13} }

type StreamReadsResponse struct {
	Alignments []*Read `protobuf:"bytes,1,rep,name=alignments" json:"alignments,omitempty"`
}

func (m *StreamReadsResponse) Reset()                    { *m = StreamReadsResponse{} }
func (m *StreamReadsResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamReadsResponse) ProtoMessage()               {}
func (*StreamReadsResponse) Descriptor() ([]byte, []int) { return fileDescriptor9, []int{14} }

func (m *StreamReadsResponse) GetAlignments() []*Read {
	if m != nil {
		return m.Alignments
	}
	return nil
}

func init() {
	proto.RegisterType((*SearchReadGroupSetsRequest)(nil), "google.genomics.v1.SearchReadGroupSetsRequest")
	proto.RegisterType((*SearchReadGroupSetsResponse)(nil), "google.genomics.v1.SearchReadGroupSetsResponse")
	proto.RegisterType((*ImportReadGroupSetsRequest)(nil), "google.genomics.v1.ImportReadGroupSetsRequest")
	proto.RegisterType((*ImportReadGroupSetsResponse)(nil), "google.genomics.v1.ImportReadGroupSetsResponse")
	proto.RegisterType((*ExportReadGroupSetRequest)(nil), "google.genomics.v1.ExportReadGroupSetRequest")
	proto.RegisterType((*UpdateReadGroupSetRequest)(nil), "google.genomics.v1.UpdateReadGroupSetRequest")
	proto.RegisterType((*DeleteReadGroupSetRequest)(nil), "google.genomics.v1.DeleteReadGroupSetRequest")
	proto.RegisterType((*GetReadGroupSetRequest)(nil), "google.genomics.v1.GetReadGroupSetRequest")
	proto.RegisterType((*ListCoverageBucketsRequest)(nil), "google.genomics.v1.ListCoverageBucketsRequest")
	proto.RegisterType((*CoverageBucket)(nil), "google.genomics.v1.CoverageBucket")
	proto.RegisterType((*ListCoverageBucketsResponse)(nil), "google.genomics.v1.ListCoverageBucketsResponse")
	proto.RegisterType((*SearchReadsRequest)(nil), "google.genomics.v1.SearchReadsRequest")
	proto.RegisterType((*SearchReadsResponse)(nil), "google.genomics.v1.SearchReadsResponse")
	proto.RegisterType((*StreamReadsRequest)(nil), "google.genomics.v1.StreamReadsRequest")
	proto.RegisterType((*StreamReadsResponse)(nil), "google.genomics.v1.StreamReadsResponse")
	proto.RegisterEnum("google.genomics.v1.ImportReadGroupSetsRequest_PartitionStrategy", ImportReadGroupSetsRequest_PartitionStrategy_name, ImportReadGroupSetsRequest_PartitionStrategy_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for StreamingReadService service

type StreamingReadServiceClient interface {
	// Returns a stream of all the reads matching the search request, ordered
	// by reference name, position, and ID.
	StreamReads(ctx context.Context, in *StreamReadsRequest, opts ...grpc.CallOption) (StreamingReadService_StreamReadsClient, error)
}

type streamingReadServiceClient struct {
	cc *grpc.ClientConn
}

func NewStreamingReadServiceClient(cc *grpc.ClientConn) StreamingReadServiceClient {
	return &streamingReadServiceClient{cc}
}

func (c *streamingReadServiceClient) StreamReads(ctx context.Context, in *StreamReadsRequest, opts ...grpc.CallOption) (StreamingReadService_StreamReadsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_StreamingReadService_serviceDesc.Streams[0], c.cc, "/google.genomics.v1.StreamingReadService/StreamReads", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingReadServiceStreamReadsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type StreamingReadService_StreamReadsClient interface {
	Recv() (*StreamReadsResponse, error)
	grpc.ClientStream
}

type streamingReadServiceStreamReadsClient struct {
	grpc.ClientStream
}

func (x *streamingReadServiceStreamReadsClient) Recv() (*StreamReadsResponse, error) {
	m := new(StreamReadsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for StreamingReadService service

type StreamingReadServiceServer interface {
	// Returns a stream of all the reads matching the search request, ordered
	// by reference name, position, and ID.
	StreamReads(*StreamReadsRequest, StreamingReadService_StreamReadsServer) error
}

func RegisterStreamingReadServiceServer(s *grpc.Server, srv StreamingReadServiceServer) {
	s.RegisterService(&_StreamingReadService_serviceDesc, srv)
}

func _StreamingReadService_StreamReads_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamReadsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StreamingReadServiceServer).StreamReads(m, &streamingReadServiceStreamReadsServer{stream})
}

type StreamingReadService_StreamReadsServer interface {
	Send(*StreamReadsResponse) error
	grpc.ServerStream
}

type streamingReadServiceStreamReadsServer struct {
	grpc.ServerStream
}

func (x *streamingReadServiceStreamReadsServer) Send(m *StreamReadsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _StreamingReadService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.StreamingReadService",
	HandlerType: (*StreamingReadServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamReads",
			Handler:       _StreamingReadService_StreamReads_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google.golang.org/genproto/googleapis/genomics/v1/reads.proto",
}

// Client API for ReadServiceV1 service

type ReadServiceV1Client interface {
	// Creates read group sets by asynchronously importing the provided
	// information.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The caller must have WRITE permissions to the dataset.
	//
	// ## Notes on [BAM](https://samtools.github.io/hts-specs/SAMv1.pdf) import
	//
	// - Tags will be converted to strings - tag types are not preserved
	// - Comments (`@CO`) in the input file header will not be preserved
	// - Original header order of references (`@SQ`) will not be preserved
	// - Any reverse stranded unmapped reads will be reverse complemented, and
	// their qualities (also the "BQ" and "OQ" tags, if any) will be reversed
	// - Unmapped reads will be stripped of positional information (reference name
	// and position)
	ImportReadGroupSets(ctx context.Context, in *ImportReadGroupSetsRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Exports a read group set to a BAM file in Google Cloud Storage.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Note that currently there may be some differences between exported BAM
	// files and the original BAM file at the time of import. See
	// [ImportReadGroupSets][google.genomics.v1.ReadServiceV1.ImportReadGroupSets]
	// for caveats.
	ExportReadGroupSet(ctx context.Context, in *ExportReadGroupSetRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Searches for read group sets matching the criteria.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchReadGroupSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L135).
	SearchReadGroupSets(ctx context.Context, in *SearchReadGroupSetsRequest, opts ...grpc.CallOption) (*SearchReadGroupSetsResponse, error)
	// Updates a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateReadGroupSet(ctx context.Context, in *UpdateReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error)
	// Deletes a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteReadGroupSet(ctx context.Context, in *DeleteReadGroupSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Gets a read group set by ID.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetReadGroupSet(ctx context.Context, in *GetReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error)
	// Lists fixed width coverage buckets for a read group set, each of which
	// correspond to a range of a reference sequence. Each bucket summarizes
	// coverage information across its corresponding genomic range.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Coverage is defined as the number of reads which are aligned to a given
	// base in the reference sequence. Coverage buckets are available at several
	// precomputed bucket widths, enabling retrieval of various coverage 'zoom
	// levels'. The caller must have READ permissions for the target read group
	// set.
	ListCoverageBuckets(ctx context.Context, in *ListCoverageBucketsRequest, opts ...grpc.CallOption) (*ListCoverageBucketsResponse, error)
	// Gets a list of reads for one or more read group sets.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Reads search operates over a genomic coordinate space of reference sequence
	// & position defined over the reference sequences to which the requested
	// read group sets are aligned.
	//
	// If a target positional range is specified, search returns all reads whose
	// alignment to the reference genome overlap the range. A query which
	// specifies only read group set IDs yields all reads in those read group
	// sets, including unmapped reads.
	//
	// All reads returned (including reads on subsequent pages) are ordered by
	// genomic coordinate (by reference sequence, then position). Reads with
	// equivalent genomic coordinates are returned in an unspecified order. This
	// order is consistent, such that two queries for the same content (regardless
	// of page size) yield reads in the same order across their respective streams
	// of paginated responses.
	//
	// Implements
	// [GlobalAllianceApi.searchReads](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L85).
	SearchReads(ctx context.Context, in *SearchReadsRequest, opts ...grpc.CallOption) (*SearchReadsResponse, error)
}

type readServiceV1Client struct {
	cc *grpc.ClientConn
}

func NewReadServiceV1Client(cc *grpc.ClientConn) ReadServiceV1Client {
	return &readServiceV1Client{cc}
}

func (c *readServiceV1Client) ImportReadGroupSets(ctx context.Context, in *ImportReadGroupSetsRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/ImportReadGroupSets", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) ExportReadGroupSet(ctx context.Context, in *ExportReadGroupSetRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/ExportReadGroupSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) SearchReadGroupSets(ctx context.Context, in *SearchReadGroupSetsRequest, opts ...grpc.CallOption) (*SearchReadGroupSetsResponse, error) {
	out := new(SearchReadGroupSetsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/SearchReadGroupSets", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) UpdateReadGroupSet(ctx context.Context, in *UpdateReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error) {
	out := new(ReadGroupSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/UpdateReadGroupSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) DeleteReadGroupSet(ctx context.Context, in *DeleteReadGroupSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/DeleteReadGroupSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) GetReadGroupSet(ctx context.Context, in *GetReadGroupSetRequest, opts ...grpc.CallOption) (*ReadGroupSet, error) {
	out := new(ReadGroupSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/GetReadGroupSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) ListCoverageBuckets(ctx context.Context, in *ListCoverageBucketsRequest, opts ...grpc.CallOption) (*ListCoverageBucketsResponse, error) {
	out := new(ListCoverageBucketsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/ListCoverageBuckets", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *readServiceV1Client) SearchReads(ctx context.Context, in *SearchReadsRequest, opts ...grpc.CallOption) (*SearchReadsResponse, error) {
	out := new(SearchReadsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.ReadServiceV1/SearchReads", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ReadServiceV1 service

type ReadServiceV1Server interface {
	// Creates read group sets by asynchronously importing the provided
	// information.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The caller must have WRITE permissions to the dataset.
	//
	// ## Notes on [BAM](https://samtools.github.io/hts-specs/SAMv1.pdf) import
	//
	// - Tags will be converted to strings - tag types are not preserved
	// - Comments (`@CO`) in the input file header will not be preserved
	// - Original header order of references (`@SQ`) will not be preserved
	// - Any reverse stranded unmapped reads will be reverse complemented, and
	// their qualities (also the "BQ" and "OQ" tags, if any) will be reversed
	// - Unmapped reads will be stripped of positional information (reference name
	// and position)
	ImportReadGroupSets(context.Context, *ImportReadGroupSetsRequest) (*google_longrunning.Operation, error)
	// Exports a read group set to a BAM file in Google Cloud Storage.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Note that currently there may be some differences between exported BAM
	// files and the original BAM file at the time of import. See
	// [ImportReadGroupSets][google.genomics.v1.ReadServiceV1.ImportReadGroupSets]
	// for caveats.
	ExportReadGroupSet(context.Context, *ExportReadGroupSetRequest) (*google_longrunning.Operation, error)
	// Searches for read group sets matching the criteria.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchReadGroupSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L135).
	SearchReadGroupSets(context.Context, *SearchReadGroupSetsRequest) (*SearchReadGroupSetsResponse, error)
	// Updates a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateReadGroupSet(context.Context, *UpdateReadGroupSetRequest) (*ReadGroupSet, error)
	// Deletes a read group set.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteReadGroupSet(context.Context, *DeleteReadGroupSetRequest) (*google_protobuf1.Empty, error)
	// Gets a read group set by ID.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetReadGroupSet(context.Context, *GetReadGroupSetRequest) (*ReadGroupSet, error)
	// Lists fixed width coverage buckets for a read group set, each of which
	// correspond to a range of a reference sequence. Each bucket summarizes
	// coverage information across its corresponding genomic range.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Coverage is defined as the number of reads which are aligned to a given
	// base in the reference sequence. Coverage buckets are available at several
	// precomputed bucket widths, enabling retrieval of various coverage 'zoom
	// levels'. The caller must have READ permissions for the target read group
	// set.
	ListCoverageBuckets(context.Context, *ListCoverageBucketsRequest) (*ListCoverageBucketsResponse, error)
	// Gets a list of reads for one or more read group sets.
	//
	// For the definitions of read group sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Reads search operates over a genomic coordinate space of reference sequence
	// & position defined over the reference sequences to which the requested
	// read group sets are aligned.
	//
	// If a target positional range is specified, search returns all reads whose
	// alignment to the reference genome overlap the range. A query which
	// specifies only read group set IDs yields all reads in those read group
	// sets, including unmapped reads.
	//
	// All reads returned (including reads on subsequent pages) are ordered by
	// genomic coordinate (by reference sequence, then position). Reads with
	// equivalent genomic coordinates are returned in an unspecified order. This
	// order is consistent, such that two queries for the same content (regardless
	// of page size) yield reads in the same order across their respective streams
	// of paginated responses.
	//
	// Implements
	// [GlobalAllianceApi.searchReads](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L85).
	SearchReads(context.Context, *SearchReadsRequest) (*SearchReadsResponse, error)
}

func RegisterReadServiceV1Server(s *grpc.Server, srv ReadServiceV1Server) {
	s.RegisterService(&_ReadServiceV1_serviceDesc, srv)
}

func _ReadServiceV1_ImportReadGroupSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportReadGroupSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).ImportReadGroupSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/ImportReadGroupSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).ImportReadGroupSets(ctx, req.(*ImportReadGroupSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_ExportReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).ExportReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/ExportReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).ExportReadGroupSet(ctx, req.(*ExportReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_SearchReadGroupSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchReadGroupSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).SearchReadGroupSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/SearchReadGroupSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).SearchReadGroupSets(ctx, req.(*SearchReadGroupSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_UpdateReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).UpdateReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/UpdateReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).UpdateReadGroupSet(ctx, req.(*UpdateReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_DeleteReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).DeleteReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/DeleteReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).DeleteReadGroupSet(ctx, req.(*DeleteReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_GetReadGroupSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReadGroupSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).GetReadGroupSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/GetReadGroupSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).GetReadGroupSet(ctx, req.(*GetReadGroupSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_ListCoverageBuckets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCoverageBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).ListCoverageBuckets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/ListCoverageBuckets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).ListCoverageBuckets(ctx, req.(*ListCoverageBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReadServiceV1_SearchReads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchReadsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReadServiceV1Server).SearchReads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.ReadServiceV1/SearchReads",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReadServiceV1Server).SearchReads(ctx, req.(*SearchReadsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReadServiceV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.ReadServiceV1",
	HandlerType: (*ReadServiceV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ImportReadGroupSets",
			Handler:    _ReadServiceV1_ImportReadGroupSets_Handler,
		},
		{
			MethodName: "ExportReadGroupSet",
			Handler:    _ReadServiceV1_ExportReadGroupSet_Handler,
		},
		{
			MethodName: "SearchReadGroupSets",
			Handler:    _ReadServiceV1_SearchReadGroupSets_Handler,
		},
		{
			MethodName: "UpdateReadGroupSet",
			Handler:    _ReadServiceV1_UpdateReadGroupSet_Handler,
		},
		{
			MethodName: "DeleteReadGroupSet",
			Handler:    _ReadServiceV1_DeleteReadGroupSet_Handler,
		},
		{
			MethodName: "GetReadGroupSet",
			Handler:    _ReadServiceV1_GetReadGroupSet_Handler,
		},
		{
			MethodName: "ListCoverageBuckets",
			Handler:    _ReadServiceV1_ListCoverageBuckets_Handler,
		},
		{
			MethodName: "SearchReads",
			Handler:    _ReadServiceV1_SearchReads_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/genomics/v1/reads.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/genomics/v1/reads.proto", fileDescriptor9)
}

var fileDescriptor9 = []byte{
	// 1358 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xbc, 0x57, 0xcf, 0x6f, 0x1b, 0xc5,
	0x17, 0xff, 0x8e, 0x1d, 0xb7, 0xcd, 0x73, 0x93, 0x38, 0xe3, 0x7e, 0x8b, 0xe3, 0x28, 0x34, 0x6c,
	0x69, 0x9b, 0x06, 0xea, 0x25, 0x2e, 0xa8, 0x28, 0xa8, 0x12, 0x49, 0xeb, 0x04, 0xa3, 0xa4, 0xb5,
	0xd6, 0x09, 0x88, 0xd3, 0x6a, 0xe2, 0x9d, 0x6c, 0x96, 0xd8, 0xbb, 0xcb, 0xce, 0x38, 0xfd, 0xa5,
	0x5e, 0x7a, 0x03, 0x09, 0x38, 0x20, 0x4e, 0x5c, 0xb9, 0x72, 0x44, 0xfc, 0x11, 0x9c, 0x10, 0x17,
	0xfe, 0x00, 0xc4, 0x1f, 0xc0, 0x89, 0x23, 0x9a, 0xd9, 0xdd, 0x78, 0xd7, 0x3b, 0x4e, 0x9c, 0x56,
	0xe2, 0x12, 0x79, 0xdf, 0xbc, 0xf9, 0xcc, 0xe7, 0xfd, 0x7e, 0x81, 0xbb, 0xb6, 0xe7, 0xd9, 0x5d,
	0x5a, 0xb3, 0xbd, 0x2e, 0x71, 0xed, 0x9a, 0x17, 0xd8, 0xba, 0x4d, 0x5d, 0x3f, 0xf0, 0xb8, 0xa7,
	0x87, 0x47, 0xc4, 0x77, 0x98, 0x90, 0x79, 0x3d, 0xa7, 0xc3, 0xf4, 0xa3, 0x15, 0x3d, 0xa0, 0xc4,
	0x62, 0x35, 0xa9, 0x82, 0x71, 0x7c, 0x3d, 0x3a, 0xaf, 0x1d, 0xad, 0x54, 0x9b, 0xe3, 0x41, 0x12,
	0xdf, 0xd1, 0x19, 0x0d, 0x8e, 0x9c, 0x0e, 0xed, 0x78, 0xee, 0xbe, 0x63, 0xeb, 0xc4, 0x75, 0x3d,
	0x4e, 0xb8, 0xe3, 0xb9, 0x11, 0x7c, 0xf5, 0x65, 0xd8, 0x11, 0xd7, 0xa6, 0xd1, 0xf5, 0xc6, 0xcb,
	0x19, 0x47, 0xba, 0x8e, 0xed, 0xf6, 0xa8, 0xcb, 0x23, 0x98, 0xfb, 0x2f, 0x07, 0x63, 0x07, 0x5e,
	0xdf, 0x67, 0x34, 0x46, 0x59, 0x1f, 0x0f, 0xa5, 0xeb, 0xb9, 0x76, 0xd0, 0x77, 0x5d, 0xc7, 0xb5,
	0x75, 0xcf, 0xa7, 0x41, 0xca, 0x1f, 0xb7, 0x6d, 0x87, 0x1f, 0xf4, 0xf7, 0x6a, 0x1d, 0xaf, 0xa7,
	0x87, 0x38, 0xba, 0x3c, 0xd8, 0xeb, 0xef, 0xeb, 0x3e, 0x7f, 0xe2, 0x53, 0xa6, 0xd3, 0x9e, 0xcf,
	0x9f, 0x84, 0x7f, 0xa3, 0x4b, 0xef, 0x9e, 0xf0, 0xf0, 0xf1, 0xed, 0x7d, 0x87, 0x76, 0x2d, 0xb3,
	0x47, 0xd8, 0x61, 0x78, 0x4b, 0xfb, 0x1a, 0x41, 0xb5, 0x4d, 0x49, 0xd0, 0x39, 0x30, 0x28, 0xb1,
	0x36, 0x85, 0x2d, 0x6d, 0xca, 0x99, 0x41, 0xbf, 0xe8, 0x53, 0xc6, 0xf1, 0x15, 0x28, 0x5a, 0x84,
	0x13, 0x46, 0xb9, 0xe9, 0x58, 0xac, 0x82, 0x16, 0xf3, 0x4b, 0x93, 0x06, 0x44, 0xa2, 0xa6, 0xc5,
	0x30, 0x86, 0x09, 0x97, 0xf4, 0x68, 0x25, 0xbf, 0x88, 0x96, 0x26, 0x0d, 0xf9, 0x1b, 0x2f, 0x00,
	0xf8, 0xc4, 0xa6, 0x26, 0xf7, 0x0e, 0xa9, 0x5b, 0xc9, 0xc9, 0x93, 0x49, 0x21, 0xd9, 0x11, 0x02,
	0x3c, 0x0f, 0xf2, 0xc3, 0x64, 0xce, 0x53, 0x5a, 0x99, 0x58, 0x44, 0x4b, 0x05, 0xe3, 0x82, 0x10,
	0xb4, 0x9d, 0xa7, 0x54, 0xfb, 0x16, 0xc1, 0xbc, 0x92, 0x0f, 0xf3, 0x3d, 0x97, 0x51, 0xfc, 0x11,
	0xcc, 0x08, 0xa7, 0x9b, 0xd2, 0xeb, 0x26, 0xa3, 0x3c, 0x24, 0x55, 0xac, 0x2f, 0xd6, 0xb2, 0x39,
	0x5a, 0x4b, 0x62, 0x18, 0x53, 0x41, 0x12, 0x11, 0x5f, 0x87, 0x19, 0x97, 0x3e, 0xe6, 0x66, 0x86,
	0xea, 0x94, 0x10, 0xb7, 0x62, 0xba, 0xda, 0x1f, 0x39, 0xa8, 0x36, 0x7b, 0xbe, 0x17, 0x70, 0xa5,
	0x87, 0x16, 0x00, 0x06, 0x1e, 0xaa, 0xa0, 0xd0, 0xd8, 0x63, 0x07, 0xe1, 0x25, 0x28, 0x05, 0x74,
	0x9f, 0x06, 0xd4, 0xed, 0x50, 0x33, 0x52, 0x9a, 0x90, 0x4a, 0xd3, 0xc7, 0xf2, 0xb6, 0xd4, 0xbc,
	0x02, 0x45, 0xe6, 0xf5, 0x83, 0x0e, 0x35, 0xfb, 0x81, 0xc3, 0x2a, 0xb9, 0xd0, 0xd5, 0xa1, 0x68,
	0x37, 0x70, 0x18, 0xf6, 0x00, 0xfb, 0x24, 0xe0, 0x8e, 0xc8, 0x14, 0x93, 0xf1, 0x80, 0x70, 0x6a,
	0x3f, 0xa9, 0x14, 0x16, 0xd1, 0xd2, 0x74, 0xfd, 0x43, 0x95, 0xf5, 0xa3, 0x59, 0xd7, 0x5a, 0x31,
	0x50, 0x3b, 0xc2, 0x31, 0x66, 0xfd, 0x61, 0x91, 0x66, 0xc2, 0x6c, 0x46, 0x0f, 0x6b, 0xf0, 0x7a,
	0x6b, 0xcd, 0xd8, 0x69, 0xee, 0x34, 0x1f, 0x3e, 0x30, 0xdb, 0x3b, 0xc6, 0xda, 0x4e, 0x63, 0xf3,
	0x33, 0x73, 0xf7, 0x41, 0xbb, 0xd5, 0xb8, 0xd7, 0xdc, 0x68, 0x36, 0xee, 0x97, 0xfe, 0x87, 0x5f,
	0x83, 0x72, 0xab, 0x61, 0x98, 0x1b, 0xcd, 0xad, 0x86, 0x29, 0x7e, 0xb4, 0xd7, 0xb6, 0x5b, 0x5b,
	0x8d, 0x12, 0xc2, 0x53, 0x30, 0xb9, 0xdd, 0x30, 0x36, 0x1b, 0xe6, 0xda, 0xd6, 0x56, 0x29, 0xa7,
	0x7d, 0x0c, 0xf3, 0x4a, 0x8e, 0x51, 0xac, 0xdf, 0x02, 0x9c, 0x8e, 0x75, 0x22, 0x07, 0x67, 0x92,
	0xc1, 0x6c, 0x5a, 0x4c, 0xfb, 0x09, 0xc1, 0x5c, 0xe3, 0xf1, 0x30, 0x58, 0x22, 0x4a, 0x7e, 0xe0,
	0x7d, 0x4e, 0x3b, 0xc9, 0x28, 0x45, 0x92, 0xa6, 0x25, 0x8e, 0xa9, 0xbc, 0x2b, 0x7c, 0x1f, 0x67,
	0x6c, 0x28, 0xd9, 0x0d, 0x1c, 0x7c, 0x13, 0x66, 0x33, 0x44, 0xa2, 0x8c, 0x9f, 0x4e, 0xf3, 0xc0,
	0x37, 0x44, 0x7e, 0xc6, 0xf1, 0x16, 0xd5, 0xc0, 0x2a, 0x13, 0x92, 0xf0, 0x20, 0xdc, 0x0f, 0x84,
	0x54, 0xfb, 0x15, 0xc1, 0xdc, 0xae, 0x6f, 0x11, 0x4e, 0x55, 0x7c, 0x95, 0x2f, 0x22, 0xe5, 0x8b,
	0x1b, 0x30, 0x9d, 0x56, 0x95, 0xfc, 0xc7, 0x29, 0x88, 0x8b, 0x49, 0x24, 0xfc, 0x01, 0x14, 0xfb,
	0x92, 0x8f, 0x6c, 0x0f, 0xd2, 0xbc, 0x62, 0xbd, 0x1a, 0x83, 0xc4, 0x1d, 0xa4, 0xb6, 0x21, 0x3a,
	0xc8, 0x36, 0x61, 0x87, 0x06, 0x84, 0xea, 0xe2, 0xb7, 0xb6, 0x01, 0x73, 0xf7, 0x69, 0x97, 0xbe,
	0xaa, 0x31, 0xda, 0x3d, 0xb8, 0xbc, 0x49, 0xf9, 0x2b, 0x82, 0xbc, 0xc8, 0x41, 0x75, 0xcb, 0x61,
	0xfc, 0x9e, 0x77, 0x44, 0x03, 0x62, 0xd3, 0xf5, 0x7e, 0xe7, 0x30, 0x51, 0xb1, 0x67, 0xf0, 0xed,
	0x35, 0x98, 0x4e, 0x47, 0x33, 0x8a, 0xfa, 0x54, 0x2a, 0x98, 0xf8, 0x12, 0x14, 0x18, 0x27, 0x01,
	0x97, 0x95, 0x9d, 0x37, 0xc2, 0x0f, 0x5c, 0x82, 0x3c, 0x75, 0x2d, 0x59, 0xa0, 0x79, 0x43, 0xfc,
	0xc4, 0x35, 0x28, 0x73, 0x12, 0xd8, 0x94, 0x9b, 0x7b, 0x92, 0x92, 0xf9, 0xc8, 0xb1, 0xf8, 0x41,
	0xe5, 0x9c, 0xd4, 0x98, 0x0d, 0x8f, 0x42, 0xb2, 0x9f, 0x8a, 0x83, 0xa1, 0x46, 0x7a, 0xfe, 0xc4,
	0x46, 0x7a, 0x61, 0xa8, 0x91, 0xee, 0xc3, 0x74, 0xda, 0x7e, 0xac, 0x43, 0x41, 0x4e, 0x4d, 0x69,
	0x6b, 0xb1, 0x3e, 0xa7, 0xcc, 0x0f, 0xa1, 0x60, 0x84, 0x7a, 0xf8, 0x2a, 0x4c, 0xf5, 0x28, 0x71,
	0xcd, 0x4e, 0x84, 0x23, 0x13, 0x2b, 0x67, 0x5c, 0x14, 0xc2, 0x18, 0x5b, 0xfb, 0x05, 0xc1, 0xbc,
	0xd2, 0xd9, 0x51, 0x11, 0xbf, 0x01, 0x17, 0x53, 0xc6, 0x22, 0x69, 0x6c, 0x71, 0x2f, 0x61, 0xe6,
	0x36, 0x94, 0xe2, 0x27, 0x22, 0xc7, 0x84, 0xed, 0xaf, 0x58, 0xd7, 0x54, 0x1c, 0xd3, 0x2f, 0x19,
	0x33, 0x9d, 0xf4, 0xcb, 0xaa, 0xc6, 0x9e, 0x57, 0x35, 0xf6, 0xbf, 0x11, 0xe0, 0xc1, 0xa8, 0x39,
	0x4e, 0x8f, 0xb3, 0x74, 0x1d, 0xfc, 0x66, 0xaa, 0xf8, 0x84, 0x62, 0x41, 0x2a, 0x0e, 0x4a, 0x4b,
	0x68, 0x65, 0xd3, 0xe8, 0xfc, 0x89, 0x69, 0x74, 0x41, 0x91, 0x46, 0x93, 0x83, 0x34, 0x4a, 0xa7,
	0x45, 0xfe, 0x4c, 0xf3, 0xf5, 0x11, 0x94, 0x53, 0x36, 0x47, 0x51, 0x7a, 0x1f, 0xe0, 0x78, 0x1d,
	0x8a, 0x27, 0x6a, 0x65, 0x54, 0x03, 0x31, 0x12, 0xba, 0x63, 0x8f, 0xd1, 0xbf, 0x84, 0xb7, 0x79,
	0x40, 0x49, 0x2f, 0xe5, 0xed, 0x53, 0x1a, 0xb3, 0xb2, 0x56, 0x73, 0xff, 0x45, 0xad, 0x0a, 0xbd,
	0x03, 0x12, 0x58, 0xb2, 0x3a, 0x0b, 0x46, 0xf8, 0x21, 0xb2, 0x99, 0x7b, 0x9c, 0x74, 0x4d, 0xf9,
	0xc9, 0x64, 0x1c, 0x0b, 0x46, 0x51, 0xca, 0xda, 0x52, 0xa4, 0x3d, 0x84, 0x72, 0xca, 0xce, 0x57,
	0xf5, 0x70, 0xfd, 0x7b, 0x04, 0x97, 0x42, 0x44, 0xc7, 0xb5, 0xc5, 0x69, 0x3b, 0x5c, 0xa7, 0xf1,
	0x73, 0x28, 0x26, 0x5e, 0xc2, 0xd7, 0x55, 0x68, 0x59, 0x97, 0x57, 0x6f, 0x9c, 0xaa, 0x17, 0x52,
	0xd6, 0xe6, 0x5f, 0xfc, 0xfe, 0xe7, 0x77, 0xb9, 0xff, 0x6b, 0xa5, 0xe3, 0x7f, 0x07, 0x56, 0x99,
	0x54, 0x5b, 0x45, 0xcb, 0xef, 0xa0, 0xfa, 0x6f, 0x93, 0x30, 0x95, 0xa0, 0xf3, 0xc9, 0x0a, 0xfe,
	0x12, 0x41, 0x59, 0x31, 0xd0, 0x71, 0xed, 0x6c, 0xdb, 0x49, 0x75, 0x21, 0xd6, 0x4f, 0x6c, 0xc9,
	0xb5, 0x87, 0xf1, 0x96, 0xac, 0x5d, 0x95, 0xbc, 0x16, 0xb4, 0xca, 0xf0, 0x0a, 0xce, 0x56, 0x1d,
	0x09, 0xba, 0x8a, 0x96, 0xf1, 0x0f, 0x08, 0x70, 0x76, 0x1f, 0xc0, 0xb7, 0x54, 0x54, 0x46, 0xee,
	0x0d, 0xa7, 0x31, 0xb9, 0x23, 0x99, 0xac, 0x68, 0x6f, 0x67, 0x98, 0xe8, 0xcf, 0x32, 0x79, 0xfb,
	0x7c, 0x35, 0xdc, 0x28, 0x22, 0x76, 0x65, 0xc5, 0x9a, 0xab, 0xf6, 0xd4, 0xe8, 0xfd, 0xbc, 0xaa,
	0x8f, 0xad, 0x1f, 0xc5, 0x74, 0xb4, 0xef, 0x74, 0x26, 0xaf, 0x09, 0x76, 0x3f, 0x22, 0xc0, 0xd9,
	0xdd, 0x44, 0xed, 0xbb, 0x91, 0x3b, 0x4c, 0xf5, 0xd4, 0x05, 0x44, 0xbb, 0x2b, 0xc9, 0xdc, 0xa9,
	0x5f, 0x1b, 0xcf, 0x7d, 0x43, 0x7b, 0x0e, 0xfe, 0x0a, 0x01, 0xce, 0x6e, 0x1d, 0x6a, 0x9a, 0x23,
	0xb7, 0x93, 0xea, 0xe5, 0xcc, 0x8a, 0xd3, 0x10, 0xff, 0x55, 0x69, 0xb7, 0x24, 0xb9, 0x1b, 0xcb,
	0xe3, 0x91, 0xc3, 0xdf, 0x20, 0x98, 0x19, 0x5a, 0x5d, 0xf0, 0xb2, 0x8a, 0x89, 0x7a, 0xbf, 0x19,
	0xc3, 0x5b, 0x11, 0x21, 0x3c, 0x26, 0xa1, 0x9f, 0x11, 0x94, 0x15, 0x83, 0x59, 0x9d, 0x62, 0xa3,
	0xd7, 0x25, 0x75, 0x8a, 0x9d, 0x30, 0xf1, 0xe3, 0xa8, 0xe2, 0xf7, 0xc6, 0xe2, 0xa9, 0xc7, 0xe3,
	0x3b, 0x9a, 0xfc, 0xf8, 0x19, 0x14, 0x13, 0x13, 0x6a, 0x44, 0x57, 0xcb, 0x8c, 0xed, 0x11, 0x5d,
	0x2d, 0x3b, 0xea, 0x14, 0x5d, 0x6d, 0x90, 0xf9, 0xeb, 0x37, 0xe1, 0x72, 0xc7, 0xeb, 0x29, 0xa0,
	0xd6, 0x41, 0xa2, 0xb4, 0x44, 0x8e, 0xb4, 0xd0, 0x3f, 0x08, 0xed, 0x9d, 0x93, 0xf9, 0x72, 0xfb,
	0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x77, 0xa2, 0x5d, 0x97, 0x5b, 0x11, 0x00, 0x00,
}
