// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/logging/v2/logging.proto
// DO NOT EDIT!

package v2 // import "google.golang.org/genproto/googleapis/logging/v2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_api3 "google.golang.org/genproto/googleapis/api/monitoredres"
import _ "github.com/golang/protobuf/ptypes/duration"
import google_protobuf5 "github.com/golang/protobuf/ptypes/empty"
import _ "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The parameters to DeleteLog.
type DeleteLogRequest struct {
	// Required. The resource name of the log to delete.  Example:
	// `"projects/my-project/logs/syslog"`.
	LogName string `protobuf:"bytes,1,opt,name=log_name,json=logName" json:"log_name,omitempty"`
}

func (m *DeleteLogRequest) Reset()                    { *m = DeleteLogRequest{} }
func (m *DeleteLogRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteLogRequest) ProtoMessage()               {}
func (*DeleteLogRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

// The parameters to WriteLogEntries.
type WriteLogEntriesRequest struct {
	// Optional. A default log resource name that is assigned to all log entries
	// in `entries` that do not specify a value for `log_name`.  Example:
	// `"projects/my-project/logs/syslog"`.  See
	// [LogEntry][google.logging.v2.LogEntry].
	LogName string `protobuf:"bytes,1,opt,name=log_name,json=logName" json:"log_name,omitempty"`
	// Optional. A default monitored resource object that is assigned to all log
	// entries in `entries` that do not specify a value for `resource`. Example:
	//
	//     { "type": "gce_instance",
	//       "labels": {
	//         "zone": "us-central1-a", "instance_id": "00000000000000000000" }}
	//
	// See [LogEntry][google.logging.v2.LogEntry].
	Resource *google_api3.MonitoredResource `protobuf:"bytes,2,opt,name=resource" json:"resource,omitempty"`
	// Optional. Default labels that are added to the `labels` field of all log
	// entries in `entries`. If a log entry already has a label with the same key
	// as a label in this parameter, then the log entry's label is not changed.
	// See [LogEntry][google.logging.v2.LogEntry].
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Required. The log entries to write. Values supplied for the fields
	// `log_name`, `resource`, and `labels` in this `entries.write` request are
	// added to those log entries that do not provide their own values for the
	// fields.
	//
	// To improve throughput and to avoid exceeding the
	// [quota limit](/logging/quota-policy) for calls to `entries.write`,
	// you should write multiple log entries at once rather than
	// calling this method for each individual log entry.
	Entries []*LogEntry `protobuf:"bytes,4,rep,name=entries" json:"entries,omitempty"`
	// Optional. Whether valid entries should be written even if some other
	// entries fail due to INVALID_ARGUMENT or PERMISSION_DENIED errors. If any
	// entry is not written, the response status will be the error associated
	// with one of the failed entries and include error details in the form of
	// WriteLogEntriesPartialErrors.
	PartialSuccess bool `protobuf:"varint,5,opt,name=partial_success,json=partialSuccess" json:"partial_success,omitempty"`
}

func (m *WriteLogEntriesRequest) Reset()                    { *m = WriteLogEntriesRequest{} }
func (m *WriteLogEntriesRequest) String() string            { return proto.CompactTextString(m) }
func (*WriteLogEntriesRequest) ProtoMessage()               {}
func (*WriteLogEntriesRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

func (m *WriteLogEntriesRequest) GetResource() *google_api3.MonitoredResource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *WriteLogEntriesRequest) GetEntries() []*LogEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

// Result returned from WriteLogEntries.
// empty
type WriteLogEntriesResponse struct {
}

func (m *WriteLogEntriesResponse) Reset()                    { *m = WriteLogEntriesResponse{} }
func (m *WriteLogEntriesResponse) String() string            { return proto.CompactTextString(m) }
func (*WriteLogEntriesResponse) ProtoMessage()               {}
func (*WriteLogEntriesResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{2} }

// The parameters to `ListLogEntries`.
type ListLogEntriesRequest struct {
	// Deprecated. One or more project identifiers or project numbers from which
	// to retrieve log entries.  Examples: `"my-project-1A"`, `"1234567890"`. If
	// present, these project identifiers are converted to resource format and
	// added to the list of resources in `resourceNames`. Callers should use
	// `resourceNames` rather than this parameter.
	ProjectIds []string `protobuf:"bytes,1,rep,name=project_ids,json=projectIds" json:"project_ids,omitempty"`
	// Optional. One or more cloud resources from which to retrieve log entries.
	// Example: `"projects/my-project-1A"`, `"projects/1234567890"`.  Projects
	// listed in `projectIds` are added to this list.
	ResourceNames []string `protobuf:"bytes,8,rep,name=resource_names,json=resourceNames" json:"resource_names,omitempty"`
	// Optional. A filter that chooses which log entries to return.  See [Advanced
	// Logs Filters](/logging/docs/view/advanced_filters).  Only log entries that
	// match the filter are returned.  An empty filter matches all log entries.
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// Optional. How the results should be sorted.  Presently, the only permitted
	// values are `"timestamp asc"` (default) and `"timestamp desc"`. The first
	// option returns entries in order of increasing values of
	// `LogEntry.timestamp` (oldest first), and the second option returns entries
	// in order of decreasing timestamps (newest first).  Entries with equal
	// timestamps are returned in order of `LogEntry.insertId`.
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy" json:"order_by,omitempty"`
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListLogEntriesRequest) Reset()                    { *m = ListLogEntriesRequest{} }
func (m *ListLogEntriesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListLogEntriesRequest) ProtoMessage()               {}
func (*ListLogEntriesRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{3} }

// Result returned from `ListLogEntries`.
type ListLogEntriesResponse struct {
	// A list of log entries.
	Entries []*LogEntry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
	// If there might be more results than appear in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListLogEntriesResponse) Reset()                    { *m = ListLogEntriesResponse{} }
func (m *ListLogEntriesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListLogEntriesResponse) ProtoMessage()               {}
func (*ListLogEntriesResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{4} }

func (m *ListLogEntriesResponse) GetEntries() []*LogEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

// The parameters to ListMonitoredResourceDescriptors
type ListMonitoredResourceDescriptorsRequest struct {
	// Optional. The maximum number of results to return from this request.
	// Non-positive values are ignored.  The presence of `nextPageToken` in the
	// response indicates that more results might be available.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method.  `pageToken` must be the value of
	// `nextPageToken` from the previous response.  The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListMonitoredResourceDescriptorsRequest) Reset() {
	*m = ListMonitoredResourceDescriptorsRequest{}
}
func (m *ListMonitoredResourceDescriptorsRequest) String() string { return proto.CompactTextString(m) }
func (*ListMonitoredResourceDescriptorsRequest) ProtoMessage()    {}
func (*ListMonitoredResourceDescriptorsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{5}
}

// Result returned from ListMonitoredResourceDescriptors.
type ListMonitoredResourceDescriptorsResponse struct {
	// A list of resource descriptors.
	ResourceDescriptors []*google_api3.MonitoredResourceDescriptor `protobuf:"bytes,1,rep,name=resource_descriptors,json=resourceDescriptors" json:"resource_descriptors,omitempty"`
	// If there might be more results than appear in this response, then
	// `nextPageToken` is included.  To get the next set of results, call this
	// method again using the value of `nextPageToken` as `pageToken`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListMonitoredResourceDescriptorsResponse) Reset() {
	*m = ListMonitoredResourceDescriptorsResponse{}
}
func (m *ListMonitoredResourceDescriptorsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMonitoredResourceDescriptorsResponse) ProtoMessage()    {}
func (*ListMonitoredResourceDescriptorsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{6}
}

func (m *ListMonitoredResourceDescriptorsResponse) GetResourceDescriptors() []*google_api3.MonitoredResourceDescriptor {
	if m != nil {
		return m.ResourceDescriptors
	}
	return nil
}

func init() {
	proto.RegisterType((*DeleteLogRequest)(nil), "google.logging.v2.DeleteLogRequest")
	proto.RegisterType((*WriteLogEntriesRequest)(nil), "google.logging.v2.WriteLogEntriesRequest")
	proto.RegisterType((*WriteLogEntriesResponse)(nil), "google.logging.v2.WriteLogEntriesResponse")
	proto.RegisterType((*ListLogEntriesRequest)(nil), "google.logging.v2.ListLogEntriesRequest")
	proto.RegisterType((*ListLogEntriesResponse)(nil), "google.logging.v2.ListLogEntriesResponse")
	proto.RegisterType((*ListMonitoredResourceDescriptorsRequest)(nil), "google.logging.v2.ListMonitoredResourceDescriptorsRequest")
	proto.RegisterType((*ListMonitoredResourceDescriptorsResponse)(nil), "google.logging.v2.ListMonitoredResourceDescriptorsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for LoggingServiceV2 service

type LoggingServiceV2Client interface {
	// Deletes a log and all its log entries.
	// The log will reappear if it receives new entries.
	DeleteLog(ctx context.Context, in *DeleteLogRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error)
	// Writes log entries to Stackdriver Logging.  All log entries are
	// written by this method.
	WriteLogEntries(ctx context.Context, in *WriteLogEntriesRequest, opts ...grpc.CallOption) (*WriteLogEntriesResponse, error)
	// Lists log entries.  Use this method to retrieve log entries from Cloud
	// Logging.  For ways to export log entries, see
	// [Exporting Logs](/logging/docs/export).
	ListLogEntries(ctx context.Context, in *ListLogEntriesRequest, opts ...grpc.CallOption) (*ListLogEntriesResponse, error)
	// Lists the monitored resource descriptors used by Stackdriver Logging.
	ListMonitoredResourceDescriptors(ctx context.Context, in *ListMonitoredResourceDescriptorsRequest, opts ...grpc.CallOption) (*ListMonitoredResourceDescriptorsResponse, error)
}

type loggingServiceV2Client struct {
	cc *grpc.ClientConn
}

func NewLoggingServiceV2Client(cc *grpc.ClientConn) LoggingServiceV2Client {
	return &loggingServiceV2Client{cc}
}

func (c *loggingServiceV2Client) DeleteLog(ctx context.Context, in *DeleteLogRequest, opts ...grpc.CallOption) (*google_protobuf5.Empty, error) {
	out := new(google_protobuf5.Empty)
	err := grpc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/DeleteLog", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) WriteLogEntries(ctx context.Context, in *WriteLogEntriesRequest, opts ...grpc.CallOption) (*WriteLogEntriesResponse, error) {
	out := new(WriteLogEntriesResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/WriteLogEntries", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListLogEntries(ctx context.Context, in *ListLogEntriesRequest, opts ...grpc.CallOption) (*ListLogEntriesResponse, error) {
	out := new(ListLogEntriesResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListLogEntries", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loggingServiceV2Client) ListMonitoredResourceDescriptors(ctx context.Context, in *ListMonitoredResourceDescriptorsRequest, opts ...grpc.CallOption) (*ListMonitoredResourceDescriptorsResponse, error) {
	out := new(ListMonitoredResourceDescriptorsResponse)
	err := grpc.Invoke(ctx, "/google.logging.v2.LoggingServiceV2/ListMonitoredResourceDescriptors", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for LoggingServiceV2 service

type LoggingServiceV2Server interface {
	// Deletes a log and all its log entries.
	// The log will reappear if it receives new entries.
	DeleteLog(context.Context, *DeleteLogRequest) (*google_protobuf5.Empty, error)
	// Writes log entries to Stackdriver Logging.  All log entries are
	// written by this method.
	WriteLogEntries(context.Context, *WriteLogEntriesRequest) (*WriteLogEntriesResponse, error)
	// Lists log entries.  Use this method to retrieve log entries from Cloud
	// Logging.  For ways to export log entries, see
	// [Exporting Logs](/logging/docs/export).
	ListLogEntries(context.Context, *ListLogEntriesRequest) (*ListLogEntriesResponse, error)
	// Lists the monitored resource descriptors used by Stackdriver Logging.
	ListMonitoredResourceDescriptors(context.Context, *ListMonitoredResourceDescriptorsRequest) (*ListMonitoredResourceDescriptorsResponse, error)
}

func RegisterLoggingServiceV2Server(s *grpc.Server, srv LoggingServiceV2Server) {
	s.RegisterService(&_LoggingServiceV2_serviceDesc, srv)
}

func _LoggingServiceV2_DeleteLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).DeleteLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/DeleteLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).DeleteLog(ctx, req.(*DeleteLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_WriteLogEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteLogEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).WriteLogEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/WriteLogEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).WriteLogEntries(ctx, req.(*WriteLogEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListLogEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLogEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListLogEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListLogEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListLogEntries(ctx, req.(*ListLogEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoggingServiceV2_ListMonitoredResourceDescriptors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMonitoredResourceDescriptorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoggingServiceV2Server).ListMonitoredResourceDescriptors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.logging.v2.LoggingServiceV2/ListMonitoredResourceDescriptors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoggingServiceV2Server).ListMonitoredResourceDescriptors(ctx, req.(*ListMonitoredResourceDescriptorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LoggingServiceV2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.logging.v2.LoggingServiceV2",
	HandlerType: (*LoggingServiceV2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeleteLog",
			Handler:    _LoggingServiceV2_DeleteLog_Handler,
		},
		{
			MethodName: "WriteLogEntries",
			Handler:    _LoggingServiceV2_WriteLogEntries_Handler,
		},
		{
			MethodName: "ListLogEntries",
			Handler:    _LoggingServiceV2_ListLogEntries_Handler,
		},
		{
			MethodName: "ListMonitoredResourceDescriptors",
			Handler:    _LoggingServiceV2_ListMonitoredResourceDescriptors_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/logging/v2/logging.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/logging/v2/logging.proto", fileDescriptor3)
}

var fileDescriptor3 = []byte{
	// 852 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x55, 0xcf, 0x6e, 0x1b, 0x45,
	0x18, 0xd7, 0xd8, 0x49, 0x6a, 0x4f, 0x68, 0x92, 0x0e, 0x8d, 0xd9, 0x3a, 0x54, 0x58, 0x8b, 0x4a,
	0xb6, 0x96, 0xba, 0x0b, 0xae, 0x2a, 0x91, 0x54, 0x45, 0x28, 0x6a, 0x0f, 0x95, 0x52, 0x88, 0x36,
	0x08, 0xa4, 0x0a, 0xc9, 0x1a, 0xaf, 0xbf, 0x2c, 0x43, 0x77, 0x77, 0x96, 0x99, 0xb1, 0xc3, 0x16,
	0x71, 0xe9, 0x81, 0x17, 0xe0, 0x3d, 0x78, 0x0b, 0xae, 0x5c, 0xb8, 0x70, 0x45, 0xe2, 0x21, 0x38,
	0xa2, 0x99, 0x9d, 0x75, 0x52, 0xdb, 0xc4, 0xdb, 0x5e, 0xec, 0x99, 0x6f, 0x7e, 0xdf, 0x9f, 0xdf,
	0xf7, 0x6f, 0xf1, 0x67, 0x31, 0xe7, 0x71, 0x02, 0x7e, 0xcc, 0x13, 0x9a, 0xc5, 0x3e, 0x17, 0x71,
	0x10, 0x43, 0x96, 0x0b, 0xae, 0x78, 0x50, 0x3e, 0xd1, 0x9c, 0xc9, 0x20, 0xe1, 0x71, 0xcc, 0xb2,
	0x38, 0x98, 0x0e, 0xaa, 0xa3, 0x6f, 0x30, 0xe4, 0x86, 0xd5, 0xaf, 0xa4, 0xd3, 0x41, 0xf7, 0x69,
	0x3d, 0x93, 0x34, 0x67, 0x81, 0x04, 0x31, 0x65, 0x11, 0x44, 0x3c, 0x3b, 0x63, 0x71, 0x40, 0xb3,
	0x8c, 0x2b, 0xaa, 0x18, 0xcf, 0x64, 0x69, 0xbd, 0xfb, 0x65, 0x7d, 0x53, 0x29, 0xcf, 0x98, 0xe2,
	0x02, 0xc6, 0x02, 0xe4, 0xc5, 0x65, 0x28, 0x40, 0xf2, 0x89, 0x88, 0xc0, 0x1a, 0xfc, 0xfc, 0x6d,
	0xe8, 0x0e, 0x21, 0x53, 0xa2, 0xb0, 0x16, 0x0e, 0x62, 0xa6, 0xbe, 0x9b, 0x8c, 0xfc, 0x88, 0xa7,
	0x41, 0x69, 0x25, 0x30, 0x0f, 0xa3, 0xc9, 0x59, 0x90, 0xab, 0x22, 0x07, 0x19, 0x8c, 0x27, 0xc2,
	0xb0, 0x98, 0x1d, 0xac, 0xea, 0xfd, 0xd5, 0xaa, 0x90, 0xe6, 0xaa, 0x28, 0x7f, 0xad, 0xd2, 0xc3,
	0xd5, 0x4a, 0x8a, 0xa5, 0x20, 0x15, 0x4d, 0xf3, 0x8b, 0x93, 0x55, 0x7e, 0x54, 0x8f, 0xae, 0xc8,
	0xa3, 0x40, 0x2a, 0xaa, 0x26, 0xd2, 0xfe, 0x95, 0xea, 0xee, 0x3d, 0xbc, 0xf3, 0x18, 0x12, 0x50,
	0x70, 0xcc, 0xe3, 0x10, 0x7e, 0x98, 0x80, 0x54, 0xe4, 0x16, 0x6e, 0xe9, 0x94, 0x64, 0x34, 0x05,
	0x07, 0xf5, 0x90, 0xd7, 0x0e, 0xaf, 0x25, 0x3c, 0xfe, 0x82, 0xa6, 0xe0, 0xfe, 0xd5, 0xc0, 0x9d,
	0x6f, 0x04, 0x33, 0xf0, 0x27, 0x99, 0x12, 0x0c, 0xe4, 0x6a, 0x2d, 0x72, 0x80, 0x5b, 0x55, 0x91,
	0x9c, 0x46, 0x0f, 0x79, 0x9b, 0x83, 0xdb, 0xbe, 0x0d, 0x9b, 0xe6, 0xcc, 0x7f, 0x56, 0x95, 0x32,
	0xb4, 0xa0, 0x70, 0x06, 0x27, 0xcf, 0xf0, 0x46, 0x42, 0x47, 0x90, 0x48, 0xa7, 0xd9, 0x6b, 0x7a,
	0x9b, 0x83, 0x07, 0xfe, 0x42, 0x37, 0xfa, 0xcb, 0x03, 0xf2, 0x8f, 0x8d, 0x9e, 0x16, 0x16, 0xa1,
	0x35, 0x42, 0x1e, 0xe0, 0x6b, 0x50, 0xa2, 0x9c, 0x35, 0x63, 0x6f, 0x6f, 0x89, 0x3d, 0x6b, 0xaa,
	0x08, 0x2b, 0x2c, 0xd9, 0xc7, 0xdb, 0x39, 0x15, 0x8a, 0xd1, 0x64, 0x28, 0x27, 0x51, 0x04, 0x52,
	0x3a, 0xeb, 0x3d, 0xe4, 0xb5, 0xc2, 0x2d, 0x2b, 0x3e, 0x2d, 0xa5, 0xdd, 0x03, 0xbc, 0x79, 0xc9,
	0x2d, 0xd9, 0xc1, 0xcd, 0x17, 0x50, 0xd8, 0x74, 0xe8, 0x23, 0xb9, 0x89, 0xd7, 0xa7, 0x34, 0x99,
	0x94, 0x79, 0x68, 0x87, 0xe5, 0xe5, 0xb0, 0xf1, 0x29, 0x72, 0x6f, 0xe1, 0xf7, 0x16, 0x88, 0xc8,
	0x9c, 0x67, 0x12, 0xdc, 0x3f, 0x10, 0xde, 0x3d, 0x66, 0x52, 0x2d, 0x26, 0xfd, 0x03, 0xbc, 0x99,
	0x0b, 0xfe, 0x3d, 0x44, 0x6a, 0xc8, 0xc6, 0xd2, 0x41, 0xbd, 0xa6, 0xd7, 0x0e, 0xb1, 0x15, 0x3d,
	0x1d, 0x4b, 0x72, 0x07, 0x6f, 0x55, 0xb9, 0x34, 0xa5, 0x91, 0x4e, 0xcb, 0x60, 0xae, 0x57, 0x52,
	0x5d, 0x20, 0x49, 0x3a, 0x78, 0xe3, 0x8c, 0x25, 0x0a, 0x84, 0x8d, 0xcb, 0xde, 0x74, 0x51, 0xb9,
	0x18, 0x83, 0x18, 0x8e, 0x0a, 0xa7, 0x59, 0x16, 0xd5, 0xdc, 0x8f, 0x0a, 0xb2, 0x87, 0xdb, 0x39,
	0x8d, 0x61, 0x28, 0xd9, 0x4b, 0x70, 0xd6, 0x7a, 0xc8, 0x5b, 0x0f, 0x5b, 0x5a, 0x70, 0xca, 0x5e,
	0x02, 0xb9, 0x8d, 0xb1, 0x79, 0x54, 0xfc, 0x05, 0x64, 0x26, 0x57, 0xed, 0xd0, 0xc0, 0xbf, 0xd2,
	0x02, 0xf7, 0x1c, 0x77, 0xe6, 0xf9, 0x94, 0x54, 0x2f, 0x17, 0x08, 0xbd, 0x41, 0x81, 0x3e, 0xc2,
	0xdb, 0x19, 0xfc, 0xa8, 0x86, 0x97, 0x9c, 0x96, 0x44, 0xae, 0x6b, 0xf1, 0xc9, 0xcc, 0x31, 0xe0,
	0x7d, 0xed, 0x78, 0xa1, 0xe3, 0x1e, 0x83, 0x8c, 0x04, 0xcb, 0x15, 0x17, 0xb3, 0xd4, 0xbe, 0xc6,
	0x0f, 0x5d, 0xc9, 0xaf, 0x31, 0xcf, 0xef, 0x37, 0x84, 0xbd, 0xd5, 0x7e, 0x2c, 0xe5, 0xe7, 0xf8,
	0xe6, 0xac, 0x44, 0xe3, 0x8b, 0x77, 0xcb, 0x7f, 0xff, 0xca, 0x49, 0xb9, 0xb0, 0x17, 0xbe, 0x2b,
	0x16, 0x7d, 0xd4, 0xcd, 0xcb, 0xe0, 0xef, 0x35, 0xbc, 0x73, 0x5c, 0x26, 0xf8, 0xb4, 0x5c, 0xd8,
	0x5f, 0x0f, 0xc8, 0x39, 0x6e, 0xcf, 0x76, 0x03, 0xf9, 0x70, 0x49, 0x1d, 0xe6, 0x37, 0x47, 0xb7,
	0x53, 0x81, 0xaa, 0xfd, 0xe5, 0x3f, 0xd1, 0x7b, 0xce, 0xbd, 0xf7, 0xea, 0xcf, 0x7f, 0x7e, 0x6d,
	0xec, 0xf7, 0xef, 0x04, 0xd3, 0xc1, 0x08, 0x14, 0xfd, 0x24, 0xf8, 0xa9, 0xda, 0x15, 0x8f, 0x6c,
	0xb3, 0xca, 0xa0, 0xaf, 0x17, 0xb1, 0x0c, 0xfa, 0x3f, 0x93, 0x5f, 0x10, 0xde, 0x9e, 0x9b, 0x05,
	0x72, 0xb7, 0xf6, 0xe0, 0x77, 0xfb, 0x75, 0xa0, 0x76, 0xb4, 0xde, 0x37, 0x91, 0x75, 0xdc, 0x1b,
	0xfa, 0x43, 0x60, 0xbb, 0xe9, 0xf0, 0x5c, 0x83, 0x0f, 0x51, 0x9f, 0xbc, 0x42, 0x78, 0xeb, 0xf5,
	0x46, 0x25, 0xde, 0xb2, 0x7e, 0x5c, 0x36, 0x9b, 0xdd, 0xbb, 0x35, 0x90, 0x36, 0x8a, 0x3d, 0x13,
	0xc5, 0xae, 0xbb, 0x73, 0x39, 0x8a, 0x84, 0x49, 0xa5, 0x83, 0xf8, 0x1d, 0xe1, 0xde, 0xaa, 0x66,
	0x22, 0x87, 0xff, 0xe3, 0xac, 0x46, 0xa7, 0x77, 0x1f, 0xbe, 0x95, 0xae, 0x0d, 0xdd, 0x33, 0xa1,
	0xbb, 0xa4, 0xa7, 0x43, 0x4f, 0xaf, 0xd0, 0x38, 0xfa, 0x16, 0xef, 0x46, 0x3c, 0x5d, 0xf4, 0x75,
	0xf4, 0x8e, 0xed, 0xbc, 0x13, 0xdd, 0x34, 0x27, 0xe8, 0xf9, 0xc7, 0x6f, 0xfa, 0x05, 0xff, 0x17,
	0xa1, 0xd1, 0x86, 0x79, 0xbf, 0xff, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x21, 0x93, 0x51, 0x60,
	0xee, 0x08, 0x00, 0x00,
}
