// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/pubsub/v1/pubsub.proto
// DO NOT EDIT!

/*
Package google_pubsub_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/pubsub/v1/pubsub.proto

It has these top-level messages:
	Topic
	PubsubMessage
	GetTopicRequest
	PublishRequest
	PublishResponse
	ListTopicsRequest
	ListTopicsResponse
	ListTopicSubscriptionsRequest
	ListTopicSubscriptionsResponse
	DeleteTopicRequest
	Subscription
	PushConfig
	ReceivedMessage
	GetSubscriptionRequest
	ListSubscriptionsRequest
	ListSubscriptionsResponse
	DeleteSubscriptionRequest
	ModifyPushConfigRequest
	PullRequest
	PullResponse
	ModifyAckDeadlineRequest
	AcknowledgeRequest
*/
package google_pubsub_v1 // import "google.golang.org/genproto/googleapis/pubsub/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A topic resource.
type Topic struct {
	// The name of the topic. It must have the format
	// `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
	// and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
	// underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
	// signs (`%`). It must be between 3 and 255 characters in length, and it
	// must not start with `"goog"`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *Topic) Reset()                    { *m = Topic{} }
func (m *Topic) String() string            { return proto.CompactTextString(m) }
func (*Topic) ProtoMessage()               {}
func (*Topic) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// A message data and its attributes. The message payload must not be empty;
// it must contain either a non-empty data field, or at least one attribute.
type PubsubMessage struct {
	// The message payload. For JSON requests, the value of this field must be
	// [base64-encoded](https://tools.ietf.org/html/rfc4648).
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Optional attributes for this message.
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ID of this message, assigned by the server when the message is published.
	// Guaranteed to be unique within the topic. This value may be read by a
	// subscriber that receives a `PubsubMessage` via a `Pull` call or a push
	// delivery. It must not be populated by the publisher in a `Publish` call.
	MessageId string `protobuf:"bytes,3,opt,name=message_id,json=messageId" json:"message_id,omitempty"`
	// The time at which the message was published, populated by the server when
	// it receives the `Publish` call. It must not be populated by the
	// publisher in a `Publish` call.
	PublishTime *google_protobuf2.Timestamp `protobuf:"bytes,4,opt,name=publish_time,json=publishTime" json:"publish_time,omitempty"`
}

func (m *PubsubMessage) Reset()                    { *m = PubsubMessage{} }
func (m *PubsubMessage) String() string            { return proto.CompactTextString(m) }
func (*PubsubMessage) ProtoMessage()               {}
func (*PubsubMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *PubsubMessage) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *PubsubMessage) GetPublishTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.PublishTime
	}
	return nil
}

// Request for the GetTopic method.
type GetTopicRequest struct {
	// The name of the topic to get.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
}

func (m *GetTopicRequest) Reset()                    { *m = GetTopicRequest{} }
func (m *GetTopicRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTopicRequest) ProtoMessage()               {}
func (*GetTopicRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Request for the Publish method.
type PublishRequest struct {
	// The messages in the request will be published on this topic.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
	// The messages to publish.
	Messages []*PubsubMessage `protobuf:"bytes,2,rep,name=messages" json:"messages,omitempty"`
}

func (m *PublishRequest) Reset()                    { *m = PublishRequest{} }
func (m *PublishRequest) String() string            { return proto.CompactTextString(m) }
func (*PublishRequest) ProtoMessage()               {}
func (*PublishRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *PublishRequest) GetMessages() []*PubsubMessage {
	if m != nil {
		return m.Messages
	}
	return nil
}

// Response for the `Publish` method.
type PublishResponse struct {
	// The server-assigned ID of each published message, in the same order as
	// the messages in the request. IDs are guaranteed to be unique within
	// the topic.
	MessageIds []string `protobuf:"bytes,1,rep,name=message_ids,json=messageIds" json:"message_ids,omitempty"`
}

func (m *PublishResponse) Reset()                    { *m = PublishResponse{} }
func (m *PublishResponse) String() string            { return proto.CompactTextString(m) }
func (*PublishResponse) ProtoMessage()               {}
func (*PublishResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// Request for the `ListTopics` method.
type ListTopicsRequest struct {
	// The name of the cloud project that topics belong to.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Maximum number of topics to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last `ListTopicsResponse`; indicates that this is
	// a continuation of a prior `ListTopics` call, and that the system should
	// return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListTopicsRequest) Reset()                    { *m = ListTopicsRequest{} }
func (m *ListTopicsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTopicsRequest) ProtoMessage()               {}
func (*ListTopicsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Response for the `ListTopics` method.
type ListTopicsResponse struct {
	// The resulting topics.
	Topics []*Topic `protobuf:"bytes,1,rep,name=topics" json:"topics,omitempty"`
	// If not empty, indicates that there may be more topics that match the
	// request; this value should be passed in a new `ListTopicsRequest`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTopicsResponse) Reset()                    { *m = ListTopicsResponse{} }
func (m *ListTopicsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTopicsResponse) ProtoMessage()               {}
func (*ListTopicsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ListTopicsResponse) GetTopics() []*Topic {
	if m != nil {
		return m.Topics
	}
	return nil
}

// Request for the `ListTopicSubscriptions` method.
type ListTopicSubscriptionsRequest struct {
	// The name of the topic that subscriptions are attached to.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
	// Maximum number of subscription names to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last `ListTopicSubscriptionsResponse`; indicates
	// that this is a continuation of a prior `ListTopicSubscriptions` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListTopicSubscriptionsRequest) Reset()                    { *m = ListTopicSubscriptionsRequest{} }
func (m *ListTopicSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsRequest) ProtoMessage()               {}
func (*ListTopicSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// Response for the `ListTopicSubscriptions` method.
type ListTopicSubscriptionsResponse struct {
	// The names of the subscriptions that match the request.
	Subscriptions []string `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new
	// `ListTopicSubscriptionsRequest` to get more subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTopicSubscriptionsResponse) Reset()                    { *m = ListTopicSubscriptionsResponse{} }
func (m *ListTopicSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsResponse) ProtoMessage()               {}
func (*ListTopicSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

// Request for the `DeleteTopic` method.
type DeleteTopicRequest struct {
	// Name of the topic to delete.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
}

func (m *DeleteTopicRequest) Reset()                    { *m = DeleteTopicRequest{} }
func (m *DeleteTopicRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteTopicRequest) ProtoMessage()               {}
func (*DeleteTopicRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// A subscription resource.
type Subscription struct {
	// The name of the subscription. It must have the format
	// `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
	// start with a letter, and contain only letters (`[A-Za-z]`), numbers
	// (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
	// plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
	// in length, and it must not start with `"goog"`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of the topic from which this subscription is receiving messages.
	// The value of this field will be `_deleted-topic_` if the topic has been
	// deleted.
	Topic string `protobuf:"bytes,2,opt,name=topic" json:"topic,omitempty"`
	// If push delivery is used with this subscription, this field is
	// used to configure it. An empty `pushConfig` signifies that the subscriber
	// will pull and ack messages using API methods.
	PushConfig *PushConfig `protobuf:"bytes,4,opt,name=push_config,json=pushConfig" json:"push_config,omitempty"`
	// This value is the maximum time after a subscriber receives a message
	// before the subscriber should acknowledge the message. After message
	// delivery but before the ack deadline expires and before the message is
	// acknowledged, it is an outstanding message and will not be delivered
	// again during that time (on a best-effort basis).
	//
	// For pull subscriptions, this value is used as the initial value for the ack
	// deadline. To override this value for a given message, call
	// `ModifyAckDeadline` with the corresponding `ack_id` if using
	// pull.
	// The maximum custom deadline you can specify is 600 seconds (10 minutes).
	//
	// For push delivery, this value is also used to set the request timeout for
	// the call to the push endpoint.
	//
	// If the subscriber never acknowledges the message, the Pub/Sub
	// system will eventually redeliver the message.
	//
	// If this parameter is 0, a default value of 10 seconds is used.
	AckDeadlineSeconds int32 `protobuf:"varint,5,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds" json:"ack_deadline_seconds,omitempty"`
}

func (m *Subscription) Reset()                    { *m = Subscription{} }
func (m *Subscription) String() string            { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()               {}
func (*Subscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Subscription) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

// Configuration for a push delivery endpoint.
type PushConfig struct {
	// A URL locating the endpoint to which messages should be pushed.
	// For example, a Webhook endpoint might use "https://example.com/push".
	PushEndpoint string `protobuf:"bytes,1,opt,name=push_endpoint,json=pushEndpoint" json:"push_endpoint,omitempty"`
	// Endpoint configuration attributes.
	//
	// Every endpoint has a set of API supported attributes that can be used to
	// control different aspects of the message delivery.
	//
	// The currently supported attribute is `x-goog-version`, which you can
	// use to change the format of the push message. This attribute
	// indicates the version of the data expected by the endpoint. This
	// controls the shape of the envelope (i.e. its fields and metadata).
	// The endpoint version is based on the version of the Pub/Sub
	// API.
	//
	// If not present during the `CreateSubscription` call, it will default to
	// the version of the API used to make such call. If not present during a
	// `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
	// calls will always return a valid version, even if the subscription was
	// created without this attribute.
	//
	// The possible values for this attribute are:
	//
	// * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
	// * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *PushConfig) Reset()                    { *m = PushConfig{} }
func (m *PushConfig) String() string            { return proto.CompactTextString(m) }
func (*PushConfig) ProtoMessage()               {}
func (*PushConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *PushConfig) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// A message and its corresponding acknowledgment ID.
type ReceivedMessage struct {
	// This ID can be used to acknowledge the received message.
	AckId string `protobuf:"bytes,1,opt,name=ack_id,json=ackId" json:"ack_id,omitempty"`
	// The message.
	Message *PubsubMessage `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

func (m *ReceivedMessage) Reset()                    { *m = ReceivedMessage{} }
func (m *ReceivedMessage) String() string            { return proto.CompactTextString(m) }
func (*ReceivedMessage) ProtoMessage()               {}
func (*ReceivedMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ReceivedMessage) GetMessage() *PubsubMessage {
	if m != nil {
		return m.Message
	}
	return nil
}

// Request for the GetSubscription method.
type GetSubscriptionRequest struct {
	// The name of the subscription to get.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetSubscriptionRequest) Reset()                    { *m = GetSubscriptionRequest{} }
func (m *GetSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSubscriptionRequest) ProtoMessage()               {}
func (*GetSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

// Request for the `ListSubscriptions` method.
type ListSubscriptionsRequest struct {
	// The name of the cloud project that subscriptions belong to.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Maximum number of subscriptions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last `ListSubscriptionsResponse`; indicates that
	// this is a continuation of a prior `ListSubscriptions` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListSubscriptionsRequest) Reset()                    { *m = ListSubscriptionsRequest{} }
func (m *ListSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSubscriptionsRequest) ProtoMessage()               {}
func (*ListSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

// Response for the `ListSubscriptions` method.
type ListSubscriptionsResponse struct {
	// The subscriptions that match the request.
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new
	// `ListSubscriptionsRequest` to get more subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListSubscriptionsResponse) Reset()                    { *m = ListSubscriptionsResponse{} }
func (m *ListSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSubscriptionsResponse) ProtoMessage()               {}
func (*ListSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ListSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

// Request for the DeleteSubscription method.
type DeleteSubscriptionRequest struct {
	// The subscription to delete.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *DeleteSubscriptionRequest) Reset()                    { *m = DeleteSubscriptionRequest{} }
func (m *DeleteSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSubscriptionRequest) ProtoMessage()               {}
func (*DeleteSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

// Request for the ModifyPushConfig method.
type ModifyPushConfigRequest struct {
	// The name of the subscription.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The push configuration for future deliveries.
	//
	// An empty `pushConfig` indicates that the Pub/Sub system should
	// stop pushing messages from the given subscription and allow
	// messages to be pulled and acknowledged - effectively pausing
	// the subscription if `Pull` is not called.
	PushConfig *PushConfig `protobuf:"bytes,2,opt,name=push_config,json=pushConfig" json:"push_config,omitempty"`
}

func (m *ModifyPushConfigRequest) Reset()                    { *m = ModifyPushConfigRequest{} }
func (m *ModifyPushConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*ModifyPushConfigRequest) ProtoMessage()               {}
func (*ModifyPushConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *ModifyPushConfigRequest) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

// Request for the `Pull` method.
type PullRequest struct {
	// The subscription from which messages should be pulled.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// If this is specified as true the system will respond immediately even if
	// it is not able to return a message in the `Pull` response. Otherwise the
	// system is allowed to wait until at least one message is available rather
	// than returning no messages. The client may cancel the request if it does
	// not wish to wait any longer for the response.
	ReturnImmediately bool `protobuf:"varint,2,opt,name=return_immediately,json=returnImmediately" json:"return_immediately,omitempty"`
	// The maximum number of messages returned for this request. The Pub/Sub
	// system may return fewer than the number specified.
	MaxMessages int32 `protobuf:"varint,3,opt,name=max_messages,json=maxMessages" json:"max_messages,omitempty"`
}

func (m *PullRequest) Reset()                    { *m = PullRequest{} }
func (m *PullRequest) String() string            { return proto.CompactTextString(m) }
func (*PullRequest) ProtoMessage()               {}
func (*PullRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

// Response for the `Pull` method.
type PullResponse struct {
	// Received Pub/Sub messages. The Pub/Sub system will return zero messages if
	// there are no more available in the backlog. The Pub/Sub system may return
	// fewer than the `maxMessages` requested even if there are more messages
	// available in the backlog.
	ReceivedMessages []*ReceivedMessage `protobuf:"bytes,1,rep,name=received_messages,json=receivedMessages" json:"received_messages,omitempty"`
}

func (m *PullResponse) Reset()                    { *m = PullResponse{} }
func (m *PullResponse) String() string            { return proto.CompactTextString(m) }
func (*PullResponse) ProtoMessage()               {}
func (*PullResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *PullResponse) GetReceivedMessages() []*ReceivedMessage {
	if m != nil {
		return m.ReceivedMessages
	}
	return nil
}

// Request for the ModifyAckDeadline method.
type ModifyAckDeadlineRequest struct {
	// The name of the subscription.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// List of acknowledgment IDs.
	AckIds []string `protobuf:"bytes,4,rep,name=ack_ids,json=ackIds" json:"ack_ids,omitempty"`
	// The new ack deadline with respect to the time this request was sent to
	// the Pub/Sub system. Must be >= 0. For example, if the value is 10, the new
	// ack deadline will expire 10 seconds after the `ModifyAckDeadline` call
	// was made. Specifying zero may immediately make the message available for
	// another pull request.
	AckDeadlineSeconds int32 `protobuf:"varint,3,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds" json:"ack_deadline_seconds,omitempty"`
}

func (m *ModifyAckDeadlineRequest) Reset()                    { *m = ModifyAckDeadlineRequest{} }
func (m *ModifyAckDeadlineRequest) String() string            { return proto.CompactTextString(m) }
func (*ModifyAckDeadlineRequest) ProtoMessage()               {}
func (*ModifyAckDeadlineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

// Request for the Acknowledge method.
type AcknowledgeRequest struct {
	// The subscription whose message is being acknowledged.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The acknowledgment ID for the messages being acknowledged that was returned
	// by the Pub/Sub system in the `Pull` response. Must not be empty.
	AckIds []string `protobuf:"bytes,2,rep,name=ack_ids,json=ackIds" json:"ack_ids,omitempty"`
}

func (m *AcknowledgeRequest) Reset()                    { *m = AcknowledgeRequest{} }
func (m *AcknowledgeRequest) String() string            { return proto.CompactTextString(m) }
func (*AcknowledgeRequest) ProtoMessage()               {}
func (*AcknowledgeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func init() {
	proto.RegisterType((*Topic)(nil), "google.pubsub.v1.Topic")
	proto.RegisterType((*PubsubMessage)(nil), "google.pubsub.v1.PubsubMessage")
	proto.RegisterType((*GetTopicRequest)(nil), "google.pubsub.v1.GetTopicRequest")
	proto.RegisterType((*PublishRequest)(nil), "google.pubsub.v1.PublishRequest")
	proto.RegisterType((*PublishResponse)(nil), "google.pubsub.v1.PublishResponse")
	proto.RegisterType((*ListTopicsRequest)(nil), "google.pubsub.v1.ListTopicsRequest")
	proto.RegisterType((*ListTopicsResponse)(nil), "google.pubsub.v1.ListTopicsResponse")
	proto.RegisterType((*ListTopicSubscriptionsRequest)(nil), "google.pubsub.v1.ListTopicSubscriptionsRequest")
	proto.RegisterType((*ListTopicSubscriptionsResponse)(nil), "google.pubsub.v1.ListTopicSubscriptionsResponse")
	proto.RegisterType((*DeleteTopicRequest)(nil), "google.pubsub.v1.DeleteTopicRequest")
	proto.RegisterType((*Subscription)(nil), "google.pubsub.v1.Subscription")
	proto.RegisterType((*PushConfig)(nil), "google.pubsub.v1.PushConfig")
	proto.RegisterType((*ReceivedMessage)(nil), "google.pubsub.v1.ReceivedMessage")
	proto.RegisterType((*GetSubscriptionRequest)(nil), "google.pubsub.v1.GetSubscriptionRequest")
	proto.RegisterType((*ListSubscriptionsRequest)(nil), "google.pubsub.v1.ListSubscriptionsRequest")
	proto.RegisterType((*ListSubscriptionsResponse)(nil), "google.pubsub.v1.ListSubscriptionsResponse")
	proto.RegisterType((*DeleteSubscriptionRequest)(nil), "google.pubsub.v1.DeleteSubscriptionRequest")
	proto.RegisterType((*ModifyPushConfigRequest)(nil), "google.pubsub.v1.ModifyPushConfigRequest")
	proto.RegisterType((*PullRequest)(nil), "google.pubsub.v1.PullRequest")
	proto.RegisterType((*PullResponse)(nil), "google.pubsub.v1.PullResponse")
	proto.RegisterType((*ModifyAckDeadlineRequest)(nil), "google.pubsub.v1.ModifyAckDeadlineRequest")
	proto.RegisterType((*AcknowledgeRequest)(nil), "google.pubsub.v1.AcknowledgeRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Subscriber service

type SubscriberClient interface {
	// Creates a subscription to a given topic.
	// If the subscription already exists, returns `ALREADY_EXISTS`.
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic. Note that
	// for REST API requests, you must specify a name.
	CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All pending messages in the subscription
	// are immediately dropped. Calls to `Pull` after deletion will return
	// `NOT_FOUND`. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription, or its topic unless the same topic is specified.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful
	// to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted. Note that this does not modify the
	// subscription-level `ackDeadlineSeconds` used for subsequent messages.
	ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Acknowledges the messages associated with the `ack_ids` in the
	// `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Pulls messages from the server. Returns an empty list if there are no
	// messages available in the backlog. The server may return `UNAVAILABLE` if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error)
	// Modifies the `PushConfig` for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified by
	// an empty `PushConfig`) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for delivery
	// continuously through the call regardless of changes to the `PushConfig`.
	ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
}

type subscriberClient struct {
	cc *grpc.ClientConn
}

func NewSubscriberClient(cc *grpc.ClientConn) SubscriberClient {
	return &subscriberClient{cc}
}

func (c *subscriberClient) CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/CreateSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/GetSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ListSubscriptions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/DeleteSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ModifyAckDeadline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/Acknowledge", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error) {
	out := new(PullResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/Pull", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Subscriber/ModifyPushConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Subscriber service

type SubscriberServer interface {
	// Creates a subscription to a given topic.
	// If the subscription already exists, returns `ALREADY_EXISTS`.
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic. Note that
	// for REST API requests, you must specify a name.
	CreateSubscription(context.Context, *Subscription) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All pending messages in the subscription
	// are immediately dropped. Calls to `Pull` after deletion will return
	// `NOT_FOUND`. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription, or its topic unless the same topic is specified.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*google_protobuf1.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful
	// to indicate that more time is needed to process a message by the
	// subscriber, or to make the message available for redelivery if the
	// processing was interrupted. Note that this does not modify the
	// subscription-level `ackDeadlineSeconds` used for subsequent messages.
	ModifyAckDeadline(context.Context, *ModifyAckDeadlineRequest) (*google_protobuf1.Empty, error)
	// Acknowledges the messages associated with the `ack_ids` in the
	// `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(context.Context, *AcknowledgeRequest) (*google_protobuf1.Empty, error)
	// Pulls messages from the server. Returns an empty list if there are no
	// messages available in the backlog. The server may return `UNAVAILABLE` if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(context.Context, *PullRequest) (*PullResponse, error)
	// Modifies the `PushConfig` for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified by
	// an empty `PushConfig`) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for delivery
	// continuously through the call regardless of changes to the `PushConfig`.
	ModifyPushConfig(context.Context, *ModifyPushConfigRequest) (*google_protobuf1.Empty, error)
}

func RegisterSubscriberServer(s *grpc.Server, srv SubscriberServer) {
	s.RegisterService(&_Subscriber_serviceDesc, srv)
}

func _Subscriber_CreateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Subscription)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).CreateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/CreateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).CreateSubscription(ctx, req.(*Subscription))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_GetSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).GetSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/GetSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).GetSubscription(ctx, req.(*GetSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ListSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/DeleteSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyAckDeadline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyAckDeadlineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ModifyAckDeadline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, req.(*ModifyAckDeadlineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Acknowledge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Acknowledge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/Acknowledge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Acknowledge(ctx, req.(*AcknowledgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Pull_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Pull(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/Pull",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Pull(ctx, req.(*PullRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyPushConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyPushConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Subscriber/ModifyPushConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, req.(*ModifyPushConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Subscriber_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1.Subscriber",
	HandlerType: (*SubscriberServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSubscription",
			Handler:    _Subscriber_CreateSubscription_Handler,
		},
		{
			MethodName: "GetSubscription",
			Handler:    _Subscriber_GetSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _Subscriber_ListSubscriptions_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _Subscriber_DeleteSubscription_Handler,
		},
		{
			MethodName: "ModifyAckDeadline",
			Handler:    _Subscriber_ModifyAckDeadline_Handler,
		},
		{
			MethodName: "Acknowledge",
			Handler:    _Subscriber_Acknowledge_Handler,
		},
		{
			MethodName: "Pull",
			Handler:    _Subscriber_Pull_Handler,
		},
		{
			MethodName: "ModifyPushConfig",
			Handler:    _Subscriber_ModifyPushConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/pubsub/v1/pubsub.proto",
}

// Client API for Publisher service

type PublisherClient interface {
	// Creates the given topic with the given name.
	CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error)
	// Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
	// does not exist. The message payload must not be empty; it must contain
	//  either a non-empty data field, or at least one attribute.
	Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error)
	// Lists matching topics.
	ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error)
	// Lists the name of the subscriptions for this topic.
	ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error)
	// Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
	// does not exist. After a topic is deleted, a new topic may be created with
	// the same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted, but their `topic` field is set to `_deleted-topic_`.
	DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
}

type publisherClient struct {
	cc *grpc.ClientConn
}

func NewPublisherClient(cc *grpc.ClientConn) PublisherClient {
	return &publisherClient{cc}
}

func (c *publisherClient) CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/CreateTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error) {
	out := new(PublishResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/Publish", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/GetTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error) {
	out := new(ListTopicsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/ListTopics", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error) {
	out := new(ListTopicSubscriptionsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/ListTopicSubscriptions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1.Publisher/DeleteTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Publisher service

type PublisherServer interface {
	// Creates the given topic with the given name.
	CreateTopic(context.Context, *Topic) (*Topic, error)
	// Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
	// does not exist. The message payload must not be empty; it must contain
	//  either a non-empty data field, or at least one attribute.
	Publish(context.Context, *PublishRequest) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(context.Context, *GetTopicRequest) (*Topic, error)
	// Lists matching topics.
	ListTopics(context.Context, *ListTopicsRequest) (*ListTopicsResponse, error)
	// Lists the name of the subscriptions for this topic.
	ListTopicSubscriptions(context.Context, *ListTopicSubscriptionsRequest) (*ListTopicSubscriptionsResponse, error)
	// Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
	// does not exist. After a topic is deleted, a new topic may be created with
	// the same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted, but their `topic` field is set to `_deleted-topic_`.
	DeleteTopic(context.Context, *DeleteTopicRequest) (*google_protobuf1.Empty, error)
}

func RegisterPublisherServer(s *grpc.Server, srv PublisherServer) {
	s.RegisterService(&_Publisher_serviceDesc, srv)
}

func _Publisher_CreateTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Topic)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).CreateTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/CreateTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).CreateTopic(ctx, req.(*Topic))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_Publish_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).Publish(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/Publish",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).Publish(ctx, req.(*PublishRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_GetTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).GetTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/GetTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).GetTopic(ctx, req.(*GetTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/ListTopics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopics(ctx, req.(*ListTopicsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopicSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/ListTopicSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, req.(*ListTopicSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_DeleteTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).DeleteTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1.Publisher/DeleteTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).DeleteTopic(ctx, req.(*DeleteTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Publisher_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1.Publisher",
	HandlerType: (*PublisherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTopic",
			Handler:    _Publisher_CreateTopic_Handler,
		},
		{
			MethodName: "Publish",
			Handler:    _Publisher_Publish_Handler,
		},
		{
			MethodName: "GetTopic",
			Handler:    _Publisher_GetTopic_Handler,
		},
		{
			MethodName: "ListTopics",
			Handler:    _Publisher_ListTopics_Handler,
		},
		{
			MethodName: "ListTopicSubscriptions",
			Handler:    _Publisher_ListTopicSubscriptions_Handler,
		},
		{
			MethodName: "DeleteTopic",
			Handler:    _Publisher_DeleteTopic_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/pubsub/v1/pubsub.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/pubsub/v1/pubsub.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1369 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xb4, 0x57, 0x5b, 0x6f, 0x13, 0x47,
	0x1b, 0xd6, 0x38, 0xe7, 0x77, 0x9d, 0x2f, 0xc9, 0x88, 0x0f, 0x8c, 0x29, 0x90, 0x2c, 0x14, 0x8c,
	0x0b, 0x5e, 0x30, 0xaa, 0x5a, 0x02, 0x01, 0x01, 0x41, 0x28, 0x15, 0xb4, 0xa9, 0xe1, 0xba, 0xd6,
	0x7a, 0x77, 0x70, 0x96, 0x78, 0x0f, 0xec, 0xcc, 0xa6, 0x31, 0x2d, 0x52, 0x45, 0xab, 0x4a, 0xbd,
	0x2b, 0xed, 0x65, 0x7b, 0x51, 0xa9, 0x57, 0xbd, 0xed, 0x0f, 0xa8, 0xfa, 0x1f, 0xfa, 0x17, 0xfa,
	0x23, 0x7a, 0x59, 0xcd, 0x61, 0xed, 0x5d, 0x7b, 0xd7, 0x87, 0xa0, 0xde, 0x58, 0xeb, 0x99, 0x77,
	0xe6, 0x79, 0xde, 0xd3, 0x33, 0x33, 0x70, 0xab, 0xed, 0xfb, 0xed, 0x0e, 0xa9, 0xb5, 0xfd, 0x8e,
	0xe9, 0xb5, 0x6b, 0x7e, 0xd8, 0x36, 0xda, 0xc4, 0x0b, 0x42, 0x9f, 0xf9, 0x86, 0x9c, 0x32, 0x03,
	0x87, 0x1a, 0x41, 0xd4, 0xa2, 0x51, 0xcb, 0x38, 0xb8, 0xa6, 0xbe, 0x6a, 0xc2, 0x02, 0xaf, 0xaa,
	0xd5, 0x6a, 0xf0, 0xe0, 0x5a, 0x79, 0x67, 0xb2, 0xfd, 0xcc, 0xc0, 0x31, 0x28, 0x09, 0x0f, 0x1c,
	0x8b, 0x58, 0xbe, 0xf7, 0xcc, 0x69, 0x1b, 0xa6, 0xe7, 0xf9, 0xcc, 0x64, 0x8e, 0xef, 0x51, 0xb9,
	0x79, 0xf9, 0x7a, 0xdb, 0x61, 0x7b, 0x51, 0xab, 0x66, 0xf9, 0xae, 0x21, 0xb7, 0x33, 0xc4, 0x44,
	0x2b, 0x7a, 0x66, 0x04, 0xac, 0x1b, 0x10, 0x6a, 0x10, 0x37, 0x60, 0x5d, 0xf9, 0xab, 0x16, 0xdd,
	0x1c, 0xbf, 0x88, 0x39, 0x2e, 0xa1, 0xcc, 0x74, 0x83, 0xfe, 0x97, 0x5c, 0xac, 0x9f, 0x82, 0xb9,
	0xa7, 0x7e, 0xe0, 0x58, 0x18, 0xc3, 0xac, 0x67, 0xba, 0xa4, 0x84, 0xd6, 0x51, 0x65, 0xa9, 0x21,
	0xbe, 0xf5, 0x37, 0x05, 0x58, 0xde, 0x15, 0x7e, 0x3e, 0x26, 0x94, 0x9a, 0x6d, 0xc2, 0xad, 0x6c,
	0x93, 0x99, 0xc2, 0xaa, 0xd8, 0x10, 0xdf, 0xf8, 0x13, 0x00, 0x93, 0xb1, 0xd0, 0x69, 0x45, 0x8c,
	0xd0, 0x52, 0x61, 0x7d, 0xa6, 0xa2, 0xd5, 0x8d, 0xda, 0x60, 0x98, 0x6a, 0xa9, 0x8d, 0x6a, 0x77,
	0x7b, 0x2b, 0x1e, 0x78, 0x2c, 0xec, 0x36, 0x12, 0x5b, 0xe0, 0xd3, 0x00, 0xae, 0x34, 0x6b, 0x3a,
	0x76, 0x69, 0x46, 0x10, 0x5a, 0x52, 0x23, 0x3b, 0x36, 0xde, 0x82, 0x62, 0x10, 0xb5, 0x3a, 0x0e,
	0xdd, 0x6b, 0x72, 0x6f, 0x4a, 0xb3, 0xeb, 0xa8, 0xa2, 0xd5, 0xcb, 0x3d, 0x44, 0xe5, 0x7b, 0xed,
	0x69, 0xec, 0x6a, 0x43, 0x53, 0xf6, 0x7c, 0xa4, 0xbc, 0x05, 0x2b, 0x03, 0xe0, 0x78, 0x15, 0x66,
	0xf6, 0x49, 0x57, 0xb9, 0xce, 0x3f, 0xf1, 0x31, 0x98, 0x3b, 0x30, 0x3b, 0x11, 0x29, 0x15, 0xc4,
	0x98, 0xfc, 0xb3, 0x59, 0xf8, 0x10, 0xe9, 0x17, 0x61, 0xe5, 0x21, 0x61, 0x22, 0x66, 0x0d, 0xf2,
	0x22, 0x22, 0x94, 0x71, 0x63, 0xc6, 0xff, 0xab, 0x0d, 0xe4, 0x1f, 0xdd, 0x82, 0xff, 0xed, 0x4a,
	0xd8, 0x91, 0x76, 0xf8, 0x26, 0x2c, 0x2a, 0xdf, 0xe2, 0xe0, 0x9d, 0x1d, 0x13, 0xbc, 0x46, 0x6f,
	0x81, 0x5e, 0x87, 0x95, 0x1e, 0x08, 0x0d, 0x7c, 0x8f, 0x12, 0x7c, 0x16, 0xb4, 0x7e, 0xf4, 0x68,
	0x09, 0xad, 0xcf, 0x54, 0x96, 0x1a, 0xd0, 0x0b, 0x1f, 0xd5, 0x1d, 0x58, 0x7b, 0xe4, 0x50, 0xe9,
	0x02, 0x8d, 0xb9, 0x95, 0x60, 0x21, 0x08, 0xfd, 0xe7, 0xc4, 0x62, 0x8a, 0x5d, 0xfc, 0x17, 0x9f,
	0x82, 0xa5, 0x80, 0x6f, 0x46, 0x9d, 0x97, 0x32, 0x1c, 0x73, 0x8d, 0x45, 0x3e, 0xf0, 0xc4, 0x79,
	0x49, 0x78, 0xaa, 0xc4, 0x24, 0xf3, 0xf7, 0x89, 0x17, 0xa7, 0x8a, 0x8f, 0x3c, 0xe5, 0x03, 0xba,
	0x0b, 0x38, 0x09, 0xa5, 0x18, 0x1a, 0x30, 0x2f, 0x5c, 0x97, 0xe4, 0xb4, 0xfa, 0x89, 0x61, 0x7f,
	0x65, 0x7c, 0x95, 0x19, 0xbe, 0x00, 0x2b, 0x1e, 0x39, 0x64, 0xcd, 0x04, 0x94, 0xcc, 0xcb, 0x32,
	0x1f, 0xde, 0xed, 0xc1, 0xbd, 0x80, 0xd3, 0x3d, 0xb8, 0x27, 0x51, 0x8b, 0x5a, 0xa1, 0x13, 0x88,
	0xf6, 0x1a, 0x9d, 0x81, 0xb7, 0xf1, 0xd0, 0x83, 0x33, 0x79, 0x90, 0xca, 0xdb, 0xf3, 0xb0, 0x4c,
	0x93, 0x13, 0x2a, 0x23, 0xe9, 0xc1, 0x89, 0x5d, 0xac, 0x02, 0xde, 0x26, 0x1d, 0xc2, 0xc8, 0x04,
	0x15, 0xf8, 0x1b, 0x82, 0x62, 0x92, 0x53, 0x56, 0x8f, 0xf7, 0x97, 0x16, 0x92, 0x21, 0xd9, 0x02,
	0x2d, 0x88, 0xe8, 0x5e, 0x53, 0x2a, 0x95, 0x6a, 0xb1, 0x77, 0xb2, 0xea, 0x92, 0xee, 0xdd, 0x17,
	0x36, 0x0d, 0x08, 0x7a, 0xdf, 0xf8, 0x2a, 0x1c, 0x33, 0xad, 0xfd, 0xa6, 0x4d, 0x4c, 0xbb, 0xe3,
	0x78, 0xa4, 0x49, 0xb9, 0xe4, 0xd9, 0xb4, 0x34, 0x27, 0x82, 0x8b, 0x4d, 0x6b, 0x7f, 0x5b, 0x4d,
	0x3d, 0x91, 0x33, 0xfa, 0x1f, 0x08, 0xa0, 0xbf, 0x19, 0x3e, 0x07, 0xcb, 0x02, 0x9f, 0x78, 0x76,
	0xe0, 0x3b, 0x5e, 0x5c, 0x94, 0x45, 0x3e, 0xf8, 0x40, 0x8d, 0xe1, 0x47, 0x19, 0xc2, 0x73, 0x79,
	0x14, 0xc7, 0x51, 0xaa, 0xf3, 0xb6, 0xba, 0x60, 0xc1, 0x4a, 0x83, 0x58, 0xc4, 0x39, 0x20, 0x76,
	0x2c, 0x96, 0xff, 0x87, 0x79, 0x1e, 0x05, 0xc7, 0x8e, 0xd3, 0x62, 0x5a, 0xfb, 0x3b, 0x36, 0xbe,
	0x01, 0x0b, 0xaa, 0x1b, 0xc5, 0x2e, 0x13, 0xf4, 0x7b, 0x6c, 0xaf, 0xdf, 0x82, 0xe3, 0x0f, 0x09,
	0x4b, 0xe6, 0x34, 0xae, 0x00, 0x1d, 0x8a, 0xc9, 0x82, 0x8a, 0xe3, 0x95, 0x1c, 0xd3, 0x03, 0x28,
	0xf1, 0x5a, 0xcd, 0xec, 0x8c, 0xff, 0xa6, 0xff, 0xbf, 0x43, 0x70, 0x32, 0x03, 0x52, 0x75, 0xc6,
	0x76, 0x56, 0x67, 0x68, 0xf5, 0x33, 0xc3, 0xe1, 0x48, 0x79, 0x7c, 0xc4, 0xce, 0xb9, 0x03, 0x27,
	0x65, 0xe7, 0x1c, 0x35, 0x7c, 0x5f, 0xc2, 0x89, 0xc7, 0xbe, 0xed, 0x3c, 0xeb, 0x26, 0x8a, 0x7e,
	0xf2, 0xe5, 0x83, 0x2d, 0x55, 0x98, 0xae, 0xa5, 0xf4, 0xaf, 0x11, 0x68, 0xbb, 0x51, 0xa7, 0x33,
	0x0d, 0xe4, 0x15, 0xc0, 0x21, 0x61, 0x51, 0xe8, 0x35, 0x1d, 0xd7, 0x25, 0xb6, 0x63, 0x32, 0xd2,
	0xe9, 0x0a, 0xe4, 0xc5, 0xc6, 0x9a, 0x9c, 0xd9, 0xe9, 0x4f, 0xe0, 0x0d, 0x28, 0xba, 0xe6, 0x61,
	0xb3, 0x77, 0x1a, 0xcd, 0x88, 0x64, 0x6b, 0xae, 0x79, 0xf8, 0x38, 0x3e, 0x6f, 0x3e, 0x83, 0xa2,
	0x24, 0xa1, 0x52, 0xf8, 0x31, 0xac, 0x85, 0xaa, 0xea, 0xfb, 0xeb, 0x64, 0x1a, 0x37, 0x86, 0x5d,
	0x1b, 0x68, 0x90, 0xc6, 0x6a, 0x98, 0x1e, 0xa0, 0xbc, 0x60, 0x4a, 0x32, 0xc8, 0x77, 0xfb, 0x1a,
	0x31, 0x8d, 0xcb, 0x27, 0x60, 0x41, 0xf6, 0x1c, 0x2d, 0xcd, 0x0a, 0x9d, 0x9d, 0x17, 0x4d, 0x47,
	0x73, 0x25, 0x69, 0x26, 0x57, 0x92, 0x3e, 0x05, 0x7c, 0xd7, 0xda, 0xf7, 0xfc, 0xcf, 0x3b, 0xc4,
	0x6e, 0x1f, 0x95, 0x44, 0x21, 0x49, 0xa2, 0xfe, 0xe7, 0x12, 0x80, 0x2a, 0xbf, 0x16, 0x09, 0xf1,
	0xb7, 0x08, 0xf0, 0xfd, 0x90, 0x98, 0xe9, 0x9a, 0xc4, 0x63, 0x1a, 0xa0, 0x3c, 0x66, 0x5e, 0xbf,
	0xfa, 0xfa, 0xaf, 0xbf, 0x7f, 0x2c, 0x54, 0xcb, 0xef, 0xf2, 0xcb, 0xeb, 0x17, 0x5c, 0xe5, 0xb7,
	0x54, 0x33, 0x53, 0xa3, 0x6a, 0xa4, 0xba, 0xc7, 0xa8, 0xbe, 0xda, 0x44, 0x55, 0xfc, 0x03, 0x12,
	0xb7, 0x9a, 0x14, 0x8b, 0xca, 0x30, 0x4a, 0xb6, 0xf6, 0x8c, 0xe5, 0xf3, 0xbe, 0xe0, 0x63, 0xe0,
	0x2b, 0x82, 0x4f, 0x12, 0x7f, 0x14, 0x2f, 0xfc, 0x33, 0x92, 0x17, 0x95, 0x94, 0x78, 0xe0, 0xea,
	0x30, 0x58, 0x9e, 0xa8, 0x95, 0xdf, 0x9b, 0xc8, 0x56, 0x96, 0xb2, 0x5e, 0x13, 0x2c, 0x2b, 0xf8,
	0x82, 0x60, 0xa9, 0x88, 0x25, 0x08, 0xbe, 0x4a, 0x33, 0xc4, 0xdf, 0xa3, 0xf8, 0x28, 0x4e, 0x85,
	0x2d, 0x03, 0x33, 0x57, 0x76, 0xca, 0xc7, 0x87, 0x2e, 0xad, 0x0f, 0xf8, 0xc5, 0x3e, 0x8e, 0x58,
	0x75, 0xca, 0x88, 0xfd, 0x8a, 0x60, 0x6d, 0xa8, 0x7b, 0xb2, 0x22, 0x96, 0xd7, 0x62, 0xb9, 0x84,
	0x3e, 0x12, 0x84, 0xb6, 0xf5, 0x3b, 0x53, 0x11, 0xda, 0x74, 0x07, 0x71, 0x78, 0xb1, 0xbd, 0x41,
	0xa0, 0x25, 0x1a, 0x0b, 0x9f, 0x1f, 0xe6, 0x37, 0xdc, 0x77, 0xb9, 0xcc, 0xb6, 0x05, 0xb3, 0xdb,
	0xfa, 0x8d, 0xe9, 0x98, 0x99, 0x7d, 0x04, 0xce, 0xe9, 0x1b, 0x04, 0xb3, 0x5c, 0xd8, 0xf0, 0xe9,
	0x2c, 0x41, 0xee, 0xa9, 0x6e, 0x56, 0xa9, 0x27, 0xf5, 0x50, 0xdf, 0x12, 0x6c, 0x3e, 0xd0, 0xeb,
	0xd3, 0xb1, 0x09, 0xa2, 0x4e, 0x87, 0xd3, 0xf8, 0x05, 0xc1, 0xea, 0xe0, 0x19, 0x83, 0x2f, 0xe5,
	0xe5, 0x6f, 0xe8, 0x1c, 0xca, 0x0d, 0xd2, 0x8e, 0xa0, 0x75, 0x5f, 0xbf, 0x7d, 0x94, 0xf4, 0xf5,
	0x61, 0x36, 0x51, 0xb5, 0xfe, 0xd3, 0x3c, 0x2c, 0xa9, 0x27, 0x07, 0x09, 0xf1, 0x73, 0xd0, 0xa4,
	0x80, 0xc9, 0x47, 0x64, 0xde, 0x4d, 0xbe, 0x9c, 0x37, 0xa1, 0x5f, 0x12, 0xcc, 0xce, 0x95, 0xcf,
	0x64, 0x6a, 0x95, 0xbc, 0xff, 0x2b, 0x91, 0x7a, 0x8d, 0x60, 0x41, 0x21, 0xe3, 0xf5, 0xcc, 0x2b,
	0x53, 0xe2, 0xb1, 0x55, 0xde, 0x18, 0x61, 0xa1, 0x92, 0x55, 0x17, 0xd8, 0x97, 0xf5, 0x8b, 0x02,
	0x5b, 0x60, 0x65, 0x83, 0xab, 0xe7, 0x23, 0x27, 0xe1, 0xc3, 0x62, 0xfc, 0xfc, 0xc3, 0x1b, 0x99,
	0x0a, 0x99, 0xbc, 0x98, 0xe7, 0xfb, 0x7d, 0x51, 0x60, 0x6f, 0xe0, 0xb3, 0x63, 0xb0, 0xf1, 0x57,
	0x08, 0xa0, 0xff, 0x86, 0xc2, 0xe7, 0xb2, 0x25, 0x2d, 0xf5, 0x98, 0x2b, 0x9f, 0x1f, 0x6d, 0xa4,
	0xdc, 0x4f, 0x53, 0xc8, 0x12, 0x3c, 0xf5, 0xfc, 0xfa, 0x1d, 0xc1, 0xf1, 0xec, 0x47, 0x0e, 0x36,
	0x46, 0x20, 0x65, 0x4a, 0xf2, 0xd5, 0xc9, 0x17, 0x28, 0x9a, 0xe9, 0xd3, 0x23, 0x3f, 0x52, 0x03,
	0xf2, 0xcc, 0x40, 0x4b, 0x3c, 0x94, 0xb2, 0x44, 0x66, 0xf8, 0x1d, 0x95, 0xdb, 0x3f, 0x2a, 0x54,
	0xd5, 0x71, 0xd9, 0xba, 0x57, 0x81, 0x63, 0x96, 0xef, 0x0e, 0x61, 0xdd, 0xd3, 0xe4, 0x85, 0x7e,
	0x97, 0x6f, 0xbb, 0x8b, 0xfe, 0x41, 0xa8, 0x35, 0x2f, 0x20, 0xae, 0xff, 0x1b, 0x00, 0x00, 0xff,
	0xff, 0x87, 0x6f, 0x33, 0xa9, 0x8e, 0x12, 0x00, 0x00,
}
