/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc.controls;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioDeviceCapabilities;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioDeviceState;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioRepeatState;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioShuffleState;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.AudioVideoCommandNumber;
import com.dsi.ant.plugins.antplus.pcc.controls.defines.ControlsMode;
import com.dsi.ant.plugins.antplus.pcc.controls.pccbase.AntPlusBaseRemoteControlPcc;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestStatus;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.util.EnumSet;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusAudioRemoteControlPcc
extends AntPlusBaseRemoteControlPcc {
    private static final String TAG = AntPlusAudioRemoteControlPcc.class.getSimpleName();
    private static final int INVALIDCOMMANDDATA = 255;
    IAudioStatusReceiver mAudioStatusReceiver;
    IAudioCommandFinishedReceiver mAudioCommandFinishedReceiver;
    Semaphore mCommandLock = new Semaphore(1);

    public static AntPlusBaseRemoteControlPcc.RemoteControlAsyncScanController<AntPlusAudioRemoteControlPcc> requestRemoteControlAsyncScanController(EnumSet<ControlsMode> requestModes, Context bindToContext, int searchProximityThreshold, AntPlusBaseRemoteControlPcc.IRemoteControlAsyncScanResultReceiver scanResultReceiver) {
        AntPlusAudioRemoteControlPcc potentialRetObj = new AntPlusAudioRemoteControlPcc();
        return AntPlusAudioRemoteControlPcc.requestAccessRemoteControl_Helper(requestModes, bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    public static PccReleaseHandle<AntPlusAudioRemoteControlPcc> requestAccessByDeviceNumber(EnumSet<ControlsMode> requestModes, Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusAudioRemoteControlPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusAudioRemoteControlPcc potentialRetObj = new AntPlusAudioRemoteControlPcc();
        return AntPlusAudioRemoteControlPcc.requestAccessRemoteControl_Helper(requestModes, bindToContext, antDeviceNumber, searchProximityThreshold, resultReceiver, stateReceiver, potentialRetObj);
    }

    private AntPlusAudioRemoteControlPcc() {
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Audio Remote Control";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 202: {
                if (this.mAudioStatusReceiver == null) break;
                Bundle b = eventMsg.getData();
                b.setClassLoader(AudioDeviceCapabilities.class.getClassLoader());
                long estTimestamp = b.getLong("long_EstTimestamp");
                int volume = b.getInt("int_volume");
                int totalTrackTime = b.getInt("int_totalTrackTime");
                int currentTrackTime = b.getInt("int_currentTrackTime");
                AudioDeviceState audioState = AudioDeviceState.getValueFromInt(b.getInt("int_audioState"));
                AudioRepeatState repeatState = AudioRepeatState.getValueFromInt(b.getInt("int_repeatState"));
                AudioShuffleState shuffleState = AudioShuffleState.getValueFromInt(b.getInt("int_shuffleState"));
                this.mAudioStatusReceiver.onNewAudioStatus(estTimestamp, volume, totalTrackTime, currentTrackTime, AudioDeviceCapabilities.readFromBundle(b), audioState, repeatState, shuffleState);
                break;
            }
            case 206: {
                if (this.mAudioCommandFinishedReceiver == null) break;
                this.mCommandLock.release();
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                RequestStatus status = RequestStatus.getValueFromInt(b.getInt("int_requestStatus"));
                this.mAudioCommandFinishedReceiver.onAudioCommandFinished(estTimestamp, eventFlags, status);
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void subscribeAudioStatusEvent(IAudioStatusReceiver AudioStatusReceiver) {
        this.mAudioStatusReceiver = AudioStatusReceiver;
        if (AudioStatusReceiver != null) {
            this.subscribeToEvent(202);
        } else {
            this.unsubscribeFromEvent(202);
        }
    }

    public void RequestAudioCommand(IAudioCommandFinishedReceiver audioCommandFinishedReceiver, AudioVideoCommandNumber commandNumber, int commandData) {
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd RequestAudioCommand failed to start because a local command is still processing.");
            return;
        }
        this.mAudioCommandFinishedReceiver = audioCommandFinishedReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = 20003;
        Bundle params = new Bundle();
        cmdMsg.setData(params);
        params.putInt("int_commandData", commandData);
        params.putInt("int_commandNumber", commandNumber.getIntValue());
        Message ret = this.sendPluginCommand(cmdMsg);
        if (ret == null) {
            LogAnt.e(TAG, "Cmd RequestAudioCommand died in sendPluginCommand()");
            this.mCommandLock.release();
            return;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd RequestAudioCommand failed with code " + ret.arg1);
            this.mCommandLock.release();
            throw new RuntimeException("RequestAudioCommand cmd failed internally");
        }
        ret.recycle();
    }

    public void RequestAudioCommand(IAudioCommandFinishedReceiver audioCommandFinishedReceiver, AudioVideoCommandNumber commandNumber) {
        this.RequestAudioCommand(audioCommandFinishedReceiver, commandNumber, 255);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IAudioCommandFinishedReceiver {
        public void onAudioCommandFinished(long var1, EnumSet<EventFlag> var3, RequestStatus var4);
    }

    public static interface IAudioStatusReceiver {
        public void onNewAudioStatus(long var1, int var3, int var4, int var5, AudioDeviceCapabilities var6, AudioDeviceState var7, AudioRepeatState var8, AudioShuffleState var9);
    }

    public class IpcDefines {
        public static final int MSG_EVENT_REMOTECONTROL_whatAUDIOSTATUS = 202;
        public static final int MSG_EVENT_REMOTECONTROL_whatAUDIOCOMMANDFINISHED = 206;
        public static final String MSG_EVENT_REMOTECONTRL_AUDIOCOMMANDFINISHED_PARAM_intREQUESTSTATUS = "int_requestStatus";
        public static final int MSG_CMD_REMOTECONTROL_whatAUDIOCOMMAND = 20003;
    }
}

