<?php
/**
 * Login screen for Gollem.
 *
 * $Horde: gollem/login.php,v 1.94.2.5 2005/12/02 07:07:28 slusarz Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2005 Max Kalika <max@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('AUTH_HANDLER', true);
@define('GOLLEM_BASE', dirname(__FILE__));
$authentication = 'none';
require_once GOLLEM_BASE . '/lib/base.php';
require_once 'Horde/Menu.php';
require GOLLEM_BASE . '/config/credentials.php';

/* Get an Auth object. */
$gollem_auth = (Auth::getProvider() == 'gollem');
$auth = &Auth::singleton($conf['auth']['driver']);
$autologin = Util::getFormData('autologin', false);
$autologin_fail = Util::getFormData('autologin_fail', false);

$actionID = Util::getFormData('actionID');
$backend_key = Util::getFormData('backend_key');
$logout_reason = $auth->getLogoutReason();

/* Handle cases when we already have a session. */
if (!empty($_SESSION['gollem']) && is_array($_SESSION['gollem'])) {
    if ($logout_reason) {
        /* Log logout requests now. */
        if ($logout_reason == AUTH_REASON_LOGOUT) {
            $entry = sprintf('Logout for %s [%s]',
                             $GLOBALS['gollem_be']['params']['username'],
                             $_SERVER['REMOTE_ADDR']);
        } else {
            $entry = $_SERVER['REMOTE_ADDR'] . ' ' . $auth->getLogoutReasonString();
        }
        Horde::logMessage($entry, __FILE__, __LINE__, PEAR_LOG_NOTICE);

        $language = (isset($prefs)) ? $prefs->getValue('language') : NLS::select();

        unset($_SESSION['gollem']);

        if (isset($prefs)) {
            $prefs->cleanup($gollem_auth);
        }
        if ($gollem_auth) {
            Auth::clearAuth();
            @session_destroy();
            Horde::setupSessionHandler();
            @session_start();
        }

        NLS::setLang($language);

        /* Hook to preselect the correct language in the widget. */
        $_GET['new_lang'] = $language;

        $registry->loadPrefs('horde');
        $registry->loadPrefs();
    } elseif (!$autologin_fail) {
        /* Check to see if we have logged in to the backend yet. */
        if (isset($_SESSION['gollem']['backends'][$backend_key])) {
            if (Util::getFormData('change_backend')) {
                require_once GOLLEM_BASE . '/lib/Session.php';
                Gollem_Session::changeBackend($backend_key);
            }

            $url = Util::getFormData('url');
            if (empty($url)) {
                /* If there is an existing session, redirect the user to the
                 * file manager. */
                $url = Horde::applicationUrl('manager.php', true);
                if ($actionID == 'login') {
                    $url = Util::addParameter($url, 'actionID', 'login', false);
                }
            }
            header('Location: ' . $url);
            exit;
        }
    }
}

/* Log session timeouts. */
if ($logout_reason == AUTH_REASON_SESSION) {
    $entry = sprintf('Session timeout for client [%s]', $_SERVER['REMOTE_ADDR']);
    Horde::logMessage($entry, __FILE__, __LINE__, PEAR_LOG_NOTICE);

    /* Make sure everything is really cleared. */
    Auth::clearAuth();
    unset($_SESSION['gollem']);
}

/* Redirect the user on logout if redirection is enabled. */
if (($logout_reason == AUTH_REASON_LOGOUT) &&
    ($conf['user']['redirect_on_logout'] ||
     !empty($conf['auth']['redirect_on_logout']))) {
    $url = Auth::addLogoutParameters((!empty($conf['auth']['redirect_on_logout'])) ? $conf['auth']['redirect_on_logout'] : $conf['user']['redirect_on_logout'], AUTH_REASON_LOGOUT);
    if (!isset($_COOKIE[session_name()])) {
        $url = Util::addParameter($url, session_name(), session_id());
    }
    header('Location: ' . $url);
    exit;
}

/* Redirect the user if an alternate login page has been specified. */
if (!empty($conf['auth']['alternate_login']) ||
    !empty($conf['user']['alternate_login'])) {
    $url = Auth::addLogoutParameters(!empty($conf['auth']['alternate_login']) ? $conf['auth']['alternate_login'] : $conf['user']['alternate_login']);
    if (!isset($_COOKIE[session_name()])) {
        $url = Util::addParameter($url, session_name(), session_id());
    }
    header('Location: ' . $url);
    exit;
}

/* Initialize the password key(s). If we are doing Horde auth as well,
 * make sure that the Horde auth key gets set. */
Secret::setKey('gollem');
if ($gollem_auth) {
    Secret::setKey('auth');
}

if (!$backend_key) {
    $backend_key = Gollem::getPreferredBackend();
    /* If there is no backend key defined, there is no available backends for
     * the current user. */
    if (is_null($backend_key)) {
        $reason = _("There are no backends available for the current user.");
        require GOLLEM_TEMPLATES . '/common-header.inc';
        require GOLLEM_TEMPLATES . '/login/nologin.inc';
        if (@is_readable(GOLLEM_BASE . '/config/motd.php')) {
            require GOLLEM_BASE . '/config/motd.php';
        }
        require $registry->get('templates', 'horde') . '/common-footer.inc';
        exit;
    }
}

/* Build the <select> widget for the servers list. */
if ($conf['backend']['backend_list'] == 'shown') {
    $backends_list = '';

    foreach ($GLOBALS['gollem_backends'] as $key => $curBackend) {
        $sel = ($key == $backend_key) ? ' selected="selected"' : '';
        $backends_list .= "<option value=\"$key\"$sel>";
        $backends_list .= $curBackend['name'] . '</option>';
    }

    $autologin = Util::getFormData('autologin');
}

$login_vfs = array();
foreach ($GLOBALS['gollem_backends'] as $key => $curBackend) {
    $login_vfs[$key] = &VFS::singleton($curBackend['driver'], array_merge($curBackend['params'], array('user' => Auth::getAuth())));
    if (is_a($login_vfs[$key], 'PEAR_Error')) {
        Horde::fatal($login_vfs[$key]);
    }
}
$GLOBALS['gollem_vfs'] = $login_vfs[$backend_key];

/* If we only have one backend, and it doesn't require authentication, skip
 * all further steps and login. */
$redirect_params = array();
if (!$logout_reason && !$autologin_fail) {
    if (count($login_vfs) == 1) {
        if (!$GLOBALS['gollem_vfs']->getRequiredCredentials()) {
            $redirect_params['nocredentials'] = 1;
        } elseif (Gollem::canAutoLogin($backend_key, $autologin)) {
            $redirect_params['autologin'] = 1;
        }
    } elseif (Util::getFormData('change_backend') &&
              empty($GLOBALS['gollem_backends'][$backend_key]['loginparams'])) {
        $redirect_params['autologin'] = 1;
    }
}

if (!empty($redirect_params)) {
    $redirect_params += array('actionID' => 'login', 'backend_key' => $backend_key);
    $url = Util::addParameter(Horde::applicationUrl('redirect.php', true), $redirect_params, null, false);
    header('Location: ' . $url);
    exit;
}

$title = sprintf(_("Welcome to %s"), $registry->get('name', ($gollem_auth) ? 'horde' : null));

if ($logout_reason && $gollem_auth && $conf['menu']['always']) {
    $notification->push('setFocus();if (window.parent.frames.horde_menu) window.parent.frames.horde_menu.location.reload();', 'javascript');
} else {
    $notification->push('setFocus()', 'javascript');
}

$reason = $auth->getLogoutReasonString();

/* Add some javascript. */
Horde::addScriptFile('enter_key_trap.js', 'horde', true);

/* Do we need to do IE version detection? */
if (!Auth::getAuth() &&
    ($browser->getBrowser() == 'msie') &&
    ($browser->getMajor() >= 5)) {
    $ie_clientcaps = true;
}

require GOLLEM_TEMPLATES . '/common-header.inc';
require GOLLEM_TEMPLATES . '/login/login.inc';
if (@is_readable(GOLLEM_BASE . '/config/motd.php')) {
    require GOLLEM_BASE . '/config/motd.php';
}
require $registry->get('templates', 'horde') . '/common-footer.inc';
