<?php
/* Build the <select> widget containing the available languages. */
$choose_language = ($gollem_auth && !$prefs->isLocked('language'));
if ($choose_language) {
    $_SESSION['horde_language'] = NLS::select();
    $langs = '';
    foreach ($nls['languages'] as $key => $val) {
        $sel = ($key == $_SESSION['horde_language']) ? ' selected="selected"' : '';
        $langs .= "<option value=\"$key\"$sel>$val</option>";
    }
}
?>

<script type="text/javascript">
<!--

function setFocus()
{
    if (document.gollem_login.username) {
        document.gollem_login.username.focus();
    }
}

<?php if ($conf['backend']['backend_list'] == 'shown'): ?>
function gollem_reload()
{
    var url = '<?php echo Util::addParameter(htmlspecialchars(Horde::selfUrl(false, true, true)), array('backend_key' => null), null, false) ?>' + document.gollem_login.backend_key[document.gollem_login.backend_key.selectedIndex].value;
    if (document.gollem_login.url &&
        document.gollem_login.url.value) {
        url += '&url=' + document.gollem_login.url.value;
    }
    window.location = url;
}
<?php endif; ?>

function submit_login(e)
{
    if (typeof e != 'undefined' && !enter_key_trap(e)) {
        return;
    }

    if (document.gollem_login.username &&
        document.gollem_login.username.value == "") {
        alert('<?php echo addslashes(_("Please provide your username.")) ?>');
        document.gollem_login.username.focus();
        return false;
    } else if (document.gollem_login.password &&
               document.gollem_login.password.value == "") {
        alert('<?php echo addslashes(_("Please provide your password.")) ?>');
        document.gollem_login.password.focus();
        return false;
    } else {
        document.gollem_login.loginButton.disabled = true;
<?php if (!empty($ie_clientcaps)): ?>
        try {
            document.gollem_login.ie_version.value = objCCaps.getComponentVersion("{89820200-ECBD-11CF-8B85-00AA005B4383}","componentid");
        } catch (e) {
        }
<?php endif; ?>
        document.gollem_login.submit();
        return true;
    }
}
//-->
</script>

<form action="<?php echo Horde::url('redirect.php', false, -1, true) ?>" method="post" name="gollem_login"<?php echo $gollem_auth ? ' target="_parent"' : '' ?>>
<?php Util::pformInput() ?>
<input type="hidden" name="gollem_loginform" value="1" />
<input type="hidden" name="actionID" value="<?php echo $actionID ?>" />
<input type="hidden" name="load_frameset" value="<?php echo $gollem_auth ? 1 : 0 ?>" />
<input type="hidden" name="url" value="<?php echo htmlspecialchars(Util::getFormData('url')) ?>" />
<input type="hidden" name="autologin" value="<?php echo ($autologin || Gollem::canAutoLogin($backend_key, true)) ? 1 : 0 ?>" />
<?php if (!empty($ie_clientcaps)): ?>
<input type="hidden" name="ie_version" value="" />
<?php endif; ?>
<?php if ($conf['backend']['backend_list'] != 'shown'): ?>
<input type="hidden" name="backend_key" value="<?php echo $backend_key ?>" />
<?php endif; ?>

<div id="menu">
 <span style="float:right">
  <?php
  $menu = &new Menu(HORDE_MENU_MASK_NONE);
  echo $menu->render();
  ?>
 </span>
 <h1 align="center"><?php printf(_("%s Login"), $registry->get('name')) ?></h1>
</div>

<table width="100%"><tr><td align="center"><table width="300" align="center">

<?php if (!empty($reason)): ?>
    <tr>
     <td colspan="2" class="notice"><?php echo $reason ?></td>
    </tr>
<?php endif; ?>

<?php $tabindex = 1; if ($conf['backend']['backend_list'] == 'shown'): ?>
    <tr>
     <td align="right" class="light"><strong><?php echo _("Server") ?></strong></td>
     <td class="light" align="left">
      <select tabindex="<?php echo $tabindex++ ?>" name="backend_key" onchange="gollem_reload()">
       <?php echo $backends_list ?>
      </select>
     </td>
    </tr>
<?php elseif ($conf['backend']['backend_list'] == 'hidden'): ?>
    <tr>
     <td colspan="2" align="center" class="light">
      <?php echo sprintf(_("Connect to: %s"), $GLOBALS['gollem_backends'][$backend_key]['name']) ?>
     </td>
    </tr>
<?php endif; ?>

<?php foreach ($GLOBALS['gollem_backends'][$backend_key]['loginparams'] as $key => $val): ?>
    <tr>
     <td align="right" class="light"><strong><?php echo $val ?></strong></td>
     <td align="left" class="light">
      <input type="text" tabindex="<?php echo $tabindex++ ?>" name="<?php echo $key ?>" value="<?php echo $GLOBALS['gollem_backends'][$backend_key]['params'][$key] ?>" />
     </td>
    </tr>
<?php endforeach; ?>

<?php foreach ($login_vfs[$backend_key]->getRequiredCredentials() as $credential): ?>
<?php if ((($credential == 'username') || ($credential == 'password')) && empty($GLOBALS['gollem_backends'][$backend_key]['hordeauth'])): ?>
    <tr>
     <td align="right" class="light"><strong><?php echo $credentials[$credential]['desc'] ?></strong></td>
     <td align="left"><input tabindex="<?php echo $tabindex++ ?>" type="<?php echo $credentials[$credential]['type'] ?>" name="<?php echo $credential ?>" value="<?php echo Util::getFormData($credential) ?>" /></td>
    </tr>
<?php endif; ?>
<?php endforeach; ?>

<?php if ($choose_language): ?>
    <tr>
     <td align="right" class="light"><strong><?php echo _("Language") ?></strong></td>
     <td align="left" class="light">
      <select tabindex="<?php echo $tabindex++ ?>" name="new_lang" onchange="selectLang()"><?php echo $langs ?></select>
     </td>
    </tr>
<?php endif; ?>

    <tr>
     <td>&nbsp;</td>
     <td class="light"><input class="button" type="submit" name="loginButton" tabindex="<?php echo $tabindex++ ?>" value="<?php echo _("Log in") ?>" onclick="return submit_login();" /></td>
    </tr>
</table></td></tr></table>
</form>

<script type="text/javascript">
<?php if ($choose_language): ?>
function selectLang()
{
    // We need to reload the login page here, but only if the user hasn't
    // already entered a username and password.
    var lang_page = 'login.php?new_lang=' + document.gollem_login.new_lang[document.gollem_login.new_lang.selectedIndex].value;
<?php
    $url = Util::getFormData('url');
    if (!empty($url)) {
        echo "lang_page += '&url=" . urlencode($url) . "';";
    }
?>
    self.location = lang_page;
}
<?php endif; ?>

<!--
<?php if ($gollem_auth): ?>
if (parent.frames.horde_main) {
    document.gollem_login.target = '_parent';
}
<?php endif; ?>

// Set up the enter keytrap code
if (typeof document.captureEvents != 'undefined') {
    document.captureEvents(Event.KEYPRESS);
    document.onkeypress = submit_login;
}
//-->
</script>
