<?php
/**
 * $Horde: gollem/test.php,v 1.5 2005/06/13 23:53:54 slusarz Exp $
 *
 * Copyright 2003-2005 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/* Include Horde's core.php file. */
include_once '../lib/core.php';

/* We should have loaded the String class, from the Horde_Util
   package, in core.php. If String:: isn't defined, then we're not
   finding some critical libraries. */
if (!class_exists('String')) {
    echo '<br /><span style="color: red; font-size: 18px; font-weight: bold;">The Horde_Util package was not found. If PHP\'s error_reporting setting is high enough, there should be error messages printed above that may help you in debugging the problem. If you are simply missing these files, then you need to get the <a href="http://cvs.horde.org/cvs.php/framework">framework</a> module from <a href="http://horde.org/source/">Horde CVS</a>, and install the packages in it with the install-packages.php script.</span>';
    exit;
}

/* Initialize the Horde_Test:: class. */
if (!(@is_readable('../lib/Test.php'))) {
    echo 'ERROR: You must install Horde before running this script.';
    exit;
}
require_once '../lib/Test.php';
$horde_test = &new Horde_Test;

/* Gollem version. */
$module = 'Gollem';
require_once './lib/version.php';
$module_version = GOLLEM_VERSION;

/* Gollem configuration files. */
$file_list = array(
    'config/backends.php' => 'The file <code>./config/backends.php</code> appears to be missing. You probably just forgot to copy <code>./config/backends.php.dist</code> over. While you do that, take a look at the settings and make sure they are appropriate for your site.',
    'config/credentials.php' => 'The file <code>./config/credentials.php</code> appears to be missing. You probably just forgot to copy <code>./config/credentials.php.dist</code> over. While you do that, take a look at the settings and make sure they are appropriate for your site.',
    'config/conf.php' => 'The file <code>./config/conf.php</code> appears to be missing. You probably just forgot to generate it using the Horde config system - see docs/INSTALL for details. While you do that, take a look at the settings and make sure they are appropriate for your site.',
    'config/mime_drivers.php' => 'The file <code>./config/mime_drivers.php</code> appears to be missing. You probably just forgot to copy <code>./config/mime_drivers.php.dist</code> over. While you do that, take a look at the settings and make sure they are appropriate for your site.',
    'config/prefs.php' => 'The file <code>./config/prefs.php</code> appears to be missing. You probably just forgot to copy <code>./config/prefs.php.dist</code> over. While you do that, take a look at the settings and make sure they are appropriate for your site.'
);

require TEST_TEMPLATES . 'header.inc';
require TEST_TEMPLATES . 'version.inc';

/* PHP module capabilities. */
$module_list = array(
    'ftp' => array(
        'descrip' => 'FTP Support',
        'error' => 'You need FTP support compiled into PHP if you plan to use the FTP VFS driver (see config/backends.php).'
    ),
);

/* Display versions of other Horde applications. */
$app_list = array(
    'horde' => array(
        'error' => 'Gollem requires Horde 3.0.0 or greater to operate.',
        'version' => '3.0.0'
    )
);
$app_output = $horde_test->requiredAppCheck($app_list);

?>
<h1>Other Horde Applications</h1>
<ul>
    <?php echo $app_output ?>
</ul>
<?php

/* Display PHP Version information. */
$php_info = $horde_test->getPhpVersionInformation();
require TEST_TEMPLATES . 'php_version.inc';

/* PEAR */
$pear_list = array(
);

/* Get the status output now. */
$module_output = $horde_test->phpModuleCheck($module_list);

?>
<h1>PHP Module Capabilities</h1>
<ul>
    <?php echo $module_output ?>
</ul>

<h1>Gollem Configuration Files</h1>
<ul>
    <?php echo $horde_test->requiredFileCheck($file_list) ?>
</ul>

<h1>PEAR Modules</h1>
<ul>
    <?php echo $horde_test->PEARModuleCheck($pear_list) ?>
</ul>

<?php
require TEST_TEMPLATES . 'footer.inc';
