/*
 * GooCanvas. Copyright (C) 2005 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvasimageview.h - view for image item.
 */
#ifndef __GOO_CANVAS_IMAGE_VIEW_H__
#define __GOO_CANVAS_IMAGE_VIEW_H__

#include <gtk/gtk.h>
#include "goocanvasitemviewsimple.h"
#include "goocanvasimage.h"

G_BEGIN_DECLS


#define GOO_TYPE_CANVAS_IMAGE_VIEW            (goo_canvas_image_view_get_type ())
#define GOO_CANVAS_IMAGE_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_IMAGE_VIEW, GooCanvasImageView))
#define GOO_CANVAS_IMAGE_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_IMAGE_VIEW, GooCanvasImageViewClass))
#define GOO_IS_CANVAS_IMAGE_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_IMAGE_VIEW))
#define GOO_IS_CANVAS_IMAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GOO_TYPE_CANVAS_IMAGE_VIEW))
#define GOO_CANVAS_IMAGE_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GOO_TYPE_CANVAS_IMAGE_VIEW, GooCanvasImageViewClass))


typedef struct _GooCanvasImageView       GooCanvasImageView;
typedef struct _GooCanvasImageViewClass  GooCanvasImageViewClass;

/**
 * GooCanvasImageView
 *
 * The #GooCanvasImageView-struct struct contains private data only.
 */
struct _GooCanvasImageView
{
  GooCanvasItemViewSimple parent_object;
};

struct _GooCanvasImageViewClass
{
  GooCanvasItemViewSimpleClass parent_class;
};


GType              goo_canvas_image_view_get_type (void) G_GNUC_CONST;
GooCanvasItemView* goo_canvas_image_view_new      (GooCanvasView     *canvas_view,
						   GooCanvasItemView *parent_view,
						   GooCanvasImage    *image);


G_END_DECLS

#endif /* __GOO_CANVAS_IMAGE_VIEW_H__ */
