#
# Distribution
#
%define dist rh9

Summary: 		Web Based LDAP Administration Program 
Name:			gosa
Version: 		2.1
Release:		1.%{dist}
License: 		GPL
Group: 			System/Administration
Source: 		ftp://oss.GONICUS.de/pub/gosa/beta/%{name}-%{version}.tar.bz2
URL: 			http://www.GONICUS.de
Buildarch: 		noarch
Prereq: 		php
Prereq:			perl-Crypt-SmbHash >= 0.02
BuildRoot: 		%{_tmppath}/%{name}-%{version}-root
BuildArch:		noarch

%define confdir 	/etc/%{name}

%description
GOsa is a combination of system-administrator and end-user web
interface, designed to handle LDAP based setups.
Provided is access to posix, shadow, samba, proxy, fax, and kerberos
accounts. It is able to manage the postfix/cyrus server combination
and can write user adapted sieve scripts.

%package ldap
Group: 			System/Administration
Summary: 		Schema Definitions for the GOSA package
Requires:		openldap >= 2.0

%description ldap
Contains the Schema definition files for the GOSA admin package.

%prep
%setup -q -n %{name}-%{version}

find . -depth -name CVS -type d | xargs rm -rf

%build

%install
# Create buildroot
mkdir -p %{buildroot}/usr/share/gosa

DIRS="doc ihtml plugins html include locale"

for i in $DIRS; do \
  cp -ua $i %{buildroot}/usr/share/gosa/$i ; \
done

mkdir -p %{buildroot}/var/spool/gosa
# Copy default config
mkdir -p %{buildroot}%{confdir}
cp contrib/gosa.conf %{buildroot}%{confdir}/gosa.conf.ori

cat > %{buildroot}%{confdir}/gosa_include.conf <<EOF
# Set alias to gosa
Alias /gosa /usr/share/gosa/html
EOF

mkdir -p %{buildroot}/etc/openldap/schema/gosa
mv contrib/openldap/* %{buildroot}/etc/openldap/schema/gosa

%clean
rm -rf %{buildroot}

%files
%defattr(-,apache,apache)
%doc %attr(-,root,root) AUTHORS TODO README Changelog COPYING INSTALL contrib

%config(noreplace) %attr(0640,root,apache) %{confdir}/gosa.conf.ori
%config(noreplace) %attr(0640,root,apache) %{confdir}/gosa_include.conf
%dir %attr(0750, apache, apache) /var/spool/gosa
%attr(-, apache, apache) /usr/share/gosa

%files ldap
%defattr(-,root,root)
%doc contrib/slapd.conf COPYING AUTHORS README
/etc/openldap/schema/gosa

%changelog
* Mon Apr 19 2004 Levente Farkas <lfarkas@lfarkas.org> 2.1
- update to 2.1

* Fri Apr 16 2004 Levente Farkas <lfarkas@lfarkas.org> 2.1
- minor fixes
- update to 2.1rc2

* Tue Jan 24 2004 Henning P. Schmiedehausen <hps@intermeta.de> 2.1-2t
- bumped to 2.1beta2
- first INTERMETA internal build

* Mon Oct 20 2003 Lars Scheiter <lars.scheiter@GONICUS.de>
- Update to new upstream release (2.0rc1)
* Fri Oct 17 2003 Lars Scheiter <lars.scheiter@GONICUS.de>
- First build of GOsa as an RPM, should work on SuSE and RedHat
