<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class config  {

  /* XML parser */
  var $parser;
  var $config_found= FALSE;
  var $tags= array();
  var $level= 0;
  var $gpc= 0;
  var $section= "";

  /* Selected connection */
  var $current= array();

  /* Link to LDAP-server */
  var $ldap= NULL;

  /* Configuration data */
  var $data= array( 'TABS' => array(), 'LOCATIONS' => array(), 'SERVERS' => array(),
		'MAIN' => array( 'LANGUAGES' => array(), 'FAXFORMATS' => array() ),
		'MENU' => array(), 'SERVICE' => array());
  var $basedir= "";

  /* Keep a copy of the current deparment list */
  var $departments= array();
  var $idepartments= array();

  function config($filename, $basedir= "")
  {
	$this->parser = xml_parser_create();
	$this->basedir= $basedir;

	xml_set_object($this->parser, &$this);
	xml_set_element_handler($this->parser, "tag_open", "tag_close");

	/* Parse config file directly? */
	if ($filename != ""){
		$this->parse($filename);
	}
  }

  function parse($filename)
  { 
	$fh= fopen($filename, "r"); 
	$xmldata= fread($fh, 100000);
	fclose($fh); 
	if(!xml_parse($this->parser, chop($xmldata))){
		print_red(_("Error: gosa.conf contains no valid XML code!"));
		exit;
	}
  }

  function tag_open($parser, $tag, $attrs)
  { 
	/* Save last and current tag for reference */
	$this->tags[$this->level]= $tag;
	$this->level++;

	/* Trigger on CONF section */
	if ($tag == 'CONF'){
		$this->config_found= TRUE;
	}

	/* Return if we're not in config section */
	if (!$this->config_found){
		return;
	}

	/* Look through attributes */
	switch ($this->tags[$this->level-1]){

		/* Handle tab section */
		case 'TAB':	$name= $this->tags[$this->level-2];
		
				/* Create new array? */
				if (!isset($this->data['TABS'][$name])){
					$this->data['TABS'][$name]= array();
				}

				/* Add elements */
				$this->data['TABS'][$name][]= $attrs;
				break;

		/* Handle location */
		case 'LOCATION':
				if ($this->tags[$this->level-2] == 'MAIN'){
					$name= $attrs['NAME'];

					/* Add location elements */
					$this->data['LOCATIONS'][$name]= $attrs;
				}
				break;

		/* Handle language */
		case 'LANGUAGE':
				if ($this->tags[$this->level-2] == 'MAIN'){
					/* Add languages */
					$this->data['MAIN']['LANGUAGES'][$attrs['NAME']]= 
						$attrs['TAG'];
				}
				break;

		/* Handle faxformat */
		case 'FAXFORMAT':	
				if ($this->tags[$this->level-2] == 'MAIN'){
					/* Add fax formats */
					$this->data['MAIN']['FAXFORMATS'][]= $attrs['TYPE'];
				}
				break;

		/* Load main parameters */
		case 'MAIN':
				$this->data['MAIN']= array_merge ($this->data['MAIN'], $attrs);
				break;

		/* Load menu */
		case 'SECTION':
				if ($this->tags[$this->level-2] == 'MENU'){
					$this->section= $attrs['NAME'];
					$this->data['MENU'][$this->section]= array(); ;
				}
				break;

		/* Inser plugins */
		case 'PLUGIN':
				if ($this->tags[$this->level-3] == 'MENU' &&
				    $this->tags[$this->level-2] == 'SECTION'){
		
					$this->data['MENU'][$this->section][$this->gpc++]= $attrs;
				}
				if ($this->tags[$this->level-2] == 'SERVICEMENU'){
					$this->data['SERVICE'][$attrs['CLASS']]= $attrs;
				}
				break;
	}
  }

  function tag_close($parser, $tag)
  {
	/* Close config section */
	if ($tag == 'CONF'){
		$this->config_found= FALSE;
	}
	$this->level--;
  }

  function get_ldap_link()
  {
	/* Build new connection */
	$this->ldap= ldap_init ($this->current['SERVER'], $this->current['BASE'],
			$this->current['ADMIN'], $this->current['PASSWORD']);

	if ($this->ldap == 0){
		print_red (_("Can't bind to LDAP. Please contact the system administrator."));
		exit;
	}

	return ($this->ldap);
  }

  function set_current($name)
  {
	$this->current= $this->data['LOCATIONS'][$name];
	if (!isset($this->current['PEOPLE'])){
		$this->current['PEOPLE']= "people";
	}
	if (!isset($this->current['GROUPS'])){
		$this->current['GROUPS']= "groups";
	}
	$this->load_servers();
  }

  function load_servers ()
  {
	/* Only perform actions if current is set */
	if ($this->current == NULL){
		return;
	}

	/* Fill imap servers */
	$ldap= $this->get_ldap_link();
	$ldap->cd ($this->current['BASE']);
	$ldap->search ("(objectClass=goImapServer)");

	$this->data['SERVERS']['IMAP']= array();
	while ($attrs= $ldap->fetch()){
		$name= $attrs['goImapName'][0];
		$this->data['SERVERS']['IMAP'][$name]= array( "connect" => $attrs['goImapConnect'][0],
					"admin" => $attrs['goImapAdmin'][0],
					"password" => $attrs['goImapPassword'][0],
					"sieve_server" => $attrs['goImapSieveServer'][0],
					"sieve_port" => $attrs['goImapSievePort'][0]);
	}

	/* Get kerberos server. FIXME: only one is supported currently */
	$ldap->cd ($this->current['BASE']);
	$ldap->search ("(objectClass=goKrbServer)");
	if ($ldap->count()){
		$attrs= $ldap->fetch();
		$this->data['SERVERS']['KERBEROS']= array( 'SERVER' => $attrs['cn'][0],
						'REALM' => $attrs['goKrbRealm'][0],
						'ADMIN' => $attrs['goKrbAdmin'][0],
						'PASSWORD' => $attrs['goKrbPassword'][0]);
	}

	/* Get cups server. FIXME: only one is supported currently */
	$ldap->cd ($this->current['BASE']);
	$ldap->search ("(objectClass=goCupsServer)");
	if ($ldap->count()){
		$attrs= $ldap->fetch();
		$this->data['SERVERS']['CUPS']= $attrs['cn'][0];	
	}

	/* Get fax server. FIXME: only one is supported currently */
	$ldap->cd ($this->current['BASE']);
	$ldap->search ("(objectClass=goFaxServer)");
	if ($ldap->count()){
		$attrs= $ldap->fetch();
		$this->data['SERVERS']['FAX']= array( 'SERVER' => $attrs['cn'][0],
						'LOGIN' => $attrs['goFaxAdmin'][0],
						'PASSWORD' => $attrs['goFaxPassword'][0]);
	}

	/* Get NFS server lists */
	$tmp= array("default");
	$ldap->cd ($this->current['BASE']);
	$ldap->search ("(&(objectClass=goNfsServer)(goExportEntry=*))");
	while ($attrs= $ldap->fetch()){
		for ($i= 0; $i<$attrs["goExportEntry"]["count"]; $i++){
			$path= preg_replace ("/\s.*$/", "", $attrs["goExportEntry"][$i]);
			$tmp[]= $attrs["cn"][0].":$path";
		}
	}
	$this->data['SERVERS']['NFS']= $tmp;


	/* Load Terminalservers */
	$ldap->cd ($this->current['BASE']);
	$ldap->search ("(objectClass=goTerminalServer)");
	$this->data['SERVERS']['TERMINAL'][]= "default";
	$this->data['SERVERS']['FONT'][]= "default";
	while ($attrs= $ldap->fetch()){
		$this->data['SERVERS']['TERMINAL'][]= utf8_decode($attrs["cn"][0]);
		for ($i= 0; $i<$attrs["goFontPath"]["count"]; $i++){
			$this->data['SERVERS']['FONT'][]= $attrs["goFontPath"][$i];
		}
	}

	/* Ldap Server */
	$this->data['SERVERS']['LDAP']= array("default");
	$ldap->cd ($this->current['BASE']);
	$ldap->search ("(objectClass=goLdapServer)");
	while ($attrs= $ldap->fetch()){
		for ($i= 0; $i<$attrs["goLdapBase"]["count"]; $i++){
			$this->data['SERVERS']['LDAP'][]= $attrs["cn"][0].":".$attrs["goLdapBase"][$i];
		}
	}

	/* Get misc server lists */
	$this->data['SERVERS']['SYSLOG']= array("default");
	$this->data['SERVERS']['NTP']= array("default");
	$ldap->cd ($this->current['BASE']);
	$ldap->search ("(objectClass=goNtpServer)");
	while ($attrs= $ldap->fetch()){
		$this->data['SERVERS']['NTP'][]= utf8_decode($attrs["cn"][0]);
	}
	$ldap->cd ($this->current['BASE']);
	$ldap->search ("(objectClass=goSyslogServer)");
	while ($attrs= $ldap->fetch()){
		$this->data['SERVERS']['SYSLOG'][]= utf8_decode($attrs["cn"][0]);
	}

	/* Get samba servers from LDAP, in case of samba3 */
	if ($this->current['SAMBAVERSION'] == 3){
		$this->data['SERVERS']['SAMBA']= array();
		$ldap->cd ($this->current['BASE']);
		$ldap->search ("(objectClass=sambaDomain)");
		while ($attrs= $ldap->fetch()){
			$this->data['SERVERS']['SAMBA'][$attrs['sambaDomainName'][0]]= array(
				"SID" => $attrs["sambaSID"][0],
				"RIDBASE" => $attrs["sambaAlgorithmicRidBase"][0]);
		}

		/* If no samba servers are found, look for configured sid/ridbase */
		if (count($this->data['SERVERS']['SAMBA']) == 0){
			if (!isset($this->current["SID"]) || !isset($this->current["RIDBASE"])){
				print_red(_("SID and/or RIDBASE missing in your configuration!"));
				exit;
			} else {
				$this->data['SERVERS']['SAMBA']['DEFAULT']= array(
					"SID" => $this->current["SID"],
					"RIDBASE" => $this->current["RIDBASE"]);
			}
		}
	}
  }

  function make_idepartments()
  {
  	$this->idepartments= array();
	foreach ($this->departments as $key => $val){
		$this->idepartments[$val]= $key;
	}
  }

}

?>
