<?php

class mailgroup extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage mail groups/shared folders";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* plugin specific values */
  var $mail= "";
  var $uid= "";
  var $cn= "";
  var $gosaMailAlternateAddress= array();
  var $gosaMailForwardingAddress= array();
  var $gosaMailDeliveryMode= "[L        ]";
  var $gosaMailServer= "";
  var $gosaMailQuota= "";
  var $gosaMailMaxSize= "";
  var $gosaVacationMessage= "";
  var $gosaSpamSortLevel= "";
  var $gosaSpamMailbox= "";

  var $quotaUsage= 0;
  var $forward_dialog= FALSE;
  var $admins_dialog= FALSE;
  var $mailboxList= array();
  var $members= array();
  var $default_permissions= "p";
  var $member_permissions= "lrsp";
  var $admins= array();
  var $saved_admins= array();
  var $mailusers= array();
  var $allmailusers= array();
  var $perms= array();

  /* attribute list for save action */
  var $attributes= array("mail", "gosaMailServer", "gosaMailQuota", "gosaMailMaxSize",
			"gosaMailDeliveryMode", "gosaSpamSortLevel", "gosaSpamMailbox",
			"gosaVacationMessage");
  var $objectclasses= array("gosaMailAccount");


  /* constructor, if 'dn' is set, the node loads the given
     'dn' from LDAP */
  function mailgroup ($config, $dn= NULL, $ui= NULL)
  {
        /* Configuration is fine, allways */
        $this->config= $config;

        /* Load bases attributes */
        plugin::plugin($config, $dn);

	/* Convert cn to uid in case of existing entries */
	if (isset($this->attrs['cn'][0])){
		$this->uid= $this->attrs['cn'][0];
	}

	if ($dn != NULL){

		/* Load attributes containing arrays */
		foreach (array("gosaMailAlternateAddress", "gosaMailForwardingAddress") as $val){
			if (isset($this->attrs["$val"]["count"])){
				for ($i= 0; $i<$this->attrs["$val"]["count"]; $i++){
					array_push($this->$val, utf8_decode($this->attrs["$val"][$i]));
				}
			}
		}

		/* Only do IMAP actions if gosaMailServer attribute is set */
		if (isset ($this->attrs["gosaMailServer"][0])){
			$this->getImapAttributes();
		}

	}

	/* Fill translations */
	$this->perms["lrs"]= _("read");
	$this->perms["lrsp"]= _("post");
	$this->perms["p"]= _("external post");
	$this->perms["lrsip"]= _("append");
	$this->perms["lrswipcd"]= _("write");
  }


  function getImapAttributes()
  {
	/* Connect to IMAP server. I don't want to see these warning here... */
	error_reporting (0);
	$cfg= $this->config->data['SERVERS']['IMAP'][$this->gosaMailServer];
	$this->mailboxList[]= "INBOX";
	$mbox = @imap_open($cfg['connect'], $cfg['admin'], $cfg['password'], OP_HALFOPEN);
	error_reporting (E_ALL);

	/* Mailbox reachable? */
	if ($mbox === FALSE){
		print_orange (_("Warning: IMAP Server cannot be reached!"));
	} else {

		/* Load quota settings */
		error_reporting (0);
		$quota_value = imap_get_quota($mbox, $this->uid);
		if(is_array($quota_value)) {
			if (isset($quota_value["STORAGE"]) && is_array($quota_value["STORAGE"])){
				# use for PHP >= 4.3
				$this->quotaUsage= $quota_value["STORAGE"]['usage'];
				$this->gosaMailQuota=  $quota_value["STORAGE"]['limit'];
			} else {
				# backward compatible
				$this->quotaUsage= $quota_value['usage'];
				$this->gosaMailQuota=  $quota_value['limit'];
			}
		}
		error_reporting (E_ALL);

		/* Get list of mailboxes for combo box */
		$list = imap_listmailbox($mbox, $cfg["connect"],
					$this->uid.".*");
		if (is_array($list)){
			foreach ($list as $val){
				$this->mailboxList[]=preg_replace ("/.*".$this->uid."\./",
						"INBOX.", imap_utf7_decode ($val));
			}
		}

		/* imap_getacl available? */
		if (!function_exists('imap_getacl')){
			print_orange (_("Warning: imap_getacl is not available, can't get imap permissions!"));
		}

		/* Get permissions in case of shared folders */
		else {
			$this->admins= array();

			$users= imap_getacl ($mbox, $this->uid);

			/* load permissions, these are all users with "lrswipcda" rights */
			foreach ($users as $userid => $perms){
				if ($perms == "lrswipcda"){
					$this->admins[]= preg_replace("/^user\./", "", $userid);
				}
				if ($userid == 'anyone'){
					$this->default_permissions= $perms;
				}
				if ($userid != "anyone" && $perms != "lrswipcda"){
					$this->member_permissions= $perms;
				}
			}
		} /* get folder permissions */

		/* Close mbox */
		imap_close ($mbox);

	} /* Mailbox reacable */
  }


  function setImapAttributes()
  {
	error_reporting (0);
	$cfg= $this->config->data['SERVERS']['IMAP'][$this->gosaMailServer];
	$mbox = @imap_open($cfg["connect"], $cfg["admin"], $cfg["password"], OP_HALFOPEN);
	error_reporting (E_ALL);

	if ($mbox === FALSE){
		print_red (_("The IMAP server cannot be reached. Note that some changes to mail settings are lost.  Please check the changes later on and save the user settings again in order to let GOsa write the changes."));
	} else {
		/* Check if mailbox exists */
		$list = imap_listmailbox($mbox, $cfg["connect"], $this->uid);
		if ($list === FALSE){
			if (!imap_createmailbox($mbox, $cfg["connect"].$this->uid)){

				print_red(sprintf(_("Can't create IMAP mailbox. Server says '%s'."), imap_last_error()));
				return;
			}
		}

		/* Workaround for the php imap extension */
		if ($this->gosaMailQuota == ""){
			$this->gosaMailQuota= "0";
		}

		/* Write mail quota */
		if (!imap_set_quota($mbox, $this->uid, $this->gosaMailQuota)){
				print_red(sprintf(_("Can't write IMAP quota. Server says '%s'."), imap_last_error()));
				return;
		}

		/* Set shared folder acl's */
		if (function_exists('imap_getacl')){

			/* Remove all acl's */
			$users= imap_getacl ($mbox, $this->uid);
			foreach ($users as $userid => $perms){
				imap_setacl ($mbox, $this->uid, $userid, "");
			}

			imap_setacl ($mbox, $this->uid, "anyone", $this->default_permissions);
			foreach ($this->members as $user){
				imap_setacl ($mbox, $this->uid, $user, $this->member_permissions);
			}
			foreach ($this->admins as $user){
				imap_setacl ($mbox, $this->uid, $user, "lrswipcda");
			}
		}

		/* Show warning message in case of missing imap_getacl */
		if (!function_exists('imap_getacl')){
			print_orange (_("Warning: imap_getacl is not implemented, wouldn't modify acl informations."));
		}
	
		/* Shutdown IMAP connection */
		imap_close($mbox);
	}
  }

  function execute()
  {
	/* Load templating engine */
	$smarty= get_smarty();
	if ($_SESSION['js']==FALSE){
		$smarty->assign("javascript", "false");
	} else {
		$smarty->assign("javascript", "true");
	}

	/* Do we need to flip is_account state? */
	if (isset($_POST['modify_state'])){
		$this->is_account= !$this->is_account;
	}

	/* Do we represent a valid account? */
	if (!$this->is_account && $this->parent == NULL){
		echo "<img src=\"images/stop.png\" align=center>&nbsp;<b>".
		_("This 'dn' has no valid mail extensions.")."</b>";
		return;
	}

	/* Show tab dialog headers */
	if ($this->parent != NULL){
		if ($this->is_account){
			$this->show_header(_("Remove mail account"),
				_("This account has mail features enabled. You can disable them by clicking below."));
		} else {
			$this->show_header(_("Create mail account"),
				_("This account has mail features disabled. You can enable them by clicking below."));
			return;
		}
	}

	/* Check sorting variable */
	$this->check_sortranges();

	/* Trigger forward add dialog? */
	if (isset($_POST['add_local_forwarder'])){
		$this->forward_dialog= TRUE;
		$this->dialog= TRUE;
	}

        /* Cancel forward add dialog? */
        if (isset($_POST['add_locals_cancel'])){
                $this->forward_dialog= FALSE;
                $this->dialog= FALSE;
        }

	/* Edit mailgroup admins? */
        if (isset($_POST['edit_admins'])){
		$this->saved_admins= $this->admins;
                $this->admins_dialog= TRUE;
                $this->dialog= TRUE;
	}

        /* Cancel admins dialog? */
        if (isset($_POST['edit_admins_cancel'])){
                $this->admins_dialog= FALSE;
		$this->admins= $this->saved_admins;
                $this->dialog= FALSE;
        }

	/* Edit admins finished */
	if (isset($_POST['edit_admins_finish'])){
                $this->admins_dialog= FALSE;
                $this->dialog= FALSE;
	}

	/* Finished adding of locals? */
	if (isset($_POST['add_locals_finish'])){
		if (count ($_POST['local_list']) &&
			chkacl ($this->acl, "gosaMailForwardingAddress") == ""){

			/* Walk through list of forwarders, ignore own addresses */
			foreach ($_POST['local_list'] as $val){
				if (!in_array ($val, $this->gosaMailAlternateAddress) &&
					$val != $this->mail){

					$this->addForwarder($val);
				}
			}
		}
		$this->forward_dialog= FALSE;
		$this->dialog= FALSE;
	}

	/* Add forward email addresses */
	if (isset($_POST['add_forwarder'])){
		if ($_POST['forward_address'] != ""){

			/* Valid email address specified? */
			$address= $_POST['forward_address'];
			if (!is_email($address)){

				print_red (_("You're trying to add an invalid email address ".
					"to the list of forwarders."));

			} elseif ($address == $this->mail
				|| in_array($address, $this->gosaMailAlternateAddress)) {

				print_red (_("Adding your one of your own addresses to the forwarders makes no sense."));

			} else {

				/* Add it */
				if (chkacl ($this->acl, "gosaMailForwardingAddress") == ""){
					$this->addForwarder ($address);
				}

			}
		}
	}

	/* Delete forward email addresses */
	if (isset($_POST['delete_forwarder'])){
		if (count($_POST['forwarder_list']) 
			&& chkacl ($this->acl, "gosaMailForwardingAddress") == ""){

			$this->delForwarder ($_POST['forwarder_list']);
		}
	}

	/* Add alternate email addresses */
	if (isset($_POST['add_alternate'])){
		if ($_POST['alternate_address'] != "" &&
			chkacl ($this->acl, "gosaMailAlternateAddress") == ""){

			if (!is_email($_POST['alternate_address'])){
				print_red (_("You're trying to add an invalid email address to the list of alternate addresses."));

			} elseif (($user= $this->addAlternate ($_POST['alternate_address'])) != ""){
				$ui= get_userinfo();
				if ($user != $ui->username){
					print_red (_("The address you're trying to add is already used by user")." '$user'.");
				}
			}
		}
	}

	/* Delete alternate email addresses */
	if (isset($_POST['delete_alternate']) && isset ($_POST['alternates_list'])){
		if (count($_POST['alternates_list']) &&
			chkacl ($this->acl, "gosaMailAlternateAddress") == ""){

			$this->delAlternate ($_POST['alternates_list']);
		}
	}

	/* Add users to administrators */
	if (isset($_POST['add_users']) && isset($_POST['users'])){
		foreach ($_POST['users'] as $value){
			$this->admins["$value"]= $value;
		}
		$this->admins= array_unique($this->admins);
		natsort ($this->admins);
	}

	/* Delete user from administrators */
	if (isset($_POST['del_users']) && isset($_POST['admins'])){
		$this->admins= array_strip($_POST['admins'], $this->admins);
	}

	/* Show edit admins dialog */
	if ($this->admins_dialog){
		$this->mailusers= array ();
		$this->allmailuser= array ();
		$ldap= $this->config->get_ldap_link();
		if (isset ($_POST['department'])){
			$ldap->cd ($_POST['department']);
		} else {
			$ldap->cd ($this->config->current['BASE']);
		}
		$ldap->search ("(&(objectClass=gosaMailAccount)(objectClass=gosaAccount)(!(objectClass=gosaUserTemplate)))");

		error_reporting(0);
		while ($attrs= $ldap->fetch()){
			if (preg_match ($this->sortranges[$this->sorting], $attrs["sn"][0])){
				$this->mailusers[$attrs['uid'][0]]=
					utf8_decode($attrs['sn'][0]).", ".
					utf8_decode($attrs['givenName'][0])." &lt;".
					$attrs['mail'][0]."&gt;";
			}
		}
		natcasesort ($this->mailusers);
		reset ($this->mailusers);

		$ldap->search ("(&(objectClass=gosaMailAccount)(objectClass=gosaAccount)(!(objectClass=gosaUserTemplate)))");
		while ($attrs= $ldap->fetch()){
			$this->allmailusers[$attrs['uid'][0]]=
				utf8_decode($attrs['sn'][0]).", ".
				utf8_decode($attrs['givenName'][0])." &lt;".
				$attrs['mail'][0]."&gt;";
		}
		natcasesort ($this->allmailusers);
		reset ($this->allmailusers);
		error_reporting(E_ALL);

		$admins= array();
		foreach ($this->admins as $value){
			$admins[$value]= $this->allmailusers["$value"];
		}
		$smarty->assign("admins", $admins);

		$mailusers= array();
		foreach ($this->mailusers as $key => $value){
			if (!array_key_exists($key, $this->admins)){
				$mailusers[$key]= $value;
			}
		}
		$smarty->assign("mailusers", $mailusers);

		$smarty->assign("sortranges", get_sort_ranges($this->sortranges));
		if (isset($_POST['department'])){
			$smarty->assign("department", $_POST['department']);
		}
		$smarty->assign("departments", $this->config->idepartments);
		$smarty->display (get_template_path('mail_admins.tpl', TRUE));
		return;
	}

	/* Show forward add dialog */
        if ($this->forward_dialog){
		$ldap= $this->config->get_ldap_link();

		/* Get actual list */
		$mailusers= array ();
		if (isset ($_POST['department'])){
			$ldap->cd ($_POST['department']);
		} else {
			$ldap->cd ($this->config->current['BASE']);
		}
		$ldap->search ("(&(objectClass=gosaMailAccount)(objectClass=gosaAccount)(!(objectClass=gosaUserTemplate)))");
		while ($attrs= $ldap->fetch()){
			if (preg_match ($this->sortranges[$this->sorting], $attrs["sn"][0])){
				$mailusers[$attrs['mail'][0]]= utf8_decode($attrs['sn'][0]).", ".
							utf8_decode($attrs['givenName'][0])." &lt;".
							$attrs['mail'][0]."&gt;";
			}
		}
		natcasesort ($mailusers);
		reset ($mailusers);

                /* Show dialog */
		$smarty->assign("mailusers", $mailusers);
		if (isset($_POST['department'])){
			$smarty->assign("department", $_POST['department']);
		}
		$smarty->assign("departments", $this->config->idepartments);
		$smarty->assign("sortranges", get_sort_ranges($this->sortranges));
		$smarty->display (get_template_path('mail_locals.tpl', TRUE));
                return;
        }

	/* Show main page */
	$mailserver= array();
	foreach ($this->config->data['SERVERS']['IMAP'] as $key => $val){
		$mailserver[]= $key;
	}
	$smarty->assign("mailServers", $mailserver);
	foreach(array("gosaMailServer", "gosaMailQuota", "perms", "mail",
			"gosaMailAlternateAddress", "member_permissions",
			"default_permissions", "gosaMailForwardingAddress") as $val){
		$smarty->assign("$val", $this->$val);
		$smarty->assign("$val"."ACL", chkacl($this->acl, "$val"));
	}
	if (is_numeric($this->gosaMailQuota) && $this->gosaMailQuota != 0){
		$smarty->assign("quotausage", $this->quotaUsage * 100 / $this->gosaMailQuota);
		$smarty->assign("quotadefined", "true");
	} else {
		$smarty->assign("quotadefined", "false");
	}

	$smarty->display (get_template_path('mail.tpl', TRUE));
  }


  /* remove object from parent */
  function remove_from_parent()
  {
        /* include global link_info */
        $ldap= $this->config->get_ldap_link();

        /* Remove and write to LDAP */
        plugin::remove_from_parent();

	/* Zero arrays */
	$this->attrs['gosaMailAlternateAddress']= array();
	$this->attrs['gosaMailForwardingAddress']= array();
	$this->attrs['gosaSharedFolderTarget']= array();

	/* Keep uid */
	unset ($this->attrs['uid']);
	$ldap->cd($this->dn);
        $ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());
  }


  /* Save data to object */
  function save_object()
  {
	/* Assemble mail delivery mode
	   The mode field in ldap consists of values between braces, this must
	   be called when 'mail' is set, because checkboxes may not be set when
	   we're in some other dialog.

	   Example for gosaMailDeliveryMode [LR        ]
	   L: Local delivery
	   R: Reject when exceeding mailsize limit
	   S: Use spam filter
	   V: Use vacation message
	   C: Use custom sieve script
	   I: Only insider delivery */
	if (isset($_POST['mailedit'])){

		/* Save ldap attributes */
		plugin::save_object();

		$tmp= "";
		if (!isset($_POST["drop_own_mails"])){
			$tmp.= "L";
		}
		if (isset($_POST["use_mailsize_limit"])){
			$tmp.= "R";
		}
		if (isset($_POST["use_spam_filter"])){
			$tmp.= "S";
		}
		if (isset($_POST["use_vacation"])){
			$tmp.= "V";
		}
		if (isset($_POST["own_script"])){
			$tmp.= "C";
		}
		if (isset($_POST["only_local"])){
			$tmp.= "I";
		}
		$tmp= "[$tmp]";

		if (chkacl ($this->acl, "gosaMailDeliveryMode") == ""){
			$this->gosaMailDeliveryMode= $tmp;
		}

		$this->member_permissions= $_POST['member_permissions'];
		$this->default_permissions= $_POST['default_permissions'];
	}
  }


  /* Save data to LDAP, depending on is_account we save or delete */
  function save()
  {
	$ldap= $this->config->get_ldap_link();

	/* Call parents save to prepare $this->attrs */
	plugin::save();

	/* Save arrays */
	$this->attrs['gosaMailAlternateAddress']= $this->gosaMailAlternateAddress;
	$this->attrs['gosaMailForwardingAddress']= $this->gosaMailForwardingAddress;

	/* Save shared folder target */
	$this->attrs['gosaSharedFolderTarget']= "share+".$this->uid;

	/* Save data to LDAP */
	$ldap->cd($this->dn);
	$ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());

	/* Only do IMAP actions if we are not a template */
	if (!$this->is_template){
		$this->setImapAttributes();
	}
  }

  /* Check formular input */
  function check()
  {
	$ldap= $this->config->get_ldap_link();

	$message= array();

	/* must: mail */
	if ($this->mail == ""){
		$message[]= _("The required field 'Primary address' is not set.");
	}
	if (!is_email($this->mail)){
		$message[]= _("Please enter a valid email addres in 'Primary address' field.");
	}
	$ldap->cd($this->config->current['BASE']);
	$ldap->search ("(&(|(mail=".$this->mail.")(gosaMailAlternateAddress=".
		$this->mail."))(!(uid=".$this->cn."))(!(cn=".$this->cn.")))");
	if ($ldap->count() != 0){
		$message[]= _("The primary address you've entered is already in use.");
	}

	/* Check quota */
	if ($this->gosaMailQuota != '' && chkacl ($this->acl, "gosaMailQuota") == ""){
		if (!is_numeric($this->gosaMailQuota)) {
			$message[]= _("Value in 'Quota size' is not valid.");
		} else {
			$this->gosaMailQuota= (int) $this->gosaMailQuota;
		}
	}

	/* Check rejectsize for integer */
	if ($this->gosaMailMaxSize != '' && chkacl ($this->acl, "gosaMailQuota") == ""){
		if (!is_numeric($this->gosaMailMaxSize)){
			$message[]= _("Please specify a vaild mail size for mails to be rejected.");
		} else {
			$this->gosaMailMaxSize= (int) $this->gosaMailMaxSize;
		}
	}

	/* Need gosaMailMaxSize if use_mailsize_limit is checked */
	if (is_integer(strpos($this->gosaMailDeliveryMode, "reject")) && $this->gosaMailMaxSize == ""){
		$message[]= _("You need to set the maximum mail size in order to reject anything.");
	}

	return ($message);
  }

  /* Adapt from template, using 'dn' */
  function adapt_from_template($dn)
  {
	plugin::adapt_from_template($dn);

	foreach (array("gosaMailAlternateAddress", "gosaMailForwardingAddress") as $val){
		$this->$val= array();
		if (isset($this->attrs["$val"]["count"])){
			for ($i= 0; $i<$this->attrs["$val"]["count"]; $i++){
				$value= utf8_decode($this->attrs["$val"][$i]);
				foreach (array("sn", "givenName", "uid") as $repl){
					if (preg_match("/%$repl/i", $value)){
						$value= preg_replace ("/%$repl/i", $this->parent->$repl, $value);
					}
				}
				array_push($this->$val, $value);
			}
		}
      }
  }

  /* Add entry to forwarder list */
  function addForwarder($address)
  {
	$this->gosaMailForwardingAddress[]= $address;
	$this->gosaMailForwardingAddress= array_unique ($this->gosaMailForwardingAddress);

	sort ($this->gosaMailForwardingAddress);
	reset ($this->gosaMailForwardingAddress);
  }

  /* Remove list of addresses from forwarder list */
  function delForwarder($addresses)
  {
	$this->gosaMailForwardingAddress= array_strip ($addresses, $this->gosaMailForwardingAddress);
  }



  function addAlternate($address)
  {
	$ldap= $this->config->get_ldap_link();

	$address= strtolower($address);

	/* Is this address already assigned in LDAP? */
	$ldap->cd ($this->config->current['BASE']);
	$ldap->search ("(&(objectClass=gosaMailAccount)(|(mail=$address)".
				"(gosaMailAlternateAddress=$address)))");

	if ($ldap->count() > 0){
		$attrs= $ldap->fetch ();
		return ($attrs["uid"][0]);
	}

	/* Add to list of alternates */
	if (!in_array($address, $this->gosaMailAlternateAddress)){
		$this->gosaMailAlternateAddress[]= $address;
	}

	sort ($this->gosaMailAlternateAddress);
	reset ($this->gosaMailAlternateAddress);

	return ("");
  }


  function delAlternate($addresses)
  {
	$this->gosaMailAlternateAddress= array_strip ($addresses, $this->gosaMailAlternateAddress);
  }

}

?>
