<?php
class terminfo extends plugin
{
  /* CLI vars */
  var $cli_summary= "Retrieve informations about terminals";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Generic terminal attributes */
  var $ghCpuType= "-";
  var $ghMemSize= "-";
  var $macAddress= "-";
  var $ghUsbSupport= "-";
  var $ghNetNic= array();
  var $ghIdeDev= array();
  var $ghScsiDev= array();
  var $ghGfxAdapter= "-";
  var $ghSoundAdapter= "-";
  var $gotoLastUser= "-";
  var $gotoFloppyEnable= "";
  var $gotoCdromEnable= "";

  /* Needed values and lists */
  var $base= "";
  var $cn= "";

  /* attribute list for save action */
  var $attributes= array("cn", "gotoMode", "gotoTerminalPath", "gotoFloppyEnable", "gotoCdromEnable",
			"gotoSwapServer", "gotoSyslogServer", "gotoNtpServer",
			"ghCpuType", "ghMemSize", "macAddress", "ghUsbSupport",
			"ghGfxAdapter", "ghSoundAdapter", "gotoLastUser");
  var $objectclasses= array("gotoTerminal", "GOhard");

  function terminfo ($config, $dn= NULL)
  {
	plugin::plugin ($config, $dn);

	/* Read arrays */
	foreach (array("ghNetNic", "ghIdeDev", "ghScsiDev") as $val){
		if (!isset($this->attrs[$val])){
			continue;
		}
		for ($i= 0; $i<$this->attrs[$val]['count']; $i++){
			array_push($this->$val, $this->attrs[$val][$i]);
		}
	}

	/* Fix USB entry */
	if ($this->ghUsbSupport == "true"){
		$this->ghUsbSupport= _("present");
	}
  }

  function execute()
  {
	/* Do we represent a valid terminal? */
	if (!$this->is_account && $this->parent == NULL){
		echo "<img src=\"images/stop.png\" align=center>&nbsp;<b>".
		_("This 'dn' has no terminal features.")."</b>";
		return;
	}

	/* Take action on selected system? */
	if (isset($_POST['action'])){
		switch($_POST['saction']){
			case 'wake':
				$cmd= $this->search($this->config->data['TABS'], "terminfo", "WAKECMD");
				if ($cmd == ""){
					print_red(_("No WAKECMD definition found in your gosa.conf"));
				} else {
					exec ($cmd." ".$this->macAddress, $dummy, $retval);
					if ($retval != 0){
						print_red(sprintf(_("Execution of '%s' failed!"), $cmd));
					}
				}
				break;

			case 'reboot':
				$cmd= $this->search($this->config->data['TABS'], "terminfo", "REBOOTCMD");
				if ($cmd == ""){
					print_red(_("No REBOOTCMD definition found in your gosa.conf"));
				} else {
					exec ($cmd." ".$this->cn, $dummy, $retval);
					if ($retval != 0){
						print_red(sprintf(_("Execution of '%s' failed!"), $cmd));
					}
				}
				break;

			case 'halt':
				$cmd= $this->search($this->config->data['TABS'], "terminfo", "HALTCMD");
				if ($cmd == ""){
					print_red(_("No HALTCMD definition found in your gosa.conf"));
				} else {
					exec ($cmd." ".$this->cn, $dummy, $retval);
					if ($retval != 0){
						print_red(sprintf(_("Execution of '%s' failed!"), $cmd));
					}
				}
				break;
		}
	}

	/* Default entry? */
	if ($this->cn == "default"){
		echo "<div style='height:150px;'><br><b>";
		echo _("This is a virtual terminal which has no properties to show here.");
		echo "</b></div>";
	} else {
		/* Get template object */
		$smarty= get_smarty();

		/* Check if terminal is online */
		$query= "fping -q -r 1 -t 500 ".$this->cn;
		exec ($query, $dummy, $retval);

		if ($retval == 0){
			$smarty->assign("status", _("online"));
			$smarty->assign("active", "true");
			$actions= array("halt" => _("Switch off"), "reboot" => _("Reboot"));

			/* Fill data if we have snmp */
			$host= $this->cn;
			$community= 'goto';

			/* Get memory informations */
			$MemFree= @snmpget($host, $community, "UCD-SNMP-MIB::memory.memAvailReal.0");
			if ($MemFree != FALSE){
				$MemFree= preg_replace('/^.*= ([0-9.]+)$/', '\\1', $MemFree);
				$MemTotal= @snmpget($host, $community, "UCD-SNMP-MIB::memory.memTotalReal.0");
				$MemTotal= preg_replace('/^.*= ([0-9.]+)$/', '\\1', $MemTotal);
				if ($MemTotal != 0){
					$smarty->assign("mem", (int)(($MemTotal - $MemFree))*100/$MemTotal);
				}
				$SwapFree= @snmpget($host, $community, "UCD-SNMP-MIB::memory.memAvailReal.0");
				$SwapFree= preg_replace('/^.*= ([0-9.]+)$/', '\\1', $SwapFree);
				$SwapTotal= @snmpget($host, $community, "UCD-SNMP-MIB::memory.memTotalReal.0");
				$SwapTotal= preg_replace('/^.*= ([0-9.]+)$/', '\\1', $SwapTotal);
				if ($SwapTotal != 0){
					$smarty->assign("mem", (int)(($SwapTotal - $SwapFree))*100/$SwapTotal);
				}

				/* Get system uptime */
				$sysup= @snmpget($host, $community, "system.sysUpTime.0");
				$smarty->assign("uptime", preg_replace('/^.* ([0-9:]+)\..*$/', '\\1', $sysup));

				/* Get system load */
				$sysload= @snmpget($host, $community, "UCD-SNMP-MIB::laLoad.2");
				$sysload= preg_replace('/^.*= ([0-9.]+)$/', '\\1', $sysload);
				$smarty->assign("load", $sysload*100);
							
				/* Get status for key processes */
				$processes= @snmpwalk($host, $community, "UCD-SNMP-MIB::prNames");
				$check4= array("sshd", "cupsd", "artsd", "X", "saned");
				foreach ($check4 as $pname){
					$eflag= -1;
					foreach ($processes as $key => $val){
						$process= preg_replace('/^.*= (.*)$/', '\\1', $val);
						if ($process == $pname){
							$index= preg_replace('/^.*\.([0-9]+) = .*$/', '\\1', $val);
							$res= @snmpget($host, $community, "UCD-SNMP-MIB::prErrorFlag.$index");
							$eflag= preg_replace('/^.*= /', '', $res);
							break;
						}
					}
					switch ($eflag){
						case 0:
							$smarty->assign("$pname", "<font style='color:green'>"._("running")."</font>");
							break;
						case 1:
							$smarty->assign("$pname", "<font style='color:red'>"._("not running")."</font>");
							break;
						default:
							$smarty->assign("$pname", _("not defined"));
					}
				}
			} else {
				foreach(array("uptime", "sshd", "X", "saned", "artsd", "cupsd") as $val){
					$smarty->assign("$val", "<i>"._("unknown status")."</i>");
				}
			}
		} else {
			$smarty->assign("status", _("offline"));
			$smarty->assign("active", "false");
			$actions= array("wake" => _("Wake up"));
		}

		/* Sort and assign actions */
		natsort($actions);
		$smarty->assign("actions", $actions);

		/* Set floppy and cdrom status */
		foreach(array("Floppy", "Cdrom") as $val){
			$name= "goto".$val."Enable";
			if ($this->$name == "YES"){
				$status= _("present");
			} else {
				$status= "-";
			}
			$smarty->assign($val."Device", $status);
		}

		/* Show main page */
		foreach(array("ghNetNic", "ghIdeDev", "ghScsiDev") as $val){
			if (!count($this->$val)){
				$this->$val= "-";
			}
			$smarty->assign($val, $this->$val);
		}
		foreach(array("ghCpuType", "ghMemSize", "macAddress", "ghUsbSupport",
			"ghGfxAdapter", "ghSoundAdapter", "gotoLastUser") as $val){

			$smarty->assign($val, $this->$val);
		}
		$smarty->display (get_template_path('info.tpl', TRUE));
	}
  }

  function remove_from_parent()
  {
	$ldap= $this->config->get_ldap_link();
	$ldap->rmdir($this->dn);
	show_ldap_error($ldap->get_error());
  }


  /* Save data to object */
  function save_object()
  {
	plugin::save_object();
  }



  /* Save to LDAP */
  function save()
  {
  }

}

?>
