<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
require "tabs_terminal.inc";

class terminals extends plugin
{
  /* Dialog attributes */
  var $termtab= NULL;
  var $terminals= array();
  var $ui= NULL;
  var $acl= "";

  function terminals ($config, $ui)
  {
	/* Save configuration for internal use */
	$this->config= $config;
	$this->ui= $ui;
	
        /* Get global filter config */
	if (!is_global("terminalfilter")){
                $ui= get_userinfo();
                $base= get_base_from_people($ui->dn);
		$terminalfilter= array("textterms" => "checked",
				"gfxterms" => "checked",
				"debugterms" => "checked",
				"disabledterms" => "checked",
				"user" => "",
				"depselect" => $base,
				"regex" => "");
		register_global("terminalfilter", $terminalfilter);
	}
  }

  function execute()
  {
        /* Save data */
        $terminalfilter= get_global("terminalfilter");
        foreach( array("depselect", "user", "regex") as $type){
                if (isset($_POST[$type])){
                        $terminalfilter[$type]= $_POST[$type];
                }
        }
        if (isset($_POST['depselect'])){
                foreach( array("textterms", "gfxterms", "debugterms", "disabledterms") as $type){

                        if (isset($_POST[$type])) {
                                $terminalfilter[$type]= "checked";
                        } else {
                                $terminalfilter[$type]= "";
                        }
                }
        }
        register_global("terminalfilter", $terminalfilter);

        /* Check sorting variable */
	$this->check_sortranges();
	if (!isset($this->termtab)){
                $this->reload();
        }
	$smarty= get_smarty();

	/* Create new default terminal */
	if (isset($_POST['new_terminal'])) {
		$this->dn= "new";
		$this->acl= "#all#";
	
		$this->termtab= new termtabs($this->config,
			$this->config->data['TABS']['TERMTABS'], $this->dn);
		$this->termtab->set_acl (array($this->acl));
		$this->termtab->by_object['termgeneric']->cn= "default";
		$this->termtab->by_object['termservice']->cn= "default";
	}

	/* User wants to edit data? */
	if (isset($_POST['select_terminal']) && isset($_POST['termlist']) &&
		 $_POST['termlist'] != ""){

		/* Get 'dn' from posted 'cn', must be unique */
		$this->dn= $_POST['termlist'];

		/* Check locking, save current plugin in 'back_plugin', so
		   the dialog knows where to return. */
		if (($user= get_lock($this->dn)) != ""){
			gen_locked_message ($user, $this->dn);
			return;
		}

		/* Lock the current entry, so everyone will get the
		   above dialog */
		add_lock ($this->dn, $this->ui->dn);

		/* Set up the users ACL's for this 'dn' */
		$acl= get_permissions ($this->dn, $this->ui->subtreeACL);

		/* Register termtab to trigger edit dialog */
		$this->termtab= new termtabs($this->config,
					$this->config->data['TABS']['TERMTABS'], $this->dn);
		$this->termtab->set_acl($acl);
	}

	/* Set terminals root password */
	if (isset($_POST['set_password']) && isset($_POST['termlist'])){
		$this->dn= $_POST['termlist'];
        	$smarty->display(get_template_path('password.tpl', TRUE));
		return;
	}
	
	/* Correctly specified? */
	if (isset($_POST['password_finish'])){
		if ($_POST['new_password'] != $_POST['repeated_password']){
			print_red (_("Passwords entered as new and repeated do not match!"));
        		$smarty->display(get_template_path('password.tpl', TRUE));
			return;
		}
	}

	/* Change terminal password */
	if (isset($_POST['password_finish']) && 
		$_POST['new_password'] == $_POST['repeated_password']){

		/* Check if user is allowed to set password */
		$acl= get_permissions ($this->dn, $this->ui->subtreeACL);
		$acl= get_module_permission($acl, "terminal", $this->dn);
		if (chkacl($acl, "password") != ""){
			print_red (_("You are not allowed to set this systems password!"));
		} else {
			$ldap= $this->config->get_ldap_link();
			$ldap->cd($this->dn);

			$attrs= array();
			if ($_POST['new_password'] == ""){
				$attrs['gotoRootPasswd']= array();
			} else {
				$attrs['gotoRootPasswd']= crypt($_POST['new_password'],
								substr(session_id(),0,2));
			}
			$ldap->modify($attrs);
			gosa_log ("Password for '".$this->dn."' has been changed");
		}
	}

	/* Delete terminal canceled? */
	if (isset($_POST['delete_cancel']) || isset($_POST['password_cancel'])){
		del_lock ($this->dn);
	}

	/* Remove terminal was requested */
	if (isset($_POST['delete_terminal']) && isset($_POST['termlist'])){

		/* Get 'dn' from posted termlinst */
		$this->dn= $_POST['termlist'];

		/* Load permissions for selected 'dn' and check if
		   we're allowed to remove this 'dn' */
		$acl= get_permissions ($this->dn, $this->ui->subtreeACL);
		$this->acl= get_module_permission($acl, "terminal", $this->dn);
		if (chkacl($this->acl, "delete") == ""){

			/* Check locking, save current plugin in 'back_plugin', so
			   the dialog knows where to return. */
			if (($user= get_lock($this->dn)) != ""){
				gen_locked_message ($user, $this->dn);
				exit ();
			}

			/* Lock the current entry, so nobody will edit it during deletion */
			add_lock ($this->dn, $this->ui->dn);
			$smarty->assign("warning", sprintf(_("You're about to delete all information about the terminal at '%s'."), utf8_decode($this->dn)));
        		$smarty->display(get_template_path('remove.tpl', TRUE));
			return;
		} else {

			/* Obviously the user isn't allowed to delete. Show message and
			   clean session. */
			print_red (_("You are not allowed to delete this terminal!"));
		}
	}

	/* Confirmation for deletion has been passed. Terminal should be deleted. */
	if (isset($_POST['delete_terminal_confirm'])){

		/* Some nice guy may send this as POST, so we've to check
		   for the permissions again. */
		if (chkacl($this->acl, "delete") == ""){

			/* Delete request is permitted, perform LDAP action */
			$this->termtab= new termtabs($this->config,
				$this->config->data['TABS']['TERMTABS'], $this->dn);
			$this->termtab->set_acl(array($this->acl));
			$this->termtab->by_object['termgeneric']->remove_from_parent ();
			unset ($this->termtab);
			gosa_log ("Terminal object'".$this->dn."' has been removed");
			$this->termtab= NULL;

			/* Terminal list has changed, reload it. */
			$this->reload ();
		} else {

			/* Normally this shouldn't be reached, send some extra
			   logs to notify the administrator */
			print_red (_("You are not allowed to delete this terminal!"));
			gosa_log ("Warning: '".$this->ui->uid."' tried to trick terminal ".
				"deletion.");
		}

		/* Remove lock file after successfull deletion */
		del_lock ($this->dn);
	}

	/* Finish user edit is triggered by the tabulator dialog, so
	   the user wants to save edited data. Check and save at this
	   point. */
	if (isset($_POST['edit_finish'])){

		/* Check tabs, will feed message array */
		$message= $this->termtab->check(TRUE);

		/* Save, or display error message? */
		if (count($message) == 0){

			/* Save terminal data to ldap */
			gosa_log ("Terminal object'".$this->dn."' has been saved");
			$this->termtab->save();

			/* Terminal has been saved successfully, remove lock from
			   LDAP. */
			if ($this->dn != "new"){
				del_lock ($this->dn);
			}

			/* There's no page reload so we have to read new terminals at
			   this point. */
			$this->reload ();
			unset ($this->termtab);
			$this->termtab= NULL;

		} else {
			/* Ok. There seem to be errors regarding to the tab data,
			   show message and continue as usual. */
			show_errors($message);
		}

	}

	/* Cancel dialogs */
	if (isset($_POST['edit_cancel']) || isset($_POST['password_cancel'])){
		del_lock ($this->termtab->dn);
		unset ($this->termtab);
		$this->termtab= NULL;
	}

	/* Show tab dialog if object is present */
	if ($this->termtab){
		$this->termtab->execute();

		/* Don't show buttons if tab dialog requests this */
		if (!$this->termtab->by_object[$this->termtab->current]->dialog){
			echo "<p style=\"text-align:right\">\n";
			echo "<input type=submit name=\"edit_finish\" value=\""._("Finish")."\">\n";
			echo "&nbsp;\n";
			echo "<input type=submit name=\"edit_cancel\" value=\""._("Cancel")."\">\n";
			echo "</p>";
		}
		return;
	}

	/* Show main page */
	$smarty->assign("terminals", $this->terminals);
        $smarty->assign("sortranges", get_sort_ranges($this->sortranges));
        $smarty->assign("infoimage", get_template_path('images/info.png'));
        $smarty->assign("launchimage", get_template_path('images/launch.png'));
        foreach( array("depselect", "user", "regex", "textterms", "gfxterms",
                        "debugterms", "disabledterms") as $type){

                $smarty->assign("$type", $terminalfilter[$type]);
        }
	$smarty->assign("deplist", $this->config->idepartments);

	/* Extend if we are not using javascript */
	$smarty->assign("apply", apply_filter());

        $smarty->display(get_template_path('headpage.tpl', TRUE));
  }


  function remove_from_parent()
  {
	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
  }


  /* Check values */
  function check()
  {
  }


  /* Save to LDAP */
  function save()
  {
  }

  function adapt_from_template($dn)
  {
  }

  function password_change_needed()
  {
  }

  function show_header($button_text, $text, $disabled= FALSE)
  {
  }

  function reload()
  {
	/* Load terminal shortcuts */
	$responsible= array();
	foreach ($this->config->departments as $key => $value){
		if (get_module_permission(get_permissions ($value, $this->ui->subtreeACL),
			      "terminal", $value) == "#all#"){
			$responsible[$key]= $value;
		}
	}
	$this->last_sorting= "invalid";

       /* Get config */
        $terminalfilter= get_global('terminalfilter');

        /* Set base for all searches */
        $base= $terminalfilter['depselect'];

	/* Regex filter? */
        if ($terminalfilter['regex'] != ""){
                $regex= $terminalfilter['regex'];
        } else {
                $regex= "";
        }

        /* User filter? */
        if ($terminalfilter['user'] != ""){
                $filter= "(gotoLastUser=".$terminalfilter['user'].")";
        } else {
                $filter= "";
        }

	/* Get list of terminals to be shown */
	$ldap= $this->config->get_ldap_link();
	$showTerms= array();
        if ($terminalfilter['textterms'] == "checked"){
                $ldap->cd($base);
                $ldap->search("(&(objectClass=gotoTerminal)(gotoMode=text)$filter)");
                while ($attrs= $ldap->fetch()){
                        $showTerms[$attrs['cn'][0]]= $attrs['cn'][0];
                }
        }
        if ($terminalfilter['gfxterms'] == "checked"){
                $ldap->cd($base);
                $ldap->search("(&(objectClass=gotoTerminal)(gotoMode=graphic)$filter)");
                while ($attrs= $ldap->fetch()){
                        $showTerms[$attrs['cn'][0]]= $attrs['cn'][0];
                }
        }
        if ($terminalfilter['debugterms'] == "checked"){
                $ldap->cd($base);
                $ldap->search("(&(objectClass=gotoTerminal)(gotoMode=debug)$filter)");
                while ($attrs= $ldap->fetch()){
                        $showTerms[$attrs['cn'][0]]= $attrs['cn'][0];
                }
        }
        if ($terminalfilter['disabledterms'] == "checked"){
                $ldap->cd($base);
                $ldap->search("(&(objectClass=gotoTerminal)(gotoMode=disabled)$filter)");
                while ($attrs= $ldap->fetch()){
                        $showTerms[$attrs['cn'][0]]= $attrs['cn'][0];
                }
        }

	/* Nothing to show? */
        if (count($showTerms) == 0){
                $this->terminals= array();
                return;
        }

	/* Get all gotoTerminal's */
	$this->terminals= array();
	$res= get_list($this->ui->subtreeACL, "(objectClass=gotoTerminal)");
	foreach ($res as $value){

		/* Unwanted? */
		if (!isset($showTerms[$value['cn'][0]])) continue;
		if ($regex != "" && !preg_match("/$regex/", $value['cn'][0])) continue;

		/* Look for new terminals and mark them with '+' */
		$tmp= preg_replace("/^[^,]+,[^o]*ou=terminals,ou=systems,/", "", $value["dn"]);
		if (preg_match ("/,ou=incoming,/", $tmp)){
			$add= "+"._("New terminal");
		} else {
			$add= "";
		}

		if (in_array ($tmp, $responsible) || $add != ""){
			preg_match ($this->sortranges[$this->sorting], $value["cn"][0]);

			if (isset($value["macAddress"][0]) &&
				$value["macAddress"][0] != "-"){

				$this->terminals[$value["dn"]]= $add." ".
						$value["cn"][0].
						" [".$value["macAddress"][0]."]";
			} else {
				$location= array_search($tmp, $this->config->departments);
				$this->terminals[$value["dn"]]= "-"._("Default for").
								" $location";
			}
		}
	}
	natcasesort ($this->terminals);
	reset ($this->terminals);
  }

  function remove_lock()
  {
        del_lock ($this->termtab->dn);
  }


}

?>
