<?php
/* Load sieve support */
@require_once ("sieve-php.inc");

/*! \brief   mail plugin
    \author  Cajus Pollmeier <pollmeier@gonicus.de>
    \version 2.00
    \date    24.07.2003

    This class provides the functionality to read and write all attributes
    relevant for gosaMailAccounts from/to the LDAP. It does syntax checking
    and displays the formulars required.
 */

class mailAccount extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage users mail account";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* plugin specific values */
  var $mail= "";
  var $uid= "";
  var $gosaMailAlternateAddress= array();
  var $gosaMailForwardingAddress= array();
  var $gosaMailDeliveryMode= "[L        ]";
  var $gosaMailServer= "";
  var $gosaMailQuota= "";
  var $gosaMailMaxSize= "";
  var $gosaVacationMessage= "";
  var $gosaSpamSortLevel= "";
  var $gosaSpamMailbox= "";

  var $quotaUsage= 0;
  var $forward_dialog= FALSE;
  var $folder_prefix= "";
  var $mailboxList= array();
  var $default_permissions= "none";
  var $member_permissions= "post";
  var $members= array();
  var $admins= array();
  var $vacations= array();
  var $perms= array( "lrs" => "read", "lrsp" => "post", "lrsip" => "append",
			"lrswipcd" => "write", "lrswipcda" => "all" );

  /* attribute list for save action */
  var $attributes= array("mail", "gosaMailServer", "gosaMailQuota", "gosaMailMaxSize",
			"gosaMailDeliveryMode", "gosaSpamSortLevel", "gosaSpamMailbox",
			"gosaVacationMessage", "uid");
  var $objectclasses= array("gosaMailAccount");


  /* constructor, if 'dn' is set, the node loads the given
     'dn' from LDAP */
  function mailAccount ($config, $dn= NULL)
  {
        /* Configuration is fine, allways */
        $this->config= $config;

        /* Load bases attributes */
        plugin::plugin($config, $dn);

	/* Preset folder prefix. Will change it later to respect
	   altnamespace. */
	$this->folder_prefix= "user.";

	if ($dn != NULL){

		/* Load attributes containing arrays */
		foreach (array("gosaMailAlternateAddress", "gosaMailForwardingAddress") as $val){
			if (isset($this->attrs["$val"]["count"])){
				for ($i= 0; $i<$this->attrs["$val"]["count"]; $i++){
					array_push($this->$val, utf8_decode($this->attrs["$val"][$i]));
				}
			}
		}

		/* Only do IMAP actions if gosaMailServer attribute is set */
		if (isset ($this->attrs["gosaMailServer"][0])){
			$this->getImapAttributes();
		}

	}

	/* Fill vacation array */
	$this->vacation= array();
	if (isset($this->config->current['VACATIONDIR'])){
		$dir= $this->config->current['VACATIONDIR'];
		if (is_dir($dir) && is_readable($dir)){

			/* Look for files and build the vacation array */
			$dh= opendir($dir);
			while ($file = readdir($dh)){
				$description= $this->parse_vacation("$dir/$file");
				if ($description != ""){
					$this->vacation["$dir/$file"]= $description;
				}
			}
			closedir($dh);
		}
	}
  }


  function parse_vacation($file)
  {
	$desc= "";

	if (is_file($file)){
		$fh = fopen($file, "r");
		$line= fgets($fh, 256);

		if (!preg_match('/^DESC:/', $line)){
			print_red (_("No DESC tag in vacation file:")." $file");
			return $desc;
		}
		fclose ($fh);

		$desc= trim(preg_replace('/^DESC:\s*/', '', $line));
	}
	
	return $desc;
  }


  function getImapAttributes()
  {
	/* Connect to IMAP server. I don't want to see these warning here... */
	error_reporting (0);
	$cfg= $this->config->data['SERVERS']['IMAP'][$this->gosaMailServer];
	$this->mailboxList[]= "INBOX";
	$mbox = @imap_open($cfg['connect'], $cfg['admin'], $cfg['password'], OP_HALFOPEN);
	error_reporting (E_ALL);

	/* Mailbox reachable? */
	if ($mbox === FALSE){
		print_orange (_("Warning: IMAP Server cannot be reached!"));
	} else {

		/* Load quota settings */
		error_reporting (0);
		$quota_value = @imap_get_quota($mbox, $this->folder_prefix.$this->uid);
		if(is_array($quota_value)) {
			if (isset($quota_value["STORAGE"]) && is_array($quota_value["STORAGE"])){
				# use for PHP >= 4.3
				$this->quotaUsage= $quota_value["STORAGE"]['usage'];
				$this->gosaMailQuota=  $quota_value["STORAGE"]['limit'];
			} else {
				# backward compatible
				$this->quotaUsage= $quota_value['usage'];
				$this->gosaMailQuota=  $quota_value['limit'];
			}
		}
		error_reporting (E_ALL);

		/* Get list of mailboxes for combo box */
		$list = imap_listmailbox($mbox, $cfg["connect"],
					$this->folder_prefix.$this->uid.".*");
		if (is_array($list)){

			foreach ($list as $val){
				$this->mailboxList[]=preg_replace ("/.*user\.".$this->uid."\./",
							"INBOX.", imap_utf7_decode ($val));
			}
		}

		/* Close mbox */
		imap_close ($mbox);

	} /* Mailbox readable */
  }


  function setImapAttributes()
  {
	error_reporting (0);
	$cfg= $this->config->data['SERVERS']['IMAP'][$this->gosaMailServer];
	$mbox = @imap_open($cfg["connect"], $cfg["admin"], $cfg["password"], OP_HALFOPEN);
	error_reporting (E_ALL);

	if ($mbox === FALSE){
		print_red (_("The IMAP server cannot be reached. Note that some changes to mail settings are lost.  Please check the changes later on and save the user settings again in order to let GOsa write the changes."));
		return (FALSE);
	} else {

		/* Check if mailbox exists */
		$list = imap_listmailbox($mbox, $cfg["connect"],
			$this->folder_prefix.$this->uid);
		if ($list === FALSE){
			if (!imap_createmailbox($mbox, $cfg["connect"].
				$this->folder_prefix.$this->uid)){

				print_red(sprintf(_("Can't create IMAP mailbox. Server says '%s'."), imap_last_error()));
                                return;
			}
		}

		/* Workaround for the php imap extension */
		if ($this->gosaMailQuota == ""){
			$this->gosaMailQuota= "0";
		}

		/* Write mail quota */
		if (!imap_set_quota($mbox, $this->folder_prefix.$this->uid, $this->gosaMailQuota)){
				print_red(sprintf(_("Can't write IMAP quota. Server says '%s'."), imap_last_error()));
                                return;
		}
	
		/* Shutdown IMAP connection */
		imap_close($mbox);
	}
	return (TRUE);
  }


  function setSieveAttributes()
  {
	$cfg= $this->config->data['SERVERS']['IMAP'][$this->gosaMailServer];	

	/* Build spamlevel. Spamassassin tags mails with "*" for each integer
	   point of spam. So a spam level of 5.3 gets "*****" which can be
	   checked easily by spam filters */
	$spamlevel= "";
	for ($i= 0; $i<$this->gosaSpamSortLevel; $i++){
		$spamlevel .= "*";
	}

	/* Log into the mail server */
	$path= dirname(__FILE__);
	$sieve=new sieve($cfg["sieve_server"], $cfg["sieve_port"], $cfg["admin"],
			$cfg["password"], $this->uid);

	if (!$sieve->sieve_login()){
			print_red(sprintf(_("Can't log into SIEVE server. Server says '%s'."), to_string($sieve->error_raw)));
                        return;
	}

	/* Load current script from server and remove everything between the comments
	   "###GOSA" */
	$script= "";
	if($sieve->sieve_listscripts()){
		if (in_array("gosa", $sieve->response)){

			/* get old GOsa script */
			if(!$sieve->sieve_getscript("gosa")){
				print_red(sprintf(_("Can't get sieve script. Server says '%s'."), to_string($sieve->error_raw)));
                                return;
			}

			foreach ($sieve->response as $line){
				if (preg_match ("/^###GOSA/", $line)){
					break;
				}
				$line= rtrim($line);
				if (!preg_match ('/^\s*$/', $line)){
					$script .= $line."\n";
				}
			}

		}
	}


	/* Only create a new one, if it is not empty */
	if (is_integer(strpos($this->gosaMailDeliveryMode, "R")) ||
		is_integer(strpos($this->gosaMailDeliveryMode, "C")) ||
		!is_integer(strpos($this->gosaMailDeliveryMode, "L")) ||
		is_integer(strpos($this->gosaMailDeliveryMode, "V")) ||
		is_integer(strpos($this->gosaMailDeliveryMode, "S"))){

		$text= preg_replace('/"/', '\\"', implode ("", file("$path/sieve-header.txt")));
		eval ("\$script.=\"$text\";");
	}

	/* Add anti-spam code */
	if (is_integer(strpos($this->gosaMailDeliveryMode, "S"))){
		$spambox= $this->gosaSpamMailbox;
		$text= preg_replace('/"/', '\\"', implode ("", file("$path/sieve-spam.txt")));
		eval ("\$script.=\"$text\";");
	}

	/* Add "reject due to mailsize" code, message is currently not
	   adjustable through GOsa. */
	if (is_integer(strpos($this->gosaMailDeliveryMode, "R"))){
		$maxsize= $this->gosaMailMaxSize;
		$text= preg_replace('/"/', '\\"', implode ("", file("$path/sieve-mailsize.txt")));
		eval ("\$script.=\"$text\";");
	}

	/* Add vacation information */
	if (is_integer(strpos($this->gosaMailDeliveryMode, "V"))){

		/* Sieve wants all destination addresses for the
		   vacation message, so we've to assemble them from
		   mail and mailAlternateAddress */
		$addrlist= "\"".$this->mail."\"";
		foreach ($this->gosaMailAlternateAddress as $val){
			$addrlist .= ", \"$val\"";
		}
		$vacmsg= $this->gosaVacationMessage;
		$text= preg_replace('/"/', '\\"', implode ("", file("$path/sieve-vacation.txt")));
		eval ("\$script.=\"$text\";");
	}

	/* If no local delivery is wanted, tell the script to discard the mail */
	if (!is_integer(strpos($this->gosaMailDeliveryMode, "L"))){
		$text= preg_replace('/"/', '\\"', implode ("", file("$path/sieve-discard.txt")));
		eval ("\$script.=\"$text\";");
	}

	/* Just be aware of null scripts... */
	if (!isset ($script)){
		$script= "";
	}

	/* Upload script and make it the default one */
	if (!$sieve->sieve_sendscript("gosa", $script)){
		print_red(sprintf(_("Can't send sieve script. Server says '%s'."), to_string($sieve->error_raw)));
                return;
	}
	if(!$sieve->sieve_setactivescript("gosa")){
		print_red(sprintf(_("Can't activate GOsa sieve script. Server says '%s'."), to_string($sieve->error_raw)));
                return;
	}

	$sieve->sieve_logout();
  }


  function execute()
  {
	/* Load templating engine */
        $smarty= get_smarty();

	/* Do we need to flip is_account state? */
	if (isset($_POST['modify_state'])){
		$this->is_account= !$this->is_account;
	}

	/* Do we represent a valid account? */
	if (!$this->is_account && $this->parent == NULL){
		echo "<img src=\"images/stop.png\" align=center>&nbsp;<b>".
		_("This account has no mail extensions.")."</b>";
		echo back_to_main();
		return;
	}

	/* Show tab dialog headers */
	if ($this->parent != NULL){
		if ($this->is_account){
			$this->show_header(_("Remove mail account"),
				_("This account has mail features enabled. You can disable them by clicking below."));
		} else {
			$this->show_header(_("Create mail account"),
				_("This account has mail features disabled. You can enable them by clicking below."));
			return;
		}
	}

	/* Check sorting variable */
	$this->check_sortranges();

	/* Trigger forward add dialog? */
	if (isset($_POST['add_local_forwarder'])){
		$this->forward_dialog= TRUE;
		$this->dialog= TRUE;
	}

        /* Cancel forward add dialog? */
        if (isset($_POST['add_locals_cancel'])){
                $this->forward_dialog= FALSE;
                $this->dialog= FALSE;
        }

	/* Finished adding of locals? */
	if (isset($_POST['add_locals_finish'])){
		if (count ($_POST['local_list']) &&
			chkacl ($this->acl, "gosaMailForwardingAddress") == ""){

			/* Walk through list of forwarders, ignore own addresses */
			foreach ($_POST['local_list'] as $val){
				if (!in_array ($val, $this->gosaMailAlternateAddress) &&
					$val != $this->mail){

					$this->addForwarder($val);
				}
			}
		}
		$this->forward_dialog= FALSE;
		$this->dialog= FALSE;
	}

	/* Add forward email addresses */
	if (isset($_POST['add_forwarder'])){
		if ($_POST['forward_address'] != ""){

			/* Valid email address specified? */
			$address= $_POST['forward_address'];
			if (!is_email($address)){
				print_red (_("You're trying to add an invalid email address to the list of forwarders."));
			} elseif ($address == $this->mail
				|| in_array($address, $this->gosaMailAlternateAddress)) {

				print_red (_("Adding your one of your own addresses to the forwarders makes no sense."));

			} else {

				/* Add it */
				if (chkacl ($this->acl, "gosaMailForwardingAddress") == ""){
					$this->addForwarder ($address);
				}

			}
		}
	}

	/* Delete forward email addresses */
	if (isset($_POST['delete_forwarder'])){
		if (count($_POST['forwarder_list']) 
			&& chkacl ($this->acl, "gosaMailForwardingAddress") == ""){

			$this->delForwarder ($_POST['forwarder_list']);
		}
	}

	/* Add alternate email addresses */
	if (isset($_POST['add_alternate'])){
		if ($_POST['alternate_address'] != "" &&
			chkacl ($this->acl, "gosaMailAlternateAddress") == ""){

			$valid= FALSE;
			if (!is_email($_POST['alternate_address'])){
				if ($this->is_template){
					if (!(is_email($_POST['alternate_address'], TRUE))){
						print_red (_("You're trying to add an invalid email address to the list of alternate addresses."));
					} else {
						$valid= TRUE;
					}
				} else {
					print_red (_("You're trying to add an invalid email address to the list of alternate addresses."));
				}

			} else {
				$valid= TRUE;
			}
			
			if ($valid && ($user= $this->addAlternate ($_POST['alternate_address'])) != ""){
				$ui= get_userinfo();
				if ($user != $ui->username){
					print_red (_("The address you're trying to add is already used by user")." '$user'.");
				}
			}
		}
	}

	/* Delete alternate email addresses */
	if (isset($_POST['delete_alternate']) && isset ($_POST['alternates_list'])){
		if (count($_POST['alternates_list']) &&
			chkacl ($this->acl, "gosaMailAlternateAddress") == ""){

			$this->delAlternate ($_POST['alternates_list']);
		}
	}

	/* Import vacation message? */
	if (isset($_POST["import_vacation"]) && isset($this->vacation[$_POST["vacation_template"]])){
		$contents= "";
		$lines= file($_POST["vacation_template"]);
		foreach ($lines as $line){
			if (!preg_match('/^DESC:/', $line)){
				$contents.= $line;
			}
		}

		/* Replace attributes */
		$attrs= $this->parent->by_object['user']->attributes;
		foreach ($attrs as $val){
			$contents= preg_replace("/%$val/",
				$this->parent->by_object['user']->$val, $contents);
		}

		/* Save message */
		$this->gosaVacationMessage= htmlspecialchars($contents);
	}

	/* Show forward add dialog */
        if ($this->forward_dialog){
		$ldap= $this->config->get_ldap_link();

		/* Get actual list */
		$mailusers= array ();
		if (isset ($_POST['department'])){
			$ldap->cd ($this->config->departments[$_POST['department']]);
		} else {
			$ldap->cd ($this->config->current['BASE']);
		}
		$ldap->search ("(objectClass=gosaMailAccount)");
		error_reporting (0);
		while ($attrs= $ldap->fetch()){
			if (preg_match ($this->sortranges[$this->sorting], $attrs["sn"][0])){
				if(preg_match('/%/', $attrs['mail'][0])){
					continue;
				}
				$name= $this->make_name($attrs);
				$mailusers[$attrs['mail'][0]]= utf8_decode($name)."&lt;".
						$attrs['mail'][0]."&gt;";
			}
		}
		error_reporting (E_ALL);
		natcasesort ($mailusers);
		reset ($mailusers);

		/* Show dialog */
                $smarty->assign("mailusers", $mailusers);
                if (isset($_POST['department'])){
                        $smarty->assign("department", $_POST['department']);
                }
                $smarty->assign("departments", $this->config->idepartments);
                $smarty->assign("sortranges", get_sort_ranges($this->sortranges));
                $smarty->display (get_template_path('mail_locals.tpl', TRUE, dirname(__FILE__)));
                return;
        }

	/* Show main page */
        $mailserver= array();
        foreach ($this->config->data['SERVERS']['IMAP'] as $key => $val){
                $mailserver[]= $key;
        }
        $smarty->assign("mailServers", $mailserver);
        foreach(array("gosaMailServer", "gosaMailQuota", "perms", "mail",
                        "gosaMailAlternateAddress", "gosaMailForwardingAddress",
			"gosaVacationMessage", "gosaMailDeliveryMode",
			"gosaMailMaxSize", "gosaSpamSortLevel", "gosaSpamMailbox") as $val){
                $smarty->assign("$val", $this->$val);
                $smarty->assign("$val"."ACL", chkacl($this->acl, "$val"));
        }
        if (is_numeric($this->gosaMailQuota) && $this->gosaMailQuota != 0){
                $smarty->assign("quotausage", $this->quotaUsage * 100 / $this->gosaMailQuota);
                $smarty->assign("quotadefined", "true");
        } else {
                $smarty->assign("quotadefined", "false");
        }

	/* Fill checkboxes */
	if (!preg_match("/L/", $this->gosaMailDeliveryMode)) {
		$smarty->assign("drop_own_mails", "checked");
        }
	if (preg_match("/V/", $this->gosaMailDeliveryMode)) {
		$smarty->assign("use_vacation", "checked");
        }
	if (preg_match("/S/", $this->gosaMailDeliveryMode)) {
		$smarty->assign("use_spam_filter", "checked");
        }
	if (preg_match("/R/", $this->gosaMailDeliveryMode)) {
		$smarty->assign("use_mailsize_limit", "checked");
        }
	if (preg_match("/I/", $this->gosaMailDeliveryMode)) {
		$smarty->assign("only_local", "checked");
        }
	if (preg_match("/C/", $this->gosaMailDeliveryMode)) {
		$smarty->assign("own_script", "checked");
        }

	/* Have vacation templates? */
	if (count($this->vacation)){
		$smarty->assign("show_templates", "true");
		$smarty->assign("vacationtemplates", $this->vacation);
		if (isset($_POST['vacation_template'])){
			$smarty->assign("template", $_POST['vacation_template']);
		}
        }

	/* Fill spam selector */
	$spamlevel= array();
	for ($i= 0; $i<21; $i++){
		$spamlevel[]= $i;
	}
	$smarty->assign("spamlevel", $spamlevel);
	$smarty->assign("spambox", $this->mailboxList);
	$smarty->assign("custom_sieveACL", chkacl($this->acl, "custom_sieve"));	
	$smarty->assign("only_localACL", chkacl($this->acl, "only_local"));	

	$smarty->display (get_template_path('generic.tpl', TRUE, dirname(__FILE__)));
  }


  /* remove object from parent */
  function remove_from_parent()
  {
        /* include global link_info */
        $ldap= $this->config->get_ldap_link();

        /* Remove and write to LDAP */
        plugin::remove_from_parent();

	/* Zero arrays */
	$this->attrs['gosaMailAlternateAddress']= array();
	$this->attrs['gosaMailForwardingAddress']= array();

	/* Keep uid */
	unset ($this->attrs['uid']);
        @DEBUG (DEBUG_LDAP, __LINE__, __FUNCTION__, __FILE__,
                $this->attributes, "Save");
	$ldap->cd($this->dn);
        $ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
	if (isset($_POST['mailTab'])){
		/* Save ldap attributes */
		plugin::save_object();

		/* Assemble mail delivery mode
		   The mode field in ldap consists of values between braces, this must
		   be called when 'mail' is set, because checkboxes may not be set when
		   we're in some other dialog.

		   Example for gosaMailDeliveryMode [LR        ]
		   L: Local delivery
		   R: Reject when exceeding mailsize limit
		   S: Use spam filter
		   V: Use vacation message
		   C: Use custm sieve script
		   I: Only insider delivery */

		$tmp= "";
		if (!isset($_POST["drop_own_mails"])){
			$tmp.= "L";
		}
		if (isset($_POST["use_mailsize_limit"])){
			$tmp.= "R";
		}
		if (isset($_POST["use_spam_filter"])){
			$tmp.= "S";
		}
		if (isset($_POST["use_vacation"])){
			$tmp.= "V";
		}
		if (isset($_POST["own_script"])){
			$tmp.= "C";
		}
		if (isset($_POST["only_local"])){
			$tmp.= "I";
		}
		$tmp= "[$tmp]";

		if (chkacl ($this->acl, "gosaMailDeliveryMode") == ""){
			$this->gosaMailDeliveryMode= $tmp;
		}
	}
  }


  /* Save data to LDAP, depending on is_account we save or delete */
  function save()
  {
	$ldap= $this->config->get_ldap_link();

	/* Call parents save to prepare $this->attrs */
	plugin::save();

	/* Save arrays */
	$this->attrs['gosaMailAlternateAddress']= $this->gosaMailAlternateAddress;
	$this->attrs['gosaMailForwardingAddress']= $this->gosaMailForwardingAddress;

	/* Save data to LDAP */
	$ldap->cd($this->dn);
	$ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());

	/* Only do IMAP actions if we are not a template */
	if (!$this->is_template){
		if ($this->setImapAttributes()){
		
			/* Write sieve information only if not in C mode */
			if (!is_integer(strpos($this->gosaMailDeliveryMode, "C"))){
				$this->setSieveAttributes();
			}
		}
	}

	/* Optionally execute a command after we're done */
	$this->postcreate();
  }

  /* Check formular input */
  function check()
  {
	$ldap= $this->config->get_ldap_link();

	$message= array();

	/* must: mail */
	if ($this->mail == ""){
		$message[]= _("The required field 'Primary address' is not set.");
	}
	if ($this->is_template){
		if (!is_email($this->mail, TRUE)){
			$message[]= _("Please enter a valid email address in 'Primary address' field.");
		}
	} else {
		if (!is_email($this->mail)){
			$message[]= _("Please enter a valid email address in 'Primary address' field.");
		}
	}
	$ldap->cd($this->config->current['BASE']);
	$ldap->search ("(&(|(mail=".$this->mail.")(gosaMailAlternateAddress=".
			$this->mail."))(!(uid=".$this->uid."))(!(cn=".$this->uid.")))");
	if ($ldap->count() != 0){
		$message[]= _("The primary address you've entered is already in use.");
	}

	/* Check quota */
	if ($this->gosaMailQuota != '' && chkacl ($this->acl, "gosaMailQuota") == ""){
		if (!is_numeric($this->gosaMailQuota)) {
			$message[]= _("Value in 'Quota size' is not valid.");
		} else {
			$this->gosaMailQuota= (int) $this->gosaMailQuota;
		}
	}

	/* Check rejectsize for integer */
	if ($this->gosaMailMaxSize != '' && chkacl ($this->acl, "gosaMailQuota") == ""){
		if (!is_numeric($this->gosaMailMaxSize)){
			$message[]= _("Please specify a vaild mail size for mails to be rejected.");
		} else {
			$this->gosaMailMaxSize= (int) $this->gosaMailMaxSize;
		}
	}

	/* Need gosaMailMaxSize if use_mailsize_limit is checked */
	if (is_integer(strpos($this->gosaMailDeliveryMode, "R")) && 
		$this->gosaMailMaxSize == ""){

		$message[]= _("You need to set the maximum mail size in order to reject anything.");
	}

	return ($message);
  }

  /* Adapt from template, using 'dn' */
  function adapt_from_template($dn)
  {
	plugin::adapt_from_template($dn);

	foreach (array("gosaMailAlternateAddress", "gosaMailForwardingAddress") as $val){
		$this->$val= array();
		if (isset($this->attrs["$val"]["count"])){
			for ($i= 0; $i<$this->attrs["$val"]["count"]; $i++){
				$value= utf8_decode($this->attrs["$val"][$i]);
				foreach (array("sn", "givenName", "uid") as $repl){
					if (preg_match("/%$repl/i", $value)){
						$value= preg_replace ("/%$repl/i", $this->parent->$repl, $value);
					}
				}
				array_push($this->$val, strtolower(rewrite($value)));
			}
		}
	}
	$this->mail= strtolower(rewrite($this->mail));
  }

  /* Add entry to forwarder list */
  function addForwarder($address)
  {
	$this->gosaMailForwardingAddress[]= $address;
	$this->gosaMailForwardingAddress= array_unique ($this->gosaMailForwardingAddress);

	sort ($this->gosaMailForwardingAddress);
	reset ($this->gosaMailForwardingAddress);
  }

  /* Remove list of addresses from forwarder list */
  function delForwarder($addresses)
  {
	$this->gosaMailForwardingAddress= array_strip ($addresses, $this->gosaMailForwardingAddress);
  }



  function addAlternate($address)
  {
	$ldap= $this->config->get_ldap_link();

	$address= strtolower($address);

	/* Is this address already assigned in LDAP? */
	$ldap->cd ($this->config->current['BASE']);
	$ldap->search ("(&(objectClass=gosaMailAccount)(|(mail=$address)".
				"(gosaMailAlternateAddress=$address)))");

	if ($ldap->count() > 0){
		$attrs= $ldap->fetch ();
		return ($attrs["uid"][0]);
	}

	/* Add to list of alternates */
	if (!in_array($address, $this->gosaMailAlternateAddress)){
		$this->gosaMailAlternateAddress[]= $address;
	}

	sort ($this->gosaMailAlternateAddress);
	reset ($this->gosaMailAlternateAddress);

	return ("");
  }


  function delAlternate($addresses)
  {
	$this->gosaMailAlternateAddress= array_strip ($addresses, $this->gosaMailAlternateAddress);
  }

  function make_name($attrs)
  {
	$name= "";
	if (isset($attrs['sn'][0])){
		$name= $attrs['sn'][0];
	}
	if (isset($attrs['givenName'][0])){
		if ($name != ""){
			$name.= ", ".$attrs['givenName'][0];
		} else {
			$name.= $attrs['givenName'][0];
		}
	}
	if ($name != ""){
		$name.= " ";
	}

	return ($name);
  }

}

?>
