<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class dhcpPool extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage DHCP pools";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Used attributes */
  var $cn= "";
  var $dhcpRange= "";
  var $options= array();
  var $statements= array();

  /* attribute list for save action */
  var $attributes= array("cn", "dhcpRange");
  var $objectclasses= array("dhcpPool");

  function dhcpPool($config, $dn= NULL)
  {
        /* Load bases attributes */
        plugin::plugin($config, $dn);

	/* This is always an account */
	$this->is_account= TRUE;
  }

  function execute()
  {
	/* Show main page */
	$smarty= get_smarty();
	foreach(array("cn", "dhcpRange") as $val){
		$smarty->assign("$val", $this->$val);
		$smarty->assign("$val"."ACL", chkacl($this->acl, $val));
	}

	/* Prepare range */
	if ($this->dhcpRange != ""){
		list($r1, $r2)= preg_split('/\s+/', $this->dhcpRange);
		list($r00, $r01, $r02, $r03)= split('\.', $r1);
		for ($i= 0; $i<4; $i++){
			$name= "r0$i";
			$smarty->assign("r0$i", $$name);
		}
		list($r10, $r11, $r12, $r13)= split('\.', $r2);
		for ($i= 0; $i<4; $i++){
			$name= "r1$i";
			$smarty->assign("r1$i", $$name);
		}
	}

	$smarty->display (get_template_path('pool.tpl', TRUE));
  }

  function remove_from_parent()
  {
        /* Just remove the dn from the ldap, then we're done. Host
           entries do not have any entries below themselfes. */
        $ldap= $this->config->get_ldap_link();
        $ldap->cd($this->dn);
        $ldap->recursive_remove();
        show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
  	plugin::save_object();

	if (isset($_POST['r00'])){
                $this->dhcpRange= $_POST['r00'].".".$_POST['r01'].".".$_POST['r02'].".".$_POST['r03']." ".$_POST['r10'].".".$_POST['r11'].".".$_POST['r12'].".".$_POST['r13'];
        }

  }


  /* Check values */
  function check()
  {
        $message= array();

        /* All required fields are set? */
        if ($this->cn == ""){
                $message[]= _("Required field 'Name' is not filled.");
        }
        if ($this->dhcpRange == ""){
                $message[]= _("Required field 'Range' is not filled.");
        }

	return $message;
  }


  /* Save to LDAP */
  function save()
  {
        plugin::save();

        /* Get ldap mode */
        if ($this->dn == "new"){
                $mode= "add";
        } else {
                $mode= "modify";
        }

        /* Generate new dn */
        if ($this->parent->parent != NULL && $this->dn == "new"){
                $this->dn= "cn=".utf8_encode($this->cn).",".$this->parent->parent;
        }

	/* Assemble new entry - options */
        if (isset ($this->options) && count ($this->options)){
                $this->attrs['dhcpOption']= array();
                foreach ($this->options as $key => $val){
                        $this->attrs['dhcpOption'][]= "$key $val";
                }
        } else {
                if ($mode == "modify"){
                        $this->attrs['dhcpOption']= array();
                }
        }

        /* Assemble new entry - statements */
        if (isset ($this->statements) && count ($this->statements)){
                $this->attrs['dhcpStatements']= array();
                foreach ($this->statements as $key => $val){
                        $this->attrs['dhcpStatements'][]= "$key $val";
                }
        } else {
                if ($mode == "modify"){
                        $this->attrs['dhcpStatements']= array();
                }
        }

        /* Do LDAP action */
        $ldap= $this->config->get_ldap_link();
        if ($mode == "add"){
		$ldap->cd($this->config->current['BASE']);
                $ldap->create_missing_trees(preg_replace('/^[^,]+,/', '', $this->dn));
        }
        $ldap->cd($this->dn);
        $ldap->$mode($this->attrs);
        show_ldap_error($ldap->get_error());
  }
  
}

?>
