<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class dnszone extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage DNS zones";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Used attributes */
  var $zonedn= "";
  var $zoneName= "";
  var $tXTRecord= "";
  var $dNSTTL= "84600";
  var $dnsmaster= "";
  var $admin= "";
  var $refresh= "28800";
  var $serial= "";
  var $retry= "7200";
  var $expire= "604800";
  var $base= "";
  
  var $original_base= "";
  var $soa_dn= "";

  /* Helpers */
  var $slaves= array();
  var $mx= array();

  /* attribute list for save action */
  var $attributes= array("zoneName", "tXTRecord", "dNSTTL");
  var $objectclasses= array("dnsZone");

  function dnszone($config, $dn= NULL)
  {
	$ldap= $config->get_ldap_link();
	$this->config=$config;

  	if ($dn != "new"){
		/* Load '@' entry for that zone */
		$ldap= $config->get_ldap_link();
		$ldap->cd ($dn);
		$ldap->search ('(&(objectClass=dnsZone)(relativeDomainName=@))');
		$ldap->fetch();

		/* Valid zone? */
		if ($ldap->count() > 1){
			print_red (_("Your zone contains two SOA entries. This is not supported by GOsa."));
			return;
		}

		/* Take dn pointer to @ entry */
		$this->zonedn= $dn;
		$this->soa_dn= $ldap->getDN();
	  	plugin::plugin ($config, $this->soa_dn);

		/* Convert attributes coded into SOA */
		list($this->dnsmaster, $this->admin, $this->serial, $this->refresh,
			$this->retry, $this->expire, $this->dNSTTL) = preg_split("/\s+/",
			$this->attrs['sOARecord'][0], 7);

		/* Convert admin to email contact */
		$this->admin= preg_replace('/^([^.]+)\.(.*)\.$/', '$1@$2', $this->admin);
		$this->serial= (int)($this->serial);

		/* Get list of dns slaves */
		if (isset($this->attrs['nSRecord'])){
			for ($i= 0; $i < $this->attrs['nSRecord']['count']; $i++){
				$server= $this->attrs['nSRecord'][$i];
				if ($server != $this->dnsmaster){
					$this->slaves[$server]= "$server";
				}
			}
		}

		/* Get list of MX entries */
		if (isset($this->attrs['mXRecord'])){
			for ($i= 0; $i < $this->attrs['mXRecord']['count']; $i++){
				$server= $this->attrs['mXRecord'][$i];
				$this->mx[$server]= "$server";
			}
		}
		
		/* Set base */
		$this->base= array_search (preg_replace("/^.*,ou=bind,ou=configs,ou=systems,/", "", $this->zonedn), $this->config->departments);
		$this->original_base= preg_replace("/^.*,ou=bind,ou=configs,ou=systems,/", "", $this->zonedn);
	}

	/* This is always an account */
	$this->is_account= TRUE;
  }

  function execute()
  {
  	/* Add slave */
	if (isset($_POST['add_slave']) && $_POST['slaveselect'] != ""){
		if (!preg_match('/^[a-z0-9.-]+\.$/', $_POST['slaveselect'])){
			print_red (_("Slave entry is invalid. Use DNS syntax."));
		} else {
			$this->slaves[$_POST['slaveselect']]= $_POST['slaveselect'];
			asort($this->slaves);
			array_unique($this->slaves);
		}
	}
  
	/* Delete slave */
	if (isset($_POST['delete_slave']) && isset($_POST['slave'])){
		$this->slaves= array_remove_entry($_POST['slave'], $this->slaves);
	}

  	/* Add mx */
	if (isset($_POST['add_mx']) && $_POST['mxselect'] != ""){
		if (!preg_match('/^[0-9]+ [a-z0-9.-]+\.$/', $_POST['mxselect'])){
			print_red (_("MX entry is invalid. Use priority plus DNS syntax."));
		} else {
			$this->mx[$_POST['mxselect']]= $_POST['mxselect'];
			asort($this->mx);
			array_unique($this->mx);
		}
	}
  
	/* Delete mx */
	if (isset($_POST['delete_mx']) && isset($_POST['mx'])){
		$this->mx= array_remove_entry($_POST['mx'], $this->mx);
	}
  
	/* Show main page */
	$smarty= get_smarty();
	$smarty->assign ("base_options", $this->config->idepartments);
	$smarty->assign ("autorev_state", "disabled");
	$smarty->assign ("base_id", $this->base);
	foreach ($this->attributes as $val){
		$smarty->assign ("$val", $this->$val);
	}
	foreach (array("admin", "refresh", "retry", "expire", "dnsmaster",
			"slaves", "mx") as $val){
		$smarty->assign ("$val", $this->$val);
	}
	$smarty->display (get_template_path('zone.tpl', TRUE));
  }

  function remove_from_parent()
  {
	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
  	if (isset($_POST['zoneName'])){
	  	plugin::save_object();

		/* Save soa/zone values */
		foreach (array("admin", "refresh", "retry", "expire", "dnsmaster",
			"base") as $val){
			$this->$val= $_POST[$val];
		}
	}
  }


  /* Check values */
  function check()
  {
	$message= array();

	/* Permissions for that base? */
	if ($this->base != ""){
		$new_dn= "ou=bind,ou=configs,ou=systems,".$this->base;
	} else {
		$new_dn= $this->dn;
	}

	$ui= get_userinfo();
	$acl= get_permissions ($new_dn, $ui->subtreeACL);
	$acl= get_module_permission($acl, "dns", $new_dn);
	if (chkacl($acl, "create") != ""){
		$message[]= _("You have no permissions to create a zone on this 'Base'.");
	}

	/* All required fields are set? */
	if ($this->zoneName == ""){
		$message[]= _("Required field 'Name' is not filled.");
	}
	if ($this->dnsmaster == ""){
		$message[]= _("Required field 'Master' is not filled.");
	} else {
		if (!is_dns_notation($this->dnsmaster)){
			$message[]= _("Required field 'Master' has invalid contents.");
		}
	}
	if ($this->admin == ""){
		$message[]= _("Required field 'Contact' is not filled.");
	} else {
		if (!(is_dns_notation($this->admin) || is_email($this->admin))){
			$message[]= _("Required field 'Contact' has invalid contents.");
		}
	}

	/* Valid integers? */
	foreach (array("refresh", "retry", "expire", "dNSTTL") as $val){
		if ($this->$val == ""){
			$message[]= _("Required field '$val' is not filled.");
		} else {
			if (!(is_id($this->$val))){
				$message[]= _("Required field '$val' has invalid contents.");
			}
		}
	}

	return $message;
  }


  /* Save to LDAP */
  function save()
  {
	/* Create eventually missing subtrees in ldap */
	$cdn= "ou=bind,ou=configs,ou=systems,".$this->base;
	$subtrees= array_reverse(explode(".", $this->zoneName));
	foreach ($subtrees as $part){
		$cdn= "dc=$part,$cdn";
	}
	$ldap= $this->config->get_ldap_link();
	$ldap->cd ($this->config->current['BASE']);
	$ldap->create_missing_trees ($cdn);

	/* Edit existing entry? */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd ($cdn);
	$ldap->search("(&(objectClass=dnsZone)(relativeDomainName=@))");
	if ($ldap->count()){
		$ldap->fetch();
		$target_dn= $ldap->getDN();
		$mode= "modify";
	} else {
		$mode= "add";
		$target_dn= "relativeDomainName=@+dNSTTL=".$this->dNSTTL.",".$cdn;
	}

	/* Prepare contact */
	if (preg_match("/@/", $this->admin)){
		$this->admin= preg_replace("/@/", ".", $this->admin).".";
	}

	/* Take care about the serial */
	$new_serial= (int)(date("Ymd")."00");
	while ($this->serial >= $new_serial){
		$new_serial++;
	}
	$this->serial= $new_serial;
	
	/* Create SOA entry */
	$attrs= array();
	$attrs["objectClass"]= array("dnsZone", "top");
	$attrs["dNSTTL"]= $this->dNSTTL;
	$attrs["zoneName"]= $this->zoneName;
	if ($this->tXTRecord != ""){
		$attrs["tXTRecord"]= $this->tXTRecord;
	} elseif ($mode != "add"){
		$attrs["tXTRecord"]= array();
	}
	$attrs["SOARecord"]= $this->dnsmaster." ".$this->admin." ".
		$this->serial." ".$this->refresh." ".$this->retry." ".
		$this->expire." ".$this->dNSTTL;
	foreach (array("nSRecord" => "slaves", "mXRecord" => "mx") as $key => $val){
		if (!count($this->$val) && $mode == "add"){
			continue;
		}
		$attrs["$key"]= array();
		foreach ($this->$val as $e){
			$attrs["$key"][]= $e;
		}
	}
	$attrs["nSRecord"][]= $this->dnsmaster;
	$attrs["relativeDomainName"]= "@";

	/* Write entry to ldap */
	$ldap->cd($target_dn);
	if ($mode == "modify"){
		$ldap->modify($attrs);
	} else {
		$ldap->add($attrs);
	}
	show_ldap_error($ldap->get_error());

	/* Moved? Delete old stuff */
	if ($this->original_base != $this->base && $this->original_base != 'new'){
		$ldap->rmDir($this->soa_dn);
	}
  }
  
}

?>
