<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


class pluglist {
  var $index= 0;
  var $menu= "";
  var $iconmenu= "";
  var $config= NULL;
  var $dirlist= array();
  var $ui= NULL;

  function pluglist($config, $ui)
  {
	$this->ui= $ui;
	$this->config= $config;

	/* Create dirlist for all plugins */
	$this->dirlist= $this->get_plugins ($this->dirlist, $this->config->data);
  }

  function get_plugins($list, $config)
  {
  	/* Error reporting, because I'm getting strange messages in PHP 4.2.x */
  	error_reporting(0);
	if (!isset($config['PATH']) && !isset($config['CLASS'])){
		if (is_array($config)){
			foreach ($config as $val){
				$list= $this->get_plugins($list, $val);
			}
		}
	} else {
		if (isset ($config['PATH']) && is_array($config)){
			$list[$this->index++]= $config['PATH'];
		}
	}
  	error_reporting(E_ALL);

	return ($list);
  }

  function check_access($modname)
  {
	/* This plugin is readable for everyone, return true */
	if ($modname == 'default'){
		return (TRUE);
	}

	/* Look through ACL's */
	foreach($this->ui->subtreeACL as $arr){
		foreach($arr as $value){
			if ($value == ':all' || preg_match("/[,:]$modname#/", $value)){
				if (!preg_match('/^!/', $value)){
					return (TRUE);
				}
			}
		}
	}

	return (FALSE);
  }

  function show_menu()
  {
	if ($this->menu == ""){
		$cfg= $this->config->data['MENU'];

		/* Parse headlines */
		foreach ($cfg as $headline => $plug){
			$menu= "<p class=\"menuheader\">"._($headline)."</p>\n";
			$entries= "";

			/* Parse sub-plugins */
			foreach ($plug as $info){

				$index= $this->get_index($info['PATH']);

				if ($this->check_access($info['ACL'])){

					$entries= $entries."<p class=\"menuitem\" onClick='location.href=\"main.php?plug=$index&amp;reset=1\"'>".
						"<a class=\"menuitem\" ".
						"href=\"main.php?plug=$index&amp;reset=1\">".
						_($info['HEADLINE'])."</a></p>\n";
				}
			}

			/* Append to menu */
			if ($entries != ""){
				$this->menu.= $menu.$entries;
			}
		}

	}

	/* Write menu output */
	return ($this->menu);
  }

  function show_iconmenu()
  {
	if ($this->iconmenu == ""){
		$cfg= $this->config->data['MENU'];

		if (isset($this->config->current['ICONSIZE'])){
			list($x, $y)= split("x", $this->config->current['ICONSIZE']);
			$isize= "width=\"$x\" height=\"$y\"";
		} else {
			$isize= "";
		}

		/* Parse headlines */
		foreach ($cfg as $headline => $plug){
			$col= 1;
			$menu= "<h1 class=\"menuheader\">".
					_($headline)."</h1>\n<table style=\"width:100%;".
					"font-size: 14px;\" cellpadding=7 border=0>\n<tr>\n";
			$entries= "";

			foreach ($plug as $info){

				$index= $this->get_index($info['PATH']);

				if ($this->check_access($info['ACL'])){

					/* next row? */
					$image= get_template_path('images/'.$info['ICON']);
					if ($col % 4){
						$entries= $entries."<td class=\"iconmenu\" style=\"width:25%;\" onClick='location.href=\"main.php?plug=$index&amp;reset=1\"'".
							"><a class=\"iconmenu\" href=\"main.php?plug=$index&amp;reset=1\">".
							"<img $isize border=0 align=middle src=\"$image".
							"\" alt=\"*\">&nbsp;".
							_($info['HEADLINE'])."</a></td>\n";
						$col++;
					} else {
						$entries= $entries."<td class=\"iconmenu\" style=\"width:25%;\" onClick='location.href=\"main.php?plug=$index&amp;reset=1\"'".
							"><a class=\"iconmenu\" href=\"main.php?plug=$index&amp;reset=1\">".
							"<img $isize border=0 align=middle src=\"$image".
							"\" alt=\"*\">&nbsp;".
							_($info['HEADLINE'])."</a></td>\n</tr>\n<tr>\n";
						$col= 1;
					}
				}
			}

			/* Append to menu */
			if ($entries != ""){
				$this->iconmenu.= $menu.$entries;

				/* Fill up remaining columns */
				if ($col != 1){
					$col--;
					while ($col % 4){
						$this->iconmenu= $this->iconmenu.
							"<td style=\"width:25%\">&nbsp;</td>\n";
						$col++;
					}
				}

				/* close table */
				$this->iconmenu= $this->iconmenu."</tr>\n</table>\n";
			}
		}

	}

	/* Write menu output */
	return ($this->iconmenu);
  }

  function get_path($index)
  {
	if(!isset($this->dirlist[$index])){
		return ("");
	}
	return ("../".$this->dirlist[$index]);
  }

  function get_index($path)
  {
	return (array_search($path, $this->dirlist));
  }
}

?>
