<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class department extends plugin
{
  /* CLI vars */
  var $cli_summary= "Handling of LDAP subtrees";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* department attributes */
  var $ou= "";
  var $description= "";
  var $base= "";
  var $st= "";
  var $l= "";
  var $postalAddress= "";
  var $businessCategory= "";
  var $telephoneNumber= "";
  var $facsimileTelephoneNumber= "";

  /* Headpage attributes */
  var $last_dep_sorting= "invalid";
  var $departments= array();

  /* attribute list for save action */
  var $attributes= array("ou", "description", "businessCategory", "st", "l", "postalAddress",
			"telephoneNumber", "facsimileTelephoneNumber");
  var $objectclasses= array("gosaDepartment", "organizationalUnit");

  function department ($config, $ui)
  {
	$this->ui= $ui;
	$this->dn= "";
	$this->config= $config;

        /* Get global filter config */
        if (!is_global("depfilter")){
                $base= get_base_from_people($ui->dn);
                $depfilter= array("depselect" => $base,
                                  "regex" => "");
                register_global("depfilter", $depfilter);
        }
  }

  function execute()
  {
	/* Reload departments */
	$this->config->departments= get_departments();
	$this->config->make_idepartments();
	$smarty= get_smarty();

        /* Save data */
        $depfilter= get_global("depfilter");
        foreach( array("depselect", "regex") as $type){
                if (isset($_POST[$type])){
                        $depfilter[$type]= $_POST[$type];
                }
        }
        register_global("depfilter", $depfilter);

	/* Create new department? */
	if (isset($_POST['new_department'])){
		$this->clear_fields();
		$this->acl= "#all#";
		$this->dn= "new";
		plugin::plugin ($this->config, $this->dn);
	}

	/* Edit existing department */
	if (isset($_POST['select_department']) && isset($_POST['deplist']) != ""){
		$this->clear_fields();
		$this->dn= $this->config->departments[$_POST['deplist']];
		$this->acl= get_permissions ($this->dn, $this->ui->subtreeACL);
		$this->acl= get_module_permission($this->acl, "department", $this->dn);
		plugin::plugin ($this->config, $this->dn);
	}


	/* Delete requested department */
	if (isset($_POST['delete_department']) && isset($_POST['deplist'])){
		$this->dn= $this->config->departments[$_POST['deplist']];

		/* Check locking */
		if (($user= get_lock($this->dn)) != ""){
			$_SESSION['dn']= $this->dn;
			gen_locked_message($user, $this->dn);
			return;
		} else {
			# Lock this dn for editing
			add_lock ($this->dn, $this->ui->dn);

			$smarty->assign("info", sprintf(_("You're about to delete the whole LDAP subtree placed under '%s'."), utf8_decode($this->dn)));
			$smarty->display (get_template_path('remove.tpl', TRUE));
			return;
		}
	}


	/* What about finish? */
	if (isset($_POST['edit_finish'])){
		$message= $this->check();

		/* No errors, save object */
		if (count ($message) == 0){

			/* Perpare 'dn' in case of new entries */
			if ($this->dn == "new"){
				$this->dn= utf8_encode("ou=$this->ou,".$this->base);
			}

			$this->save ();
			gosa_log ("Department object'".$this->dn."' has been removed");
			$this->clear_fields();
			del_lock ($this->ui->dn);
		} else {
			/* Errors found, show message */
			show_errors ($message);
		}
	}

	/* Finally delete department */
	if (isset($_POST['delete_department_confirm'])){
		$acl= get_permissions ($this->dn, $this->ui->subtreeACL);
		$acl= get_module_permission($acl, "department", $this->dn);
		if (chkacl($acl, "all") == ""){
			$this->remove_from_parent();
			gosa_log ("Department object'".$this->dn."' has been removed");
			$this->reload ();
		} else {
			print_red (_("You have no permission to remove this department."));
		}
	}


	/* Cancel dialog */
	if (isset($_POST['edit_cancel']) || isset($_POST['delete_cancel']) ||
		isset($_POST['delete_department_confirm']) || isset($_POST['delete_lock'])){

		del_lock ($this->dn);
		$this->clear_fields();
	}


	/* Headpage or normal plugin screen? */
	if ($this->dn == ""){
		/* Check sorting variable */
		$this->check_sortranges();
		$this->reload();

		/* Show main page */
		$smarty->assign("departments", $this->departments);
		$smarty->assign("sortranges", get_sort_ranges($this->sortranges));
		$smarty->assign("infoimage", get_template_path('images/info.png'));
		$smarty->assign("launchimage", get_template_path('images/launch.png'));
		$smarty->assign("deplist", $this->config->idepartments);
		foreach( array("depselect", "regex") as $type){
                	$smarty->assign("$type", $depfilter[$type]);
		}

		/* Extend if we are not using javascript */
	        $smarty->assign("apply", apply_filter());

		$smarty->display(get_template_path('headpage.tpl', TRUE));
		return;
	}

	/* Show main page */
	$smarty->assign("bases", $this->config->idepartments);
        if ($this->base == ""){
                $this->base= preg_replace ("/^[^,]+,/", "", $this->dn);
        }
        if ($this->dn == "new"){
                $smarty->assign("mode", "");
                $smarty->assign("selectmode", "");
        } else {
                $smarty->assign("mode", "readonly");
                $smarty->assign("selectmode", "disabled");
        }

	foreach ($this->attributes as $val){
		$smarty->assign("$val", $this->$val);
		$smarty->assign("$val"."ACL", chkacl($this->acl, "$val"));
	}
	$smarty->assign("bases", $this->config->idepartments);
	$smarty->assign("base_select", $this->base);
	$smarty->display (get_template_path('generic.tpl', TRUE));
  }

  function clear_fields()
  {
	$this->dn= "";
	$this->base= "";
	$this->acl= "#none#";

	foreach ($this->attributes as $val){
		$this->$val= "";
	}
  }

  function reload()
  {
	/* Get config */
        $depfilter= get_global('depfilter');

        /* Set base for all searches */
        $base= $depfilter['depselect'];

        /* Regex filter? */
        if ($depfilter['regex'] != ""){
                $regex= $depfilter['regex'];
        } else {
                $regex= "";
        }

	/*Get all gosaDepartments */
	$res= get_list($this->ui->subtreeACL, "(objectClass=gosaDepartment)", $base);

	$this->departments= array();
	foreach ($res as $value){
		if ($regex != "" && !preg_match("/$regex/", $value['ou'][0])) continue;

		if (preg_match ($this->sortranges[$this->sorting], $value["ou"][0])){
			$title= utf8_decode (convert_department_dn($value["dn"]));
			$this->departments[$title]= "$title [".utf8_decode($value["description"][0])."]";
		}
	}
	natcasesort ($this->departments);
	reset ($this->departments);
  }

  function remove_from_parent()
  {
	$ldap= $this->config->get_ldap_link();
	$ldap->cd ($this->dn);
	$ldap->recursive_remove();

	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
	plugin::save_object();

	/* Save base, since this is no LDAP attribute */
	if (isset($_POST['base']) && chkacl($this->acl, "create") == ""){
		$this->base= $_POST['base'];
	}
  }


  /* Check values */
  function check()
  {
	$message= array();

	/* Permissions for that base? */
	$new_dn= utf8_encode("ou=$this->ou,".$this->base);
	$acl= get_permissions ($new_dn, $this->ui->subtreeACL);
	$acl= get_module_permission($acl, "department", $new_dn);
	if (chkacl($acl, "create") != ""){
		$message[]= _("You have no permissions to create a department on this 'Base'.");
	}

	/* Check for presence of this department */
	$ldap= $this->config->get_ldap_link();
	$attrs= $ldap->cat ($new_dn);
	if (($this->dn == "new") && !($attrs === FALSE)){
		$message[]= _("Department with that 'Name' already exists.");
	}

	/* All required fields are set? */
	if ($_POST["ou"] == ""){
		$message[]= _("Required field 'Name' is not set.");
	}
	if ($_POST["description"] == ""){
		$message[]= _("Required field 'Description' is not set.");
	}

	/* Validate and modify - or: spaghetti rules! */
	if ($_POST['ou'] == "incoming"){
		$message[]= _("The field 'Name' contains the reserved word 'incoming'.".
				" Please choose another name.");
	}
	if (preg_match ('/[,#+:=>\\\\]/', $_POST['ou'])){
		$message[]= _("The field 'Name' contains invalid characters.");
	}
	if (!is_phone_nr($_POST['telephoneNumber'])){
		$message[]= _("The field 'Phone' contains an invalid phone number.");
	}
	if (!is_phone_nr($_POST['facsimileTelephoneNumber'])){
		$message[]= _("The field 'Fax' contains an invalid phone number.");
	}

	return $message;
  }


  /* Save to LDAP */
  function save()
  {
	plugin::save();

	/* Write back to ldap */
	$ldap= $this->config->get_ldap_link();
	$ldap->cat($this->dn);
	$a= $ldap->fetch();
	$ldap->cd($this->dn);
	if (count($a)){
		$ldap->modify($this->attrs);
	} else {
		$ldap->add($this->attrs);
	}
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postcreate();
  }

  function remove_lock()
  {
        del_lock ($this->dn);
  }

}

?>
