<?php

class usertabs extends tabs
{
  function usertabs($config, $data, $dn)
  {
	tabs::tabs($config, $data, $dn);
	$base= preg_replace('/^[^,]+,'.get_people_ou().',(.*)$/i', '\\1', $dn);
	if ($dn != 'new'){
		$this->base= $base;
	} else {
		$this->base= "new";
	}
	$this->by_object['user']->base= $this->base;
  }

  function save_object($save_current= FALSE)
  {
	tabs::save_object($save_current);

	/* Update reference, transfer variables */
	$baseobject= $this->by_object['user'];
	foreach ($this->by_object as $name => $obj){
		/* Don't touch base object */
		if ($name != 'user'){
			$obj->parent= &$this;
			$obj->uid= $baseobject->uid;
			$obj->sn= $baseobject->uid;
			$obj->givenName= $baseobject->uid;
			$this->by_object[$name]= $obj;
		}
	}

	/* Move facsimile phone number if nessecary */
	if ($this->last == "user" && isset($this->by_object['gofaxAccount'])){

		/* Move number to fax plugin */
		$this->by_object['gofaxAccount']->facsimileTelephoneNumber=
			$this->by_object['user']->facsimileTelephoneNumber;
	}
	if ($this->last == "gofaxAccount"){
	
		/* Move number from fax plugin */
		$this->by_object['user']->facsimileTelephoneNumber=
			$this->by_object['gofaxAccount']->facsimileTelephoneNumber;

	}
  }

  function save()
  {
	/* Check for new 'dn', in order to propagate the
	   'dn' to all plugins */
	$baseobject= $this->by_object['user'];
	if ($this->dn == 'new'){
		$baseobject->cn= $baseobject->sn." ".$baseobject->givenName;
		$this->by_object['user']= $baseobject;
	        if (isset($this->config->current['DNMODE']) && $this->config->current['DNMODE'] == "uid"){
	                $this->dn= utf8_encode('uid='.$baseobject->uid.','.get_people_ou().',').$baseobject->base;
	        } else {
	                $this->dn= utf8_encode('cn='.$baseobject->cn.','.get_people_ou().',').$baseobject->base;
	        }
	} else {
		/* Extract cn and compare with actual cn present in 'dn' */
	        if (isset($this->config->current['DNMODE']) && $this->config->current['DNMODE'] == "uid"){
	                $new_dn= utf8_encode('uid='.$baseobject->uid.','.get_people_ou().',').$baseobject->base;
	        } else {
	                $new_dn= utf8_encode("cn=".$baseobject->sn." ".$baseobject->givenName.','.
				get_people_ou().',').$baseobject->base;
	        }

		if ($this->dn != $new_dn){

			/* Write entry on new 'dn' */
			$baseobject->cn= $baseobject->sn." ".$baseobject->givenName;
			$baseobject->move($this->dn, $new_dn);
			$this->by_object['user']= $baseobject;

                        /* Did we change ourselves? Update ui object. */
			change_ui_dn($this->dn, $new_dn);

                        /* Happen to use the new one */
                        $this->dn= $new_dn;
		}
	}

	return tabs::save();
  }


  function set_template_mode()
  {
        foreach ($this->by_object as $key => $obj){
                $this->by_object[$key]->is_template= TRUE;
        }
  }

}

?>
