<?php
/*!
    \brief   user plugin
    \author  Cajus Pollmeier <pollmeier@gonicus.de>
    \version 2.00
    \date    24.07.2003

    This class provides the functionality to read and write all attributes
    relevant for person, organizationalPerson, inetOrgPerson and gosaAccount
    from/to the LDAP. It does syntax checking and displays the formulars required.
 */

class user extends plugin
{
  /* CLI vars */
  var $cli_summary= "Handling of GOsa's user base object";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Plugin specific values */
  var $base= "";
  var $cn= "";
  var $personalTitle= "";
  var $academicTitle= "";
  var $homePostalAddress= "";
  var $homePhone= "";
  var $labeledURI= "";
  var $o= "";
  var $ou= "";
  var $departmentNumber= "";
  var $employeeNumber= "";
  var $employeeType= "";
  var $roomNumber= "";
  var $telephoneNumber= "";
  var $facsimileTelephoneNumber= "";
  var $mobile= "";
  var $pager= "";
  var $l= "";
  var $st= "";
  var $postalAddress= "";

  var $jpegPhoto= "*removed*";
  var $photoData= "";
  var $old_jpegPhoto= "";
  var $old_photoData= "";
  var $cert_dialog= FALSE;
  var $picture_dialog= FALSE;

  var $userPKCS12= "";
  var $userSMIMECertificate= "";
  var $userCertificate= "";
  var $certificateSerialNumber= "";
  var $old_certificateSerialNumber= "";
  var $old_userPKCS12= "";
  var $old_userSMIMECertificate= "";
  var $old_userCertificate= "";

  var $gouvernmentOrganizationalUnit= "";
  var $houseIdentifier= "";
  var $street= "";
  var $postalCode= "";
  var $vocation= "";
  var $ivbbLastDeliveryCollective= "";
  var $gouvernmentOrganizationalPersonLocality= "";
  var $gouvernmentOrganizationalUnitDescription= "";
  var $gouvernmentOrganizationalUnitSubjectArea= "";
  var $functionalTitle= "";
  var $role= "";
  var $publicVisible= "";

  /* variables to trigger password changes */
  var $pw_storage= "crypt";
  var $last_pw_storage= "crypt";

  /* attribute list for save action */
  var $attributes= array("sn", "givenName", "uid", "personalTitle", "academicTitle",
	"homePostalAddress", "homePhone", "labeledURI", "o", "ou",
	"departmentNumber", "employeeNumber", "employeeType", "l", "st",
	"roomNumber", "telephoneNumber", "mobile", "pager", "cn", "userPKCS12",
	"postalAddress", "facsimileTelephoneNumber", "userSMIMECertificate");

  var $objectclasses= array("person", "organizationalPerson", "inetOrgPerson", "gosaAccount");

  /* attributes that are part of the government mode */
  var $govattrs= array("gouvernmentOrganizationalUnit", "houseIdentifier", "vocation",
        "ivbbLastDeliveryCollective", "gouvernmentOrganizationalPersonLocality",
        "gouvernmentOrganizationalUnitDescription","gouvernmentOrganizationalUnitSubjectArea",
	"functionalTitle", "certificateSerialNumber", "publicVisible", "street", "role", "postalCode");


  /* constructor, if 'dn' is set, the node loads the given
     'dn' from LDAP */
  function user ($config, $dn= NULL)
  {
        /* Configuration is fine, allways */
        $this->config= $config;

	/* Load base attributes */
	plugin::plugin ($config, $dn);

	/* Load government mode attributes */
	if ($this->config->current['GOVERNMENTMODE']){

		/* Convert all attributs from utf8 */
		foreach ($this->govattrs as $val){
			if (isset($this->attrs["$val"][0])){
				$this->$val= utf8_decode($this->attrs["$val"][0]);
			}
		}
	}

	/* Create me for new accounts */
        if ($dn == "new"){
                $this->is_account= TRUE;
        }

	/* Load data from LDAP? */
	if ($dn != NULL){

		/* Do base conversation */
		$this->base= dn2base($dn);

		/* get password storage type */
		if (isset ($this->attrs['userPassword'][0])){
			if (preg_match ("/^{([^}]+)}(.+)/", $this->attrs['userPassword'][0], $matches)){
				$this->pw_storage= strtolower($matches[1]);
			}
		}

		/* Load extra attributes: certificate and picture */
		$this->load_cert();
		$this->load_picture();
	}

	/* Reset password storage indicator, used by password_change_needed() */
	if ($dn == "new"){
		$this->last_pw_storage= "unset";
	} else {
		$this->last_pw_storage= $this->pw_storage;
	}
  }


  /* execute generates the html output for this node */
  function execute()
  {
	$smarty= get_smarty();

	/* Do we represent a valid gosaAccount? */
	if (!$this->is_account){
		echo "<img src=\"images/stop.png\" align=center>&nbsp;<b>".
		_("This account has no valid GOsa extensions.")."</b>";
		return;
	}

	/* Want picture edit dialog? */
	if (isset($_POST['edit_picture'])){
		/* Save values for later recovery, in case some presses
		   the cancel button. */
		$this->old_jpegPhoto= $this->jpegPhoto;
		$this->old_photoData= $this->photoData;
		$this->picture_dialog= TRUE;
		$this->dialog= TRUE;
	}


	/* Remove picture? */
	if (isset($_POST['picture_remove'])){
		$this->jpegPhoto= "*removed*";
		$this->set_picture ("./images/default.jpg");

		$smarty->display (get_template_path('generic_picture.tpl', TRUE, dirname(__FILE__)));
		return;
	}

	/* Save picture */
	if (isset($_POST['picture_edit_finish'])){

		/* Check for clean upload */
		if ($_FILES['picture_file']['name'] != ""){
			if (!is_uploaded_file($_FILES['picture_file']['tmp_name'])) {
				print_red(_("The specified file has not been uploaded via HTTP POST! Aborted."));
				exit;
			}

			/* Activate new picture */
			$this->set_picture($_FILES['picture_file']['tmp_name']);
		}
		$this->picture_dialog= FALSE;
		$this->dialog= FALSE;
	}


	/* Cancel picture */
	if (isset($_POST['picture_edit_cancel'])){

		/* Restore values */
		$this->jpegPhoto= $this->old_jpegPhoto;
		$this->photoData= $this->old_photoData;

		/* Update picture */
		$_SESSION['picture']= $this->photoData;
		$this->picture_dialog= FALSE;
		$this->dialog= FALSE;
	}


	/* Want certificate= */
	if (isset($_POST['edit_cert'])){

		/* Save original values for later reconstruction */
		foreach (array("certificateSerialNumber", "userCertificate",
				"userSMIMECertificate", "userPKCS12") as $val){

			$oval= "old_$val";
			$this->$oval= $this->$val;
		}

		$this->cert_dialog= TRUE;
		$this->dialog= TRUE;
	}


	/* Cancel certificate dialog */
	if (isset($_POST['cert_edit_cancel'])){

		/* Restore original values in case of 'cancel' */
		foreach (array("certificateSerialNumber", "userCertificate",
				"userSMIMECertificate", "userPKCS12") as $val){

			$oval= "old_$val";
			$this->$val= $this->$oval;
		}
		$this->cert_dialog= FALSE;
		$this->dialog= FALSE;
	}


	/* Remove certificate? */
	foreach (array ("userCertificate", "userSMIMECertificate", "userPKCS12") as $val){
		if (isset($_POST["remove_$val"])){

			/* Reset specified cert*/
			$this->$val= "";
		}
	}


	/* Upload new cert and close dialog? */	
	if (isset($_POST['cert_edit_finish'])){

		/* for all certificates do */
		foreach (array ("userCertificate", "userSMIMECertificate", "userPKCS12")
			as $val){

			/* Check for clean upload */
			if ($_FILES[$val."_file"]['name'] != "" && 
				is_uploaded_file($_FILES[$val."_file"]['tmp_name'])) {

				$this->set_cert("$val", $_FILES[$val."_file"]['tmp_name']);
			}
		}

		/* Save serial number */
		if (isset($_POST["certificateSerialNumber"]) &&
			$_POST["certificateSerialNumber"] != ""){

			if (!is_id($_POST["certificateSerialNumber"])){
				print_red (_("Please enter a valid serial number"));

				$smarty->display (get_template_path('generic_certs.tpl', TRUE, dirname(__FILE__)));
				foreach(array("userCertificate", "userSMIMECertificate", "userPKCS12") as $cert){
					if ($this->$cert != ""){
						$smarty->assign("$cert"."_state", _("present"));
					} else {
						$smarty->assign("$cert"."_state", _("absent"));
					}
				}
				return;
			}

			$this->certificateSerialNumber= $_POST["certificateSerialNumber"];
		}

		$this->cert_dialog= FALSE;
		$this->dialog= FALSE;
	}

	/* Display picture dialog */
	if ($this->picture_dialog){
		$smarty->display (get_template_path('generic_picture.tpl', TRUE, dirname(__FILE__)));
		return;
	}

	/* Display cert dialog */
	if ($this->cert_dialog){
		foreach(array("userCertificate", "userSMIMECertificate", "userPKCS12") as $cert){
			if ($this->$cert != ""){
				$smarty->assign("$cert"."_state", _("present"));
			} else {
				$smarty->assign("$cert"."_state", _("absent"));
			}
		}
		$smarty->display (get_template_path('generic_certs.tpl', TRUE, dirname(__FILE__)));
		return;
	}

	/* Show us the edit screen */
	$smarty->assign("bases", $this->config->idepartments);
	$smarty->assign("base_select", $this->base);
	$smarty->assign("selectmode", chkacl($this->acl, "create"));
	$smarty->assign("certificatesACL", chkacl($this->acl, "certificates"));
	$smarty->assign("jpegPhotoACL", chkacl($this->acl, "jpegPhoto"));

	/* Prepare password hashes */
	if ($this->pw_storage == ""){
		$this->pw_storage= $this->config->current['HASH'];
	}
	if(function_exists('mhash')){
		$hashes= array("crypt", "md5", "ssha");
	} else {
		$hashes= array("crypt", "md5");
	}
	if (function_exists('kadm5_init_with_password') &&
		isset ($this->config->data['SERVER']['KRB_SERVER'])){

		$hashes[]= "kerberos";
	}
	$smarty->assign("pwmode", $hashes);
	$smarty->assign("pwmode_select", $this->pw_storage);
	$smarty->assign("passwordStoreageACL", chkacl($this->acl, "passwordStorage"));

	/* Load attributes and acl's */
        foreach($this->attributes as $val){
                $smarty->assign("$val", $this->$val);
                $smarty->assign("$val"."ACL", chkacl($this->acl,$val));
        }

	/* Save government mode attributes */
	if (isset($this->config->current['GOVERNMENTMODE']) &&
		preg_match('/true/i', $this->config->current['GOVERNMENTMODE'])){
		$smarty->assign("governmentmode", "true");
		$ivbbmodes= array("nein", "ivbv", "testa", "ivbv,testa", "internet",
                      "internet,ivbv", "internet,testa", "internet,ivbv,testa", "ja");
		$smarty->assign("ivbbmodes", $ivbbmodes);
		foreach ($this->govattrs as $val){
                	$smarty->assign("$val", $this->$val);
	                $smarty->assign("$val"."ACL", chkacl($this->acl,$val));
		}
	} else {
		$smarty->assign("governmentmode", "false");
	}

	/* Special mode for uid */
	$uidACL= "";
	if (isset ($this->dn)){
		if ($this->dn != "new"){
			$uidACL="readonly";
		}
	}  else {
		$uidACL= "readonly";
	}
	if ($uidACL == ""){
		$uidACL= chkacl($this->acl, "uid");
	}
	$smarty->assign("uidACL", $uidACL);
	$smarty->assign("is_template", $this->is_template);
	$smarty->display (get_template_path('generic.tpl', TRUE, dirname(__FILE__)));
  }


  /* remove object from parent */
  function remove_from_parent()
  {
	$ldap= $this->config->get_ldap_link();
	$ldap->rmdir ($this->dn);

        /* Delete references to groups */
        $ldap->cd ($this->config->current['BASE']);
        $ldap->search ("(&(objectClass=posixGroup)(memberUid=".$this->uid."))");
        while ($ldap->fetch()){
                $g= new group($this->config, $ldap->getDN());
                $g->removeUser($this->uid);
                $g->save ();
        }

	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
	if (isset($_POST['generic'])){

		/* Parents save function */
		plugin::save_object ();

		/* Save government mode attributes */
		if ($this->config->current['GOVERNMENTMODE']){
			foreach ($this->govattrs as $val){
				if (chkacl ($this->acl, "$val") == "" && isset ($_POST["$val"])){
					$this->$val= stripcslashes($_POST["$val"]);
				}
			}
		}

		/* In template mode, the uid is autogenerated... */
		if ($this->is_template){
			$this->uid= strtolower($this->sn);
			$this->givenName= $this->sn;
		}

		/* Save base and pw_storage, since these are no LDAP attributes */
		if (isset($_POST['base'])){
			$this->base= $_POST['base'];
			$this->pw_storage= $_POST['pw_storage'];
		}
	}
  }


  /* Save data to LDAP, depending on is_account we save or delete */
  function save()
  {
	/* First use parents methods to do some basic fillup in $this->attrs */
	plugin::save ();

	/* Remove additional objectClasses */
	$tmp= array();
	foreach ($this->attrs['objectClass'] as $key => $set){
		$found= false;
		foreach (array("ivbbEntry", "gosaUserTemplate") as $val){
			if (preg_match ("/^$set$/i", $val)){
				$found= true;
				break;
			}
		}
		if (!$found){
			$tmp[]= $set;
		}
	}

	/* Replace the objectClass array. This is done because of the
	   separation into government and normal mode. */
	$this->attrs['objectClass']= $tmp;

	/* Add objectClasss for template mode? */
	if ($this->is_template){
		$this->attrs['objectClass'][]= "gosaUserTemplate";
	}

	/* Hard coded government mode? */
	if ($this->config->current['GOVERNMENTMODE'] != 'false'){
		$this->attrs['objectClass'][]= "ivbbEntry";

		/* Copy standard attributes */
		foreach ($this->govattrs as $val){
			if ($this->$val != ""){
				$this->attrs["$val"]= utf8_encode($this->$val);
			} elseif (!$this->new) {
				$this->attrs["$val"]= array();
			}
		}

	}

	/* Special handling for attribute userCertificate needed */
	if ($this->userCertificate != ""){
		$this->attrs["userCertificate;binary"]= $this->userCertificate;
		$remove_userCertificate= false;
	} else {
		$remove_userCertificate= true;
	}

	/* Special handling for attribute jpegPhote needed, scale image via
	   image magick to 147x200 pixels and inject resulting data. */
	if ($this->jpegPhoto != "*removed*"){

		/* Get temporary file name for conversation */
		$fname = tempnam ("/tmp", "GOsa");

		/* Open file and write out photoData */
		$fp = fopen ($fname, "w");
		fwrite ($fp, $this->photoData);
		fclose ($fp);

		/* Build conversation query. Filename is generated automatically, so
		   we do not need any special security checks. Exec command and save
		   output. For PHP safe mode, you'll need a configuration which respects
		   image magick as executable... */
		$query= "convert -size 147x200 $fname -resize 147x200 +profile \"*\" -";
		@DEBUG (DEBUG_SHELL, __LINE__, __FUNCTION__, __FILE__,
			$query, "Execute");

		$output= shell_exec ($query);
		unlink($fname);

		/* Errors? */
		#if ($result != 0){
		#	print_red (_("Can't convert image file. Not saving image image."));
		#	$output= array();
		#}

		/* Save attribute */
		$this->attrs["jpegPhoto"] = $output;
	} elseif(!$this->new) {
		$this->attrs["jpegPhoto"] = array();
	}

	/* Build new dn */
	if (isset($this->config->current['DNMODE']) && $this->config->current['DNMODE'] == "uid"){
		$new_dn= utf8_encode('uid='.$this->uid.','.get_people_ou().',').$this->base;
	} else {
		$new_dn= utf8_encode('cn='.$this->cn.','.get_people_ou().',').$this->base;
	}

	/* This only gets called when user is renaming himself */
	if ($this->dn != $new_dn){

		/* Write entry on new 'dn' */
		$this->move($this->dn, $new_dn);

		/* Happen to use the new one */
		change_ui_dn($this->dn, $new_dn);
		$this->dn= $new_dn;
	}


	/* Save data. Using 'modify' implies that the entry is already present, use 'add' for
	   new entries. So do a check first... */
	$ldap= $this->config->get_ldap_link();
	$ldap->cat ($this->dn);
	if ($ldap->fetch()){
		$mode= "modify";
	} else {
		$mode= "add";
		$ldap->cd($this->config->current['BASE']);
		$ldap->create_missing_trees(preg_replace('/^[^,]+,/', '', $this->dn));
	}

	/* Set password to some junk stuff in case of templates */
	if ($this->is_template){
		$this->attrs['userPassword']= '{crypt}N0T$3T4N0W';
	}

	@DEBUG (DEBUG_LDAP, __LINE__, __FUNCTION__, __FILE__,
		$this->attributes, "Save via $mode");

	/* Finally write data with selected 'mode' */
	$ldap->cd ($this->dn);
	$ldap->$mode ($this->attrs);
	if (show_ldap_error($ldap->get_error())){
		return (1);
	}

	/* Remove cert? 
	   For some reason, the 'ldap' class doesn't want to remove binary entries, so I need
	   to work around myself. */
	if ($remove_userCertificate == true && !$this->new){
		/* ldap class is somewhat noisy with errors, hide them */
		error_reporting(0);

		/* Reset array, assemble new, this should be reworked */
		$this->attrs= array();
		$this->attrs['userCertificate;binary']= array();

		/* Prepare connection */
		if (!($ds = ldap_connect($this->config->current['SERVER']))) {
			die ("Could not connect to LDAP server");
		}
		ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
		if (!($res = @ldap_bind($ds, $this->config->current['ADMIN'],
					$this->config->current['PASSWORD']))) {
			die ("Could not bind to LDAP");
		}

		/* Modify using attrs */
		ldap_mod_del($ds,$this->dn,$this->attrs);
		ldap_close($ds);

		/* Back on air, want to see my errors */
		error_reporting(E_ALL);
	}

	/* Kerberos server defined? */
	if (isset($this->config->data['SERVERS']['KERBEROS'])){
		$cfg= $this->config->data['SERVERS']['KERBEROS'];
	}
	if (isset($cfg['SERVER']) && function_exists('kadm5_init_with_password')){

		/* Connect to the admin interface */
		$handle = kadm5_init_with_password($cfg['SERVER'], $cfg['REALM'],
						$cfg['ADMIN'], $cfg['PASSWORD']);

		/* Errors? */		
		if ($handle === FALSE){
			print_red (_("Kerberos database communication failed"));
			return (2);
		}

		/* Build user principal, get list of existsing principals */
		$principal= $this->uid."@".$cfg['REALM'];
		$principals = kadm5_get_principals($handle);

		/* User exists in database? */
		if (in_array($principal, $principals)){

			/* Ok. User exists. Remove him/her when pw_storage has
			   changed to be NOT kerberos. */
			if ($this->pw_storage != "kerberos"){
				$ret= kadm5_delete_principal ( $handle, $principal);

				if ($ret === FALSE){
					print_red (_("Can't remove user from kerberos database."));
				}
			}

		} else {

			/* User doesn't exists, create it when pw_storage is kerberos. */
			if ($this->pw_storage == "kerberos"){
				$ret= kadm5_create_principal ( $handle, $principal);

				if ($ret === FALSE){
					print_red (_("Can't add user to kerberos database."));
				}
			}

		}

		/* Free kerberos admin handle */
		kadm5_destroy($handle);
	}

	/* Optionally execute a command after we're done */
	$this->postcreate();

	return (0);
  }


  /* Check formular input */
  function check()
  {
	$message= array();

	/* Assemble cn */
	$this->cn= $this->sn." ".$this->givenName;

	/* Permissions for that base? */
	if (isset($this->config->current['DNMODE']) && $this->config->current['DNMODE'] == "uid"){
		$new_dn= utf8_encode('uid='.$this->uid.','.get_people_ou().',').$this->base;
	} else {
		$new_dn= utf8_encode('cn='.$this->cn.','.get_people_ou().',').$this->base;
	}

	$ui= get_userinfo();
	$acl= get_permissions ($new_dn, $ui->subtreeACL);
	$acl= get_module_permission($acl, "user", $new_dn);
	if ($this->dn == "new" && chkacl($acl, "create") != ""){
		$message[]= _("You have no permissions to create a user on this 'Base'.");
	}

	/* must: sn, givenName, uid */
	if ($this->sn == "" && chkacl ($this->acl, "sn") == ""){
		$message[]= _("The required field 'Name' is not set.");
	}

	/* UID already used? */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd($this->config->current['BASE']);
	$ldap->search("(uid=$this->uid)");
	$ldap->fetch();
	if ($ldap->count() != 0 && $this->dn == 'new'){
		$message[]= _("There's already a person with this 'Login' in the database.");
	}

	/* In template mode, the uid and givenName are autogenerated... */
	if (!$this->is_template){
		if ($this->givenName == "" && chkacl ($this->acl, "givenName") == ""){
			$message[]= _("The required field 'Given name' is not set.");
		}
		if ($this->uid == "" && chkacl ($this->acl, "uid") == ""){
			$message[]= _("The required field 'Login' is not set.");
		}
		if (!(isset($this->config->current['DNMODE']) && $this->config->current['DNMODE'] == "uid")){
			$ldap->cd($this->config->current['BASE']);
			$ldap->search("(cn=".$this->cn.")");
			$ldap->fetch();
			if ($ldap->count() != 0 && $this->dn != $new_dn && $this->dn == 'new'){
				$message[]= _("There's already a person with this 'Name'/'Given name' combination in the database.");
			}
		}
	}

	/* Check for valid input */
	if (!is_uid($this->uid)){
		$message[]= _("The field 'Login' contains invalid characters. Lowercase, numbers and dashes are allowed.");
	}
	if (!is_url($this->labeledURI)){
		$message[]= _("The field 'Homepage' contains an invalid URL definition.");
	}
	if (preg_match ("/[+\\\\]/", $this->sn)){
		$message[]= _("The field 'Name' contains invalid characters.");
	}
	if (preg_match ("/[+\\\\]/", $this->givenName)){
		$message[]= _("The field 'Given name' contains invalid characters.");
	}

	/* Check phone numbers */
	if (!is_phone_nr($this->homePhone)){
		$message[]= _("The field 'Phone' contains an invalid phone number.");
	}
	if (!is_phone_nr($this->telephoneNumber)){
		$message[]= _("The field 'Phone' contains an invalid phone number.");
	}
	if (!is_phone_nr($this->facsimileTelephoneNumber)){
		$message[]= _("The field 'Fax' contains an invalid phone number.");
	}
	if (!is_phone_nr($this->mobile)){
		$message[]= _("The field 'Mobile' contains an invalid phone number.");
	}
	if (!is_phone_nr($this->pager)){
		$message[]= _("The field 'Pager' contains an invalid phone number.");
	}

	/* Check name for reserved characers */
	if (preg_match ('/[,#:=>]/', $this->givenName)){
		$message[]= _("The field 'Given name' contains invalid characters.");
	}
	if (preg_match ('/[,#:=>]/', $this->sn)){
		$message[]= _("The field 'Name' contains invalid characters.");
	}

	return $message;
  }


  /* Indicate whether a password change is needed or not */
  function password_change_needed()
  {
	return ($this->pw_storage != $this->last_pw_storage);
  }


  /* Load a jpegPhoto from LDAP, this is going to be simplified later on */
  function load_picture()
  {
	/* make connection and read jpegPhoto */
	$ds= ldap_connect($this->config->current['SERVER']);
	ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
	$r=ldap_bind($ds);
	error_reporting (0);
	$sr=ldap_read($ds, $this->dn, "objectClass=*", array("jpegPhoto"));

	/* in case we don't get an entry, load a default picture */
	$this->set_picture ("./images/default.jpg");
	$this->jpegPhoto= "*removed*";

	/* fill data from LDAP */
	if ($sr) {
		$ei=ldap_first_entry($ds, $sr);
		if ($ei) {
			if ($info = ldap_get_values_len($ds, $ei, "jpegPhoto")){
				$this->photoData= $info[0];
				$_SESSION['picture']= $this->photoData;
				$this->jpegPhoto= "";
			}
		}
	}

	/* close conncetion */
	error_reporting (E_ALL);
	ldap_unbind($ds);
  }


  /* Load a certificate from LDAP, this is going to be simplified later on */
  function load_cert()
  {
	$ds= ldap_connect($this->config->current['SERVER']);
	ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
	$r=ldap_bind($ds);
	error_reporting (0);
	$sr=ldap_read($ds, $this->dn, "objectClass=*", array("userCertificate"));

	if ($sr) {
		$ei=ldap_first_entry($ds, $sr);
		if ($ei) {
			if (!$info = ldap_get_values_len($ds, $ei, "userCertificate;binary")){
				$this->userCertificate= "";
			} else {
				$this->userCertificate= $info[0];
			}
		}
	} else {
		$this->userCertificate= "";
	}

	error_reporting (E_ALL);
	ldap_unbind($ds);
  }


  /* Load picture from file to object */
  function set_picture($filename)
  {
	if (!is_file($filename)){
		$filename= "./images/default.jpg";
		$this->jpegPhoto= "*removed*";
	}

	$fd = fopen ($filename, "rb");
	$this->photoData= fread ($fd, filesize ($filename));
	$_SESSION['picture']= $this->photoData;
	$this->jpegPhoto= "";

	fclose ($fd);
  }


  /* Load certificate from file to object */
  function set_cert($cert, $filename)
  {
	$fd = fopen ($filename, "rb");
	$this->$cert= fread ($fd, filesize ($filename));
	fclose ($fd);
  }

  /* Adapt from given 'dn' */
  function adapt_from_template($dn)
  {
	plugin::adapt_from_template($dn);

	/* Get base */
	$this->base= $this->config->idepartments[preg_replace('/^[^,]+,'.get_people_ou().',/i', '', $dn)];

        if ($this->config->current['GOVERNMENTMODE']){
	
		/* Walk through govattrs */
		foreach ($this->govattrs as $val){

			if (isset($this->attrs["$val"][0])){

				/* If attribute is set, decode from utf8 and replace
				   dynamic parts: %sn, %givenName and %uid. Fill these
				   in our local variables. */
				$value= utf8_decode($this->attrs["$val"][0]);

				foreach (array("sn", "givenName", "uid") as $repl){
					if (preg_match("/%$repl/i", $value)){
						$value= preg_replace ("/%$repl/i",
								$this->parent->$repl, $value);
					}
				}
				$this->$val= $value;
			}
		}
	}

	/* Get back uid/sn/givenName */
	if ($this->parent != NULL){
		$this->uid= $this->parent->uid;
		$this->sn= $this->parent->sn;
		$this->givenName= $this->parent->givenName;
	}
  }

  /* This is a workaround function. */
  function move($src_dn, $dst_dn)
  {
	$ldap= $this->config->get_ldap_link();
	$ldap->cat($dst_dn);
	$attrs= $ldap->fetch();
	if (count($attrs)){
		trigger_error("Trying to overwrite $dst_dn, which already exists.", 
				E_USER_WARNING);
		return;
	}

	$ldap->cat($src_dn);
	$attrs= array();
	$attrs= $ldap->fetch();
	if (!count($attrs)){
		trigger_error("Trying to move $src_dn, which does not seem to exist.", 
				E_USER_WARNING);
		return;
	}

	/* Grummble. This really sucks. PHP ldap doesn't support rdn stuff. */
	$ds= ldap_connect($this->config->current['SERVER']);
	ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
	$r=ldap_bind($ds,$this->config->current['ADMIN'], $this->config->current['PASSWORD']);
	error_reporting (0);
	$sr=ldap_read($ds, $this->dn, "objectClass=*");

	/* Fill data from LDAP */
	$new= array();
	if ($sr) {
		$ei=ldap_first_entry($ds, $sr);
		if ($ei) {
			foreach($attrs as $attr => $val){
				if ($info = ldap_get_values_len($ds, $ei, $attr)){
					for ($i= 0; $i<$info['count']; $i++){
						if ($info['count'] == 1){
							$new[$attr]= $info[$i];
						} else {
							$new[$attr][]= $info[$i];
						}
					}
				}
			}
		}
	}

        /* close conncetion */
	error_reporting (E_ALL);
	ldap_unbind($ds);

	/* Save copy */
	$new['cn']= utf8_encode($this->cn);
	$ldap->cd($this->config->current['BASE']);
	$ldap->create_missing_trees(preg_replace('/^[^,]+,/', '', $dst_dn));
	$ldap->cd($dst_dn);
	$ldap->add($new);

	if ($ldap->error != "Success"){
		trigger_error("Trying to save $dst_dn failed.", 
				E_USER_WARNING);
		return;
	}

	/* Delete source */
	$ldap->rmdir($src_dn);
	if ($ldap->error != "Success"){
		trigger_error("Trying to delete $src_dn failed.", 
				E_USER_WARNING);
		return;
	}
  }

}

?>
