<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class dhcpGroup extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage DHCP groups";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Used attributes */
  var $cn= "";
  var $options= array();
  var $statements= array();

  /* attribute list for save action */
  var $attributes= array("cn");
  var $objectclasses= array("dhcpGroup", "dhcpOptions");

  function dhcpGroup($config, $dn= NULL)
  {
	/* Load bases attributes */
	plugin::plugin($config, $dn);

	/* Load statements / options */
	if ($this->dn != "new"){

                /* Load options */
                if (isset($this->attrs['dhcpOption'])){
                        for($i= 0; $i<$this->attrs['dhcpOption']['count']; $i++){
                                $tmp= $this->attrs['dhcpOption'][$i];
                                $idx= preg_replace('/\s.+$/', '', $tmp);
                                $value= preg_replace('/^[^\s]+\s/', '', $tmp);
                                $this->options[$idx]= $value;
                        }
                }

                /* Load statements */
                if (isset($this->attrs['dhcpStatements'])){
                        for($i= 0; $i<$this->attrs['dhcpStatements']['count']; $i++){
                                $tmp= $this->attrs['dhcpStatements'][$i];
                                $idx= preg_replace('/\s.+$/', '', $tmp);
                                $value= preg_replace('/^[^\s]+\s/', '', $tmp);
                                $this->statements[$idx]= $value;
                        }
                }

	}

	/* This is always an account */
	$this->is_account= TRUE;
  }

  function execute()
  {
	$smarty= get_smarty();
	$smarty->assign("cn", $this->cn);

	if ($this->dn != "new"){
		$smarty->assign("mode", "readonly");
	}

	/* Show main page */
	$smarty->display (get_template_path('group.tpl', TRUE));
  }

  function remove_from_parent()
  {
	/* Just remove the dn from the ldap, then we're done. Host
	   entries do not have any entries below themselfes. */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd($this->dn);
	$ldap->recursive_remove();
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
  	plugin::save_object();
  }


  /* Check values */
  function check()
  {
	$message= array();

	/* All required fields are set? */
	if ($this->cn == ""){
		$message[]= _("Required field 'Name' is not filled.");
	}

	/* cn already used? */
	if ($this->dn != "new"){
		$ldap= $this->config->get_ldap_link();
		$ldap->cd($this->config->current['BASE']);
		$ldap->search("(&(objectClass=dhcpGroup)(cn=".$this->cn."))");
		if ($ldap->count() >= 1){
			while ($attrs= $ldap->fetch()){
				if ($ldap->getDN() != $this->dn){
					$message[]= _("The name for this group section is already used!");
					break;
				}

			}
		}
		$ldap->fetch();
	}

	return $message;
  }


  /* Save to LDAP */
  function save()
  {
	plugin::save();

	/* Get ldap mode */
	if ($this->dn == "new"){
		$mode= "add";
	} else {
		$mode= "modify";
	}

	/* Generate new dn */
	if ($this->parent->parent != NULL && $this->dn == "new"){
                $this->dn= "cn=".utf8_encode($this->cn).",".$this->parent->parent;
        }

	
	/* Assemble new entry - options */
	if (isset ($this->options) && count ($this->options)){
		$this->attrs['dhcpOption']= array();
		foreach ($this->options as $key => $val){
			$this->attrs['dhcpOption'][]= "$key $val";
		}
	} else {
		if ($mode == "modify"){
			$this->attrs['dhcpOption']= array();
		}
	}
	
	/* Assemble new entry - statements */
	if (isset ($this->statements) && count ($this->statements)){
		$this->attrs['dhcpStatements']= array();
		foreach ($this->statements as $key => $val){
			$this->attrs['dhcpStatements'][]= "$key $val";
		}
	} else {
		if ($mode == "modify"){
			$this->attrs['dhcpStatements']= array();
		}
	}

	/* Do LDAP action */
	$ldap= $this->config->get_ldap_link();
	if ($mode == "add"){
		$ldap->cd($this->config->current['BASE']);
		$ldap->create_missing_trees(preg_replace('/^[^,]+,/', '', $this->dn));
	}
	$ldap->cd($this->dn);
	$ldap->$mode($this->attrs);
	show_ldap_error($ldap->get_error());
  }
  
}

?>
