<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
require "tabs_dhcp.inc";

class dhcpManagement extends plugin
{
  /* Internal use */
  var $sectlist= array();
  var $list= array();
  var $dhcptabs= NULL;

  /* Dialog attributes */
  var $ui= NULL;

  function dhcpManagement ($config, $ui)
  {
	/* Save configuration for internal use */
	$this->config= $config;
	$this->ui= $ui;

        /* Get global filter config */
        if (!is_global("dhcpfilter")){
                $ui= get_userinfo();
                $base= get_base_from_people($ui->dn);
                $dhcpfilter= array("entry" => "",
                                "depselect" => $base,
                                "regex" => "");
                register_global("dhcpfilter", $dhcpfilter);
        }
  }

  function execute()
  {
        /* Save data */
        $dhcpfilter= get_global("dhcpfilter");
        foreach( array("depselect", "entry", "regex") as $type){
                if (isset($_POST[$type])){
                        $dhcpfilter[$type]= $_POST[$type];
                }
        }
        register_global("dhcpfilter", $dhcpfilter);

        /* Check sorting variable */
	if (!isset($this->dhcptabs)){
		$this->reload();
	}
	$smarty= get_smarty();
	$ldap= $this->config->get_ldap_link();

	/* Dialog canceled */
	if (isset($_POST['edit_cancel'])){
                del_lock ($this->dhcptabs->dn);
                del_lock ($this->dn);
                $this->dhcptabs= NULL;
	}

	/* Want to create a new section? */
	if (isset($_POST['create_section'])){
	
		/* Get types */
		if (isset($_POST['sectlist'])){
			$parent= $_POST['sectlist'];
			$type= $this->get_type($parent);
		} else {
			$parent= "none";
			$type= "none";
		}

		/* Check validity */
		$combinations= array(	"dhcpService" => array("none", "dhcpService", "dhcpSharedNetwork", "dhcpSubnet", "dhcpGroup", "dhcpPool", "dhcpHost"),
					"dhcpSubnet" => array("dhcpService", "dhcpSharedNetwork"),
					"dhcpGroup" => array("dhcpService", "dhcpSubnet",
								"dhcpSharedNetwork", "dhcpGroup"),
					"dhcpHost" => array("dhcpService", "dhcpGroup",
								"dhcpSharedNetwork", "dhcpSubnet"),
					"dhcpPool" => array("dhcpSubnet", "dhcpSharedNetwork"),
					"dhcpSharedNetwork" => array("dhcpService"));

		$ctype= $_POST['typeselect'];
		if (isset($combinations[$ctype])){
			if (!in_array($type, $combinations[$ctype])){
				if ($parent == 'none' && $ctype != "dhcpService"){
					print_red(_("It is not possible to create parent objects other than 'Service'."));
				} else {
					print_red(sprintf(_("You've choosen to create an object of type '%s' inside of section '%s', which is not possible."), $ctype, $type));
				}
			} else {
				$this->create($ctype, $parent);
			}
		} else {
			print_red(_("Can't find selected type in code, please contact the developers."));
		}
	}

	/* Edit? */
	if (isset($_POST['select_section']) && isset($_POST['sectlist']) && count($_POST['sectlist'])){
		
		/* Get type of entry */
		$type= $this->get_type($_POST['sectlist']);

		/* Edit entry... */
		if ($this->edit($type, $_POST["sectlist"])){
			return;
		}
	}

        /* Finish section edit is triggered by the tabulator dialog, so
           the user wants to save edited data. Check and save at this
           point. */
        if (isset($_POST['edit_finish'])){

                /* Check tabs, will feed message array */
                $this->dhcptabs->last= $this->dhcptabs->current;
                $this->dhcptabs->save_object();
                $message= $this->dhcptabs->check();

                /* Save, or display error message? */
                if (count($message) == 0){

                        /* Save data data to ldap */
                        $this->dhcptabs->save();
			gosa_log ("DHCP object'".$this->dn."' has been saved");
                        $this->postcreate();

                        /* Application has been saved successfully, remove lock from
                           LDAP. */
                        if ($this->dn != "new"){
                                del_lock ($this->dn);
                        }

                        /* There's no page reload so we have to read new apps at
                           this point. */
                        $this->reload ();
                        unset ($this->dhcptabs);
                        $this->dhcptabs= NULL;

                } else {
                        /* Ok. There seem to be errors regarding to the tab data,
                        show message and continue as usual. */
                        show_errors($message);
                }
        }

        if (isset($_POST['delete_section']) && isset($_POST['sectlist'])){
		/* Get 'dn' from posted 'list', must be unique */
                $this->dn= $_POST['sectlist'];

                /* Load permissions for selected 'dn' and check if
                   we're allowed to remove this 'dn' */
                $acl= get_permissions ($this->dn, $this->ui->subtreeACL);
                $this->acl= get_module_permission($acl, "dhcp", $this->dn);
                if (chkacl($this->acl, "delete") == ""){

                        /* Check locking, save current plugin in 'back_plugin', so
                           the dialog knows where to return. */
                        if (($user= get_lock($this->dn)) != ""){
                                gen_locked_message ($user, $this->dn);
                                return;
                        } else {
                                # Lock this dn for editing
                                add_lock ($this->dn, $this->ui->dn);

				$smarty->assign("message", sprintf(_("You're about to delete all information about the section of type '%s' at '%s'."), $this->get_type($this->dn), utf8_decode($this->dn)));
                                $smarty->display(get_template_path('remove.tpl', TRUE));
                                return;
                        }
                } else {
                        /* Obviously the user isn't allowed to delete. Show message and
                           clean session. */
                        print_red (_("You are not allowed to delete this section!"));
                }
	}
	

        /* Confirmation for deletion has been passed. Section should be deleted. */
        if (isset($_POST['delete_section_confirm'])){

                /* Some nice guy may send this as POST, so we've to check
                   for the permissions again. */
                if (chkacl($this->acl, "delete") == ""){

                        /* Delete request is permitted, perform LDAP action */
			$type= $this->get_type($this->dn);
			$this->dhcptabs= new dhcptabs($this->config,
				$this->config->data['TABS'][strtoupper($type)], $this->dn);
                        $this->dhcptabs->set_acl(array($this->acl));
	                $this->dhcptabs->delete ();
			gosa_log ("DHCP object'".$this->dn."' has been removed");
                        unset ($this->dhcptabs);
                        $this->dhcptabs= NULL;

                        /* Zone list has changed, reload it. */
                        $this->reload ();
                } else {

                        /* Normally this shouldn't be reached, send some extra
                           logs to notify the administrator */
                        print_red (_("You are not allowed to delete this section!"));
                        gosa_log ("Warning: '".$this->ui->uid."' tried to trick section deletion.");
                }

                /* Remove lock file after successfull deletion */
                del_lock ($this->dn);
        }



	/* Show tab dialog if object is present */
	if ($this->dhcptabs != NULL){
		$this->dhcptabs->execute();

		/* Don't show buttons if tab dialog requests this */
		if (!$this->dhcptabs->by_object[$this->dhcptabs->current]->dialog){
			echo "<p style=\"text-align:right\">\n";
			echo "<input type=submit name=\"edit_finish\" value=\""._("Finish")."\">\n";
			echo "&nbsp;\n";
			echo "<input type=submit name=\"edit_cancel\" value=\""._("Cancel")."\">\n";
			echo "</p>";
		}
		return;
	}

	/* Show main page */
	$smarty->assign("sectlist", $this->sectlist);
	$smarty->assign("infoimage", get_template_path('images/info.png'));
	$smarty->assign("launchimage", get_template_path('images/launch.png'));
        foreach( array("depselect", "entry", "regex") as $type){
                $smarty->assign("$type", $dhcpfilter[$type]);
        }
        $smarty->assign("deplist", $this->config->idepartments);
	$temp= array("dhcpService" => _("Service"), "dhcpSubnet" => _("Subnet"),
		"dhcpGroup" => _("Group"), "dhcpHost" => _("Host"), "dhcpPool" => _("Pool"),
		"dhcpSharedNetwork" => _("Shared network"));
	natsort($temp);
	$smarty->assign("typelist", $temp);

	/* Extend if we are not using javascript */
	$smarty->assign("apply", apply_filter());
		
	$smarty->display(get_template_path('headpage.tpl', TRUE));
  }


  function create($type, $parent)
  {
	/* By default we set 'dn' to 'new', all relevant plugins will
	   react on this. */
	$this->dn= "new";

	/* Create new dhcptabs object */
	$this->dhcptabs= new dhcptabs($this->config,
		$this->config->data['TABS'][strtoupper($type)], $this->dn, $parent);
	$this->dhcptabs->set_acl(array(':all'));
  }

  
  function edit($type, $dn)
  {
	/* Check if we're editing a valid entry */
	if ($type == "none"){
		print_red (sprintf(_("Can't determine object type for object '%s'."), $dn));
                del_lock ($this->dn);
		return (1);
	}

	$this->dn= $dn;

	/* Check locking, save current plugin in 'back_plugin', so
	   the dialog knows where to return. */
	if (($user= get_lock($this->dn)) != ""){
		gen_locked_message ($user, $this->dn);
		return (1);
	}

	/* Lock the current entry, so everyone will get the
           above dialog */
	add_lock ($this->dn, $this->ui->dn);

	/* Set up the users ACL's for this 'dn' */
	$acl= get_permissions ($this->dn, $this->ui->subtreeACL);

	$this->dhcptabs= new dhcptabs($this->config,
		$this->config->data['TABS'][strtoupper($type)], $this->dn);
	$this->dhcptabs->set_acl($acl);
	return (0);
  }

  
  function reload()
  {
	/* Get config */
        $dhcpfilter= get_global('dhcpfilter');

        /* Set base for all searches */
        $base= $dhcpfilter['depselect'];

        /* Regex filter? */
        if ($dhcpfilter['regex'] != ""){
                $regex= $dhcpfilter['regex'];
        } else {
                $regex= "";
        }

        /* User filter? */
        if ($dhcpfilter['entry'] != ""){
		# FIXME
		$filter= "";
        } else {
                $filter= "";
        }

	/* Get list of sections to be shown */
        $ldap= $this->config->get_ldap_link();
        $showSections= array();

	/* Generate section list */
	$this->list= get_list($this->ui->subtreeACL, "(objectClass=dhcpService)", $base);
	$final= array();
	foreach ($this->list as $value){

		/* Set header */
		$sortpart= split(",", $value['dn']);
                $sortpart= array_reverse($sortpart);
                $tmp= implode(",", $sortpart);

		$final[$value['dn']]= $tmp."!"._("Service")." '".utf8_decode($value['cn'][0])."'";
		
		/* Read all sub entries to place here */
		$ldap->cd($value['dn']);
		$ldap->search("(|(objectClass=dhcpLog)(objectClass=dhcpClass)(objectClass=dhcpSubClass)(objectClass=dhcpLeases)(objectClass=dhcpHost)(objectClass=dhcpGroup)(objectClass=dhcpPool)(objectClass=dhcpSubnet)(objectClass=dhcpSharedNetwork))");

		while ($attrs= $ldap->fetch()){
			$tmp= preg_replace("/".$value['dn']."/", "", $ldap->getDN());
			$indent= substr_count($tmp, ",");
			$spaces= "";
			for ($i= 0; $i<$indent; $i++){
				$spaces.= "&nbsp;&nbsp;&nbsp;&nbsp;";
			}
			$types= array(	"dhcpLog" => _("Logging"),
					"dhcpClass" => _("Class"),
					"dhcpSubClass" => _("Subclass"),
					"dhcpLeases" => _("Lease"),
					"dhcpHost" => _("Host"),
					"dhcpGroup" => _("Group"),
					"dhcpPool" => _("Pool"),
					"dhcpSubnet" => _("Subnet"),
					"dhcpSharedNetwork" => _("Shared network"));
					
			foreach ($types as $key => $val){
				if (in_array("$key", $attrs['objectClass'])){
					$type= $val;
					break;
				}
			}
			
			/* Prepare for sorting... */
			$sortpart= split(",", $ldap->getDN());
			$sortpart= array_reverse($sortpart);
			$tmp= implode(",", $sortpart);
			$final[$ldap->getDN()]= $tmp."!".$spaces.$type." '".$attrs['cn'][0]."'";
		}
	}
	
	/* Sort it... */
	natsort($final);
	$this->sectlist= array();
	foreach ($final as $key => $val){
		$this->sectlist[$key]= preg_replace('/^[^!]+!(.*)$/', '\\1', $val);
	}
  }

  function remove_from_parent()
  {
	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Check values */
  function check()
  {
  }


  /* Save to LDAP */
  function save()
  {
	/* Optionally execute a command after we're done */
	$this->postcreate();
  }

  function adapt_from_template($dn)
  {
  }

  function password_change_needed()
  {
  }

  function show_header($button_text, $text, $disabled= FALSE)
  {
  }

  function remove_lock()
  {
        del_lock ($this->dhcptabs->dn);
  }

  function get_type($parent)
  {
	$ldap= $this->config->get_ldap_link();
	$ldap->cat($parent);
	$attrs= $ldap->fetch();

	/* Determine object Type */
	foreach(array("dhcpService", "dhcpSubnet", "dhcpGroup", "dhcpHost",
			"dhcpPool", "dhcpSharedNetwork", "unknown") as $type){
		if (in_array($type, $attrs['objectClass'])){
			break;
		}
	}

	return ($type);
  }

}

?>
