<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class dhcpService extends plugin
{
  /* CLI vars */
  var $cli_summary= "Handle DHCP configurations";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Used attributes */
  var $cn= "";
  var $base= "";
  var $dhcpPrimaryDN= "";
  var $orig_dhcpPrimaryDN= "";
  var $options= array();
  var $statements= array();

  /* attribute list for save action */
  var $attributes= array("cn", "dhcpPrimaryDN");
  var $objectclasses= array("dhcpService");
  var $servers= array();

  function dhcpService($config, $dn= NULL)
  {
        /* Load bases attributes */
        plugin::plugin($config, $dn);

	/* Eventually get server list */
	if (!count($this->servers)){
		$ldap= $this->config->get_ldap_link();
		$ldap->cd($this->config->current['BASE']);
		$ldap->search('(objectClass=goServer)');
		while($attrs= $ldap->fetch()){
			$this->servers[$ldap->getDN()]= $attrs['cn'][0];
		}
	}
	
	/* Save for later action */
	$this->orig_dhcpPrimaryDN= $this->dhcpPrimaryDN;

	/* This is always an account */
	$this->is_account= TRUE;
  }

  function execute()
  {
	/* Show main page */
	$smarty= get_smarty();
	$smarty->assign("cn", $this->cn);
	$smarty->assign("base_id", $this->base);
	if ($this->dn != "new"){
		$smarty->assign("mode", "disabled");
	}
	$smarty->assign ("base_options", $this->config->idepartments);
	$smarty->assign ("servers", $this->servers);
	$smarty->assign ("dhcpPrimaryDN", $this->dhcpPrimaryDN);
	$smarty->display (get_template_path('service.tpl', TRUE));
  }

  function remove_from_parent()
  {
        /* Just remove the dn from the ldap, then we're done. Host
           entries do not have any entries below themselfes. */
        $ldap= $this->config->get_ldap_link();
        $ldap->cd($this->dn);
        $ldap->recursive_remove();
        show_ldap_error($ldap->get_error());

	$ldap->cat($this->dhcpPrimaryDN);
	$attrs= $ldap->fetch();
	$objectclasses= array();
	for($i= 0; $i<$attrs['objectClass']['count']; $i++){
		if ($attrs['objectClass'][$i] != "dhcpServer"){
			$objectclasses[]= $attrs['objectClass'][$i];
		}
	}
	$attrs= array();
	$attrs['dhcpServiceDN']= array();
	$attrs['objectClass']= $objectclasses;
	$ldap->cd($this->dhcpPrimaryDN);
	$ldap->modify($attrs);
	show_ldap_error($ldap->get_error());


	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
  	plugin::save_object();

	/* Save base */
	if (isset($_POST['base'])){
		$this->base= $_POST['base'];
	}
  }


  /* Check values */
  function check()
  {
	$message= array();
	/* All required fields are set? */
        if ($this->cn == ""){
                $message[]= _("Required field 'Name' is not filled.");
        }
        if ($this->dhcpPrimaryDN == ""){
                $message[]= _("No server specified to host dhcp service!");
        }

	return $message;
  }


  /* Save to LDAP */
  function save()
  {
        plugin::save();

        /* Get ldap mode */
        if ($this->dn == "new"){
                $mode= "add";
		$this->dn= "cn=".utf8_encode($this->cn).",ou=dhcp,ou=configs,ou=systems,".$this->base;
        } else {
                $mode= "modify";
        }

        /* Assemble new entry - options */
        if (isset ($this->options) && count ($this->options)){
                $this->attrs['dhcpOption']= array();
                foreach ($this->options as $key => $val){
                        $this->attrs['dhcpOption'][]= "$key $val";
                }
        } else {
                if ($mode == "modify"){
                        $this->attrs['dhcpOption']= array();
                }
        }

        /* Assemble new entry - statements */
        if (isset ($this->statements) && count ($this->statements)){
                $this->attrs['dhcpStatements']= array();
                foreach ($this->statements as $key => $val){
                        $this->attrs['dhcpStatements'][]= "$key $val";
                }
        } else {
                if ($mode == "modify"){
                        $this->attrs['dhcpStatements']= array();
                }
        }

        /* Do LDAP action */
        $ldap= $this->config->get_ldap_link();
        if ($mode == "add"){
		$ldap->cd($this->config->current['BASE']);
                $ldap->create_missing_trees(preg_replace('/^[^,]+,/', '', $this->dn));
        }
        $ldap->cd($this->dn);
        $ldap->$mode($this->attrs);
        show_ldap_error($ldap->get_error());

	/* Modify server entry to keep our 'dn' */
	$ldap->cat($this->dhcpPrimaryDN);
	$attrs= $ldap->fetch();
	$objectclasses= array();
	for($i= 0; $i<$attrs['objectClass']['count']; $i++){
		if ($attrs['objectClass'][$i] != "dhcpServer"){
			$objectclasses[]= $attrs['objectClass'][$i];
		}
	}
	$objectclasses[]= "dhcpServer";
	$attrs= array();
	$attrs['dhcpServiceDN']= $this->dn;
	$attrs['objectClass']= $objectclasses;
	$ldap->cd($this->dhcpPrimaryDN);
	$ldap->modify($attrs);
	show_ldap_error($ldap->get_error());

	/* Modify old server entry */
	if ( ($this->orig_dhcpPrimaryDN != "")
		&& ($this->orig_dhcpPrimaryDN != $this->dhcpPrimaryDN)){

		$ldap->cat($this->orig_dhcpPrimaryDN);
		$attrs= $ldap->fetch();
		if (isset($attrs['dhcpServiceDN'])){
			$objectclasses= array();
			for($i= 0; $i<$attrs['objectClass']['count']; $i++){
				if ($attrs['objectClass'][$i] != "dhcpServer"){
					$objectclasses[]= $attrs['objectClass'][$i];
				}
			}
			$attrs= array();
			$attrs['dhcpServiceDN']= array();
			$attrs['objectClass']= $objectclasses;
			$ldap->cd($this->orig_dhcpPrimaryDN);
			$ldap->modify($attrs);
			show_ldap_error($ldap->get_error());
		}
	}
  }
  
}

?>
