<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class dnsEntries extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage DNS zone entries";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Parameters  */
  var $option_name= array();
  var $option_type= array();
  var $option_value= array();
  var $zonedn= "";
  var $zoneName= "";

  var $dnstypes= array("A", "CNAME", "AAAA", "MD", "MX", "PTR", "HINFO", "MINFO",
			"TXT", "SIG", "KEY", "LOC", "NXT", "SRV", "NAPTR",
			"KX", "CERT", "A6", "DNAME");

  /* attribute list for save action */
  var $attributes= array();
  var $objectclasses= array();

  function dnsEntries ($config, $dn= NULL)
  {
  	/* Nothing to do with normal plugin:: stuff */
	$index= 0;
	$this->dn= $dn;
	$this->config= $config;

	/* Get ldap link and parse all dnsZone entries */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd($this->dn);
	$ldap->search("(&(objectClass=dnsZone)(!(relativeDomainName=@)))");
	while ($attrs= $ldap->fetch()){
		$name= $attrs['relativeDomainName'][0];
		$this->zoneName= $attrs['zoneName'][0];
		
		foreach ($this->dnstypes as $key){
			$ckey= strtolower($key{0}).substr($key, 1)."Record";
			if (isset($attrs[$ckey])){
				for ($i= 0; $i<$attrs[$ckey]['count']; $i++){
					$this->option_name[$index]= $name;
					$this->option_type[$index]= $key;
					$this->option_value[$index]= utf8_decode(trim($attrs[$ckey][$i], "\""));
					$index++;
				}
			}
		}
	}

	/* Sort combobox/dns entries for better readability */
	sort($this->dnstypes);
	asort($this->option_name);

	/* This one is allways true */
	$this->is_account= TRUE;
  }

  function execute()
  {
	/* Add option to list */
	if (isset($_POST['add_entry'])){

		/* Still an empty name present? */
		foreach ($this->option_name as $value){
			if ($value == ""){
				break;
			}
		}
		
		if ($value == ""){
			print_red (_("There's still one unfilled field in the list."));
		} else {
			$i= count($this->option_name);
			$this->option_name[$i]= "";
			$this->option_type[$i]= "A";
			$this->option_value[$i]= "";
		}
	}

	/* Remove value from list */
	$removed= "";
	$count= 0;
	foreach ($this->option_name as $i => $dummy){
		if (isset($_POST["remove$i"])){
			$removed= $this->option_name[$i];
			$pos= $i;
			foreach ($this->option_name as $name){
				if ($name == $removed){
					$count++;
				}
			}
			break;
		}
		if (isset($_POST["append$i"])){
			$j= count($this->option_name);
			$this->option_name[$j]= $this->option_name[$i];
			$this->option_type[$j]= "TXT";
			$this->option_value[$j]= "";

			asort ($this->option_name);
			break;
		}
	}

	if ($removed != ""){
		$k= 0;
		$on= array();
		$ot= array();
		$ov= array();
		
		for ($i= 0; $i<count($this->option_name); $i++){
			if ($count == 1 && $this->option_name[$i] != $removed &&
				!preg_match("/[ ]*".$removed.".".
					$this->zoneName."[ ]*/", $this->option_value[$i])){
				
				$on[$k]= $this->option_name[$i];
				$ot[$k]= $this->option_type[$i];
				$ov[$k]= $this->option_value[$i];
				$k++;
			}
			if ($count != 1 && $i != $pos){
				$on[$k]= $this->option_name[$i];
				$ot[$k]= $this->option_type[$i];
				$ov[$k]= $this->option_value[$i];
				$k++;
			}
		}

		$this->option_name= $on;
		$this->option_type= $ot;
		$this->option_value= $ov;

		asort ($this->option_name);
	}

	/* Generate list of attributes */
	if (count($this->option_name) == 0){
		$this->option_name[0]= "";
		$this->option_value[0]= "";
		$this->option_type[0]= "";
	}
	$table= "";
	$oldname= "<invalid>";

	if (count ($this->option_name)){
		foreach ($this->option_name as $i => $name){
			$selector= "<select name=\"type$i\">";
			foreach ($this->dnstypes as $val){
				if ($val == $this->option_type[$i]){
					$filler= " selected";
				} else {
					$filler= "";
				}
				$selector.= "<option$filler>$val</option>";
			}
			$selector.= "</select>";
			
			/* Hide name field for common entries */
			if ($oldname == $name){
				$filler= "";
			} else {
				$filler= "<input name=\"option$i\" size=25 maxlength=50 ".
					"value=\"".$this->option_name[$i]."\">";
			}
			$oldname= $name;
			
			$table.="<tr><td>$filler</td><td>$selector</td>".
				"<td><input name=\"value$i\" "."size=35 maxlength=80 ".
				"value=\"".$this->option_value[$i]."\"><br></td><td>".
				"<input type=\"submit\" name=\"remove$i\" value=\"".
				_("Remove")."\">&nbsp;<input type=\"submit\" name=\"".
				"append$i\" value=\""._("Extend")."\"></td></tr>";
		}
	}

	/* Show main page */
	$smarty= get_smarty();
	$smarty->assign("table", $table);
	$smarty->display (get_template_path('entries.tpl', TRUE));
  }

  function remove_from_parent()
  {
	$ldap= $this->config->get_ldap_link();
	$ldap->cd ($this->dn);
	$ldap->recursive_remove();

	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
	if (isset($_POST['option0'])){

		$oldname= "<invalid>";
		foreach ($this->option_name as $i => $dummy){
			if (!isset($_POST["option$i"])){
				$this->option_name[$i]= $oldname;
			} else {
				$this->option_name[$i]= $_POST["option$i"];
			}
			if (isset($_POST["option$i"])){
				$oldname= $_POST["option$i"];
			}
			$this->option_type[$i]= $_POST["type$i"];
			$this->option_value[$i]= "";
			if ($_POST["value$i"] != ""){
				$this->option_value[$i]= $_POST["value$i"];
			}
		}
	}
  }


  /* Check values */
  function check()
  {
  	/* This one is not yet integrated and somewhat complicated.
	   Need to read some more about bind, etc. */
	$message= array();
	return $message;
  }


  /* Save to LDAP */
  function save()
  {
	/* Check if base has changed and delete values if needed */
	if ($this->dn != $this->zonedn && $this->dn != 'new'){
		$this->remove_from_parent();
	}

	/* Walk thru entries currently present in ldap, delete the ones that
	   are not in the list. */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd($this->zonedn);
	$ldap->search("(&(objectClass=dnsZone)(!(relativeDomainName=@)))");
	while ($attrs= $ldap->fetch()){
		if (!in_array($attrs['relativeDomainName'][0], $this->option_name)){
			$ldap->rmDir($ldap->getDN());
		}
	}

	/* Walk thru arrays and create/modify all zone entries. */
	$attrs= array();
	$oldname= "<invalid>";
	foreach ($this->option_name as $index => $name){
		$ldap->cd($this->zonedn);
		$ldap->search("(&(objectClass=dnsZone)(relativeDomainName=$name))");

		if ($name != $oldname){
			if (count($attrs)){
				$ldap->cd("relativeDomainName=$oldname,".$this->zonedn);
				$ldap->$mode($attrs);
				show_ldap_error($ldap->get_error());
			}
			$attrs= array();
			$attrs['objectClass']= array("dnsZone", "top");
			$attrs['zoneName']= $this->zoneName;
			$attrs['relativeDomainName']= $name;
			$oldname= $name;

			/* Set mode here */
			if ($ldap->count() == 1){
				$mode= "modify";
				foreach ($this->dnstypes as $key){
					$ckey= strtolower($key{0}).substr($key, 1)."Record";
					$attrs[$ckey]= array();
				}
			} else {
				$mode= "add";
			}
			
		}
		$key= $this->option_type[$index];
		$key= strtolower($key{0}).substr($key, 1)."Record";
		$attrs[$key]= $this->option_value[$index];
	}

	/* Write last entry */
	if (count($attrs)){
	        if ($mode == "add"){
			$ldap->cd($this->config->current['BASE']);
                	$ldap->create_missing_trees($this->zonedn);
       		}
		$ldap->cd("relativeDomainName=$oldname,".$this->zonedn);
		$ldap->$mode($attrs);
		show_ldap_error($ldap->get_error());
	}
	

  }

}

?>
