#!/usr/bin/perl
#
# Parse squid log and write current traffic usage by users
#
# Igor Muratov <migor@altlinux.org>
#

use strict;
use DB_File;

my $log = '/var/log/squid/access.log';
my $db = '/var/spool/squid/quota.db';
my %quota;
my $format = "L L L";

tie(%quota, 'DB_File', $db, O_CREAT|O_RDWR);

open(LOG, "< $log");
my $i = 0;
while(<LOG>)
{
	my @line = split / +/;
	$i++;

	# Get timestamp and skip line if timestamp is old
	(my $timestamp = $line[0]) =~ s/\..*//;
	next if $quota{TIMESTAMP} > $timestamp;
	next if $quota{TIMESTAMP} == $timestamp and $quota{STRING_NUMBER} >= $i;

	# Skip line if traffic is local
	(my $errcode = $line[3]) =~ s/(\w+)\/(\d+)/$1/;
	next if $errcode eq "TCP_HIT";
	next if $errcode eq "TCP_DENIED";

	# Get filesize and username
	my $bytes = $line[4];
	(my $user = $line[7]) =~ s/^-$/anonymous/;

	# Memorize timestamp and line number
	$quota{TIMESTAMP} = $timestamp;
	$quota{STRING_NUMBER} = $i;

	# Memorize timestamp and line number
	my ($traffic, $first, $last) = unpack($format, $quota{$user});
	$quota{$user} = pack($format, $traffic+$bytes, $first || $timestamp, $timestamp);
	#printf "%s: %s (%s/%s)\n", $user, $traffic+$bytes, $first || $timestamp, $timestamp;
}
close(LOG);

untie %quota;

