#!/bin/sh

ORIG=`pwd`
TEMPDIR="/tmp/gosa-locale"

echo "Creating temporary directory"
[ -d $TEMPDIR ] && rm -rf $TEMPDIR
mkdir $TEMPDIR

echo "Creating copy of GOsa"
tar c . | tar x -C $TEMPDIR

echo "Converting .tpl files"
pushd . &> /dev/null
cd $TEMPDIR

for template in $(find -name '*.tpl'); do
	sed -e 's/{t}/<?php $t= _("/g;s!{/t}!");?>!g' $template > $template.new
	mv $template.new $template
done

for class in $(find -name 'class_*.inc'); do
	sed -e 's/\($pl[DH][^=]*\)= *"\([^"]*\)";$/\1= _("\2");/g' $class > $class.new
	mv $class.new $class
done

echo "Converting strings from gosa.conf"
sed -e 's/headline="\([^"]*\)"/<?php $headline=_("\1");?>/g;s/name="\([^"]*\)"/<?php $t= _("\1");?>/g' contrib/gosa.conf > contrib/gosa.conf.new
mv contrib/gosa.conf.new contrib/gosa.conf

echo "Extracting languages"
rm locale/messages.po
(echo contrib/gosa.conf; find . -name '*.[ctpi][ophn][nlpc]') | xgettext -f - --omit-header --keyword=must -d Domain -L PHP -n -o locale/messages.po

echo "Merging po files with existing ones"
for f in locale/??/LC_MESSAGES; do
	msgmerge $f/messages.po locale/messages.po --output-file=$f/messages.po.new
done

echo "Copying new po files, making backups"
find . -name messages.po | while read f; do
        [ -f $ORIG/$f ] && mv $ORIG/$f $ORIG/$f.orig
	echo $f | grep -q "locale/messages.po"
	if [ $? -ne 0 ]; then
		 echo "* replaced $ORIG/$f"
        	cp $f.new $ORIG/$f
	else
        	cp $f $ORIG/$f
	fi
done

rm -rf $TEMPDIR

cat << EOF

Now edit all files that have been replaced above (i.e. using kbabel)
and mail the changes to gosa@oss.gonicus.de to be included in the
next release.

To see the changes you've made in GOsa, run "msgfmt messages.po"
on your freshly edited files and restart your apache after that.
Set the webbrowser to the language you've edited and go back to
the login screen.

EOF

popd &> /dev/null
