<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Load required includes */
require_once ("../include/php_setup.inc");
require_once ("functions.inc");
require_once ("setup_checks.inc");

/* Don't call setup if gosa.conf exists */
if (file_exists(CONFIG_DIR."/gosa.conf")){
        header("location:index.php");
        exit();
}

/* Set error handler to own one, initialize time calculation
   and start session. */
session_start ();
$_SESSION['DEBUGLEVEL']= "0";
$_SESSION['errors']= "";

/* Download config? */
if (isset($_SESSION['classes']) && isset($_SESSION['ldapconf']) && isset($_GET['getconfig'])){
	$classes= $_SESSION['classes'];
	$ldapconf= $_SESSION['ldapconf'];
	foreach($ldapconf as $key => $value){
		$$key= $value;
	}

	/* Set detected samba version */
	if (isset($classes['samba2'])){
		$samba= "3";
	} else {
		$samba= "2";
	}

	/* Set pwdhash */
        $query= "mkntpwd 2>&1";
        $output= shell_exec ($query);
        if (preg_match("/^Usage: mkntpwd /", $output)){
		$pwdhash= "mkntpwd";
	} else {
		$pwdhash= "perl -MCrypt::SmbHash -e \"ntlmgen \\\"\\\$ARGV[0]\\\", \\\$lm, \\\$nt; print \\\"\\\${lm}:\\\${nt}\\\n\\\";\"";
        }


	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");
	header("Cache-Control: no-cache");
	header("Pragma: no-cache");
	header("Cache-Control: post-check=0, pre-check=0");
	header("Content-type: text/plain");
	if (preg_match('/MSIE 5.5/', $_SERVER['HTTP_USER_AGENT']) ||
	        preg_match('/MSIE 6.0/', $_SERVER['HTTP_USER_AGENT'])) {

	        header('Content-Disposition: filename="gosa.conf"');
	} else {
	        header('Content-Disposition: attachment; filename="gosa.conf"');
	}

	echo <<<EOT
<?xml version="1.0"?>
<conf>
        <menu>
                <section name="My account">
                        <plugin acl="default" class="user" icon="personal.png"
                                path="plugins/personal/generic" />
                        <plugin acl="default" class="posixAccount" icon="posix.png"
                                path="plugins/personal/posix" />
                        <plugin acl="default" class="mailAccount" icon="email.png"
                                path="plugins/personal/mail" />
                        <plugin acl="default" class="sambaAccount" icon="samba.png"
                                path="plugins/personal/samba" />

EOT;
	echo <<<EOT
			<plugin acl="default" class="proxyAccount" icon="proxy.png"
                                path="plugins/personal/proxy" />

EOT;
	if (!isset($classes['pureftp'])){
		echo <<<EOT
                        <plugin acl="default" class="pureftpdAccount" icon="ftp.png"
                                path="plugins/personal/pureftpd" />

EOT;
	}
	echo <<<EOT
                        <plugin acl="default" class="gofaxAccount" icon="fax.png"
                                path="plugins/gofax/faxaccount" />
                        <plugin acl="default" class="password" icon="password.png"
                                path="plugins/personal/password" />
                </section>

                <section name="Administration">
                        <plugin acl="user" class="userManagement" icon="user.png"
                                path="plugins/admin/users" />
                        <plugin acl="group" class="groupManagement" icon="group.png"
                                path="plugins/admin/groups" />
                        <plugin acl="ogroup" class="ogroupManagement" icon="ogroup.png"
                                path="plugins/admin/ogroups" />
                        <plugin acl="department" class="departmentManagement" icon="department.png"
                                path="plugins/admin/departments" />
                        <plugin acl="application" class="applicationManagement"
                                icon="application.png" path="plugins/admin/applications" />
                        <plugin acl="blocklists" class="blocklist" icon="blocklists.png"
                                path="plugins/gofax/blocklists" />
                        <plugin acl="systems" class="systems" icon="system.png"
                                path="plugins/admin/systems" />
                </section>

                <section name="Addons">
                        <plugin acl="default" class="addressbook" icon="addressbook.png"
                                path="plugins/addons/addressbook" />
                        <plugin acl="default" class="faxreport" icon="reports.png"
                                path="plugins/gofax/reports" />
                        <plugin acl="ldif" class="export" icon="ldif.png"
                                path="plugins/addons/ldifexport" />
                </section>
        </menu>

        <usertabs>
                <tab class="user" name="Generic" />
                <tab class="posixAccount" name="Unix" />
                <tab class="mailAccount" name="Mail" />
                <tab class="sambaAccount" name="Samba" />

EOT;
	echo <<<EOT
		<tab class="proxyAccount" name="Proxy" />

EOT;
	if (!isset($classes['pureftp'])){
		echo <<<EOT
                <tab class="pureftpdAccount" name="FTP" />

EOT;
	}

	echo <<<EOT
		<tab class="gofaxAccount" name="Fax" />
		<tab class="reference" name="References" />
        </usertabs>

        <grouptabs>
                <tab class="group" name="Generic" />
                <tab class="appgroup" name="Applications" />
                <tab class="mailgroup" name="Mail" />
                <tab class="acl" name="ACL" />
                <tab class="reference" name="References" />
        </grouptabs>

        <appstabs>
                <tab class="application" name="Generic" />
                <tab class="applicationParameters" name="Options" />
                <tab class="reference" name="References" />
        </appstabs>

        <termtabs>
                <tab class="termgeneric" name="Generic" />
                <tab class="termservice" name="Devices" />
                <tab class="termstartup" name="Startup" />
                <tab class="terminfo" name="Monitoring"
                        wakecmd="/usr/bin/sudo /usr/sbin/etherwake" />
                <tab class="reference" name="References" />
        </termtabs>

        <worktabs>
                <tab class="workgeneric" name="Generic" />
                <tab class="termservice" name="Devices" />
                <tab class="termstartup" name="Startup" />
                <tab class="terminfo" name="Monitoring"
                        wakecmd="/usr/bin/sudo /usr/sbin/etherwake" />
                <tab class="reference" name="References" />
        </worktabs>

        <printtabs>
                <tab class="printgeneric" name="Generic" />
                <tab class="reference" name="References" />
        </printtabs>

	<deptabs>
                <tab class="department" name="Generic" />
                <tab class="reference" name="References" />
        </deptabs>

        <ogrouptabs>
                <tab class="ogroup" name="Generic" />
                <tab class="reference" name="References" />
        </ogrouptabs>

EOT;

	echo <<<EOT

        <main default="$location"
                compile="/var/spool/gosa"
                lang=""
                theme="default"
                debuglevel="0"
                forcessl="false"
                warnssl="false"
                iconsize="48x48"
                pwminlen="6"
                forceglobals="false"
                smbhash='$pwdhash'>

                <location name="$location"
                        uidbase="$uidbase"
                        governmentmode="false"
                        sambaversion="$samba"
			mailMethod="Cyrus"
                        server="$uri"
                        admin="$admin"
                        hash="md5"
                        password="$password"
                        dnmode="$peopledn"
                        base="$base"
                        people="$peopleou"
                        groups="$groupou"
			vacationdir="/etc/gosa/vacation"
                        config="ou=gosa,ou=configs,ou=systems,$base" />

                <language name="German" tag="de_DE" />
                <language name="Russian" tag="ru_RU" />
                <language name="Spanish" tag="es_ES" />
                <language name="French" tag="fr_FR" />
                <language name="English" tag="en_EN" />

                <faxformat type="pdf" />
                <faxformat type="ps" />
                <faxformat type="png" />
                <faxformat type="mtiff" />
                <faxformat type="tiff" />
        </main>
</conf>
EOT;

	exit;
}

/* Set template compile directory */
$smarty->compile_dir= '/var/spool/gosa';

/* Check for compile directory */
if (!(is_dir($smarty->compile_dir) && is_writable($smarty->compile_dir))){
	print_red(sprintf(_("Directory '%s' specified as compile directory is not accessable!"), $smarty->compile_dir));
	exit();
}

/* Language setup */
$lang= get_browser_language();
header("Content-type: text/html; charset=UTF-8");
$lang.=".UTF-8";
putenv("LANGUAGE=");
putenv("LANG=$lang");
setlocale(LC_ALL, $lang);
$GLOBALS['t_language']= $lang;
$GLOBALS['t_gettext_message_dir'] = $BASE_DIR.'/locale/';

/* Set the text domain as 'messages' */
$domain = 'messages';
bindtextdomain($domain, "$BASE_DIR/locale");
textdomain($domain);

if ($_SERVER["REQUEST_METHOD"] != "POST"){
	@DEBUG (DEBUG_TRACE, __LINE__, __FUNCTION__, __FILE__, $lang, "Setting language to");
}

/* Fill template with required values */
$smarty->assign ('date', gmdate("D, d M Y H:i:s"));

if (isset($_POST['continue'])){
	$_SESSION['step']= 2;
}
if (isset($_POST['continue2'])){
	$_SESSION['step']= 3;
}
if (isset($_POST['continue3'])){
	$_SESSION['step']= 4;
}
if (isset($_POST['check'])){
	$_SESSION['step']= 5;
}
if (isset($_POST['retry'])){
	$_SESSION['step']= 6;
}

if (!isset($_SESSION['step'])){
	$smarty->assign ("content", get_template_path('setup_introduction.tpl'));
	$smarty->assign ("tests", perform_php_checks($faults));
	if ($faults){
		$smarty->assign("mode", "disabled");
	}
} else {

	switch ($_SESSION['step']){
		case 2:
			$smarty->assign ("content", get_template_path('setup_step2.tpl'));
			$smarty->assign ("tests", perform_additional_checks($faults));
			if ($faults){
				$smarty->assign("mode", "disabled");
			}
			break;

		case 3:
			$smarty->assign ("content", get_template_path('setup_step3.tpl'));
			$smarty->assign ("uri", "ldap://localhost:389");
			break;

		case 4:
			if (!isset($_POST['uri']) || $_POST['uri'] == ''){
				print_red (_("You've to specify an ldap server before continuing!"));
				$smarty->assign ("content", get_template_path('setup_step3.tpl'));
				break;
			}

			/* Build LDAP connection */
			error_reporting(0);
			$ds= ldap_connect (validate($_POST['uri']));
			if (!$ds) {
				print_red (_("Can't connect to the specified LDAP server! Please make sure that is reachable for GOsa."));
				$smarty->assign ("content", get_template_path('setup_step3.tpl'));
				$smarty->assign ("uri", validate($_POST['uri']));
				break;
			}
			ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
			$r= ldap_bind ($ds);
			if (!$r) {
				print_red (_("Can't bind to the specified LDAP server! Please make sure that is reachable for GOsa."));
				$smarty->assign ("content", get_template_path('setup_step3.tpl'));
				$smarty->assign ("uri", validate($_POST['uri']));
				break;
			}

			/* Get base to look for schema */
			$sr= ldap_read ($ds, "", "objectClass=*", array("namingContexts"));
			$attr= ldap_get_entries($ds,$sr);
			if (isset($attr[0]['dn'])){
				$base= $attr[0]['dn'];
			} else {
				$base= "dc=example,dc=net";
			}
			error_reporting(E_ALL);

			$ldapconf= array(	"uri" => validate($_POST['uri']),
						"base" => $base,
						"admin" => "cn=ldapadmin,$base",
						"password" => "",
						"peopleou" => "people",
						"groupou" => "groups",
						"peopledn" => "cn",
						"location" => "Example",
						"uidbase" => "1000");
			$_SESSION['ldapconf']= $ldapconf;

			$smarty->assign ("content", get_template_path('setup_step4.tpl'));
			foreach($ldapconf as $key => $val){
				$smarty->assign($key, $val);
			}
			$smarty->assign ("peopledns", array("cn", "uid"));
			break;

		case 5:
			$ldapconf= $_SESSION['ldapconf'];
			$showstopper= false;
			foreach ($ldapconf as $key => $val){
				if ($key == "uri" || $key == "base"){
					continue;
				}
				if (!isset($_POST[$key]) || $_POST[$key] == ""){
					print_red(sprintf(_("You're missing the required attribute '%s' from this formular. Please complete!"), $key));
					$showstopper= true;
					$_SESSION['ldapconf']= $ldapconf;
					$smarty->assign ("content", get_template_path('setup_step4.tpl'));
					foreach($ldapconf as $key => $val){
						$smarty->assign($key, $val);
					}
					$smarty->assign ("peopledns", array("cn", "uid"));
					break;
				}
				$ldapconf[$key]= validate($_POST[$key]);
			}
			$_SESSION['ldapconf']= $ldapconf;
			if (!$showstopper){
				$ldap= new LDAP($ldapconf['admin'], $ldapconf['password'], $ldapconf['uri']);
				if ($ldap->error != "Success"){
					print_red(sprintf(_("Can't log into LDAP server. Reason was: %s."), $ldap->get_error()));
					$smarty->assign ("content", get_template_path('setup_step4.tpl'));
					foreach($ldapconf as $key => $val){
						$smarty->assign($key, $val);
					}
					$smarty->assign ("peopledns", array("cn", "uid"));
					break;
				}

				/* Schema check */
				$m= schema_check($ldapconf['uri'], $ldapconf['admin'], $ldapconf['password']);
				$_SESSION['classes']= $m;
				$errors= 0;
				$message= "";
				foreach ($m as $key => $msg){
					if ($key != 'dns' && $key != 'dhcp' && $key != 'pureftp' && ! ($key == 'samba2' || $key == 'samba3') ){
						$errors++;
						$message.= "$msg!<br>";
					}
				}
				if ($errors){
					print_red (preg_replace('/<br>$/', '', $message));
					$smarty->assign ("content", get_template_path('setup_step4.tpl'));
					foreach($ldapconf as $key => $val){
						$smarty->assign($key, $val);
					}
					$smarty->assign ("peopledns", array("cn", "uid"));
				} else {
					$info= posix_getgrgid(posix_getgid());
					$smarty->assign ("webgroup", $info['name']);
					$smarty->assign ("path", CONFIG_DIR);
					$smarty->assign ("content", get_template_path('setup_finish.tpl'));
				}
			}
			break;
			
		case 6:

			/* Check for config - and permissions */
			if (!file_exists(CONFIG_DIR."/gosa.conf")){
				print_red (_("No configuration found! Please save the generated one and place it in the suggested directory."));
				$info= posix_getgrgid(posix_getgid());
				$smarty->assign ("webgroup", $info['name']);
				$smarty->assign ("path", CONFIG_DIR);
				$smarty->assign ("content", get_template_path('setup_finish.tpl'));
				break;
			}
			$res= stat(CONFIG_DIR."/gosa.conf");
			if ($res['mode'] != 33184 || $res['uid'] != 0 || $res['gid'] != posix_getgid()){
				print_red (_("Config file found, but permissions are not secure. Please fix!"));
				$info= posix_getgrgid(posix_getgid());
				$smarty->assign ("webgroup", $info['name']);
				$smarty->assign ("path", CONFIG_DIR);
				$smarty->assign ("content", get_template_path('setup_finish.tpl'));
				break;
			}

			header ("Location: index.php");
			exit;
	}
}

/* show login screen */
$smarty->display (get_template_path('headers.tpl'));
$smarty->display (get_template_path('setup.tpl'));

?>

</body>

</html>
