<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2004  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


class mailMethodCyrus extends mailMethod
{
  var $mbox= "-";
  var $config;
  var $gosaMailServer= "";

  function mailMethodCyrus($config)
  {
	$this->config= $config->data['SERVERS']['IMAP'];
  }

  function connect($gosaMailServer)
  {
	/* Connect to IMAP server. I don't want to see these warning here... */
	error_reporting (0);
	$this->gosaMailServer= $gosaMailServer;
	$cfg= $this->config[$gosaMailServer];
	$this->mbox = @imap_open($cfg['connect'], $cfg['admin'], $cfg['password'], OP_HALFOPEN);
	error_reporting (E_ALL);

	/* Mailbox reachable? */
	if ($this->mbox === FALSE){
		print_red (_("Warning: IMAP Server cannot be reached! If you save this account, some mail settings will not be stored on your server!"));
		return (FALSE);
	}
	return (TRUE);
  }

  function disconnect()
  {
	imap_close ($this->mbox);
  }

  function getQuota($folder)
  {
	$result= array('quotaUsage' => '', 'gosaMailQuota' => '');

	/* Load quota settings */
	error_reporting (0);
	$quota_value = @imap_get_quota($this->mbox, $folder);
	if(is_array($quota_value)) {
		if (isset($quota_value["STORAGE"]) && is_array($quota_value["STORAGE"])){
			# use for PHP >= 4.3
			$result['quotaUsage']=    $quota_value["STORAGE"]['usage'];
			$result['gosaMailQuota']= $quota_value["STORAGE"]['limit'];
		} else {
			# backward compatible
			$result['quotaUsage']=    $quota_value['usage'];
			$result['gosaMailQuota']= $quota_value['limit'];
		}
	}
	error_reporting (E_ALL);

	return ($result);
  }

  function getMailboxList($folder, $uid)
  {
	$result= array("INBOX");

	/* Get list of mailboxes for combo box */
	$cfg= $this->config[$this->gosaMailServer];
	$list = imap_listmailbox($this->mbox, $cfg["connect"], $folder.".*");
	if (is_array($list)){
		foreach ($list as $val){
			$result[]=preg_replace ("/.*user\.".$uid."\./",
						"INBOX.", imap_utf7_decode ($val));
		}
	}

	return ($result);
  }

  function updateMailbox($folder)
  {
	/* Check if mailbox exists */
	$cfg= $this->config[$this->gosaMailServer];
	$list = imap_listmailbox($this->mbox, $cfg["connect"], $folder);
	if ($list === FALSE){
		if (!imap_createmailbox($this->mbox, $cfg["connect"]. $folder)){
			print_red(sprintf(_("Can't create IMAP mailbox. Server says '%s'."), imap_last_error()));
			return;
		}
	}
  }


  function setQuota($folder, $gosaMailQuota)
  {
	/* Workaround for the php imap extension */
	if ($gosaMailQuota == ""){
		$gosaMailQuota= "0";
	}

	/* Write mail quota */
	if (!imap_set_quota($this->mbox, $folder, $gosaMailQuota)){
		print_red(sprintf(_("Can't write IMAP quota. Server says '%s'."), imap_last_error()));
		return (FALSE);
	}
	return (TRUE);
  }


  function setSharedFolderPermissions($folder, $defaultperm, $members, $memberperm, $admins)
  {
	/* Set shared folder acl's */
	if (function_exists('imap_getacl')){

		/* Remove all acl's */
		$users= imap_getacl ($this->mbox, $folder);
		foreach ($users as $userid => $perms){
			imap_setacl ($this->mbox, $folder, $userid, "");
		}

		imap_setacl ($this->mbox, $folder, "anyone", $defaultperm);
		foreach ($members as $user){
			imap_setacl ($this->mbox, $folder, $user, $memberperm);
		}
		foreach ($admins as $user){
			imap_setacl ($this->mbox, $folder, $user, "lrswipcda");
		}
	}

	/* Show warning message in case of missing imap_getacl */
	if (!function_exists('imap_getacl')){
		print_red (_("Warning: imap_getacl is not implemented, wouldn't modify acl informations."));
	}
  }


  function getSharedFolderPermissions($folder)
  {
	$result= array("default_permissions" => "", "member_permissions" => "", "admins" => array());
	$admins= array();
	$default_permissions= "";
	$member_permissions= "";

	/* imap_getacl available? */
	if (!function_exists('imap_getacl')){
		print_red (_("Warning: imap_getacl is not available, can't get imap permissions!"));
	}

	/* Get permissions in case of shared folders */
	else {
		$this->admins= array();

		$users= imap_getacl ($this->mbox, $folder);

		/* load permissions, these are all users with "lrswipcda" rights,
		   this is a ugly hack... */
		foreach ($users as $userid => $perms){
			if ($perms == "lrswipcda"){
				$admins[]= preg_replace("/^user\./", "", $userid);
			}
			if ($userid == 'anyone'){
				$result["default_permissions"]= $perms;
			}
			if ($userid != "anyone" && $perms != "lrswipcda"){
				$result["member_permissions"]= $perms;
			}
			$result["admins"]= $admins;
		}

	} /* get folder permissions */

	return ($result);
  }

  function deleteMailbox($folder)
  {
	$cfg= $this->config[$this->gosaMailServer];
	if (!imap_deletemailbox($this->mbox, $cfg["connect"].$folder)){
		print_red(sprintf(_("Can't remove IMAP mailbox. Server says '%s'."), imap_last_error()));
		return (FALSE);
	}
	return (TRUE);
  }


  function configureFilter($user, $gosaMailDeliveryMode,
				$mail, $gosaMailAlternateAddress,
				$gosaMailMaxSize,
				$gosaSpamMailbox, $gosaSpamSortLevel,
				$gosaVacationMessage)
  {
        $cfg= $this->config[$this->gosaMailServer];

        /* Build spamlevel. Spamassassin tags mails with "*" for each integer
           point of spam. So a spam level of 5.3 gets "*****" which can be
           checked easily by spam filters */
        $spamlevel= "";
        for ($i= 0; $i<$gosaSpamSortLevel; $i++){
                $spamlevel .= "*";
        }

        /* Log into the mail server */
        $sieve= new sieve($cfg["sieve_server"], $cfg["sieve_port"], $user,
			$cfg["password"], $cfg["admin"]);

        if (!$sieve->sieve_login()){
		print_red(sprintf(_("Can't log into SIEVE server. Server says '%s'."),
			to_string($sieve->error_raw)));
		return;
        }

       /* Load current script from server and remove everything between the comments
          "###GOSA" */
        $script= "";
        if($sieve->sieve_listscripts()){
                if (in_array("gosa", $sieve->response)){

                        /* get old GOsa script */
                        if(!$sieve->sieve_getscript("gosa")){
                                print_red(sprintf(_("Can't get sieve script. Server says '%s'."), to_string($sieve->error_raw)));
                                return;
                        }

                        foreach ($sieve->response as $line){
                                if (preg_match ("/^###GOSA/", $line)){
                                        break;
                                }
                                $line= rtrim($line);
                                if (!preg_match ('/^\s*$/', $line)){
                                        $script .= $line."\n";
                                }
                        }

                }
        }

	/* Only create a new one, if it is not empty */
        if (is_integer(strpos($gosaMailDeliveryMode, "R")) ||
                is_integer(strpos($gosaMailDeliveryMode, "C")) ||
                !is_integer(strpos($gosaMailDeliveryMode, "L")) ||
                is_integer(strpos($gosaMailDeliveryMode, "V")) ||
                is_integer(strpos($gosaMailDeliveryMode, "S"))){

                $text= preg_replace('/"/', '\\"', implode ("", file(CONFIG_DIR."/sieve-header.txt")));
                eval ("\$script.=\"$text\";");
        }

        /* Add anti-spam code */
        if (is_integer(strpos($gosaMailDeliveryMode, "S"))){
                $spambox= $gosaSpamMailbox;
                $text= preg_replace('/"/', '\\"', implode ("", file(CONFIG_DIR."/sieve-spam.txt")));
                eval ("\$script.=\"$text\";");
        }

        /* Add "reject due to mailsize" code, message is currently not
           adjustable through GOsa. */
        if (is_integer(strpos($gosaMailDeliveryMode, "R"))){
                $maxsize= $gosaMailMaxSize;
                $text= preg_replace('/"/', '\\"', implode ("", file(CONFIG_DIR."/sieve-mailsize.txt")));
                eval ("\$script.=\"$text\";");
        }

        /* Add vacation information */
        if (is_integer(strpos($gosaMailDeliveryMode, "V"))){

                /* Sieve wants all destination addresses for the
                   vacation message, so we've to assemble them from
                   mail and mailAlternateAddress */
                $addrlist= "\"".$mail."\"";
                foreach ($gosaMailAlternateAddress as $val){
                        $addrlist .= ", \"$val\"";
                }
                $vacmsg= $gosaVacationMessage;
                $text= preg_replace('/"/', '\\"', implode ("", file(CONFIG_DIR."/sieve-vacation.txt")));
                eval ("\$script.=\"$text\";");
        }

        /* If no local delivery is wanted, tell the script to discard the mail */
        if (!is_integer(strpos($gosaMailDeliveryMode, "L"))){
                $text= preg_replace('/"/', '\\"', implode ("", file(CONFIG_DIR."/sieve-discard.txt")));
                eval ("\$script.=\"$text\";");
        }

        /* Just be aware of null scripts... */
        if (!isset ($script)){
                $script= "";
        }

        /* Upload script and make it the default one */
        if (!$sieve->sieve_sendscript("gosa", $script)){
                print_red(sprintf(_("Can't send sieve script. Server says '%s'."), to_string($sieve->error_raw)));
                return;
        }
        if(!$sieve->sieve_setactivescript("gosa")){
                print_red(sprintf(_("Can't activate GOsa sieve script. Server says '%s'."), to_string($sieve->error_raw)));
                return;
        }

        $sieve->sieve_logout();
  }

}

?>
