<?php

class workservice extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage terminal service aspects";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  var $gotoScannerEnable;
  /* Generic terminal attributes */
  var $gotoXMonitor= "";
  var $gotoXDriver= "";
  var $gotoXResolution= "";
  var $gotoXColordepth= "";
  var $gotoXHsync= "";
  var $gotoXVsync= "";
  var $gotoXKbModel= "";
  var $gotoXKbLayout= "";
  var $gotoXKbVariant= "";
  var $gotoXMouseType= "";
  var $gotoXMouseport= "";
  var $gotoScannerClients= "";
  var $gotoScannerBackend= "";
  var $goFonHardware= "automatic";

  /* Needed values and lists */
  var $ignore_account= TRUE;
  var $base= "";
  var $cn= "";
  var $orig_dn= "";
  var $XMethods= array();
  var $XDrivers= array("unknown", "ati", "atimisc", "chips", "cirrus", "cyrix", "fbdev",
      "i128", "i740", "i810", "imstt", "mga", "neomagic", "newport", "nsc",  "nv",
      "r128", "radeon", "rendition", "s3", "s3virge", "savage", "siliconmotion",
      "sis", "tdfx", "tga", "trident", "tseng", "vesa", "vga");
  var $XResolutions= array("default", "640x480", "800x600", "1024x768", "1152x864", "1280x1024",
      "1400x1050", "1600x1200");
  var $XColordepths= array("default", "8", "15", "16", "24");
  var $XKbModels= array ("default", "btc9000", "chicony", "compaq", "dell", "dell101", "everex",
      "flexpro", "geniuscomfy", "hp", "itouch", "jp106", "logicordless",
      "logiinetnav", "logiinternet", "macintosh", "microsoft",
      "microsoftpro", "omnikey101", "pc101", "pc102", "pc104",
      "pc105", "rapidaccess", "rapidaccess2", "winbook");
  var $XKbLayouts= array ("default", "de", "intl", "us");
  var $XKbVariants= array ("default", "nodeadkeys", "basic");
  var $MouseTypes= array("AUTO", "ImPS/2", "PS/2", "Microsoft", "Logitech");
  var $MousePorts= array("AUTO", "/dev/ttyS0", "/dev/ttyS1", "/dev/psaux", "/dev/input/mice");
  var $hardware_list= array();
  var $used_hardware= array();


  /* attribute list for save action */
  var $attributes= array("gotoXMonitor",
      "gotoXDriver", "gotoXResolution", "gotoXColordepth",
      "gotoXHsync", "gotoXVsync",
      "gotoScannerEnable", "gotoScannerClients",
      "gotoScannerBackend", "gotoXKbModel", "gotoXKbLayout", "gotoXKbVariant",
      "gotoXMouseType", "gotoXMouseport", "goFonHardware");
  var $objectclasses= array("GOhard");


  function workservice ($config, $dn= NULL)
  {
    plugin::plugin ($config, $dn);

    /* Initialize methods */
    $this->XMethods["default"]= _("default");
    $this->XMethods["indirect"]= _("show chooser");
    $this->XMethods["query"]= _("direct");
#$this->XMethods["squery"]= _("direct via ssh");
#$this->XMethods["nquery"]= _("direct via nx");
    $this->XMethods["load"]= _("load balanced");
#$this->XMethods["sload"]= _("load balanced via ssh");
#$this->XMethods["nload"]= _("load balanced via nx");
    $this->XMethods["rdp"]= _("Windows RDP");
    $this->XMethods["citrix"]= _("ICA client");

    $this->orig_dn= $this->dn;

    /* Load hardware list */
    $ldap= $this->config->get_ldap_link();
    $ldap->cd($this->config->current['BASE']);
    $ldap->search("(objectClass=goFonHardware)", array('cn', 'description'));
    while ($attrs= $ldap->fetch()){
      $cn= $attrs['cn'][0];
      if (isset($attrs['description'])){
        $description= " - ".$attrs['description'][0];
      } else {
        $description= "";
      }
      $this->hardware_list[$cn]= "$cn$description";
    }

    /* Eventually colorize phones */
    $ldap->cd($this->config->current['BASE']);
    foreach ($this->hardware_list as $cn => $desc){
      $ldap->search("(goFonHardware=$cn)", array('cn'));
      if ($ldap->count() > 0){
        $ldap->fetch();
        if ($ldap->getDN() != $this->dn){
          $this->used_hardware[$cn]= $ldap->getDN();
        }
      }
    }

    $this->hardware_list["automatic"]= _("automatic");
    ksort($this->hardware_list);
  }

  function execute()
  {
	/* Call parent execute */
	plugin::execute();

    /* Do we need to flip is_account state? */
    if (isset($_POST['modify_state'])){
      $this->is_account= !$this->is_account;
    }

    /* Do we represent a valid terminal? */
    if (!$this->is_account && $this->parent == NULL){
      $display= "<img alt=\"\" src=\"images/stop.png\" align=\"middle\">&nbsp;<b>".
        _("This 'dn' has no terminal features.")."</b>";
      return ($display);
    }

    /* Show main page */
    $smarty= get_smarty();

    /* Arrays */ 
    foreach(array("XMethods", "XDrivers", "XResolutions", "XColordepths",
          "XKbModels", "XKbLayouts", "XKbVariants",
          "MouseTypes", "MousePorts") as $val){
      $smarty->assign("$val", $this->$val);
    }
    $smarty->assign("xdmcpservers", $this->config->data['SERVERS']['TERMINAL']);
    $smarty->assign("fontservers", $this->config->data['SERVERS']['FONT']);
    $smarty->assign("nfsservers", $this->config->data['SERVERS']['NFS']);
    $smarty->assign("nfsservers", $this->config->data['SERVERS']['NFS']);

    /* Variables - select */
    foreach(array(
          "gotoXDriver", "gotoXResolution", "gotoXColordepth", 
          "gotoXKbModel", "gotoXKbLayout","gotoScannerEnable",
          "gotoXKbVariant", "gotoXMouseType", "gotoXMouseport") as $val){

      $smarty->assign($val."_select", $this->$val);
      $smarty->assign($val."ACL", chkacl($this->acl, $val));
    }

    /* Variables */
    foreach(array("gotoXHsync", "gotoXVsync") as $val){
      $smarty->assign($val, $this->$val);
      $smarty->assign($val."ACL", chkacl($this->acl, $val));
    }
    $smarty->assign("staticAddress", "");

    /* Checkboxes */
    foreach(array("gotoScannerEnable") as $val){
      if ($this->$val == TRUE) {
        $smarty->assign("$val", "checked");
      } else {
        $smarty->assign("$val", "");
      }
    }

    /* Phone stuff */
    $smarty->assign ("goFonHardware", $this->goFonHardware);
    $hl= "<select size=\"1\" name=\"goFonHardware\" title=\"".
         _("Choose the phone located at the current terminal")."\" ".
         chkacl($this->acl, "goFonHardware").">\n";
    foreach ($this->hardware_list as $cn => $description){
      if ($cn == $this->goFonHardware){
        $selected= "selected";
      } else {
        $selected= "";
      }
      if (isset($this->used_hardware[$cn])){
        $color= "style=\"color:#A0A0A0\"";
      } else {
        $color= "";
      }
      $hl.= "  <option $color label=\"$cn\" value=\"$cn\" $selected>$description</option>\n";
    }
    $hl.= "</select>\n";
    $smarty->assign ("hardware_list", $hl);
    $smarty->assign ("gotoXMonitor", $this->gotoXMonitor);

    /* Show main page */
    return($smarty->fetch (get_template_path('workstationService.tpl',TRUE,dirname(__FILE__))));
  }

  function remove_from_parent()
  {
    /* This is not necessary, i think 
     * Remove should be called from workGeneric ... 
     */
    /*$ldap= $this->config->get_ldap_link();
    $ldap->rmdir($this->dn);
    show_ldap_error($ldap->get_error());
    $this->handle_post_events("remove");
    */
   
    /* This only removes the attributes from this tab, 
     * and not hte whole entry 
     */ 
    $ldap= $this->config->get_ldap_link();
    plugin::remove_from_parent();
    $ldap->cd($this->dn);
    $ldap->modify($this->attrs);
    show_ldap_error($ldap->get_error());}


  /* Save data to object */
  function save_object()
  {
    plugin::save_object();

  }


  /* Check supplied data */
  function check()
  {
    $message= array();

    /* Default entries can use blank hsync/vsync entries */
    if ($this->dn != "" && $this->cn != "default" && $this->cn != "wdefault"){

      /* Check vsync for correct usage */
      $val= preg_replace ("/\s/", "", $this->gotoXVsync);
      if (!preg_match ("/^\d+(\.\d+)?(\-\d+(\.\d+)?)?$/", $val)
          && chkacl ($this->acl, "gotoXVsync") == ""){

        $message[]= _("Please specify a valid VSync range.");
      } elseif (chkacl ($this->acl, "gotoXVsync") == ""){
        list($v1,$v2)= split ("-", $val);
        if ($v2 != ""){
          if ($v1 > $v2){
            $message[]= _("Please specify a valid VSync range.");
          }
        }
      }

      /* Check hsync for correct usage */
      $val= preg_replace ("/\s/", "", $this->gotoXHsync);
      if (!preg_match ("/^\d+(\.\d+)?(\-\d+(\.\d+)?)?$/", $val)
          && chkacl ($this->acl, "gotoXHsync") == ""){

        $message[]= _("Please specify a valid HSync range.");
      } elseif (chkacl ($this->acl, "gotoXHsync") == ""){
        list($v1,$v2)= split ("-", $val);
        if ($v2 != ""){
          if ($v1 > $v2){
            $message[]= _("Please specify a valid HSync range.");
          }
        }
      }
    }
    return ($message);
  }


  /* Save to LDAP */
  function save()
  {
    plugin::save();

    /* Strip out 'default' values */
    foreach(array(
          "gotoXDriver", "gotoXResolution", "gotoXColordepth",
          "gotoXKbModel", "gotoXKbLayout",
          "gotoXKbVariant", "gotoXMouseType", "gotoXMouseport") as $val){

      if ($this->attrs[$val] == "default"){
        $this->attrs[$val]= array();
      }
    }

    /* Write back to ldap */
    $ldap= $this->config->get_ldap_link();
    $ldap->cd($this->dn);
    $ldap->modify($this->attrs);
    show_ldap_error($ldap->get_error());
    $this->handle_post_events("modify");
  }

}

// vim:tabstop=2:expandtab:shiftwidth=2:filetype=php:syntax:ruler:
?>
