# gozerbot/generic.py
#
#

""" generic functions """

__copyright__ = 'this file is in the public domain'

from gozerbot.datadir import datadir
from gozerbot.config import config
import time, sys, re, traceback, Queue, urllib, urllib2, urlparse, socket, random
import os, sgmllib, thread, popen2, types, calendar, httplib, string, glob
import htmlentitydefs

try:
    import chardet
except ImportError:
    chardet = None

# list of exception handled by handle_exception
exceptionlist = []

# RE to dectect if string is a hostname
hostnamere = re.compile('^[\w\.]+$')

logging_enabled = False
logfile = None

def enable_logging():
    global logging_enabled
    logging_enabled = True

if config.has_key('logfile'):
    def openlogfile(filename, mode="a+"):
        try:
            f = open(filename, mode)
        except IOError, e:
            sys.stderr.write("[%s] (%s) %s" % \
                (time.strftime("%H:%M:%S"), "logfile", str(e)))
            return None
        else:
            return f
    filename = os.path.join(datadir, config['logfile'])
    logfile = openlogfile(filename)

def cchar(bot, ievent):
    try:
        cchar = bot.channels[ievent.channel]['cc']
    except LookupError:
        cchar = config['defaultcc'] or '!'
    except TypeError:
        cchar = config['defaultcc'] or '!'
    return cchar

def splittxt(what):
    txtlist = []
    start = 0
    end = 375
    length = len(what)
    for i in range(length/end+1):
        endword = what.find(' ', end)
        if endword == -1:
            endword = length
        res = what[start:endword]
        if res:
            txtlist.append(res)
        start = endword
        end = start + 375
    return txtlist
    
class istr(str): 
    """ adjustable string object """
    pass

def lockdec(lock):
    """ return locking descriptor locking on the provided lock """
    def locked(func):
        """ lock function func """
        def lockedfunc(*args, **kwargs):
            """ the locked function """
            if lock.locked():
                rlog(-1, 'generic', 'locking on %s .. %s' % (str(func), \
str(args)))
            lock.acquire()
            res = None
            try:
                res = func(*args, **kwargs)
            finally:
                lock.release()
            return res
        return lockedfunc
    return locked

# lock for popen
popenlock = thread.allocate_lock()
popenlocked = lockdec(popenlock)

class PopenWhitelistError(Exception):

    def __init__(self, item):
        self.item = item
        
    def __str__(self):
        return self.item

class PopenListError(Exception):

    def __init__(self, item):
        self.item = item
        
    def __str__(self):
        return str(self.item)

class Gozerpopen4(popen2.Popen4):

    def close(self):
        result = self.wait()
        self.fromchild.close()
        self.tochild.close()
        return result

@popenlocked
def gozerpopen(args, userargs=[]):
    if type(args) != types.ListType:
        raise PopenListError(args)
    if type(userargs) != types.ListType:
        raise PopenListError(args)
    for i in userargs:
        if i.startswith('-'):
            raise PopenWhitelistError(i)
    proces = Gozerpopen4(args + userargs)
    return proces

def die():
    """ stop the bot """
    rlog(10, 'generic', 'sending kill signal')
    os.kill(os.getpid(), 9)

def reboot():
    """ reboot the bot """
    os.execl(sys.argv[0], *sys.argv)

def calledfrom(frame):
    """ return plugin from which function is called """
    try:
        plugname = frame.f_back.f_code.co_filename
        name = plugname.split(os.sep)[-1][:-3]
    except AttributeError:
        name = None
    del frame
    return name

def stripident(userhost):
    """ strip ident char from userhost """
    try:
        jid = userhost.getNode()
        return str(userhost)
    except AttributeError:
        pass
    if not userhost:
        return None
    doit = config['stripident']
    if not doit:
        return userhost
    if userhost[0] in "~-+^":
        userhost = userhost[1:]
    elif userhost[1] == '=':
        userhost = userhost[2:]
    return userhost

def stripidents(ulist):
    """ strip ident char from list of userhosts """
    result = []
    for userhost in ulist:
        result.append(stripident(userhost))
    return result

def rlogfile(level, descr, txt):
    global logfile
    if logfile==None or logfile.closed:
        return
    if level >= config['loglevel']:
        try:
            logfile.write("[%s] (%s) %s\n" % (uurminsec(time.time()), \
descr, txt))
        except IOError:
            try:
                logfile.close()
            finally:
                logfile = None
        else:
            logfile.flush()

def rlog(level, descr, txt, nofile=False):
    """ log text if level >= loglevel """
    global logging_enabled
    if not logging_enabled:
        return
    if level >= config['loglevel']:
        txt = str(txt)
        sys.stdout.write("[%s] (%s) %s\n" % (uurminsec(time.time()), descr, \
txt))
        sys.stdout.flush()
        if not nofile and logfile:
            rlogfile(level, descr, txt)

def handle_exception(ievent=None, log=True):
    """ print exception trace to sys.stderr """
    result = ""
    exctype, excvalue, tb = sys.exc_info()
    trace = traceback.extract_tb(tb)
    for i in trace:
        filename = i[0].split(os.sep)[-1]
        linenr = i[1]
        func = i[2]
        result += "%s:%s %s | " % (filename, linenr, func)
    errormsg = "EXCEPTION: %s%s: %s" % (result, exctype, excvalue)
    exceptionlist.append(errormsg)
    if ievent:
        ievent.reply(errormsg)
    if log:
        rlog(100, "ALERT", "EXCEPTION !!")
        traceback.print_exc(sys.stderr)
	if logfile:
	    traceback.print_exc(logfile)
    del trace
    
def getlistensocket(listenip):
    """ scan for a free socket on listenip """
    port = 5000
    while 1:
        time.sleep(0.01)
        try:
            port += 1
            if ':' in listenip:
                sock = socket.socket(socket.AF_INET6, socket.SOCK_STREAM)
            else:
                sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
            sock.setblocking(1)
            if port > 65000:
                port = 5000
            sock.bind((listenip, port))
            sock.listen(1)
            return (port, sock)
        except Exception, ex:
            pass

leapfactor = float(6*60*60)/float(365*24*60*60)

def elapsedstring(nsec, ywd = None):
    """ return string of elapsed time """
    nsec = int(float(nsec))
    year = 365*24*60*60
    week = 7*24*60*60
    day = 24*60*60
    hour = 60*60
    minute = 60
    nsec -= nsec * leapfactor
    years = int(nsec/year)
    nsec -= years*year
    weeks = int(nsec/week)
    nsec -= weeks*week
    days = int(nsec/day)
    nsec -= days*day
    hours = int(nsec/hour)
    nsec -= hours*hour
    minutes = int(nsec/minute)
    sec = int(nsec - minutes*minute)   
    result = ''
    if (years > 1):
        result = str(years) + " years "
    if (years == 1):
        result = "1 year "
    if (weeks > 1):
        result += str(weeks) + " weeks "
    if (weeks == 1):
        result += "1 week "
    if (days > 1):
        if ywd:
            result += 'and '+ str(days) + " days"
        else:
            result += str(days) + " days "
    if (days == 1):
        if ywd:
            result += 'and 1 day'
        else:
            result += "1 day "
    if ywd:
        return result
    if (hours > 1):
        result += str(hours) + " hours "
    if (hours == 1):
        result += "1 hour "
    if (minutes > 1):
        result += str(minutes) + " minutes "
    if (minutes == 1):
        result += "1 minute "
    if sec == 0:
        if result:
            return result
        else:
            return 0
    if (sec == 1):
        if result:
            result += "and 1 second "
        else:
            result = "1 second"
    else:
        if result:
            result += "and " + str(sec) + " seconds"
        else: 
            result = str(sec) + " seconds"
    return result.strip()

def hourmin(ttime):
    """ extract hour:minutes from time """
    result = ""
    timeres = time.localtime(ttime)
    if timeres[3] < 10:
        result += "0" + str(timeres[3]) + ":"
    else:
        result += str(timeres[3]) + ":"
    if timeres[4] < 10:
        result += "0" + str(timeres[4])
    else:
        result += str(timeres[4])
    return result

timere = re.compile('(\S+)\s+(\S+)\s+(\d+)\s+(\d+):(\d+):(\d+)\s+(\d+)')

bdmonths = ['Bo', 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', \
'Sep', 'Oct', 'Nov', 'Dec']

def striptime(what):
    """ strip time indicators from string """
    what = str(what)
    what = re.sub('\d+-\d+-\d+', '', what)
    what = re.sub('\d+-\d+', '', what)
    what = re.sub('\d+:\d+', '', what)
    what = re.sub('\s+', ' ', what)
    return what

def today():
    """ get time for today 00:00 """
    if time.daylight:
        ttime = time.ctime(time.time() + int(time.timezone) + 3600)
    else:
        ttime = time.ctime(time.time() + int(time.timezone))
    matched = re.search(timere, ttime)
    if matched:
        temp = "%s %s %s" % (matched.group(3), matched.group(2), \
matched.group(7))
        timestring = time.strptime(temp, "%d %b %Y")
        result = time.mktime(timestring)
        return result

def strtotime(what):
    """ convert string to time """
    daymonthyear = 0
    hoursmin = 0
    try:
        # check for day-month-year
        dmyre = re.search('(\d+)-(\d+)-(\d+)', str(what))
        if dmyre:
            (day, month, year) = dmyre.groups()
            day = int(day)
            month = int(month)
            year = int(year)
            if day <= calendar.monthrange(year, month)[1]:
                date = "%s %s %s" % (day, bdmonths[month], year)
                daymonthyear = time.mktime(time.strptime(date, "%d %b %Y"))
            else:
                return None
        else:
            # check for day-month
            dmre = re.search('(\d+)-(\d+)', str(what))
            if dmre:
                year = time.localtime()[0]
                (day, month) = dmre.groups()
                day = int(day)
                month = int(month)
                if day <= calendar.monthrange(year, month)[1]: 
                    date = "%s %s %s" % (day, bdmonths[month], year)
                    daymonthyear = time.mktime(time.strptime(date, "%d %b %Y"))
                else:
                    return None
        # check for hours:minutes:seconds
        hmsre = re.search('(\d+):(\d+):(\d+)', str(what))
        if hmsre:
            (h, m, s) = hmsre.groups()
            h = int(h)
            m = int(m)
            s = int(s)
            if h > 24 or h < 0 or m > 60 or m < 0 or s > 60 or s < 0:
                return None
            hours = 60 * 60 * (int(hmsre.group(1)))
            hoursmin = hours  + int(hmsre.group(2)) * 60
            hms = hoursmin + int(hmsre.group(3))
        else:
            # check for hours:minutes
            hmre = re.search('(\d+):(\d+)', str(what))
            if hmre:
                (h, m) = hmre.groups()
                h = int(h)
                m = int(m)
                if h > 24 or h < 0 or m > 60 or m < 0:
                    return None
                hours = 60 * 60 * (int(hmre.group(1)))
                hms = hours  + int(hmre.group(2)) * 60
            else:
                hms = 0
        if not daymonthyear and not hms:
            return None
        if daymonthyear == 0:
            heute = today()
        else:
            heute = daymonthyear
        return heute + hms
    except OverflowError:
        return None
    except ValueError:
        return None
    except Exception, ex:
        handle_exception()
        return None

def uurminsec(ttime):
    """ return hours:minutes:seconds string """
    result = ""
    timeres = time.localtime(ttime)
    if timeres[3] < 10:
        result += "0" + str(timeres[3]) + ":"
    else:
        result += str(timeres[3]) + ":"
    if timeres[4] < 10:
        result += "0" + str(timeres[4]) + ":"
    else:
        result += str(timeres[4]) + ":"
    if timeres[5] < 10:
        result += "0" + str(timeres[5])
    else:
        result += str(timeres[5])
    return result


def getdaymonth(ttime):
    """ return day-month tuple"""
    timestr = time.ctime(ttime)
    result = re.search(timere, timestr)
    if result:
        return (result.group(3), result.group(2))
    else:
        return (None, None)

def getdaymonthyear(ttime):
    """ return day-month-year tuple"""
    timestr = time.ctime(ttime)
    result = re.search(timere, timestr)
    if result:
        return (result.group(3), result.group(2), result.group[7])
    else:
        return (None, None, None)

def dmy(ttime):
    """ return day-month-year string"""
    timestr = time.ctime(ttime)
    result = re.search(timere, timestr)
    if result:
        return "%s %s %s" % (result.group(3), result.group(2), result.group(7))
    else:
        return None

def checkchan(bot, item):
    """ check if chan <channel> is in string """ 
    chanre = re.search(' chan (\S+)', item)
    if chanre:
        chan = str(chanre.group(1))
        item = re.sub(' chan ' + re.escape(chan), '', item)
        return (chan.lower(), item)

def getwho(bot, who):
    """ get userhost from bots userhost cache """
    who = who.lower()
    try:
        result = bot.userhosts[who]
        return result
    except KeyError:
        return None

def waitforuser(bot, userhost, timeout=15):
    """ wait for user response """
    queue = Queue.Queue()
    waitnr = bot.privwait.register(userhost, queue, timeout)
    result = queue.get()
    bot.privwait.delete(waitnr)
    return result

def useragent():
    (name, version) = config['version'].split()[0:2]
    return 'Mozilla/5.0 (compatible; %s %s; http://www.gozerbot.org)' % (name, version)

class CBURLopener(urllib.FancyURLopener):

    """ our URLOpener """

    def __init__(self, version, *args):
        if version:
            self.version = version
        else:
            self.version = useragent()
        urllib.FancyURLopener.__init__(self, *args)

def geturl(url, version=None):
    """ fetch an url """
    urllib._urlopener = CBURLopener(version)
    rlog(5, 'generic', 'fetching %s' % url)
    result = urllib.urlopen(url)
    tmp = result.read()
    result.close()
    return tmp

def geturl2(url):
    """ use urllib2 to fetch an url """
    rlog(10, 'generic', 'fetching %s' % url)
    request = urllib2.Request(url)
    request.add_header('User-Agent', useragent())
    opener = urllib2.build_opener()
    result = opener.open(request)
    tmp = istr(result.read())
    tmp.info = result.info() # add header information to .info attribute
    result.close()
    return tmp

def posturl(url, myheaders, postdata):
    """ very basic HTTP POST url retriever """
    # build headers
    headers = {'Content-Type': 'application/x-www-form-urlencoded', 'Accept': 'text/plain; text/html',
        'User-Agent': useragent()}
    headers.update(myheaders)
    # parse URL components
    urlparts = urlparse.urlparse(url)
    # set up HTTP connection
    connection = httplib.HTTPConnection(urlparts[1])
    # make the request
    if type(postdata) == types.DictType:
        postdata = urllib.urlencode(postdata)
    connection.request('POST', urlparts[2], postdata, headers)
    # read the response and clean up
    response = connection.getresponse()
    data = response.read()
    connection.close()
    return data

def decode_html_entities(s):
    """ smart decoding of html entities to utf-8 """
    re_ent_match = re.compile(u'&([^;]+);')
    re_entn_match = re.compile(u'&#([^;]+);')
    s = s.decode('utf-8', 'replace')
    def to_entn(match):
        if htmlentitydefs.entitydefs.has_key(match.group(1)):
            return htmlentitydefs.entitydefs[match.group(1)].decode('utf-8', 'replace')
        return match.group(0)
    def to_utf8(match):
        return unichr(long(match.group(1)))
    s = re_ent_match.sub(to_entn, s)
    s = re_entn_match.sub(to_utf8, s)
    return s

def get_encoding(data):
    # first we try if we have the .info attribute to determine the encoding from
    if hasattr(data, 'info') and data.info.has_key('content-type') and 'charset' in data.info['content-type'].lower():
        charset = data.info['content-type'].lower().split('charset', 1)[1].strip()
        if charset[0] == '=':
            charset = charset[1:].strip()
            if ';' in charset:
                return charset.split(';')[0].strip()
            return charset
    # try to find the charset in the meta tags, 
    # <meta http-equiv="content-type" content="text/html; charset=..." />
    if '<meta' in data.lower():
        metas = re.findall(u'<meta[^>]+>', data, re.I | re.M)
        if metas:
            for meta in metas:
                test_http_equiv = re.search('http-equiv\s*=\s*[\'"]([^\'"]+)[\'"]', meta, re.I)
                if test_http_equiv and test_http_equiv.group(1).lower() == 'content-type':
                    test_content = re.search('content\s*=\s*[\'"]([^\'"]+)[\'"]', meta, re.I)
                    if test_content:
                        test_charset = re.search('charset\s*=\s*([^\s\'"]+)', meta, re.I)
                        if test_charset:
                            return test_charset.group(1)
    # everything else failed, let's see if we can use chardet
    if chardet:
        test = chardet.detect(data)
        if test.has_key('encoding'):
            return test['encoding']
    # nothing found, let's fall back to the default encoding
    return sys.getdefaultencoding()

def getrandomnick():
    """ generate random nick """
    return "gb" + str(random.randint(0, 100))

class Stripper(sgmllib.SGMLParser):

    """ html stripper """

    def __init__(self):
        sgmllib.SGMLParser.__init__(self)

    def strip(self, some_html):
        """ strip html """
        self.theString = ""
        self.feed(some_html)
        self.close()
        return self.theString

    def handle_data(self, data):
        """ data handler """
        self.theString += toascii(data)

def striphtml(txt):
    """ strip html from txt """
    stripper = Stripper()
    txt = stripper.strip(toascii(txt))
    return txt
    
def waitforqueue(queue, timeout=10):
    """ wait for queue output """
    result = []
    while 1:
        try:
            res = queue.get(1, timeout)
        except Queue.Empty:
            break
        if not res:
            break
        result.append(res)
    return result

defenc = sys.getdefaultencoding()
def toascii(what):
    what = what.decode(defenc, 'replace')
    return what

def tolatin1(what):
        what = what.decode('latin-1', 'replace')
        return what

def strippedtxt(what):
    strippedtxt = ""
    printchars = string.letters + string.digits + string.punctuation + '' \
+ ' '
    for i in what:
        if i in printchars:
            strippedtxt += i
    return strippedtxt

def uniqlist(l):
    result = []
    for i in l:
        j = i.strip()
        if j not in result:
            result.append(j)
    return result

def fix_format(s):
    counters = {
        chr(2): 0, 
        chr(3): 0
        }
    for letter in s:
        if letter in counters:
            counters[letter] += 1
    for char in counters:
        if counters[char] % 2:
            s += char
    return s

def stripbold(s):
    s = s.replace(chr(2), '')
    s = s.replace(chr(3), '')
    return s

def plugnames(dirname):
    result = []
    for i in glob.glob(dirname + os.sep + '*.py'):
        result.append(i.split(os.sep)[-1][:-3])
    try:
        result.remove('__init__')
    except:
        pass
    return result

def touch(filename):
    fd = os.open(filename, os.O_WRONLY | os.O_CREAT)
    os.close(fd)  

def stringinlist(s, l):
    for i in l:     
        if s in i:  
            return 1

def stripped(userhost):
    return userhost.split('/')[0]
