# gozerbot/lockmanager.py
#
#

""" manages locks """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog
import thread

class Lockmanager(object):

    def __init__(self):
        self.locks = {}

    def allocate(self, name):
        name = name.lower()
        self.locks[name] = thread.allocate_lock()
        rlog(10, 'lockmanager', 'allocated %s' % name)
        
    def get(self, name):
        name = name.lower()
        if not self.lock.has_key(name):
            self.allocate(name)
        return self.locks[name]
        
    def delete(self, name):
        if self.lock.has_key(name):
            del self.locks[name]

    def acquire(self, name):
        name = name.lower()
        if not self.locks.has_key(name):
            self.allocate(name)
        rlog(10, 'lockmanager', 'acquire %s' % name)
        self.locks[name].acquire()

    def release(self, name):
        name = name.lower()
        rlog(10, 'lockmanager', 'releasing %s' % name)
        self.locks[name].release()

lockmanager = Lockmanager()
