# plugs/fleet.py
#
#

""" fleet related commands """

__copyright__ = 'this file is in the public domain'

from gozerbot.fleet import fleet
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp
from gozerbot.aliases import aliasset
from gozerbot.config import config

plughelp.add('fleet', 'manage list of bots')

def handle_fleetconnect(bot, ievent):
    """ fleet-connect <botname> .. connect a fleet bot to it's server """
    try:
        botname = ievent.args[0]
    except IndexError:
        ievent.missing('<botname>')
        return
    if fleet.connect(botname):
        ievent.reply('connect thread %s to irc server started' % botname)
    else:
        ievent.reply("can't start connect thread")

cmnds.add('fleet-connect', handle_fleetconnect, 'OPER')
examples.add('fleet-connect', 'connect bot with <name> to irc \
server', 'fleet-connect undernet')

def handle_fleetdisconnect(bot, ievent):
    """ fleet-disconnect <botname> .. disconnect a fleet bot from server """
    try:
        botname = ievent.args[0]
    except IndexError:
        ievent.missing('<botname>')
        return
    ievent.reply('exiting %s' % botname)
    if fleet.exit(botname):
        ievent.reply("%s bot stopped" % botname)
    else:
        ievent.reply("can't stop %s bot" % botname)

cmnds.add('fleet-disconnect', handle_fleetdisconnect, 'OPER')
examples.add('fleet-disconnect', 'fleet-disconnect <name> .. disconnect \
bot with <name> from irc server', 'fleet-disconnect undernet')

def handle_fleetlist(bot, ievent):
    """ fleet-list .. list bot names in fleet """
    ievent.reply("fleet: ", fleet.list(), dot=True)

cmnds.add('fleet-list', handle_fleetlist, ['USER', 'WEB'])
examples.add('fleet-list', 'show current fleet list', 'fleet-list')

def handle_fleetaddirc(bot, ievent):
    """ fleed-addirc <name> <nick> <server> [port] [passwd] [ipv6] .. add irc \
        bot to fleet """
    from gozerbot.bot import Bot
    length  = len(ievent.args)
    if length == 6:
        (name, nick, server, port, password, ipv6) = ievent.args
    elif length == 5:
        (name, nick, server, port, password) = ievent.args
        ipv6 = 0
    elif length == 4:
        (name, nick, server, port) = ievent.args
        password = None
        ipv6 = 0
    elif length == 3:
        (name, nick, server) = ievent.args
        port = 6667
        password = None
        ipv6 = 0
    else:
        ievent.missing('<name> <nick> <server> [<port>] [<password>] [<ipv6>]')
        return
    if fleet.byname(name):
        ievent.reply('we already have a bot with %s name in fleet' % \
name)
        return
    b = Bot(config['owneruserhost'], name)
    b.nick = nick
    b.server = server
    b.port = port
    b.password = password
    b.ipv6 = ipv6
    fleet.addbot(b)
    fleet.connect(name)
    ievent.reply('%s started' % name)

cmnds.add('fleet-addirc', handle_fleetaddirc, 'OPER')
examples.add('fleet-addirc', 'fleet-addirc <name> <nick> <server> [port] \
[passwd] [ipv6] .. add new server to fleet', 'fleet-addirc test gozertest \
irc.xs4all.nl')
aliasset('fleet-add', 'fleet-addirc')

def handle_fleetaddjabber(bot, ievent):
    """ fleed-addjabber <name> <host> <user> <password> [port] .. add jabber \
        bot to fleet """
    try:
        import xmpp
    except:
        ievent.reply('xmpp is not enabled .. install the xmpppy package')
        return
    from gozerbot.jabberbot import Jabberbot
    if not bot.type == 'jabber':
        ievent.reply('use this command on a jabber bot (and change \
password if you used it)')
        return
    if ievent.groupchat:
        ievent.reply('use this command in a private message (and change \
password if you used it)')
        return
    length  = len(ievent.args)
    if length == 5:
        (name, host, user, password, port) = ievent.args
    elif length == 4:
        (name, host, user, password) = ievent.args
        port = 5222
    else:
        ievent.missing('<name> <host> <user> <password> [<port>]')
        return
    if fleet.byname(name):
        ievent.reply('we already have a bot with %s name in fleet' % \
name)
        return
    b = Jabberbot(name)
    b.host = host
    b.user = user
    b.password = password
    b.port = port
    fleet.addbot(b)
    fleet.connect(name)
    ievent.reply('%s started' % name)

cmnds.add('fleet-addjabber', handle_fleetaddjabber, 'OPER')
examples.add('fleet-addjabber', 'fleet-addjabber <name> <host> <user> \
<passwd> [<port>] .. add new jabber server to fleet', 'fleet-add test \
jabber.xs4all.nl jtest@jabber.xs4all.nl xwe23')

def handle_fleetdel(bot, ievent):
    """ fleet-del <botname> .. delete bot from fleet """
    try:
        name = ievent.args[0]
    except IndexError:
        ievent.missing('<name>')
        return
    if fleet.delete(name):
        ievent.reply('%s deleted' % name)
    else:
        ievent.reply('%s delete failed' % name)

cmnds.add('fleet-del', handle_fleetdel, 'OPER')
examples.add('fleet-del', 'fleet-del <botname> .. delete bot from fleet \
list', 'fleet-del test')

def docmnd(bot, ievent):
    """ cmnd 'all'|<botname> <cmnd> .. do command on bot/all bots """
    try:
        name = ievent.args[0]
        cmnd = ' '.join(ievent.args[1:])
    except IndexError:
        ievent.missing('<name> <cmnd>')
        return
    if not cmnd:
        ievent.missing('<name> <cmnd>')
        return
    if cmnd.find('cmnd') != -1:
        ievent.reply("no looping please ;]")
        return
    if name == 'all':
        fleet.cmndall(ievent, cmnd)
    else:
        fleet.cmnd(ievent, name, cmnd)

cmnds.add('cmnd', docmnd, ['USER', 'WEB'])
examples.add('cmnd', "cmnd 'all'|<botname> <cmnd> .. excecute command on \
bot with <name> or on all fleet bots", '1) cmnd main st 2) cmnd all st')
